/*************************************************************************
 *
 *  $RCSfile: registerservices.cxx,v $
 *
 *  $Revision: 1.15.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/04/25 12:58:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#include <cppuhelper/factory.hxx>

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <breakiterator.hxx>
#include <characterclassification.hxx>
#include <textsearch.hxx>
#include <collator.hxx>
#include <collator_CJK.hxx>
#include <simple_collator.hxx>
#include <calendarImpl.hxx>
#include <transliteration.hxx>


#define IMPL_CREATEINSTANCE( ImplName ) \
	::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >   \
		SAL_CALL ImplName##_CreateInstance(                                 \
			const ::com::sun::star::uno::Reference<                         \
					::com::sun::star::lang::XMultiServiceFactory >& )       \
{                                                                           \
	return ::com::sun::star::uno::Reference <                               \
			::com::sun::star::uno::XInterface >( ( ::cppu::OWeakObject* )   \
									new ImplName );                         \
}

#define IMPL_CREATEINSTANCE_MSF( ImplName ) \
	::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >   \
		SAL_CALL ImplName##_CreateInstance(                                 \
			const ::com::sun::star::uno::Reference<                         \
					::com::sun::star::lang::XMultiServiceFactory >& rxMSF ) \
{                                                                           \
	return ::com::sun::star::uno::Reference <                               \
			::com::sun::star::uno::XInterface >( ( ::cppu::OWeakObject* )   \
									new ImplName( rxMSF ) );                \
}

typedef ::com::sun::star::uno::Reference<
		::com::sun::star::uno::XInterface > (SAL_CALL *FN_CreateInstance)(
			const ::com::sun::star::uno::Reference<
				::com::sun::star::lang::XMultiServiceFactory >& );


// -------------------------------------------------------------------------------------

IMPL_CREATEINSTANCE( BreakIterator )
IMPL_CREATEINSTANCE_MSF( CharacterClassification )
IMPL_CREATEINSTANCE( TextSearch )
IMPL_CREATEINSTANCE_MSF( Collator )
IMPL_CREATEINSTANCE_MSF( Collator_zh_CN_pinyin )
IMPL_CREATEINSTANCE_MSF( Collator_zh_CN_radical )
IMPL_CREATEINSTANCE_MSF( Collator_zh_CN_stroke )
IMPL_CREATEINSTANCE_MSF( Collator_zh_CN_charset )
IMPL_CREATEINSTANCE_MSF( Collator_zh_TW_zhuyin )
IMPL_CREATEINSTANCE_MSF( Collator_zh_TW_radical )
IMPL_CREATEINSTANCE_MSF( Collator_zh_TW_stroke )
IMPL_CREATEINSTANCE_MSF( Collator_zh_TW_charset )
IMPL_CREATEINSTANCE_MSF( Collator_ko_KR_dict )
IMPL_CREATEINSTANCE_MSF( Collator_ko_KR_charset )
IMPL_CREATEINSTANCE_MSF( Collator_ja_JP_charset )
IMPL_CREATEINSTANCE_MSF( SimpleCollator )
IMPL_CREATEINSTANCE( CalendarImpl )
IMPL_CREATEINSTANCE( Transliteration )

static const struct InstancesArray {
		const sal_Char* pServiceNm;
		const sal_Char* pRegKeyNm;
		FN_CreateInstance pFn;
} aInstances[] = {
	{ 	"com.sun.star.i18n.BreakIterator",
		"com.sun.star.i18n.BreakIterator",
		&BreakIterator_CreateInstance },
	{ 	"com.sun.star.i18n.CharacterClassification",
		"com.sun.star.i18n.CharacterClassification",
		&CharacterClassification_CreateInstance },
	{ 	"com.sun.star.util.TextSearch",
		"com.sun.star.util.TextSearch",
		&TextSearch_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_pinyin",
		"com.sun.star.i18n.zh_CN_pinyin_Collator",
		&Collator_zh_CN_pinyin_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_radical",
		"com.sun.star.i18n.zh_CN_radical_Collator",
		&Collator_zh_CN_radical_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_stroke",
		"com.sun.star.i18n.zh_CN_stroke_Collator",
		&Collator_zh_CN_stroke_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_charset",
		"com.sun.star.i18n.zh_CN_charset_Collator",
		&Collator_zh_CN_charset_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_pinyin",
		"com.sun.star.i18n.zh_SG_pinyin_Collator",
		&Collator_zh_CN_pinyin_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_radical",
		"com.sun.star.i18n.zh_SG_radical_Collator",
		&Collator_zh_CN_radical_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_stroke",
		"com.sun.star.i18n.zh_SG_stroke_Collator",
		&Collator_zh_CN_stroke_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_charset",
		"com.sun.star.i18n.zh_SG_charset_Collator",
		&Collator_zh_CN_charset_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_zhuyin",
		"com.sun.star.i18n.zh_TW_zhuyin_Collator",
		&Collator_zh_TW_zhuyin_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_CN_pinyin",
		"com.sun.star.i18n.zh_TW_pinyin_Collator",
		&Collator_zh_CN_pinyin_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_radical",
		"com.sun.star.i18n.zh_TW_radical_Collator",
		&Collator_zh_TW_radical_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_stroke",
		"com.sun.star.i18n.zh_TW_stroke_Collator",
		&Collator_zh_TW_stroke_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_charset",
		"com.sun.star.i18n.zh_TW_charset_Collator",
		&Collator_zh_TW_charset_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_radical",
		"com.sun.star.i18n.zh_HK_radical_Collator",
		&Collator_zh_TW_radical_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_stroke",
		"com.sun.star.i18n.zh_HK_stroke_Collator",
		&Collator_zh_TW_stroke_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_charset",
		"com.sun.star.i18n.zh_HK_charset_Collator",
		&Collator_zh_TW_charset_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_radical",
		"com.sun.star.i18n.zh_MO_radical_Collator",
		&Collator_zh_TW_radical_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_stroke",
		"com.sun.star.i18n.zh_MO_stroke_Collator",
		&Collator_zh_TW_stroke_CreateInstance },
	{	"com.sun.star.i18n.Collator_zh_TW_charset",
		"com.sun.star.i18n.zh_MO_charset_Collator",
		&Collator_zh_TW_charset_CreateInstance },
	{	"com.sun.star.i18n.Collator_ko_KR_dict",
		"com.sun.star.i18n.ko_KR_dict_Collator",
		&Collator_ko_KR_dict_CreateInstance },
	{	"com.sun.star.i18n.Collator_ko_KR_charset",
		"com.sun.star.i18n.ko_KR_charset_Collator",
		&Collator_ko_KR_charset_CreateInstance },
	{	"com.sun.star.i18n.Collator_ja_JP_charset",
		"com.sun.star.i18n.ja_JP_charset_Collator",
		&Collator_ja_JP_charset_CreateInstance },
	{	"com.sun.star.i18n.SimpleCollator",
		"com.sun.star.i18n.SimpleCollator",
		&SimpleCollator_CreateInstance },
	{	"com.sun.star.i18n.Collator",
		"com.sun.star.i18n.Collator",
		&Collator_CreateInstance },
	{	"com.sun.star.i18n.LocaleCalendar",
		"com.sun.star.i18n.CalendarImpl",
		&CalendarImpl_CreateInstance },
    {   "com.sun.star.i18n.Transliteration",
        "com.sun.star.i18n.Transliteration",
        &Transliteration_CreateInstance },
	{ 0, 0, 0 }
};

extern "C"
{

void SAL_CALL component_getImplementationEnvironment(
					const sal_Char** ppEnvTypeName, uno_Environment** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

sal_Bool SAL_CALL component_writeInfo(
					void* _pServiceManager, void* _pRegistryKey )
{
	if (_pRegistryKey)
	{
		::com::sun::star::registry::XRegistryKey * pRegistryKey =
			reinterpret_cast< ::com::sun::star::registry::XRegistryKey* >(
								_pRegistryKey );
		::com::sun::star::uno::Reference<
						::com::sun::star::registry::XRegistryKey > xNewKey;

		for( const InstancesArray* pArr = aInstances; pArr->pServiceNm; ++pArr )
		{
			xNewKey = pRegistryKey->createKey(
					::rtl::OUString::createFromAscii( pArr->pRegKeyNm ) );
			xNewKey = xNewKey->createKey(
					::rtl::OUString::createFromAscii( "/UNO/SERVICES" ) );
			xNewKey->createKey(
					::rtl::OUString::createFromAscii( pArr->pServiceNm ) );
		}
	}
	return sal_True;
}

void* SAL_CALL component_getFactory( const sal_Char* sImplementationName,
							void* _pServiceManager, void* _pRegistryKey )
{
	void* pRet = NULL;

	::com::sun::star::lang::XMultiServiceFactory* pServiceManager = reinterpret_cast< ::com::sun::star::lang::XMultiServiceFactory* >( _pServiceManager );
	::com::sun::star::uno::Reference< ::com::sun::star::lang::XSingleServiceFactory > xFactory;

	for( const InstancesArray* pArr = aInstances; pArr->pServiceNm; ++pArr )
		if( 0 == rtl_str_compare( sImplementationName, pArr->pRegKeyNm ) )
		{
			::com::sun::star::uno::Sequence< ::rtl::OUString > aServiceNames(1);
			aServiceNames.getArray()[0] =
				::rtl::OUString::createFromAscii( pArr->pServiceNm );
			xFactory = ::cppu::createSingleFactory(
					pServiceManager, aServiceNames.getArray()[0],
					*pArr->pFn, aServiceNames );
			break;
		}

	if ( xFactory.is() )
	{
		xFactory->acquire();
		pRet = xFactory.get();
	}
	return pRet;
}

}	// "C"

