/*************************************************************************
 *
 *  $RCSfile: characterclassification.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: er $ $Date: 2001/01/29 17:08:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL

#include <characterclassification.hxx>

#if !USE_I18N_DEFAULT_IMPLEMENTAION
#error This file is not meant to not be used as the default implementation!
#endif

#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif

//	----------------------------------------------------
//	class CharacterClassification
//	----------------------------------------------------;

CharacterClassification::CharacterClassification(
			const ::com::sun::star::uno::Reference <
				::com::sun::star::lang::XMultiServiceFactory >& rxMSF )
		:
		xMSF( rxMSF ),
		pIntl( NULL ),
		pTable( NULL ),
		pStart( NULL ),
		pCont( NULL ),
		nStartTypes( 0 ),
		nContTypes( 0 ),
		eState( ssGetChar ),
		cGroupSep( ',' ),
		cDecimalSep( '.' )
{
}

CharacterClassification::~CharacterClassification()
{
	delete pIntl;
	destroyParserTable();
}


::rtl::OUString SAL_CALL
CharacterClassification::toUpper( const ::rtl::OUString& Text, sal_Int32 nPos, sal_Int32 nCount, const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return ::rtl::OUString();

	setupInternational( rLocale );
	if ( nCount == 1 )
		return pIntl->Upper( Text.getStr() + nPos );
	else
	{
		String aStr( Text.getStr() + nPos, nCount );
		pIntl->ToUpper( aStr );
		return aStr;
	}
}

::rtl::OUString SAL_CALL
CharacterClassification::toLower( const ::rtl::OUString& Text, sal_Int32 nPos, sal_Int32 nCount, const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return ::rtl::OUString();

	setupInternational( rLocale );
	if ( nCount == 1 )
		return pIntl->Lower( Text.getStr() + nPos );
	else
	{
		String aStr( Text.getStr() + nPos, nCount );
		pIntl->ToLower( aStr );
		return aStr;
	}
}

::rtl::OUString SAL_CALL
CharacterClassification::toTitle( const ::rtl::OUString& Text, sal_Int32 nPos, sal_Int32 nCount, const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return ::rtl::OUString();
	if ( Text.getLength() < nPos + nCount )
		nCount = Text.getLength() - nPos;

	setupInternational( rLocale );
//!!!!!!!!!!!!!!!!!!!!!!!
// must be implemented !!
//!!!!!!!!!!!!!!!!!!!!!!!
	if ( nCount == 1 )
		return pIntl->Upper( Text.getStr() + nPos );
	else
	{
		String aStr( Text.getStr() + nPos, nCount );
		pIntl->ToUpper( aStr );
		return aStr;
	}
}

sal_Int16 SAL_CALL
CharacterClassification::getType( const ::rtl::OUString& Text, sal_Int32 nPos ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return 0;

//	return u_charType(aStr.GetChar(nPos));
//!!!!!!!!!!!!!!!!!!!!!!!
// must be implemented !!
//!!!!!!!!!!!!!!!!!!!!!!!
	return 0;
}

sal_Int16 SAL_CALL
CharacterClassification::getCharacterDirection( const ::rtl::OUString& Text, sal_Int32 nPos ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return 0;

//	return ((Unicode::EDirectionProperty)u_charDirection(aStr.GetChar(nPos)));
//!!!!!!!!!!!!!!!!!!!!!!!
// must be implemented !!
//!!!!!!!!!!!!!!!!!!!!!!!
	return 0;
}

sal_Int16 SAL_CALL
CharacterClassification::getScript( const ::rtl::OUString& Text, sal_Int32 nPos ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return 0;

//	return ((Unicode::EUnicodeScript) u_charScript(aStr.GetChar(nPos)));
//!!!!!!!!!!!!!!!!!!!!!!!
// must be implemented !!
//!!!!!!!!!!!!!!!!!!!!!!!
	return 0;
}

sal_Int32 SAL_CALL
CharacterClassification::getCharacterType( const ::rtl::OUString& Text, sal_Int32 nPos, const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return 0;

	setupInternational( rLocale );
	return getCharType( *(Text.getStr() + nPos) );
}

sal_Int32 SAL_CALL
CharacterClassification::getStringType( const ::rtl::OUString& Text, sal_Int32 nPos, sal_Int32 nCount, const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	if ( Text.getLength() <= nPos )
		return 0;
	if ( Text.getLength() < nPos + nCount )
		nCount = Text.getLength() - nPos;

	setupInternational( rLocale );
	sal_Int32 result = 0;
	const sal_Unicode* p = Text.getStr() + nPos;
	const sal_Unicode* const pStop = p + nCount;
	while ( p < pStop )
	{
		result |= getCharType( *p++ );
	}
	return result;
}


::com::sun::star::i18n::ParseResult SAL_CALL CharacterClassification::parseAnyToken(
			const ::rtl::OUString& Text,
			sal_Int32 nPos,
			const ::com::sun::star::lang::Locale& rLocale,
			sal_Int32 startCharTokenType,
			const ::rtl::OUString& userDefinedCharactersStart,
			sal_Int32 contCharTokenType,
			const ::rtl::OUString& userDefinedCharactersCont )
				throw(::com::sun::star::uno::RuntimeException)
{
	::com::sun::star::i18n::ParseResult r;
	if ( Text.getLength() <= nPos )
		return r;

	setupParserTable( rLocale,
		startCharTokenType, userDefinedCharactersStart,
		contCharTokenType, userDefinedCharactersCont );
	parseText( r, Text, nPos );

	return r;
}


::com::sun::star::i18n::ParseResult SAL_CALL CharacterClassification::parsePredefinedToken(
			sal_Int32 nTokenType,
			const ::rtl::OUString& Text,
			sal_Int32 nPos,
			const ::com::sun::star::lang::Locale& rLocale,
			sal_Int32 startCharTokenType,
			const ::rtl::OUString& userDefinedCharactersStart,
			sal_Int32 contCharTokenType,
			const ::rtl::OUString& userDefinedCharactersCont )
				throw(::com::sun::star::uno::RuntimeException)
{
	::com::sun::star::i18n::ParseResult r;
	if ( Text.getLength() <= nPos )
		return r;

	setupParserTable( rLocale,
		startCharTokenType, userDefinedCharactersStart,
		contCharTokenType, userDefinedCharactersCont );
	parseText( r, Text, nPos, nTokenType );

	return r;
}


