/*************************************************************************
 *
 *  $RCSfile: transliteration.cxx,v $
 *
 *  $Revision: 1.1.10.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/12/09 22:19:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL
#include <tools/intn.hxx>

#include "transliteration.hxx"
#include <tools/isolang.hxx>
#include <comphelper/processfactory.hxx>

#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
#include <com/sun/star/i18n/TransliterationModules.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULESNEW_HPP_
#include <com/sun/star/i18n/TransliterationModulesNew.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONTYPE_HPP_
#include <com/sun/star/i18n/TransliterationType.hpp>
#endif

#define TRANSLITERATION_NAME (::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ClassInternational" ) ))

using namespace ::com::sun::star::i18n;


Transliteration::Transliteration()
        : mpInternational(NULL)
        , mnCompFlags(0)
        , mnCaseConv(0)
{
}


Transliteration::~Transliteration()
{
    delete mpInternational;
}


void Transliteration::SwitchInternational( const ::com::sun::star::lang::Locale& rLocale )
{
    LanguageType eLang = ConvertIsoNamesToLanguage( rLocale.Language, rLocale.Country );
    if ( eLang == LANGUAGE_DONTKNOW )
        eLang = LANGUAGE_ENGLISH_US;
    if ( !mpInternational || mpInternational->GetLanguage() != eLang )
    {
        delete mpInternational;
        mpInternational = new International( eLang );
    }
}


::rtl::OUString SAL_CALL Transliteration::getName() throw (::com::sun::star::uno::RuntimeException)
{
    return TRANSLITERATION_NAME;
}


sal_Int16 SAL_CALL Transliteration::getType() throw (::com::sun::star::uno::RuntimeException)
{
    if ( mnCompFlags == INTN_COMPARE_IGNORECASE )
        return mnCaseConv ? TransliterationType::CASCADE : TransliterationType::IGNORE;

    if ( mnCaseConv )
        return TransliterationType::ONE_TO_ONE;

    return TransliterationType::NONE;
}


void SAL_CALL Transliteration::loadModule(
            ::com::sun::star::i18n::TransliterationModules modType,
            const ::com::sun::star::lang::Locale& rLocale
            ) throw (::com::sun::star::uno::RuntimeException)
{
    mnCompFlags = ((modType & TransliterationModules_IGNORE_CASE) ?
        INTN_COMPARE_IGNORECASE : 0);
    if ( modType == TransliterationModules_UPPERCASE_LOWERCASE )
        mnCaseConv = 1;
    else if ( modType == TransliterationModules_LOWERCASE_UPPERCASE )
        mnCaseConv = 2;
    else
        mnCaseConv = 0;
    SwitchInternational( rLocale );
}


void SAL_CALL Transliteration::loadModuleNew(
            const ::com::sun::star::uno::Sequence< ::com::sun::star::i18n::TransliterationModulesNew >& modType,
            const ::com::sun::star::lang::Locale& rLocale
            ) throw (::com::sun::star::uno::RuntimeException)
{
    mnCompFlags = 0;
    mnCaseConv = 0;
    const TransliterationModulesNew* pMod = modType.getConstArray();
    sal_Int32 nLen = modType.getLength();
    for ( sal_Int32 j=0; j<nLen; ++j  )
    {
        switch ( pMod[j] )
        {
            case TransliterationModulesNew_IGNORE_CASE :
                mnCompFlags = INTN_COMPARE_IGNORECASE;
            break;
            case TransliterationModulesNew_UPPERCASE_LOWERCASE :
                mnCaseConv = 1;
            break;
            case TransliterationModulesNew_LOWERCASE_UPPERCASE :
                mnCaseConv = 2;
            break;
        }

    }
    SwitchInternational( rLocale );
}


void SAL_CALL Transliteration::loadModuleByImplName(
            const ::rtl::OUString& implName,
            const ::com::sun::star::lang::Locale& rLocale
            ) throw (::com::sun::star::uno::RuntimeException)
{
    mnCompFlags = 0;
    mnCaseConv = 0;
    SwitchInternational( rLocale );
}


void SAL_CALL Transliteration::loadModulesByImplNames(
            const ::com::sun::star::uno::Sequence< ::rtl::OUString >& implNamelist,
            const ::com::sun::star::lang::Locale& rLocale
            ) throw (::com::sun::star::uno::RuntimeException)
{
    mnCompFlags = 0;
    mnCaseConv = 0;
    SwitchInternational( rLocale );
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL Transliteration::getAvailableModules(
            const ::com::sun::star::lang::Locale& rLocale,
            sal_Int16 sType
            ) throw (::com::sun::star::uno::RuntimeException)
{
    ::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq(1);
    aSeq[0] = TRANSLITERATION_NAME;
    return aSeq;
}


::rtl::OUString SAL_CALL Transliteration::transliterate(
            const ::rtl::OUString& inStr,
            sal_Int32 startPos,
            sal_Int32 nCount,
            ::com::sun::star::uno::Sequence< sal_Int32 >& offset
            ) throw (::com::sun::star::uno::RuntimeException)
{
    if ( !mpInternational )
        throw ::com::sun::star::uno::RuntimeException();

    ::rtl::OUString aRet;
    if ( mnCompFlags || mnCaseConv == 1 )
    {
        if ( startPos || nCount != inStr.getLength() )
        {
            String aTmp( inStr.copy( startPos, nCount ) );
            aRet = mpInternational->Lower( aTmp );
        }
        else
            aRet = mpInternational->Lower( inStr );
    }
    else if ( mnCaseConv == 2 )
    {
        if ( startPos || nCount != inStr.getLength() )
        {
            String aTmp( inStr.copy( startPos, nCount ) );
            aRet = mpInternational->Upper( aTmp );
        }
        else
            aRet = mpInternational->Upper( inStr );
    }
    else
        aRet = inStr;

    sal_Int32 nLen = offset.getLength();
    if ( nLen != aRet.getLength() )
    {
        nLen = aRet.getLength();
        offset.realloc( nLen );
    }
    for ( sal_Int32 j=0; j<nLen; ++j )
    {
        offset[j] = j;
    }
    return aRet;
}


::rtl::OUString SAL_CALL Transliteration::folding(
            const ::rtl::OUString& inStr,
            sal_Int32 startPos,
            sal_Int32 nCount,
            ::com::sun::star::uno::Sequence< sal_Int32 >& offset
            ) throw (::com::sun::star::uno::RuntimeException)
{
    return transliterate( inStr, startPos, nCount, offset );
}


sal_Bool SAL_CALL Transliteration::equals(
            const ::rtl::OUString& str1,
            sal_Int32 pos1, sal_Int32 nCount1, sal_Int32& nMatch1,
            const ::rtl::OUString& str2,
            sal_Int32 pos2, sal_Int32 nCount2, sal_Int32& nMatch2
            ) throw (::com::sun::star::uno::RuntimeException)
{
    if ( !mpInternational )
        throw ::com::sun::star::uno::RuntimeException();

    String aStr1( str1.copy( pos1, nCount1 ) );
    String aStr2( str2.copy( pos2, nCount2 ) );
    // Converting both strings entirely is somewhat ugly but the only
    // possibility here since the old class International doesn't offer
    // anything else.
    if ( mnCompFlags || mnCaseConv == 1 )
    {
        mpInternational->ToLower( aStr1 );
        mpInternational->ToLower( aStr2 );
    }
    else if ( mnCaseConv == 2 )
    {
        mpInternational->ToUpper( aStr1 );
        mpInternational->ToUpper( aStr2 );
    }
    sal_Unicode const * p1 = aStr1.GetBuffer();
    sal_Unicode const * const pStop1 = p1 + aStr1.Len();
    sal_Unicode const * p2 = aStr2.GetBuffer();
    sal_Unicode const * const pStop2 = p2 + aStr2.Len();
    while ( p1 < pStop1 && p2 < pStop2 )
    {
        if ( *p1 != *p2 )
        {
            nMatch1 = nMatch2 = p1 - aStr1.GetBuffer();
            return sal_False;
        }
        ++p1;
        ++p2;
    }
    nMatch1 = nMatch2 = p1 - aStr1.GetBuffer();
    return p1 == pStop1 && p2 == pStop2;
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL Transliteration::transliterateRange(
            const ::rtl::OUString& str1,
            const ::rtl::OUString& str2
            ) throw (::com::sun::star::uno::RuntimeException)
{
    if ( !mpInternational )
        throw ::com::sun::star::uno::RuntimeException();

    ::com::sun::star::uno::Sequence< ::rtl::OUString > aRet;
    if ( mnCompFlags )
    {
        ::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq(4);
        aSeq[0] = mpInternational->Upper( str1 );
        aSeq[1] = mpInternational->Upper( str2 );
        aSeq[2] = mpInternational->Lower( str1 );
        aSeq[3] = mpInternational->Lower( str2 );
        aRet = aSeq;
    }
    else if ( mnCaseConv == 1 )
    {
        ::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq(2);
        aSeq[0] = mpInternational->Lower( str1 );
        aSeq[1] = mpInternational->Lower( str2 );
        aRet = aSeq;
    }
    else if ( mnCaseConv == 2 )
    {
        ::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq(2);
        aSeq[0] = mpInternational->Upper( str1 );
        aSeq[1] = mpInternational->Upper( str2 );
        aRet = aSeq;
    }
    else
    {
        ::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq(2);
        aSeq[0] = str1;
        aSeq[1] = str2;
        aRet = aSeq;
    }
    return aRet;
}


sal_Int32 SAL_CALL Transliteration::compareSubstring(
            const ::rtl::OUString& s1, sal_Int32 off1, sal_Int32 len1,
            const ::rtl::OUString& s2, sal_Int32 off2, sal_Int32 len2
            ) throw (::com::sun::star::uno::RuntimeException)
{
    if ( !mpInternational )
        throw ::com::sun::star::uno::RuntimeException();

    String aStr1( s1.copy( off1, len1 ) );
    String aStr2( s2.copy( off2, len2 ) );
    if ( mnCompFlags || mnCaseConv )
        return mpInternational->Compare( aStr1, aStr2, INTN_COMPARE_IGNORECASE );
    else
        return mpInternational->Compare( aStr1, aStr2, 0 );
}


sal_Int32 SAL_CALL Transliteration::compareString(
            const ::rtl::OUString& s1, const ::rtl::OUString& s2
            ) throw (::com::sun::star::uno::RuntimeException)
{
    if ( !mpInternational )
        throw ::com::sun::star::uno::RuntimeException();

    if ( mnCompFlags || mnCaseConv )
        return mpInternational->Compare( s1, s2, INTN_COMPARE_IGNORECASE );
    else
        return mpInternational->Compare( s1, s2, 0 );
}


