/*************************************************************************
 *
 *  $RCSfile: inetldap.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 12:12:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETCORELDAP_HXX
#define _INETCORELDAP_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

#ifndef _LDAPMSG_HXX
#include <ldapmsg.hxx>
#endif

/*=======================================================================
 *
 * INetCoreLDAPConnection Interface.
 *
 * References:
 *   RFC 1777 - Lightweight Directory Access Protocol (Draft Standard).
 *   RFC 1823 - The LDAP Application Program Interface (Informational).
 *   RFC 1920 - Internet Official Protocol Standards (STD 1).
 *
 *=====================================================================*/
#define INETCORELDAP_DEF_PORT 389

class  INetCoreLDAPConnection;
struct INetCoreLDAPConnectionContext;

typedef int INetCoreLDAPCallback (
	INetCoreLDAPConnection *pConnection,
	int                    nReplyCode,
	const void             *pReplyData,
	sal_uInt16              nMessageID,
	void                   *pData);

class INetCoreLDAPConnection :
	public NAMESPACE_INET(INetClientConnection_Impl)
{
public:
	INetCoreLDAPConnection (void);

	virtual sal_Bool Open (
		const rtl::OUString  &rHost,
		sal_uInt16            nPort,
		INetCoreLDAPCallback *pfnCallback,
		void                 *pData);
	virtual sal_Bool IsOpen (void);

	virtual void Abort (void);
	virtual sal_uInt16 Bind (
		const rtl::OUString &rUserDN,
		const rtl::OUString &rPassword);
	virtual sal_uInt16 Unbind (void);

	virtual sal_uInt16 Add (
		const INetCoreLDAPEntry& rNewEntry);
	virtual sal_uInt16 Compare (
		const rtl::OUString                  &rObjectDN,
		const INetCoreLDAPAttributeValuePair &rAssertion);
	virtual sal_uInt16 Delete (
		const rtl::OUString &rObjectDN);
	virtual sal_uInt16 Modify (
		const INetCoreLDAPModifyRequestMessage& rMessage);
	virtual sal_uInt16 ModifyRDN (
		const rtl::OUString &rObjectDN,
		const rtl::OUString &rNewRDN);

	virtual sal_uInt16 List (
		const rtl::OUString &rBaseObject,
		sal_Bool             bAttrsOnly = sal_False);
	virtual sal_uInt16 Read (
		const rtl::OUString &rBaseObject,
		sal_Bool             bAttrsOnly = sal_False);
	virtual sal_uInt16 Search (
		const INetCoreLDAPSearchRequestMessage& rMessage);

	virtual sal_uInt16 Abandon (sal_uInt16 nMessageID);

protected:
	virtual ~INetCoreLDAPConnection (void);

private:
	typedef NAMESPACE_INET(INetSocket) socket_type;
	INetCoreLDAPConnectionContext *m_pConCtx;

	virtual sal_Bool handleResolverEvent (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry);

	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<socket_type> &rxSocket, sal_Int32 nEvent);

	sal_uInt16 startRequest (INetCoreLDAPMessage &rMessage);
};

#endif /* !_INETCORELDAP_HXX */

