/*************************************************************************
 *
 *  $RCSfile: ldapwrap.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _INET_LDAPWRAP_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

#ifndef _INET_LDAPWRAP_HXX
#include "ldapwrap.hxx"
#endif

#ifndef _LDAPMSG_HXX
#include "ldapmsg.hxx"
#endif

#ifndef _INETLDAP_HXX
#include "inetldap.hxx"
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

/*========================================================================
 *
 * INetLDAPWrapper implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
	VOS_CLASSNAME (INetLDAPWrapper, inet),
	VOS_NAMESPACE (INetLDAPWrapper, inet),
	VOS_NAMESPACE (OMutex, vos),
	0);

/*
 * INetLDAPWrapper.
 */
INetLDAPWrapper::INetLDAPWrapper (void)
{
}

/*
 * ~INetLDAPWrapper.
 */
INetLDAPWrapper::~INetLDAPWrapper (void)
{
}

/*
 * newLDAPConnection.
 */
sal_Bool INetLDAPWrapper::newLDAPConnection (
	NAMESPACE_VOS(ORef)<INetCoreLDAPConnection> &rxConnection)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rxConnection = new INetCoreLDAPConnection();
	return (rxConnection.isValid());
}

/*
 * newLDAPSearchRequestMessage.
 */
sal_Bool INetLDAPWrapper::newLDAPSearchRequestMessage (
	INetCoreLDAPSearchRequestMessage *&rpMessage)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpMessage = new INetCoreLDAPSearchRequestMessage();
	return (!!rpMessage);
}

/*
 * newLDAPModifyRequestMessage.
 */
sal_Bool INetLDAPWrapper::newLDAPModifyRequestMessage (
	INetCoreLDAPModifyRequestMessage *&rpMessage)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpMessage = new INetCoreLDAPModifyRequestMessage();
	return (!!rpMessage);
}

/*
 * newLDAPAttributeValuePair.
 */
sal_Bool INetLDAPWrapper::newLDAPAttributeValuePair (
	INetCoreLDAPAttributeValuePair *&rpAttribValuePair)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpAttribValuePair = new INetCoreLDAPAttributeValuePair();
	return (!!rpAttribValuePair);
}

/*
 * newLDAPAttribute.
 */
sal_Bool INetLDAPWrapper::newLDAPAttribute (
	INetCoreLDAPAttribute *&rpAttrib)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpAttrib = new INetCoreLDAPAttribute();
	return (!!rpAttrib);
}

/*
 * newLDAPEntry.
 */
sal_Bool INetLDAPWrapper::newLDAPEntry (
	INetCoreLDAPEntry *&rpEntry)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpEntry = new INetCoreLDAPEntry();
	return (!!rpEntry);
}

/*
 * newLDAPModification.
 */
sal_Bool INetLDAPWrapper::newLDAPModification (
	INetCoreLDAPModification *&rpModification)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpModification = new INetCoreLDAPModification();
	return (!!rpModification);
}

/*
 * newLDAPAndFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPAndFilter (
	INetCoreLDAPAndFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPAndFilter();
	return (!!rpFilter);
}

/*
 * newLDAPOrFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPOrFilter (
	INetCoreLDAPOrFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPOrFilter();
	return (!!rpFilter);
}

/*
 * newLDAPNotFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPNotFilter (
	INetCoreLDAPNotFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPNotFilter();
	return (!!rpFilter);
}

/*
 * newLDAPEqualityMatchFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPEqualityMatchFilter (
	INetCoreLDAPEqualityMatchFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPEqualityMatchFilter();
	return (!!rpFilter);
}

/*
 * newLDAPApproxMatchFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPApproxMatchFilter (
	INetCoreLDAPApproxMatchFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPApproxMatchFilter();
	return (!!rpFilter);
}

/*
 * newLDAPGreaterOrEqualFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPGreaterOrEqualFilter (
	INetCoreLDAPGreaterOrEqualFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPGreaterOrEqualFilter();
	return (!!rpFilter);
}

/*
 * newLDAPLessOrEqualFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPLessOrEqualFilter (
	INetCoreLDAPLessOrEqualFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPLessOrEqualFilter();
	return (!!rpFilter);
}

/*
 * newLDAPPresentFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPPresentFilter (
	INetCoreLDAPPresentFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPPresentFilter();
	return (!!rpFilter);
}

/*
 * newLDAPSubstringFilter.
 */
sal_Bool INetLDAPWrapper::newLDAPSubstringFilter (
	INetCoreLDAPSubstringFilter *&rpFilter)
{
	NAMESPACE_VOS(OGuard) aGuard (*this);
	rpFilter = new INetCoreLDAPSubstringFilter();
	return (!!rpFilter);
}

/*
 * NewINetLDAPWrapper.
 */
NAMESPACE_INET(INetLDAPWrapper)* SAL_CALL NewINetLDAPWrapper (void)
{
	return new INetLDAPWrapper();
}

