/*************************************************************************
 *
 *  $RCSfile: wrapper.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/15 13:46:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _INET_WRAPPER_CXX "$Revision: 1.5 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_DYNLOAD_HXX_
#include <vos/dynload.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

using rtl::OUString;

#ifdef MACOSX
// This definition isn't automatically added by the static initializer script. 
NAMESPACE_VOS(ORealDynamicLoader) *NAMESPACE_VOS(ODynamicLoader)<INetModuleApi>::m_pStaticLoader = NULL;
#endif

/*========================================================================
 *
 * INetWrapper internals.
 *
 *======================================================================*/
#define INET_MODULE_NAME SVLIBRARY("ni")
#define INET_MODULE_INIT "INetModuleInitialize"

/*========================================================================
 *
 * INetWrapper implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
	VOS_CLASSNAME (INetWrapper, inet),
	VOS_NAMESPACE (INetWrapper, inet),
	VOS_NAMESPACE (OObject, vos),
	0);

/*
 * INetWrapper.
 */
INetWrapper::INetWrapper (void)
	: m_aLoader (
		OUString::createFromAscii (INET_MODULE_NAME),
		OUString::createFromAscii (INET_MODULE_INIT)),
	  m_pApi    (NULL)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (m_aLoader.isLoaded())
	{
		m_pApi = (INetModuleApi *)(m_aLoader.getApi());
		acquire();
	}
}

/*
 * ~INetWrapper.
 */
INetWrapper::~INetWrapper (void)
{
	release();
}

/*
 * acquire.
 */
void INetWrapper::acquire (void)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (m_pApi)
		m_pApi->acquire();
}

/*
 * release.
 */
void INetWrapper::release (void)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (m_pApi)
		m_pApi->release();
}

/*
 * getINetConfig.
 */
sal_Bool INetWrapper::getINetConfig (
	NAMESPACE_VOS(ORef)<INetConfig> &rxConfig)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (m_pApi)
		return m_pApi->getINetConfig (rxConfig);
	else
		return sal_False;
}

/*
 * getINetCoreSSLConfig.
 */
sal_Bool INetWrapper::getINetCoreSSLConfig (INetCoreSSLConfig *&rpConfig)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpConfig = NULL;

	if (m_pApi)
		return m_pApi->getINetCoreSSLConfig (rpConfig);
	else
		return sal_False;
}

/*
 * newINetIMAPClient.
 */
sal_Bool INetWrapper::newINetIMAPClient (INetIMAPClientRef &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (m_pApi)
		return m_pApi->newINetIMAPClient (rxClient);
	else
		return sal_False;
}

/*
 * newINetFTPConnection.
 */
sal_Bool INetWrapper::newINetFTPConnection (
	NAMESPACE_VOS(ORef)<INetFTPConnection> &rxConnection)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (m_pApi)
		return m_pApi->newINetFTPConnection (rxConnection);
	else
		return sal_False;
}

/*
 * newINetHTTPWrapper.
 */
sal_Bool INetWrapper::newINetHTTPWrapper (INetHTTPWrapper *&rpWrapper)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpWrapper = NULL;

	if (m_pApi)
		return m_pApi->newINetHTTPWrapper (rpWrapper);
	else
		return sal_False;
}

/*
 * newINetLDAPWrapper.
 */
sal_Bool INetWrapper::newINetLDAPWrapper (INetLDAPWrapper *&rpWrapper)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpWrapper = NULL;

	if (m_pApi)
		return m_pApi->newINetLDAPWrapper (rpWrapper);
	else
		return sal_False;
}

/*
 * newINetCoreMailer.
 */
sal_Bool INetWrapper::newINetCoreMailer (INetCoreMailer *&rpMailer)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpMailer = NULL;

	if (m_pApi)
		return m_pApi->newINetCoreMailer (rpMailer);
	else
		return sal_False;
}

/*
 * newINetSession.
 */
sal_Bool INetWrapper::newINetSession (INetSession *&rpSession)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpSession = NULL;

	if (m_pApi)
		return m_pApi->newINetSession (rpSession);
	else
		return sal_False;
}

/*========================================================================
 *
 * Unresolved externals workaround.
 *
 *======================================================================*/
#ifndef MACOSX
#include <stdio.h>
void __panic (const char *c, const char *m)
{
	fprintf (stderr, "INetWrapper: Panic: wrong %s::%s called.\n", c, m);
}

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class INetCoreMailer
{
public:
	virtual ~INetCoreMailer();
};

INetCoreMailer::~INetCoreMailer()
{
	__panic ("INetCoreMailer", "~INetCoreMailer()");
}


class INetHTTPWrapper
{
public:
	virtual ~INetHTTPWrapper();
};

INetHTTPWrapper::~INetHTTPWrapper()
{
	__panic ("inet::INetHTTPWrapper", "~INetHTTPWrapper()");
}


class INetLDAPWrapper
{
public:
	virtual ~INetLDAPWrapper();
};

INetLDAPWrapper::~INetLDAPWrapper()
{
	__panic ("inet::INetLDAPWrapper", "~INetLDAPWrapper()");
}

#ifdef _USE_NAMESPACE
}
#endif


class INetCoreLDAPAttribute
{
public:
	virtual ~INetCoreLDAPAttribute();
};

INetCoreLDAPAttribute::~INetCoreLDAPAttribute()
{
	__panic ("INetCoreLDAPAttribute", "~INetCoreLDAPAttribute()");
}


class INetCoreLDAPAttributeValuePair
{
public:
	virtual ~INetCoreLDAPAttributeValuePair();
};

INetCoreLDAPAttributeValuePair::~INetCoreLDAPAttributeValuePair()
{
	__panic ("INetCoreLDAPAttributeValuePair",
			 "~INetCoreLDAPAttributeValuePair()");
}


class INetCoreLDAPFilter
{
public:
	virtual ~INetCoreLDAPFilter();
};

INetCoreLDAPFilter::~INetCoreLDAPFilter()
{
	__panic ("INetCoreLDAPFilter", "~INetCoreLDAPFilter()");
}


class INetCoreLDAPSearchRequestMessage
{
public:
	virtual ~INetCoreLDAPSearchRequestMessage();
};

INetCoreLDAPSearchRequestMessage::~INetCoreLDAPSearchRequestMessage()
{
	__panic ("INetCoreLDAPSearchRequestMessage",
			 "~INetCoreLDAPSearchRequestMessage()");
}


class INetCoreNewsMessage
{
public:
	virtual ~INetCoreNewsMessage();
};

INetCoreNewsMessage::~INetCoreNewsMessage()
{
	__panic ("INetCoreNewsMessage", "~INetCoreNewsMessage()");
}


class INetCoreMIMEMessage
{
public:
	virtual ~INetCoreMIMEMessage();
};

INetCoreMIMEMessage::~INetCoreMIMEMessage()
{
	__panic ("INetCoreMIMEMessage", "~INetCoreMIMEMessage()");
}


class INetCoreMIMEMessageStream
{
public:
	virtual ~INetCoreMIMEMessageStream();
};

INetCoreMIMEMessageStream::~INetCoreMIMEMessageStream()
{
	__panic ("INetCoreMIMEMessageStream", "~INetCoreMIMEMessageStream()");
}


class INetIMAPArgumentBodySectionList
{
public:
	virtual ~INetIMAPArgumentBodySectionList();
};

INetIMAPArgumentBodySectionList::~INetIMAPArgumentBodySectionList()
{
	__panic ("INetIMAPArgumentBodySectionList",
			 "~INetIMAPArgumentBodySectionList()");
}

class INetIMAPSearchKeyList
{
public:
	virtual ~INetIMAPSearchKeyList();
};

INetIMAPSearchKeyList::~INetIMAPSearchKeyList()
{
	__panic ("INetIMAPSearchKeyList", "~INetIMAPSearchKeyList()");
}


class INetIMAPMessageNumberSet
{
public:
	virtual ~INetIMAPMessageNumberSet();
};

INetIMAPMessageNumberSet::~INetIMAPMessageNumberSet()
{
	__panic ("INetIMAPMessageNumberSet", "~INetIMAPMessageNumberSet()");
}

#endif
