/*************************************************************************
 *
 *  $RCSfile: imapargs.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef INET_IMAPCLNT_HXX
#include <imapclnt.hxx>
#endif

#ifndef INET_IMAPCIMP_HXX
#include <imapcimp.hxx>
#endif

//============================================================================
//
//  INetIMAPMessageNumberSet
//
//============================================================================

// virtual
void INetIMAPMessageNumberSet::add_Impl(sal_uInt32 nLowerBound,
										sal_uInt32 nUpperBound)
{
	Range ** pStartRange = &m_pRanges;
	while (*pStartRange)
		if (nUpperBound < (*pStartRange)->m_nLowerBound)
			if (nUpperBound < (*pStartRange)->m_nLowerBound - 1)
				break;
			else
			{
				(*pStartRange)->m_nLowerBound = nLowerBound;
				return;
			}
		else if (nLowerBound <= (*pStartRange)->m_nUpperBound
				 || nLowerBound == (*pStartRange)->m_nUpperBound + 1)
			if (nUpperBound <= (*pStartRange)->m_nUpperBound)
				return;
			else if (nUpperBound == (*pStartRange)->m_nUpperBound + 1)
			{
				if ((*pStartRange)->m_pNext
					&& (*pStartRange)->m_pNext->m_nLowerBound
					    == nUpperBound + 1)
				{
					Range * pNext = (*pStartRange)->m_pNext;
					(*pStartRange)->m_nUpperBound = pNext->m_nUpperBound;
					(*pStartRange)->m_pNext = pNext->m_pNext;
					delete pNext;
				}
				else
					(*pStartRange)->m_nUpperBound = nUpperBound;
				return;
			}
			else
			{
				Range * pEndRange = (*pStartRange)->m_pNext;
				while (pEndRange)
					if (nUpperBound < pEndRange->m_nLowerBound)
						if (nUpperBound < pEndRange->m_nLowerBound - 1)
							break;
						else
						{
							(*pStartRange)->m_nUpperBound
							 = pEndRange->m_nUpperBound;
							(*pStartRange)->m_pNext = pEndRange->m_pNext;
							delete pEndRange;
							return;
						}
					else if (nUpperBound <= pEndRange->m_nUpperBound)
					{
						(*pStartRange)->m_nUpperBound
						 = pEndRange->m_nUpperBound;
						(*pStartRange)->m_pNext = pEndRange->m_pNext;
						delete pEndRange;
						return;
					}
					else if (nUpperBound == pEndRange->m_nUpperBound + 1)
					{
						if (pEndRange->m_pNext
							&& pEndRange->m_pNext->m_nLowerBound
							    == nUpperBound + 1)
						{
							(*pStartRange)->m_nUpperBound
							 = pEndRange->m_pNext->m_nUpperBound;
							(*pStartRange)->m_pNext
							 = pEndRange->m_pNext->m_pNext;
							delete pEndRange->m_pNext;
						}
						else
						{
							(*pStartRange)->m_nUpperBound = nUpperBound;
							(*pStartRange)->m_pNext = pEndRange->m_pNext;
						}
						delete pEndRange;
						return;
					}
					else
					{
						Range * pNext = pEndRange->m_pNext;
						delete pEndRange;
						pEndRange = pNext;
					}
				(*pStartRange)->m_nUpperBound = nUpperBound;
				(*pStartRange)->m_pNext = pEndRange;
				return;
			}
		else
			pStartRange = &(*pStartRange)->m_pNext;

	Range * pNewRange = new Range;
	pNewRange->m_nLowerBound = nLowerBound;
	pNewRange->m_nUpperBound = nUpperBound;
	pNewRange->m_pNext = *pStartRange;
	*pStartRange = pNewRange;
}

//============================================================================
// virtual
INetIMAPMessageNumberSet::~INetIMAPMessageNumberSet()
{
	while (m_pRanges)
	{
		Range * pRange = m_pRanges;
		m_pRanges = m_pRanges->m_pNext;
		delete pRange;
	}
}

//============================================================================
// virtual
INetIMAPMessageNumberSet * INetIMAPMessageNumberSet::clone() const
{
	INetIMAPMessageNumberSet * pSet = new INetIMAPMessageNumberSet;
	Range ** pTargetRange = &pSet->m_pRanges;
	for (Range * pSourceRange = m_pRanges; pSourceRange;
		 pSourceRange = pSourceRange->m_pNext)
	{
		*pTargetRange = new Range;
		(*pTargetRange)->m_nLowerBound = pSourceRange->m_nLowerBound;
		(*pTargetRange)->m_nUpperBound = pSourceRange->m_nUpperBound;
		pTargetRange = &(*pTargetRange)->m_pNext;
	}
	*pTargetRange = 0;
	return pSet;
}

//============================================================================
sal_uInt32 INetIMAPMessageNumberSet::getRangeCount() const
{
	sal_uInt32 nCount = 0;
	for (Range * pRange = m_pRanges; pRange; pRange = pRange->m_pNext)
		++nCount;
	return nCount;
}

//============================================================================
void INetIMAPMessageNumberSet::getRange(sal_uInt32 nIndex, bool & rHalfOpen,
										sal_uInt32 & rLowerBound,
										sal_uInt32 & rUpperBound) const
{
	Range * pRange = m_pRanges;
	while (nIndex-- != 0)
		pRange = pRange->m_pNext;
	rHalfOpen = pRange->m_nUpperBound == HALF_OPEN;
	rLowerBound = pRange->m_nLowerBound;
	if (!rHalfOpen)
		rUpperBound = pRange->m_nUpperBound;
}

//============================================================================
ByteString INetIMAPMessageNumberSet::toString() const
{
	INetMIMEStringOutputSink
		aString(0, INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
	sal_uInt32 nRangeCount = getRangeCount();
	DBG_ASSERT(nRangeCount != 0,
			   "INetIMAPMessageNumberSet::toString(): Empty set");
	for (sal_uInt32 i = 0; i < nRangeCount; ++i)
	{
		bool bHalfOpen;
		sal_uInt32 nLowerBound;
		sal_uInt32 nUpperBound;
		getRange(i, bHalfOpen, nLowerBound, nUpperBound);
		DBG_ASSERT(nLowerBound
				   && (bHalfOpen ? i == nRangeCount - 1 :
					               nLowerBound <= nUpperBound),
				   "INetIMAPMessageNumberSet::toString(): Bad range");
		if (i != 0)
			aString << ',';
		INetMIME::writeUnsigned(aString, nLowerBound);
		if (bHalfOpen)
			aString.write(RTL_CONSTASCII_STRINGPARAM(":*"));
		else if (nUpperBound > nLowerBound)
		{
			aString << ':';
			INetMIME::writeUnsigned(aString, nUpperBound);
		}
	}
	return aString.takeBuffer();
}

//============================================================================
//
//  INetIMAPSearchKey
//
//============================================================================

// virtual
INetIMAPSearchKey::~INetIMAPSearchKey()
{}

//============================================================================
//
//  INetIMAPSearchKeyList
//
//============================================================================

// virtual
INetIMAPSearchKeyList::~INetIMAPSearchKeyList()
{
	while (Count() != 0)
		delete static_cast< INetIMAPSearchKey * >(Remove(Count() - 1));
}

//============================================================================
//
//  INetIMAPSimpleSearchKey
//
//============================================================================

// virtual
void INetIMAPSimpleSearchKey::appendCommandArguments(INetIMAPClient_Impl &
													     rClient) const
{
	static sal_Char const * const aCriteriumText[CRITERIUM_UNSEEN + 1]
		= { "ALL", "ANSWERED", "DELETED", "DRAFT", "FLAGGED", "NEW", "OLD",
			"RECENT", "SEEN", "UNANSWERED", "UNDELETED", "UNDRAFT",
			"UNFLAGGED", "UNSEEN" };
	rClient.appendCommandArgument(new INetIMAPCommandArgument(
		                                  INetIMAPCommandArgument::TYPE_TEXT,
										  aCriteriumText[m_eCriterium]));
}

//============================================================================
//
//  INetIMAPTextSearchKey
//
//============================================================================

// virtual
void INetIMAPTextSearchKey::appendCommandArguments(INetIMAPClient_Impl &
												       rClient) const
{
	static sal_Char const * const aPropertyText[PROPERTY_TO + 1]
		= { "BCC", "BODY", "CC", "FROM", "SUBJECT", "TEXT", "TO" };
	rClient.appendCommandArgument(new INetIMAPCommandArgument(
		                                  INetIMAPCommandArgument::TYPE_TEXT,
										  aPropertyText[m_eProperty]));
	rClient.
		appendCommandArgument(new INetIMAPCommandArgument(
			                          INetIMAPCommandArgument::TYPE_ASTRING,
									  m_aText));
}

//============================================================================
//
//  INetIMAPRFC822SizeSearchKey
//
//============================================================================

// virtual
void INetIMAPRFC822SizeSearchKey::appendCommandArguments(INetIMAPClient_Impl &
														     rClient) const
{
	INetMIMEStringOutputSink
		aArguments(0, INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
	static sal_Char const * const aConditionalText[CONDITIONAL_SMALLER + 1]
		= { "LARGER ", "SMALLER " };
	aArguments << aConditionalText[m_eConditional];
	INetMIME::writeUnsigned(aArguments, m_nSize);
	rClient.appendCommandArgument(new INetIMAPCommandArgument(
		                                  INetIMAPCommandArgument::TYPE_TEXT,
										  aArguments.takeBuffer()));
}

//============================================================================
//
//  INetIMAPDateSearchKey
//
//============================================================================

// virtual
void INetIMAPDateSearchKey::appendCommandArguments(INetIMAPClient_Impl &
												       rClient) const
{
	INetMIMEStringOutputSink
		aArguments(0, INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
	static sal_Char const * const aConditionalText[CONDITIONAL_SINCE + 1]
		= { "BEFORE ", "ON ", "SENTBEFORE ", "SENTON ", "SENTSINCE ",
			"SINCE " };
	aArguments << aConditionalText[m_eConditional];
	INetMIME::writeUnsigned(aArguments, m_aDate.GetDay());
	static sal_Char const * const aMonth[12]
		= { " Jan-", " Feb-", " Mar-", " Apr-", " May-", " Jun-", " Jul-",
			" Aug-", " Sep-", " Oct-", " Nov-", " Dec-" };
	aArguments << aMonth[m_aDate.GetMonth() - 1];
	INetMIME::writeUnsigned(aArguments, m_aDate.GetYear());
	rClient.appendCommandArgument(new INetIMAPCommandArgument(
		                                  INetIMAPCommandArgument::TYPE_TEXT,
										  aArguments.takeBuffer()));
}

//============================================================================
//
//  INetIMAPKeywordSearchKey
//
//============================================================================

// virtual
void INetIMAPKeywordSearchKey::appendCommandArguments(INetIMAPClient_Impl &
													      rClient) const
{
	static sal_Char const * const aConditionalText[CONDITIONAL_UNKEYWORD + 1]
		= { "KEYWORD ", "UNKEYWORD " };
	ByteString aArguments = aConditionalText[m_eConditional];
	aArguments += m_aKeyword;
	rClient.appendCommandArgument(new INetIMAPCommandArgument(
		                                  INetIMAPCommandArgument::TYPE_TEXT,
										  aArguments));
}

//============================================================================
//
//  INetIMAPHeaderSearchKey
//
//============================================================================

// virtual
void INetIMAPHeaderSearchKey::appendCommandArguments(INetIMAPClient_Impl &
													     rClient) const
{
	rClient.
		appendCommandArgument(new INetIMAPCommandArgument(
			                          INetIMAPCommandArgument::TYPE_ASTRING,
									  m_aFieldName));
	rClient.
		appendCommandArgument(new INetIMAPCommandArgument(
			                          INetIMAPCommandArgument::TYPE_ASTRING,
									  m_aText));
}

//============================================================================
//
//  INetIMAPSetSearchKey
//
//============================================================================

// virtual
INetIMAPSetSearchKey::~INetIMAPSetSearchKey()
{
	delete m_pSet;
}

//============================================================================
// virtual
void INetIMAPSetSearchKey::appendCommandArguments(INetIMAPClient_Impl &
												      rClient) const
{
	rClient.appendCommandArgument(new INetIMAPCommandArgument(
		                                  INetIMAPCommandArgument::TYPE_TEXT,
										  m_pSet->toString()));
}

//============================================================================
//
//  INetIMAPListSearchKey
//
//============================================================================

// virtual
void INetIMAPListSearchKey::appendCommandArguments(INetIMAPClient_Impl &
												       rClient) const
{
	rClient.appendCommandArgument(
		        new INetIMAPCommandArgument(
					    INetIMAPCommandArgument::TYPE_LIST_OPEN));
	for (sal_uInt32 i = 0; i < m_aList.getCount(); ++i)
		m_aList.get(i).appendCommandArguments(rClient);
	rClient.appendCommandArgument(
		        new INetIMAPCommandArgument(
					    INetIMAPCommandArgument::TYPE_LIST_CLOSE));
}

//============================================================================
//
//  INetIMAPNegationSearchKey
//
//============================================================================

// virtual
INetIMAPNegationSearchKey::~INetIMAPNegationSearchKey()
{
	delete m_pKey;
}

//============================================================================
// virtual
void INetIMAPNegationSearchKey::appendCommandArguments(INetIMAPClient_Impl &
													       rClient) const
{
	rClient.
		appendCommandArgument(new INetIMAPCommandArgument(
			                          INetIMAPCommandArgument::TYPE_TEXT,
									  ByteString(RTL_CONSTASCII_STRINGPARAM(
										             "NOT"))));
	m_pKey->appendCommandArguments(rClient);
}

//============================================================================
//
//  INetIMAPDisjunctionSearchKey
//
//============================================================================

// virtual
INetIMAPDisjunctionSearchKey::~INetIMAPDisjunctionSearchKey()
{
	delete m_pKey1;
	delete m_pKey2;
}

//============================================================================
// virtual
void
 INetIMAPDisjunctionSearchKey::appendCommandArguments(INetIMAPClient_Impl &
													      rClient) const
{
	rClient.
		appendCommandArgument(new INetIMAPCommandArgument(
			                          INetIMAPCommandArgument::TYPE_TEXT,
									  ByteString(RTL_CONSTASCII_STRINGPARAM(
										             "OR"))));
	m_pKey1->appendCommandArguments(rClient);
	m_pKey2->appendCommandArguments(rClient);
}

//============================================================================
//
//  INetIMAPHeaderFieldList
//
//============================================================================

// virtual
INetIMAPHeaderFieldList::~INetIMAPHeaderFieldList()
{
	while (Count() != 0)
		delete static_cast< ByteString * >(Remove(Count() - 1));
}

//============================================================================
// virtual
void INetIMAPHeaderFieldList::append(ByteString const & rHeaderField)
{
	for (sal_uInt32 i = 0; i < Count(); ++i)
		if (*static_cast< ByteString * >(GetObject(i)) == rHeaderField)
			return;
	Insert(new ByteString(rHeaderField), LIST_APPEND);
}

//============================================================================
ByteString INetIMAPHeaderFieldList::toString() const
{
	ByteString aString;
	if (m_bNegated)
		aString.Assign(RTL_CONSTASCII_STRINGPARAM(".NOT"));
	aString.Append(RTL_CONSTASCII_STRINGPARAM(" ("));
	for (sal_uInt32 i = 0; i < getCount(); ++i)
	{
		if (i != 0)
			aString += ' ';
		aString += get(i);
	}
	aString += ')';
	return aString;
}

//============================================================================
//
//  INetIMAPHeaderFieldListList
//
//============================================================================

// virtual
INetIMAPHeaderFieldListList::~INetIMAPHeaderFieldListList()
{
	while (Count() != 0)
		delete static_cast< INetIMAPHeaderFieldList * >(Remove(Count() - 1));
}

//============================================================================
//
//  INetIMAPBodySectionDescriptor
//
//============================================================================

// virtual
void INetIMAPBodySectionDescriptor::appendSectionNumber(sal_uInt32
														    nSectionNumber)
{
	DBG_ASSERT(m_eSectionText == SECTION_TEXT_NO,
			   "INetIMAPBodySectionDescriptor::appendSectionNumber():"
			       " Invalid type");
	DBG_ASSERT(m_aSectionNumberSequence.getCount() == 0
			   || m_aSectionNumberSequence.
			              get(m_aSectionNumberSequence.getCount() - 1)
			          != 0,
			   "INetIMAPBodySectionDescriptor::appendSectionNumber():"
			       " Invalid sequence");
	m_aSectionNumberSequence.append(nSectionNumber);
}

//============================================================================
// virtual
void INetIMAPBodySectionDescriptor::appendSectionText(SectionText
													      eTheSectionText)
{
	DBG_ASSERT(m_eSectionText == SECTION_TEXT_NO,
			   "INetIMAPBodySectionDescriptor::appendSectionText():"
			       " Invalid old type");
	DBG_ASSERT((eTheSectionText < RFC822
				    || !m_aSectionNumberSequence.getCount())
			   && (eTheSectionText != SECTION_TEXT_MIME
				   || m_aSectionNumberSequence.getCount())
			   && (eTheSectionText == SECTION_TEXT_NO
				   || m_aSectionNumberSequence.getCount() == 0
				   || m_aSectionNumberSequence.
				              get(m_aSectionNumberSequence.getCount() - 1)
				          != 0),
			   "INetIMAPBodySectionDescriptor::appendSectionText():"
			       " Invalid new type");
	m_eSectionText = eTheSectionText;
	if (m_eSectionText == SECTION_TEXT_HEADER_FIELDS_NOT)
		m_aHeaderFields.setNegated();
}

//============================================================================
// virtual
void INetIMAPBodySectionDescriptor::appendHeaderField(ByteString const &
													      rHeaderField)
{
	DBG_ASSERT(m_eSectionText == SECTION_TEXT_HEADER_FIELDS
			   || m_eSectionText == SECTION_TEXT_HEADER_FIELDS_NOT,
			   "INetIMAPBodySectionDescriptor::appendHeaderField():"
			       " Invalid type");
	m_aHeaderFields.append(rHeaderField);
}

//============================================================================
//
//  INetIMAPArgumentBodySection
//
//============================================================================

ByteString INetIMAPArgumentBodySection::toString() const
{
	INetMIMEStringOutputSink
		aString(0, INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
	aString.write(RTL_CONSTASCII_STRINGPARAM("BODY"));
	if (m_bPeek)
		aString.write(RTL_CONSTASCII_STRINGPARAM(".PEEK"));
	aString << '[';
	bool bDot = false;
	for (sal_uInt32 i = 0; i < getSectionNumberSequence().getCount(); ++i)
	{
		if (bDot)
			aString << '.';
		aString << getSectionNumberSequence().get(i);
		bDot = true;
	}
	if (getSectionText() != SECTION_TEXT_NO)
	{
		if (bDot)
			aString << '.';
		switch (getSectionText())
		{
			case SECTION_TEXT_HEADER:
				aString.write(RTL_CONSTASCII_STRINGPARAM("HEADER"));
				break;

			case SECTION_TEXT_HEADER_FIELDS:
			case SECTION_TEXT_HEADER_FIELDS_NOT:
			{
				aString.write(RTL_CONSTASCII_STRINGPARAM("HEADER.FIELDS"));
				aString << getHeaderFields().toString();
				break;
			}

			case SECTION_TEXT_TEXT:
				aString.write(RTL_CONSTASCII_STRINGPARAM("TEXT"));
				break;

			case SECTION_TEXT_MIME:
				aString.write(RTL_CONSTASCII_STRINGPARAM("MIME"));
				break;
		}
	}
	aString << ']';
	if (m_bPartial)
	{
		aString << '<';
		INetMIME::writeUnsigned(aString, m_nPartialOffset);
		aString << '.';
		INetMIME::writeUnsigned(aString, m_nPartialLength);
		aString << '>';
	}
	return aString.takeBuffer();
}

//============================================================================
//
//  INetIMAPArgumentBodySectionList
//
//============================================================================

// virtual
INetIMAPArgumentBodySectionList::~INetIMAPArgumentBodySectionList()
{
	while (Count() != 0)
		delete static_cast< INetIMAPArgumentBodySection * >(Remove(Count()
																       - 1));
}

//============================================================================
//
//  INetIMAPFlagKeywordList
//
//============================================================================

// virtual
INetIMAPFlagKeywordList::~INetIMAPFlagKeywordList()
{
	while (Count() != 0)
		delete static_cast< ByteString * >(Remove(Count() - 1));
}

//============================================================================
void INetIMAPFlagKeywordList::append(ByteString const & rFlagKeyword)
{
	for (sal_uInt32 i = 0; i < Count(); ++i)
		if (*static_cast< ByteString * >(GetObject(i)) == rFlagKeyword)
			return;
	Insert(new ByteString(rFlagKeyword), LIST_APPEND);
}

