/*************************************************************************
 *
 *  $RCSfile: imapcmds.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:43:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <algorithm>

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef INET_IMAPCIMP_HXX
#include <imapcimp.hxx>
#endif
#ifndef INET_IMAPCMDS_HXX
#include <imapcmds.hxx>
#endif

//============================================================================
//
//  INetIMAPCommandStream
//
//============================================================================

// static
bool INetIMAPCommandStream::isAtomOrQuoted(ByteString const & rAString,
											   bool bWildAtoms,
											   ByteString & rAtomOrQuoted)
{
	enum Type { ATM, WLD, QTD, LIT };
	static Type const aType[256]
		= { LIT, QTD, QTD, QTD, QTD, QTD, QTD, QTD,
			QTD, QTD, LIT, QTD, QTD, LIT, QTD, QTD, // LF CR
			QTD, QTD, QTD, QTD, QTD, QTD, QTD, QTD,
			QTD, QTD, QTD, QTD, QTD, QTD, QTD, QTD,
			QTD, ATM, LIT, ATM, ATM, WLD, ATM, ATM, //  !"#$%&'
			QTD, QTD, WLD, ATM, ATM, ATM, ATM, ATM, // ()*+,-./
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // 01234567
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // 89:;<=>?
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // @ABCDEFG
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // HIJKLMNO
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // PQRSTUVW
			ATM, ATM, ATM, ATM, LIT, ATM, ATM, ATM, // XYZ[\]^_
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // `abcdefg
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // hijklmno
			ATM, ATM, ATM, ATM, ATM, ATM, ATM, ATM, // pqrstuvw
			ATM, ATM, ATM, QTD, ATM, ATM, ATM, QTD, // xyz{|}~
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT,
			LIT, LIT, LIT, LIT, LIT, LIT, LIT, LIT };
		// <quoted-specials> map to LIT because at least the 'Solstice (tm)
		// Internet Mail Server (tm) IMAP4 service @ 2.0' doesn't accept <"\"
		// quoted-special> within <quoted>
	Type eType = rAString.Len() == 0 ? QTD : ATM;
	for (xub_StrLen i = 0; i < rAString.Len(); ++i)
		switch (aType[sal_uChar(rAString.GetChar(i))])
		{
			case WLD:
				if (!bWildAtoms)
					eType = QTD;
				break;

			case QTD:
				eType = QTD;
				break;

			case LIT:
				return false;
		}
	if (eType == ATM)
		rAtomOrQuoted = rAString;
	else
	{
		if (rAString.Len() > STRING_MAXLEN - 2)
			return false;
		rAtomOrQuoted = '"';
		rAtomOrQuoted += rAString;
		rAtomOrQuoted += '"';
	}
	return true;
}

//============================================================================
// virtual
INetIMAPCommandStream::~INetIMAPCommandStream()
{
	delete m_pStream;
	while (m_pArguments)
	{
		INetIMAPCommandArgument * pArgument = m_pArguments;
		m_pArguments = m_pArguments->getNext();
		delete pArgument;
	}
}

//============================================================================
void INetIMAPCommandStream::appendArgument(INetIMAPCommandArgument *
										    pArgument)
{
	DBG_ASSERT(pArgument,
			   "INetIMAPCommandStream::appendArgument(): Null argument");
	DBG_ASSERT(m_nPosition == 0,
			   "INetIMAPCommandStream::appendArgument(): Started stream");
	INetIMAPCommandArgument ** pArguments = &m_pArguments;
	while (*pArguments)
		pArguments = (*pArguments)->getNextAddress();
	*pArguments = pArgument;
}

//============================================================================
void INetIMAPCommandStream::continueWithLiteral()
{
	DBG_ASSERT(m_eState == STATE_LITERAL_WAITING && m_aText.Len() == 0
			   && !m_bActive,
			   "INetIMAPCommandStream::continueWithLiteral(): Invalid state");
	DBG_ASSERT(m_pArguments,
			   "INetIMAPCommandStream::continueWithLiteral():"
			       " Null arguments");
	DBG_ASSERT(m_pArguments->getType()
			       == INetIMAPCommandArgument::TYPE_ASTRING
			   || m_pArguments->getType()
			          == INetIMAPCommandArgument::TYPE_ASTRING_WILD
			   || m_pArguments->getType()
			          == INetIMAPCommandArgument::TYPE_STREAM
			   || m_pArguments->getType()
			          == INetIMAPCommandArgument::TYPE_STREAM_BASE64,
			   "INetIMAPCommandStream::continueWithLiteral():"
			       " Invalid argument type");
	INetIMAPCommandArgument * pUsedArgument = m_pArguments;
	m_pArguments = pUsedArgument->getNext();
	m_aText = pUsedArgument->getText();
	m_pStream = pUsedArgument->takeStream();
	delete pUsedArgument;
	m_nPosition = 0;
	m_eState = STATE_TEXT;
}

//============================================================================
// virtual
ErrCode INetIMAPCommandStream::ReadAt(ULONG nPos, void * pBuffer,
									  ULONG nCount, ULONG * pRead) const
{
	if (nCount == 0)
	{
		if (pRead)
			*pRead = 0;
		return ERRCODE_NONE;
	}
	if (!pBuffer)
		return ERRCODE_IO_INVALIDPARAMETER;
	if (m_bActive)
		return ERRCODE_IO_PENDING;
	if (nPos != m_nPosition)
		return ERRCODE_IO_CANTREAD;

	const_cast< INetIMAPCommandStream * >(this)->m_bActive = true;

	ULONG nIndex = 0;
	bool bDone = false;
	ErrCode nError = ERRCODE_NONE;
	do
	{
		if (m_aText.Len() != 0)
		{
			sal_uInt32 nSize = m_aText.Len() < nCount - nIndex ?
                                   sal_uInt32(m_aText.Len()) :
                                   sal_uInt32(nCount - nIndex);
				//TODO: assumes m_aText.Len()
				// <= std::numeric_limits< sal_uInt32 >::max()
			rtl_copyMemory(static_cast< sal_Char * >(pBuffer) + nIndex,
						   m_aText.GetBuffer(), nSize);
			const_cast< INetIMAPCommandStream * >(this)->
				m_aText.Erase(0, xub_StrLen(nSize));
			nIndex += nSize;
		}

		while (m_pStream && nIndex < nCount)
		{
			if (m_aStreamPacket.Len() != 0)
			{
				sal_uInt32 nSize = m_aStreamPacket.Len() < nCount - nIndex ?
                                       sal_uInt32(m_aStreamPacket.Len()) :
                                       sal_uInt32(nCount - nIndex);
					//TODO: assumes m_aStreamPacket.Len()
					// <= std::numeric_limits< sal_uInt32 >::max()
				rtl_copyMemory(static_cast< sal_Char * >(pBuffer) + nIndex,
							   m_aStreamPacket.GetBuffer(), nSize);
				const_cast< INetIMAPCommandStream * >(this)->
					m_aStreamPacket.Erase(0, xub_StrLen(nSize));
				nIndex += nSize;
			}

			if (m_aStreamPacket.Len() == 0)
				if (m_nStreamLen > 0)
					if (m_bBase64)
					{
						sal_uInt8 aPacketBuffer[3];
						sal_uInt32 nPacketWidth
							= std::min< sal_uInt32 >(m_nStreamLen,
													 sal_uInt32(3));
						if (m_pStream->Read(aPacketBuffer, nPacketWidth)
							    != nPacketWidth)
						{
							nError = m_pStream->GetError();
							if (nError == ERRCODE_NONE)
								nError = ERRCODE_IO_CANTREAD;
							bDone = true;
							break;
						}

						sal_uInt32 nValue = 0;
						int nPrecision = 16;
						for (sal_uInt32 i = 0; i < nPacketWidth; ++i)
						{
							nValue |= sal_uInt32(aPacketBuffer[i])
								          << nPrecision;
							nPrecision -= 8;
						}

						const_cast< INetIMAPCommandStream * >(this)->
							    m_aStreamPacket
							+= sal_Char(INetMIME::getBase64Digit(nValue
																     >> 18));
						const_cast< INetIMAPCommandStream * >(this)->
							    m_aStreamPacket
							+= sal_Char(INetMIME::getBase64Digit(nValue >> 12
															         & 63));
						if (nPacketWidth == 1)
							const_cast< INetIMAPCommandStream * >(this)->
								m_aStreamPacket.
								    Append(RTL_CONSTASCII_STRINGPARAM("=="));
						else
						{
							const_cast< INetIMAPCommandStream * >(this)->
								    m_aStreamPacket
								+= sal_Char(INetMIME::getBase64Digit(
									            nValue >> 6 & 63));
							if (nPacketWidth == 2)
								const_cast< INetIMAPCommandStream * >(this)->
									    m_aStreamPacket
									+= '=';
							else
								const_cast< INetIMAPCommandStream * >(this)->
									    m_aStreamPacket
									+= sal_Char(INetMIME::getBase64Digit(
										            nValue & 63));
						}

						const_cast< INetIMAPCommandStream * >(this)->
							    m_nStreamLen
							-= nPacketWidth;
						if (m_nStreamLen == 0
							|| ++const_cast< INetIMAPCommandStream * >(this)->
							             m_nStreamWidth
						           == INetMIME::SOFT_LINE_LENGTH_LIMIT / 4)
						{
							const_cast< INetIMAPCommandStream * >(this)->
								    m_aStreamPacket
								+= "\x0D\x0A";
							const_cast< INetIMAPCommandStream * >(this)->
								    m_nStreamWidth
								= 0;
						}
					}
					else
					{
						sal_uInt32 nSize = m_nStreamLen < nCount - nIndex ?
                                               m_nStreamLen :
                                               sal_uInt32(nCount - nIndex);
						sal_uInt32 nRead
							= m_pStream->
							      Read(static_cast< sal_Char * >(pBuffer)
									       + nIndex,
									   nSize);
						const_cast< INetIMAPCommandStream * >(this)->
							    m_nStreamLen
							-= nRead;
						nIndex += nRead;
						if (nRead != nSize)
						{
							nError = m_pStream->GetError();
							if (nError == ERRCODE_NONE)
								nError = ERRCODE_IO_CANTREAD;
							bDone = true;
							break;
						}
					}
				else
				{
					delete const_cast< INetIMAPCommandStream * >(this)->
						       m_pStream;
					const_cast< INetIMAPCommandStream * >(this)->m_pStream
						= 0;
				}
		}

		if (!bDone && m_aText.Len() == 0 && !m_pStream)
			switch (m_eState)
			{
				case STATE_TEXT:
					if (m_pArguments
						&& m_pArguments->getType()
						    != INetIMAPCommandArgument::TYPE_LIST_CLOSE)
						const_cast< INetIMAPCommandStream * >(this)->m_aText
							= ' ';
					else
						const_cast< INetIMAPCommandStream * >(this)->
							m_aText.Erase();

					while (m_pArguments
						   && m_pArguments->getType()
						          == INetIMAPCommandArgument::TYPE_LIST_OPEN)
					{
						const_cast< INetIMAPCommandStream * >(this)->m_aText
							+= '(';

						INetIMAPCommandArgument * pUsedArgument
							= m_pArguments;
						const_cast< INetIMAPCommandStream * >(this)->
							    m_pArguments
							= pUsedArgument->getNext();
						delete pUsedArgument;
					}

					if (m_pArguments)
						const_cast< INetIMAPCommandStream * >(this)->
							    m_eState
							= STATE_ARGUMENT_PREFIX;
					else
					{
						const_cast< INetIMAPCommandStream * >(this)->
							m_aText.Append(RTL_CONSTASCII_STRINGPARAM(
								               "\x0D\x0A"));
						const_cast< INetIMAPCommandStream * >(this)->
							    m_eState
							= STATE_FINAL_CRLF;
					}
					break;

				case STATE_ARGUMENT_PREFIX:
					switch (m_pArguments->getType())
					{
						case INetIMAPCommandArgument::TYPE_LIST_CLOSE:
						{
							const_cast< INetIMAPCommandStream * >(this)->
								    m_aText
								= ')';

							INetIMAPCommandArgument * pUsedArgument
								= m_pArguments;
							const_cast< INetIMAPCommandStream * >(this)->
								    m_pArguments
								= pUsedArgument->getNext();
							delete pUsedArgument;
							const_cast< INetIMAPCommandStream * >(this)->
								    m_eState
								= STATE_TEXT;
							break;
						}

						case INetIMAPCommandArgument::TYPE_TEXT:
						{
							const_cast< INetIMAPCommandStream * >(this)->
								    m_aText
								= m_pArguments->getText();

							INetIMAPCommandArgument * pUsedArgument
								= m_pArguments;
							const_cast< INetIMAPCommandStream * >(this)->
								    m_pArguments
								= pUsedArgument->getNext();
							delete pUsedArgument;
							const_cast< INetIMAPCommandStream * >(this)->
								    m_eState
								= STATE_TEXT;
							break;
						}

						case INetIMAPCommandArgument::TYPE_ASTRING:
						case INetIMAPCommandArgument::TYPE_ASTRING_WILD:
							if (isAtomOrQuoted(
								    m_pArguments->getText(),
									m_pArguments->getType()
								== INetIMAPCommandArgument::TYPE_ASTRING_WILD,
									const_cast< INetIMAPCommandStream * >(
										    this)->
									    m_aText))
							{
								INetIMAPCommandArgument * pUsedArgument
									= m_pArguments;
								const_cast< INetIMAPCommandStream * >(this)->
									    m_pArguments
									= pUsedArgument->getNext();
								delete pUsedArgument;
								const_cast< INetIMAPCommandStream * >(this)->
									    m_eState
									= STATE_TEXT;
							}
							else
							{
								INetMIMEStringOutputSink
									aSink(
										0,
									INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
								aSink << '{';
								INetMIME::writeUnsigned(aSink,
														m_pArguments->
														    getText().Len());
								if (m_bLiteralPlus)
									aSink << '+';
								aSink.write(RTL_CONSTASCII_STRINGPARAM(
									            "}\x0D\x0A"));
								const_cast< INetIMAPCommandStream * >(this)->
									    m_aText
									= aSink.takeBuffer();
								const_cast< INetIMAPCommandStream * >(this)->
									    m_eState
									= m_bLiteralPlus ? STATE_LITERAL_PLUS :
								                       STATE_LITERAL_WAITING;
							}
							break;

						case INetIMAPCommandArgument::TYPE_STREAM:
						{
							SvStream * pStream = m_pArguments->getStream();
							if (pStream)
							{
								const_cast< INetIMAPCommandStream * >(this)->
									    m_nStreamLen
									= pStream->Seek(STREAM_SEEK_TO_END);
								pStream->Seek(0);
								nError = pStream->GetError();
								if (nError != ERRCODE_NONE)
								{
									bDone = true;
									break;
								}
							}
							else
								const_cast< INetIMAPCommandStream * >(this)->
									    m_nStreamLen
									= 0;
							const_cast< INetIMAPCommandStream * >(this)->
								    m_bBase64
								= false;

							INetMIMEStringOutputSink
								aSink(
									0,
									INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
							aSink << '{';
							INetMIME::writeUnsigned(aSink,
													m_pArguments->
													        getText().Len()
													    + m_nStreamLen);
							if (m_bLiteralPlus)
								aSink << '+';
							aSink.write(RTL_CONSTASCII_STRINGPARAM(
								            "}\x0D\x0A"));
							const_cast< INetIMAPCommandStream * >(this)->
								    m_aText
								= aSink.takeBuffer();
							const_cast< INetIMAPCommandStream * >(this)->
								    m_eState
								= m_bLiteralPlus ? STATE_LITERAL_PLUS :
								                   STATE_LITERAL_WAITING;
							break;
						}

						case INetIMAPCommandArgument::TYPE_STREAM_BASE64:
						{
							SvStream * pStream = m_pArguments->getStream();
							if (pStream)
							{
								const_cast< INetIMAPCommandStream * >(this)->
									    m_nStreamLen
									= pStream->Seek(STREAM_SEEK_TO_END);
								pStream->Seek(0);
								nError = pStream->GetError();
								if (nError != ERRCODE_NONE)
								{
									bDone = true;
									break;
								}
							}
							else
								const_cast< INetIMAPCommandStream * >(this)->
									    m_nStreamLen
									= 0;
							const_cast< INetIMAPCommandStream * >(this)->
								    m_bBase64
								= true;
							const_cast< INetIMAPCommandStream * >(this)->
								m_aStreamPacket.Erase();
							const_cast< INetIMAPCommandStream * >(this)->
								    m_nStreamWidth
								= 0;

							// For a stream of length n, the length after
							// base64 encoding is
							//   4 ceil(n/3) + 2 ceil(n/57)
							// (three input chars make up four output chars,
							// and after every 57 input chars, i.e., after
							// every 76 output chars, a CRLF must be
							// inserted):
							INetMIMEStringOutputSink
								aSink(
									0,
									INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
							aSink << '{';
							INetMIME::writeUnsigned(aSink,
													m_pArguments->
													        getText().Len()
													    + 4 * ((m_nStreamLen
																        + 2)
															       / 3)
													    + 2 * ((m_nStreamLen
																        + 56)
															       / 57));
							if (m_bLiteralPlus)
								aSink << '+';
							aSink.write(RTL_CONSTASCII_STRINGPARAM(
								            "}\x0D\x0A"));
							const_cast< INetIMAPCommandStream * >(this)->
								    m_aText
								= aSink.takeBuffer();
							const_cast< INetIMAPCommandStream * >(this)->
								    m_eState
								= m_bLiteralPlus ? STATE_LITERAL_PLUS :
								                   STATE_LITERAL_WAITING;
							break;
						}

						default:
							DBG_ERROR(
							   "INetIMAPCommandStream::continueWithLiteral():"
								    " Invalid argument type");
							break;
					}
					break;

				case STATE_LITERAL_PLUS:
				{
					const_cast< INetIMAPCommandStream * >(this)->m_aText
						= m_pArguments->getText();
					const_cast< INetIMAPCommandStream * >(this)->m_pStream
						= m_pArguments->takeStream();

					INetIMAPCommandArgument * pUsedArgument = m_pArguments;
					const_cast< INetIMAPCommandStream * >(this)->
						    m_pArguments
						= pUsedArgument->getNext();
					delete pUsedArgument;
					const_cast< INetIMAPCommandStream * >(this)->m_eState
						= STATE_TEXT;
					break;
				}

				case STATE_LITERAL_WAITING:
				case STATE_FINAL_CRLF:
					bDone = true;
					break;
			}
	}
	while (nIndex < nCount && !bDone);

	const_cast< INetIMAPCommandStream * >(this)->m_nPosition += nIndex;
	if (pRead)
		*pRead = nIndex;

	const_cast< INetIMAPCommandStream * >(this)->m_bActive = false;
	return ERRCODE_NONE;
}

