/*************************************************************************
 *
 *  $RCSfile: imapcmds.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/02/27 11:13:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INET_IMAPCMDS_HXX
#define INET_IMAPCMDS_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

class INetIMAPCommandArgument;

//============================================================================
class INetIMAPCommandStream: public SvLockBytes
{
	enum State { STATE_TEXT, STATE_ARGUMENT_PREFIX, STATE_LITERAL_PLUS,
				 STATE_LITERAL_WAITING, STATE_FINAL_CRLF };

	ByteString m_aText;
	ByteString m_aStreamPacket;
	SvStream * m_pStream;
	INetIMAPCommandArgument * m_pArguments;
	ULONG m_nPosition;
	sal_uInt32 m_nStreamLen;
	State m_eState;
	int m_nStreamWidth;
	bool m_bLiteralPlus;
	bool m_bActive;
	bool m_bBase64;

	static bool isAtomOrQuoted(ByteString const & rAString, bool bWildAtoms,
							   ByteString & rAtomOrQuoted);

public:
	inline INetIMAPCommandStream(ByteString const & rPrefix,
								 bool bTheLiteralPlus);

	virtual ~INetIMAPCommandStream();

	void appendArgument(INetIMAPCommandArgument * pArgument);

	inline bool isWaitingForContinue() const;

	void continueWithLiteral();

	virtual ErrCode ReadAt(ULONG nPos, void * pBuffer, ULONG nCount,
						   ULONG * pRead) const;

	virtual ErrCode WriteAt(ULONG, void const *, ULONG, ULONG *)
	{ return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode Flush() const { return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode SetSize(ULONG) { return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode LockRegion(ULONG, ULONG, LockType)
	{ return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode UnlockRegion(ULONG, ULONG, LockType)
	{ return ERRCODE_IO_NOTSUPPORTED; }

	virtual ErrCode Stat(SvLockBytesStat *, SvLockBytesStatFlag) const
	{ return ERRCODE_IO_NOTSUPPORTED; }
};

inline INetIMAPCommandStream::INetIMAPCommandStream(ByteString const &
													    rPrefix,
													bool bTheLiteralPlus):
	m_bLiteralPlus(false/*bTheLiteralPlus*/),
	    // at least the 'Netscape IMAP4rev1 Service 3.6' hangs when sending
	    // the literal in the same IP packet as the preceeding line...
	m_eState(STATE_TEXT),
	m_nPosition(0),
	m_aText(rPrefix),
	m_pStream(0),
	m_pArguments(0),
	m_bActive(false),
	m_bBase64(false)
{}

inline bool INetIMAPCommandStream::isWaitingForContinue() const
{
	DBG_ASSERT((m_eState == STATE_LITERAL_WAITING && m_aText.Len() == 0
				    || m_eState == STATE_FINAL_CRLF)
			   && !m_bActive,
			   "INetIMAPCommandStream::isWaitingForContinue():"
			       " Invalid state");
	return m_eState == STATE_LITERAL_WAITING;
}

#endif // INET_IMAPCMDS_HXX

