/*************************************************************************
 *
 *  $RCSfile: imapscb1.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETCORESTRM_HXX
#include <inetstrm.hxx>
#endif

#ifndef INET_IMAPCHAR_HXX
#include <imapchar.hxx>
#endif
#ifndef INET_IMAPCIMP_HXX
#include <imapcimp.hxx>
#endif

//============================================================================
//
//  INetIMAPClient_Impl
//
//============================================================================

// static
ByteString INetIMAPClient_Impl::makeRFC822Phrase(ByteString const & rText)
{
	ByteString aPhrase;
	bool bWord = false;
	for (xub_StrLen nStart = 0;;)
	{
		bool bFound = false;
		while (!bFound && nStart < rText.Len())
		{
			sal_Char cChar = rText.GetChar(nStart);
			switch (cChar)
			{
				case '\t':
				case ' ':
					aPhrase += cChar;
					++nStart;
					break;

				case '\x0A': // LF
					if (nStart + 1 < rText.Len()
						&& INetMIME::isWhiteSpace(
							   sal_uChar(rText.GetChar(nStart + 1))))
					{
						aPhrase += cChar;
						aPhrase += rText.GetChar(nStart + 1);
						nStart += 2;
					}
					else
						bFound = true;
					break;

				case '\x0D': // CR
					if (nStart + 2 < rText.Len()
						&& rText.GetChar(nStart + 1) == '\x0A' // LF
						&& INetMIME::isWhiteSpace(
							   sal_uChar(rText.GetChar(nStart + 2))))
					{
						aPhrase += cChar;
						aPhrase += rText.GetChar(nStart + 1);
						aPhrase += rText.GetChar(nStart + 2);
						nStart += 3;
					}
					else if (nStart + 1 < rText.Len()
							 && INetMIME::isWhiteSpace(
								    sal_uChar(rText.GetChar(nStart + 1))))
					{
						aPhrase += cChar;
						aPhrase += rText.GetChar(nStart + 1);
						nStart += 2;
					}
					else
						bFound = true;
					break;

				default:
					bFound = true;
					break;
			}
		}

		if (nStart >= rText.Len())
			break;

		enum Type { TYPE_ATOM, TYPE_QUOTED, TYPE_QUOTED_ESCAPED };
		Type eType = TYPE_ATOM;

		xub_StrLen nEnd = nStart;
		while (nEnd < rText.Len())
		{
			sal_Char cChar = rText.GetChar(nEnd);
			if (INetMIME::isWhiteSpace(sal_uChar(cChar))
				|| (cChar == '\x0A' || cChar == '\x0D') // LF, CR
				   && nEnd + 1 < rText.Len()
				   && INetMIME::isWhiteSpace(sal_uChar(rText.GetChar(
					                                             nEnd + 1)))
				|| cChar == '\x0D' // CR
				   && nEnd + 2 < rText.Len()
				   && rText.GetChar(nEnd + 1) == '\x0A' // LF
				   && INetMIME::isWhiteSpace(sal_uChar(rText.GetChar(
					                                             nEnd + 2))))
				break;
			switch (eType)
			{
				case TYPE_ATOM:
					if (sal_uChar(cChar) < '\x0D' // CR
						|| (cChar > '\x0D' && cChar <= ' ') // CR
						|| cChar == '(' || cChar == ')' || cChar == ','
						|| cChar == '.' || cChar == ':' || cChar == ';'
						|| cChar == '<' || cChar == '>' || cChar == '@'
						|| cChar == '[' || cChar == ']'
						|| sal_uChar(cChar) >= '\x7F')
					{
						eType = TYPE_QUOTED;
						break;
					}
				case TYPE_QUOTED:
					if (cChar == '\x0D' // CR
						|| cChar == '"' || cChar == '\\')
						eType = TYPE_QUOTED_ESCAPED;
					break;
			}
			++nEnd;
		}

		switch (eType)
		{
			case TYPE_ATOM:
				aPhrase.Append(rText.GetBuffer() + nStart, nEnd - nStart);
				break;

			case TYPE_QUOTED:
				aPhrase += '"';
				aPhrase.Append(rText.GetBuffer() + nStart, nEnd - nStart);
				aPhrase += '"';
				break;

			case TYPE_QUOTED_ESCAPED:
				aPhrase += '"';
				for (xub_StrLen i = nStart; i < nEnd; ++i)
				{
					sal_Char cChar = rText.GetChar(i);
					if (cChar == '\x0D' // CR
						|| cChar == '"' || cChar == '\\')
						aPhrase += '\\';
					aPhrase += cChar;
				}
				aPhrase += '"';
				break;
		}

		bWord = true;
		nStart = nEnd;
	}
	if (!bWord)
		aPhrase.Append(RTL_CONSTASCII_STRINGPARAM("\"\""));
	return aPhrase;
}

//============================================================================
INetIMAPCodeResponse::Code
INetIMAPClient_Impl::parseResponseText(INetIMAPFlags & rePermanentFlags,
									   INetIMAPFlagKeywordList &
									       rPermanentFlagKeywords,
									   bool & rPermanentNewFlagKeywords,
									   sal_uInt32 & rNumber,
									   UniString & rText)
{
	INetIMAPCodeResponse::Code eCode = INetIMAPCodeResponse::CODE_NONE;

	xub_StrLen nOffset
		= INetIMAPASCII::skipLeadingSpace(m_aLine, m_nLineOffset);
	xub_StrLen nPos = nOffset;
	if (nPos < m_aLine.Len() && m_aLine.GetChar(nPos++) == '[')
	{
		nPos = INetIMAPASCII::skipLeadingSpace(m_aLine, nPos);
		if (nPos < m_aLine.Len())
		{
			xub_StrLen nAtomEnd = nPos;
			while (nAtomEnd < m_aLine.Len()
				   && INetIMAPASCII::isAtomChar(
					      sal_uChar(m_aLine.GetChar(nAtomEnd)))
				   && m_aLine.GetChar(nAtomEnd) != ']')
				++nAtomEnd;
				// The grammar in RFC 2060 allows a <resp_text_code> to start
				// with an <atom> that may contain a ']' character, which
				// leads to an ambiguity:  Is the <resp_text> "[ALERT] xxx]
				// yyy" an "ALERT" response with text "xxx] yyy" or is it a
				// (new) "ALERT]" response with argument "xxx" and text "yyy"?
				// The above loop will not work for an <atom> that contains a
				// ']' character.
			if (nAtomEnd > nPos)
			{
				if (m_aLine.EqualsIgnoreCaseAscii("ALERT", nPos,
												  nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_ALERT;
				else if (m_aLine.EqualsIgnoreCaseAscii("PARSE", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_PARSE;
				else if (m_aLine.EqualsIgnoreCaseAscii("PERMANENTFLAGS", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_PERMANENTFLAGS;
				else if (m_aLine.EqualsIgnoreCaseAscii("READ-ONLY", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_READ_ONLY;
				else if (m_aLine.EqualsIgnoreCaseAscii("READ-WRITE", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_READ_WRITE;
				else if (m_aLine.EqualsIgnoreCaseAscii("TRYCREATE", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_TRYCREATE;
				else if (m_aLine.EqualsIgnoreCaseAscii("UIDVALIDITY", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_UIDVALIDITY;
				else if (m_aLine.EqualsIgnoreCaseAscii("UNSEEN", nPos,
													   nAtomEnd - nPos))
					eCode = INetIMAPCodeResponse::CODE_UNSEEN;
				if (eCode != INetIMAPCodeResponse::CODE_NONE)
				{
					nPos = INetIMAPASCII::skipLeadingSpace(m_aLine, nAtomEnd);
					switch (eCode)
					{
						case INetIMAPCodeResponse::CODE_PERMANENTFLAGS:
							rePermanentFlags = INetIMAPFlags(0);
							rPermanentNewFlagKeywords = false;

							if (nPos >= m_aLine.Len()
								|| m_aLine.GetChar(nPos++) != '(')
							{
								eCode = INetIMAPCodeResponse::CODE_NONE;
								break;
							}

							{for (bool bSlash = false;;)
							{
								nPos
									= INetIMAPASCII::skipLeadingSpace(m_aLine,
																	  nPos);

								if (nPos >= m_aLine.Len())
									break;
								sal_Char cChar = m_aLine.GetChar(nPos++);
								if (cChar == '\\')
								{
									if (bSlash)
									{
										eCode
											= INetIMAPCodeResponse::CODE_NONE;
										break;
									}
									bSlash = true;
								}
								else if (cChar == ')')
								{
									if (bSlash)
										eCode
											= INetIMAPCodeResponse::CODE_NONE;
									break;
								}
								else if (cChar == '*')
								{
									if (bSlash)
										rPermanentNewFlagKeywords = true;
								}
								else if (INetIMAPASCII::isAtomChar(
									         sal_uChar(cChar)))
								{
									nAtomEnd = nPos;
									while (nAtomEnd < m_aLine.Len()
										   && INetIMAPASCII::isAtomChar(
											      sal_uChar(
													  m_aLine.GetChar(
														          nAtomEnd))))
										++nAtomEnd;
									if (bSlash)
									{
										if (m_aLine.EqualsIgnoreCaseAscii(
											            "ANSWERED", nPos - 1,
														nAtomEnd
														    - (nPos - 1)))
											rePermanentFlags
												= INetIMAPFlags(
													  rePermanentFlags
												   | INET_IMAP_FLAG_ANSWERED);
										else if (m_aLine.
												     EqualsIgnoreCaseAscii(
														 "FLAGGED", nPos - 1,
														 nAtomEnd
														     - (nPos - 1)))
											rePermanentFlags
												= INetIMAPFlags(
													  rePermanentFlags
													| INET_IMAP_FLAG_FLAGGED);
										else if (m_aLine.
												     EqualsIgnoreCaseAscii(
														 "DELETED", nPos - 1,
														 nAtomEnd
														     - (nPos - 1)))
											rePermanentFlags
												= INetIMAPFlags(
													  rePermanentFlags
													| INET_IMAP_FLAG_DELETED);
										else if (m_aLine.
												     EqualsIgnoreCaseAscii(
														 "SEEN", nPos - 1,
														 nAtomEnd
														     - (nPos - 1)))
											rePermanentFlags
												= INetIMAPFlags(
													  rePermanentFlags
													   | INET_IMAP_FLAG_SEEN);
										else if (m_aLine.
												     EqualsIgnoreCaseAscii(
														 "DRAFT", nPos - 1,
														 nAtomEnd
														     - (nPos - 1)))
											rePermanentFlags
												= INetIMAPFlags(
													  rePermanentFlags
													  | INET_IMAP_FLAG_DRAFT);
										bSlash = false;
									}
									else
										rPermanentFlagKeywords.
											append(m_aLine.
												       Copy(nPos - 1,
															nAtomEnd
															    - (nPos
																       - 1)));
								}
							}}

							if (eCode != INetIMAPCodeResponse::CODE_NONE)
								nPos
									= INetIMAPASCII::skipLeadingSpace(m_aLine,
																	  nPos);
							break;

						case INetIMAPCodeResponse::CODE_UIDVALIDITY:
						case INetIMAPCodeResponse::CODE_UNSEEN:
						{
							sal_Char const * p = m_aLine.GetBuffer() + nPos;
							if (INetMIME::scanUnsigned(p,
													   m_aLine.GetBuffer()
													       + m_aLine.Len(),
													   true, rNumber))
								nPos = INetIMAPASCII::skipLeadingSpace(
									       m_aLine, p - m_aLine.GetBuffer());
							else
								eCode = INetIMAPCodeResponse::CODE_NONE;
							break;
						}
					}
					if (eCode != INetIMAPCodeResponse::CODE_NONE
						&& (nPos >= m_aLine.Len()
							|| m_aLine.GetChar(nPos++) != ']'))
						eCode = INetIMAPCodeResponse::CODE_NONE;
					if (eCode != INetIMAPCodeResponse::CODE_NONE)
						nOffset = INetIMAPASCII::skipLeadingSpace(m_aLine,
																  nPos);
				}
			}
		}
	}

	rText = INetIMAPASCII::stripTrailingSpace(m_aLine, nOffset);
	return eCode;
}

//============================================================================
INetIMAPScanner::Mode
INetIMAPClient_Impl::doneFetchResponseEnvelopeAdr(bool bAdr)
{
	switch (m_eFetchResponseEnvelopeAdrPart)
	{
		case ENVELOPE_ADR_FROM:
			if (bAdr)
				static_cast< INetIMAPFetchResponse * >(m_pResponse)->
					setEnvelopeFrom(m_aFetchResponseEnvelopeAdr);
			m_eFetchResponseEnvelopeAdrPart = ENVELOPE_ADR_SENDER;
			m_eScanState = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
			return INetIMAPScanner::MODE_ATOM;

		case ENVELOPE_ADR_SENDER:
			if (bAdr)
				static_cast< INetIMAPFetchResponse * >(m_pResponse)->
					setEnvelopeSender(m_aFetchResponseEnvelopeAdr);
			m_eFetchResponseEnvelopeAdrPart = ENVELOPE_ADR_REPLY_TO;
			m_eScanState = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
			return INetIMAPScanner::MODE_ATOM;

		case ENVELOPE_ADR_REPLY_TO:
			if (bAdr)
				static_cast< INetIMAPFetchResponse * >(m_pResponse)->
					setEnvelopeReplyTo(m_aFetchResponseEnvelopeAdr);
			m_eFetchResponseEnvelopeAdrPart = ENVELOPE_ADR_TO;
			m_eScanState = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
			return INetIMAPScanner::MODE_ATOM;

		case ENVELOPE_ADR_TO:
			if (bAdr)
				static_cast< INetIMAPFetchResponse * >(m_pResponse)->
					setEnvelopeTo(m_aFetchResponseEnvelopeAdr);
			m_eFetchResponseEnvelopeAdrPart = ENVELOPE_ADR_CC;
			m_eScanState = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
			return INetIMAPScanner::MODE_ATOM;

		case ENVELOPE_ADR_CC:
			if (bAdr)
				static_cast< INetIMAPFetchResponse * >(m_pResponse)->
					setEnvelopeCC(m_aFetchResponseEnvelopeAdr);
			m_eFetchResponseEnvelopeAdrPart = ENVELOPE_ADR_BCC;
			m_eScanState = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR;
			return INetIMAPScanner::MODE_ATOM;

		default: // ENVELOPE_ADR_BCC
			if (bAdr)
				static_cast< INetIMAPFetchResponse * >(m_pResponse)->
					setEnvelopeBCC(m_aFetchResponseEnvelopeAdr);
			m_eScanState = SCAN_STATE_RESPONSE_FETCH_ENVELOPE_IN_REPLY_TO;
			return INetIMAPScanner::MODE_ATOM_QUOTED_LITERAL;
	}
}

//============================================================================
void INetIMAPClient_Impl::createFetchResponseBodySectionParser()
{
	if (m_pFetchResponseBodySectionParser)
	{
		if (m_pFetchResponseBodySectionParser->GetTargetMessage())
		{
			delete m_pFetchResponseBodySectionParser->
				       GetTargetMessage()->GetDocumentStream();
			delete m_pFetchResponseBodySectionParser->GetTargetMessage();
		}
		delete m_pFetchResponseBodySectionParser;
	}

	INetCoreNewsMessage * pMessage = new INetCoreNewsMessage;
	pMessage->SetDocumentStream(reinterpret_cast< SvStream * >(
		                            m_aStreamCallback.
									    Call(m_pFetchResponseBodySection)));

	m_pFetchResponseBodySectionParser = new INetCoreNewsMessageStream;
	m_pFetchResponseBodySectionParser->SetTargetMessage(pMessage);
}

