/*************************************************************************
 *
 *  $RCSfile: mailclnt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/11 18:49:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INET_MAILCLNT_HXX
#define _INET_MAILCLNT_HXX "$Revision: 1.3 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_RANDOM_H_
#include <rtl/random.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _INET_NEWSCLNT_HXX
#include <newsclnt.hxx>
#endif
#ifndef _INET_RECVCLNT_HXX
#include <recvclnt.hxx>
#endif
#ifndef _INET_SENDCLNT_HXX
#include <sendclnt.hxx>
#endif

class INetCoreDNSResolver;

namespace inet
{
namespace mail
{

/*========================================================================
 *
 * INetCoreMailer_Impl interface.
 *
 *======================================================================*/
class INetCoreMailer_Impl :
	public INetCoreMailer,
	public NewsClient_Impl::ClientManager,
	public RecvClient_Impl::ClientManager,
	public SendClient_Impl::ClientManager
{
public:
	INetCoreMailer_Impl (void);
	virtual ~INetCoreMailer_Impl (void);

	virtual operator INetCoreMailer* (void);

	/** Message Creation.
	 */
	virtual INetCoreMIMEMessage *CreateINetCoreMIMEMessage (void) const;
	virtual INetCoreNewsMessage *CreateINetCoreNewsMessage (void) const;

	/** Reserved.
	 */
	virtual void Dummy1 (void);
	virtual void Dummy2 (void);
	virtual void Dummy3 (void);

	/** NewsClient.
	 */
	virtual sal_Bool NewsOpenConnection (
		const rtl::OUString    &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsIsOpen (void) const;

	virtual sal_Bool NewsCloseConnection (
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual void NewsAbortConnection (void);

	virtual sal_Bool NewsModeReader (
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsAuthenticate (
		const rtl::OUString &rUsername,
		const rtl::OUString &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsAuthenticatePassword (
		const rtl::OUString    &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsGroupList (
		List &rList,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsNewGroupsList (
		const DateTime &rSince, List &rList,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsNewNewsList (
		const rtl::OUString &rGroups,
		const DateTime &rSince, List &rList,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsSelectGroup (
		INetCoreNNTPGroupListEntry &rEntry,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsHasOverview (void) const; /* OBSOLETE */
	virtual sal_Bool NewsArticleHeadOverview (
		sal_uInt32              nFirst,
		sal_uInt32              nLast,
		INetCoreNewsMessage    &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsArticleHead (
		sal_uInt32              nArticle,
		INetCoreNewsMessage    &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsArticleHead (
		const rtl::OUString    &rMessageID,
		INetCoreNewsMessage    &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsArticle (
		sal_uInt32              nArticle,
		INetCoreNewsMessage    &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsArticle (
		const rtl::OUString    &rMessageID,
		INetCoreNewsMessage    &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool NewsPostArticle (
		INetCoreNewsMessage    &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool NewsIsPostingAllowed (void) const;

	virtual sal_uInt32 NewsGetTransferCount (void) const;
	virtual sal_Bool   NewsSetTransferCallback ( /* OBSOLETE */
		INetCoreMailerCallback *pfnCallback, void *pData);

	/** RecvClient.
	 */
	virtual sal_Bool RecvOpenConnection (
		const rtl::OUString    &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool RecvIsOpen (void) const;

	virtual sal_Bool RecvCloseConnection (
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual void RecvAbortConnection (void);

	virtual sal_Bool RecvLogin (
		const rtl::OUString    &rUsername,
		const rtl::OUString    &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool RecvLoginSecure ( /* NYI */
		const rtl::OUString    &rUsername,
		const rtl::OUString    &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool RecvIsLoggedIn (void) const;

	virtual sal_Bool RecvMailListEntry (
		INetCoreMailInfoListEntry &rEntry,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool RecvMailList (
		List &rMailList,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool RecvUniqueIdList (
		List &rUniqueIdList,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool RecvMailHead (
		sal_uInt32 nIndex, INetCoreMIMEMessage &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool RecvMail (
		sal_uInt32 nIndex, INetCoreMIMEMessage &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_Bool RecvDeleteMail (
		sal_uInt32 nIndex,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_uInt32 RecvGetTransferCount (void) const;
	virtual sal_Bool   RecvSetTransferCallback ( /* OBSOLETE */
		INetCoreMailerCallback *pfnCallback, void *pData);

	/** SendClient.
	 */
	virtual sal_Bool SendOpenConnection (
		const rtl::OUString    &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual sal_Bool SendIsOpen (void) const;

	virtual sal_Bool SendCloseConnection (
		INetCoreMailerCallback *pfnCallback, void *pData);
	virtual void SendAbortConnection (void);

	virtual sal_Bool SendMail (
		INetCoreMIMEMessage &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);

	virtual sal_uInt32 SendGetTransferCount (void) const;
	virtual sal_Bool   SendSetTransferCallback ( /* OBSOLETE */
		INetCoreMailerCallback *pfnCallback, void *pData);

private:
	/** Representation.
	 */
	NAMESPACE_VOS(OMutex)  m_aMutex;
	NAMESPACE_VOS(IMutex)& getMutex_Impl (void) const;

	INetCoreDNSResolver   *m_pResolver;

	/** NewsClient.
	 */
	NAMESPACE_VOS(ORef)<NewsClient_Impl> m_xNewsClient;

	sal_Bool createClient_Impl (
		NAMESPACE_VOS(ORef)<NewsClient_Impl> &rxClient);
	sal_Bool getClient_Impl (
		NAMESPACE_VOS(ORef)<NewsClient_Impl> &rxClient) const;

	virtual void terminated (
		const NAMESPACE_VOS(ORef)<NewsClient_Impl> &rxClient);

	/** RecvClient.
	 */
	NAMESPACE_VOS(ORef)<RecvClient_Impl> m_xRecvClient;

	sal_Bool createClient_Impl (
		NAMESPACE_VOS(ORef)<RecvClient_Impl> &rxClient);
	sal_Bool getClient_Impl (
		NAMESPACE_VOS(ORef)<RecvClient_Impl> &rxClient) const;

	virtual void terminated (
		const NAMESPACE_VOS(ORef)<RecvClient_Impl> &rxClient);

	/** SendClient.
	 */
	NAMESPACE_VOS(ORef)<SendClient_Impl> m_xSendClient;

	sal_Bool createClient_Impl (
		NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient);
	sal_Bool getClient_Impl (
		NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient) const;

	virtual void terminated (
		const NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient);

	/** Common.
	 */
	rtlRandomPool    m_hPool;
	virtual sal_Bool prepareMessage (INetCoreMIMEMessage &rMessage);

	/** Not implemented.
	 */
	INetCoreMailer_Impl (const INetCoreMailer_Impl&);
	INetCoreMailer_Impl& operator= (const INetCoreMailer_Impl&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
} // mail
} // inet

#endif /* !_INET_MAILCLNT_HXX */

