/*************************************************************************
 *
 *  $RCSfile: client.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:27:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _INET_CLIENT_CXX "$Revision: 1.4 $"

#ifndef __STL_USE_NEWALLOC
#define __STL_USE_NEWALLOC 1
#endif
#ifndef __UTILITY__
#include <utility>
#endif
#ifndef __HASH_SET__
#include <hash_set>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

/*========================================================================
 *
 * INetClientConnection_Impl internals.
 *
 *======================================================================*/
typedef INetClientConnection_Impl* key_type;

struct key_hash : public std::unary_function<key_type, sal_uInt32>
{
	sal_uInt32 operator() (key_type k) const { return ((sal_uInt32)k); }
};

struct key_cmp : public std::binary_function<key_type, key_type, bool>
{
	bool operator() (key_type k1, key_type k2) const { return (k1 == k2); }
};

#ifdef _USE_NAMESPACE
namespace inet {
#endif

/*
 * OSocketRef.
 */
typedef NAMESPACE_INET(INetSocket) socket_type;
typedef NAMESPACE_VOS(ORef)<socket_type> OSocketRef;

/*
 * INetClientMap_Impl.
 */
class INetClientMap_Impl :
	public std::hash_set<key_type, key_hash, key_cmp>
{
	typedef std::hash_set<key_type, key_hash, key_cmp> base;

public:
	INetClientMap_Impl (void);
	virtual ~INetClientMap_Impl (void);

	sal_Bool insert (key_type k);
	sal_Bool remove (key_type k);
	sal_Bool verify (key_type k);

private:
	/** Repesentation.
	 */
	NAMESPACE_VOS(OMutex) m_aMutex;

	/** Not implemented.
	 */
	INetClientMap_Impl (const INetClientMap_Impl&);
	INetClientMap_Impl& operator= (const INetClientMap_Impl&);
};

/*
 * INetClientManager_Impl.
 */
class INetClientManager_Impl :
	public INetClientMap_Impl,
	public NAMESPACE_VOS(OReference),
	public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetClientManager_Impl, inet));
	typedef INetClientMap_Impl base;

public:
	/** Get or create the single instance.
	 */
	static sal_Bool getOrCreate (
		NAMESPACE_VOS(ORef)<INetClientManager_Impl> &rxManager);

	/** Release remaining client connections.
	 */
	static sal_Bool dispose (void);

	/** Resolver callback procedure.
	 *  @see INetCoreDNSResolverCallback
	 */
	static sal_Bool onResolverEvent (
		sal_Int32             nEvent,
		INetCoreDNSHostEntry *pHostEntry,
		void                 *pData);

	/** Socket callback procedure.
	 *  @see INetSocket::EventHandler
	 */
	static sal_Bool onSocketEvent (
		const OSocketRef &rxSocket,
		sal_Int32         nEvent,
		void             *pData);

protected:
	INetClientManager_Impl (void);
	virtual ~INetClientManager_Impl (void);

private:
	/** The single instance.
	 */
	static INetClientManager_Impl *m_pThis;

	/** Not implemented.
	 */
	INetClientManager_Impl (const INetClientManager_Impl&);
	INetClientManager_Impl& operator= (const INetClientManager_Impl&);
};

#ifdef _USE_NAMESPACE
}
#endif

/*========================================================================
 *
 * INetClientConnection_Impl implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
	VOS_CLASSNAME (INetClientConnection_Impl, inet),
	VOS_NAMESPACE (INetClientConnection_Impl, inet),
	VOS_NAMESPACE (OObject, vos),
	0);

/*
 * INetClientConnection_Impl.
 */
INetClientConnection_Impl::INetClientConnection_Impl (void)
{
	if (INetClientManager_Impl::getOrCreate (m_xManager))
		m_xManager->insert (this);
}

/*
 * ~INetClientConnection_Impl.
 */
INetClientConnection_Impl::~INetClientConnection_Impl (void)
{
	if (m_xManager.isValid())
		m_xManager->remove (this);
}

/*
 * onResolverEvent (static resolver callback).
 */
sal_Bool INetClientConnection_Impl::onResolverEvent (
	sal_Int32 nEvent, INetCoreDNSHostEntry *pHostEntry, void *pData)
{
	return INetClientManager_Impl::onResolverEvent (
		nEvent, pHostEntry, pData);
}

/*
 * onSocketEvent (static socket callback).
 */
sal_Bool INetClientConnection_Impl::onSocketEvent (
	const OSocketRef &rxSocket, sal_Int32 nEvent, void *pData)
{
	return INetClientManager_Impl::onSocketEvent (
		rxSocket, nEvent, pData);
}

/*
 * INetClientCleanup_Impl.
 * (called from ~INetModule_Impl()).
 */
void SAL_CALL INetClientCleanup_Impl (void)
{
	sal_Bool result = NAMESPACE_INET(INetClientManager_Impl)::dispose();
	VOS_ASSERT (result);
}

/*========================================================================
 *
 * INetClientManager_Impl internals.
 *
 *======================================================================*/
/*
 * __getGlobalMutex_Impl (protect the single instance creation).
 */
static NAMESPACE_VOS(IMutex)& __getGlobalMutex_Impl (void)
{
	static NAMESPACE_VOS(IMutex) *pMutex = NULL;
	if (!pMutex)
	{
		NAMESPACE_VOS(OGuard) aGuard (NAMESPACE_VOS(OMutex)::getGlobalMutex());
		if (!pMutex)
		{
			static NAMESPACE_VOS(OMutex) aGlobalMutex;
			pMutex = &aGlobalMutex;
		}
	}
	return *pMutex;
}

/*========================================================================
 *
 * INetClientManager_Impl implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
	VOS_CLASSNAME (INetClientManager_Impl, inet),
	VOS_NAMESPACE (INetClientManager_Impl, inet),
	VOS_NAMESPACE (OObject, vos),
	0);

/*
 * The single instance.
 */
NAMESPACE_INET(INetClientManager_Impl)*
NAMESPACE_INET(INetClientManager_Impl)::m_pThis = NULL;

/*
 * INetClientManager_Impl.
 */
INetClientManager_Impl::INetClientManager_Impl (void)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	m_pThis = this;
}

/*
 * ~INetClientManager_Impl.
 */
INetClientManager_Impl::~INetClientManager_Impl (void)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	m_pThis = NULL;
}

/*
 * getOrCreate.
 */
sal_Bool INetClientManager_Impl::getOrCreate (
	NAMESPACE_VOS(ORef)<INetClientManager_Impl> &rxManager)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	if (!m_pThis)
		new INetClientManager_Impl();
	rxManager = m_pThis;
	return rxManager.isValid();
}

/*
 * dispose.
 */
sal_Bool INetClientManager_Impl::dispose (void)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	if (m_pThis)
	{
		NAMESPACE_VOS(ORef)<INetClientManager_Impl> xThis (m_pThis);

		base::iterator first = xThis->begin();
		base::iterator last  = xThis->end();

		while (first != last)
		{
			key_type k = (key_type)(*first++);
			k->release();
		}
		return xThis->empty();
	}
	return sal_True;
}

/*
 * onResolverEvent.
 */
sal_Bool INetClientManager_Impl::onResolverEvent (
	sal_Int32 nEvent, INetCoreDNSHostEntry *pHostEntry, void *pData)
{
	key_type k = SAL_REINTERPRET_CAST(key_type, pData);
	if (k)
	{
		NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
		if (m_pThis && m_pThis->verify(k) && k->referenced())
			k->acquire();
		else
			k = NULL;
	}
	if (k)
	{
		sal_Bool result = k->handleResolverEvent (nEvent, pHostEntry);
		k->release();
		return result;
	}
	return (!!k);
}

/*
 * onSocketEvent.
 */
sal_Bool INetClientManager_Impl::onSocketEvent (
	const OSocketRef &rxSocket, sal_Int32 nEvent, void *pData)
{
	key_type k = SAL_REINTERPRET_CAST(key_type, pData);
	if (k)
	{
		NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
		if (m_pThis && m_pThis->verify(k) && k->referenced())
			k->acquire();
		else
			k = NULL;
	}
	if (k)
	{
		sal_Bool result = k->handleSocketEvent (rxSocket, nEvent);
		k->release();
		return result;
	}
	return (!!k);
}

/*========================================================================
 *
 * INetClientMap_Impl implementation.
 *
 *======================================================================*/
/*
 * INetClientMap_Impl.
 */
INetClientMap_Impl::INetClientMap_Impl (void)
{
}

/*
 * ~INetClientMap_Impl.
 */
INetClientMap_Impl::~INetClientMap_Impl (void)
{
}

/*
 * insert.
 */
sal_Bool INetClientMap_Impl::insert (key_type k)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	if (k)
	{
		typedef std::pair<base::iterator, bool> result_t;
		result_t result = base::insert (k);
		if (!result.second)
			k = NULL;
	}
	return (!!k);
}

/*
 * remove.
 */
sal_Bool INetClientMap_Impl::remove (key_type k)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);

	base::iterator it = base::find (k);
	if (it != base::end())
	{
		base::erase (it);
		return sal_True;
	}
	return sal_False;
}

/*
 * verify.
 */
sal_Bool INetClientMap_Impl::verify (key_type k)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);

	base::const_iterator it = base::find (k);
	return (it != base::end());
}
