/*************************************************************************
 *
 *  $RCSfile: Perl5Debug.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;

// Referenced classes of package com.sun.star.tool.starjar.regex:
//            _cls2, Perl5Pattern

public final class Perl5Debug {

    private Perl5Debug() {}

    public static String printProgram(Perl5Pattern perl5pattern) {
        char c = '\033';
        char ac[] = perl5pattern._program;
        int i = 1;
        StringBuffer stringbuffer = new StringBuffer();
        while(c != 0) 
        {
            c = ac[i];
            stringbuffer.append(i);
            _mth0172(ac, i, stringbuffer);
            int j = _cls2._mth0139(ac, i);
            i += _cls2._fld0114[c];
            stringbuffer.append("(" + j + ")");
            i += 2;
            if(c == '\t')
                i += 16;
            else
            if(c == '\016')
            {
                i++;
                stringbuffer.append(" <");
                for(; ac[i] != '\uFFFF'; i++)
                    stringbuffer.append(ac[i]);

                stringbuffer.append(">");
                i++;
            }
            stringbuffer.append('\n');
        }

        if(perl5pattern._startString != null)
            stringbuffer.append("start `" + new String(perl5pattern._startString) + "' ");
        if(perl5pattern._startClassOffset != -1)
        {
            stringbuffer.append("stclass `");
            _mth0172(ac, perl5pattern._startClassOffset, stringbuffer);
            stringbuffer.append("' ");
        }
        if((perl5pattern._anchor & 0x1) != 0)
            stringbuffer.append("anchored ");
        if((perl5pattern._anchor & 0x2) != 0)
            stringbuffer.append("plus ");
        if((perl5pattern._anchor & 0x4) != 0)
            stringbuffer.append("implicit ");
        if(perl5pattern._mustString != null)
            stringbuffer.append("must have \"" + new String(perl5pattern._mustString) + "\" back " + perl5pattern._back + " ");
        stringbuffer.append("minlen " + perl5pattern._minLength + '\n');
        return stringbuffer.toString();
    }

    static void _mth0172(char ac[], int i, StringBuffer stringbuffer)
    {
        String s = null;
        stringbuffer.append(":");
        switch(ac[i])
        {
        case 1: /* '\001' */
            s = "BOL";
            break;

        case 2: /* '\002' */
            s = "MBOL";
            break;

        case 3: /* '\003' */
            s = "SBOL";
            break;

        case 4: /* '\004' */
            s = "EOL";
            break;

        case 5: /* '\005' */
            s = "MEOL";
            break;

        case 7: /* '\007' */
            s = "ANY";
            break;

        case 8: /* '\b' */
            s = "SANY";
            break;

        case 9: /* '\t' */
            s = "ANYOF";
            break;

        case 12: /* '\f' */
            s = "BRANCH";
            break;

        case 14: /* '\016' */
            s = "EXACTLY";
            break;

        case 15: /* '\017' */
            s = "NOTHING";
            break;

        case 13: /* '\r' */
            s = "BACK";
            break;

        case 0: /* '\0' */
            s = "END";
            break;

        case 18: /* '\022' */
            s = "ALNUM";
            break;

        case 19: /* '\023' */
            s = "NALNUM";
            break;

        case 20: /* '\024' */
            s = "BOUND";
            break;

        case 21: /* '\025' */
            s = "NBOUND";
            break;

        case 22: /* '\026' */
            s = "SPACE";
            break;

        case 23: /* '\027' */
            s = "NSPACE";
            break;

        case 24: /* '\030' */
            s = "DIGIT";
            break;

        case 25: /* '\031' */
            s = "NDIGIT";
            break;

        case 10: /* '\n' */
            stringbuffer.append("CURLY {");
            stringbuffer.append(_cls2._mth013F(ac, i));
            stringbuffer.append(',');
            stringbuffer.append(_cls2._mth013E(ac, i));
            stringbuffer.append('}');
            break;

        case 11: /* '\013' */
            stringbuffer.append("CURLYX {");
            stringbuffer.append(_cls2._mth013F(ac, i));
            stringbuffer.append(',');
            stringbuffer.append(_cls2._mth013E(ac, i));
            stringbuffer.append('}');
            break;

        case 26: /* '\032' */
            stringbuffer.append("REF");
            stringbuffer.append(_cls2._mth013F(ac, i));
            break;

        case 27: /* '\033' */
            stringbuffer.append("OPEN");
            stringbuffer.append(_cls2._mth013F(ac, i));
            break;

        case 28: /* '\034' */
            stringbuffer.append("CLOSE");
            stringbuffer.append(_cls2._mth013F(ac, i));
            break;

        case 16: /* '\020' */
            s = "STAR";
            break;

        case 17: /* '\021' */
            s = "PLUS";
            break;

        case 29: /* '\035' */
            s = "MINMOD";
            break;

        case 30: /* '\036' */
            s = "GBOL";
            break;

        case 32: /* ' ' */
            s = "UNLESSM";
            break;

        case 31: /* '\037' */
            s = "IFMATCH";
            break;

        case 33: /* '!' */
            s = "SUCCEED";
            break;

        case 34: /* '"' */
            s = "WHILEM";
            break;

        case 6: /* '\006' */
        default:
            stringbuffer.append("Operator is unrecognized.  Faulty expression code!");
            break;

        }
        if(s != null)
            stringbuffer.append(s);
    }
}

