/*************************************************************************
 *
 *  $RCSfile: Perl5Matcher.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;

import java.io.IOException;
import java.util.Stack;
import java.util.Vector;

// Referenced classes of package com.sun.star.tool.starjar.regex:
//            Perl5Pattern, _cls4, _cls3, PatternMatcher, 
//            Perl5StreamInput, PatternMatcherInput, _cls2, Pattern, 
//            MatchResult

public final class Perl5Matcher implements PatternMatcher {
    private static final char _fld018D = 65535;
    private static final int _fld018C = 20;
    private boolean _fld018B;
    private boolean _fld018A;
    private char _fld0189;
    private char _fld0188[];
    private char _fld0187[];
    private _cls4 _fld0186;
    private int _fld0185;
    private int _fld0184;
    private int _fld0183;
    private int _fld0182;
    private int _fld0181;
    private char _fld0180[];
    private int _fld017F;
    private int _fld017E;
    private int _fld017D;
    private int _fld017C[];
    private int _fld017B[];
    private Stack _fld017A;
    private _cls3 _fld0179;
    private static final int _fld0178 = -100;
    private int _fld0177;

    static boolean _mth0198(char ac[], int i, char ac1[], int j, int k) {
        for (int l = 0; l < k;) {
            if (i >= ac.length)
                return false;
            if (j >= ac1.length)
                return false;
            if (ac[i] != ac1[j])
                return false;
            l++;
            i++;
            j++;
        }

        return true;
    }

    static int _mth0197(char ac[], int i, int j, char ac1[]) {
        if (ac.length == 0)
            return j;
        
        char c = ac1[0];
        
        for (; i < j; i++) {
            if (c != ac[i])
                continue;
            int l = i;
            int k;
            
            for (k = 0; i < j && k < ac1.length; i++) {
                if (ac1[k] != ac[i])
                    break;
                k++;
            }

            i = l;
            
            if (k >= ac1.length)
                break;
        }

        return i;
    }

    void _mth0196(int i) {
        int j = 3 * (_fld017F - i);
        int ai[];
        
        if (j <= 0)
            ai = new int[3];
        else
            ai = new int[j + 3];
        
        ai[0] = _fld017F;
        ai[1] = _fld017D;
        ai[2] = _fld017E;
        
        for (int k = _fld017F; k > i;) {
            ai[j] = _fld017B[k];
            ai[j + 1] = _fld017C[k];
            ai[j + 2] = k;
            k -= 3;
            j -= 3;
        }

        _fld017A.push(ai);
    }

    void _mth0195() {
        int ai[] = (int[])_fld017A.pop();
        _fld017F = ai[0];
        _fld017D = ai[1];
        _fld017E = ai[2];
        
        for (int i = 3; i < ai.length; i += 3) {
            int j = ai[i + 2];
            _fld017C[j] = ai[i + 1];
            
            if (j <= _fld017D)
                _fld017B[j] = ai[i];
        }

        for (int k = _fld017D + 1; k <= _fld0185; k++) {
            
            if (k > _fld017F)
                _fld017C[k] = -1;
            
            _fld017B[k] = -1;
        }

    }

    private void _mth0194(Perl5Pattern perl5pattern, char ac[], int i, int j) {
        _fld0188 = ac;
        _fld0181 = j;
        _fld0186 = new _cls4();
        _fld0186._fld01A0 = 0;
        _fld0186._fld0199 = null;
        _fld0180 = perl5pattern._program;
        _fld017A.setSize(0);
        
        if (i == 0) {
            _fld0189 = '\n';
        } else {
            _fld0189 = ac[i - 1];
            
            if (!_fld018B && _fld0189 == '\n')
                _fld0189 = 0;
        }
        
        _fld0185 = perl5pattern._numParentheses;
        _fld0182 = i;
        _fld0184 = i;
        _fld0183 = j;
        j = _fld0185 + 1;
        
        if (_fld017C == null || j > _fld017C.length)
        {
            if (j < 20)
                j = 20;
            _fld017C = new int[j];
            _fld017B = new int[j];
        }
    }

    void _mth0193() {
        _fld0179 = new _cls3(_fld0185 + 1);
        if (_fld017B[0] > _fld0187.length)
            throw new ArrayIndexOutOfBoundsException();
        _fld0179._fld0173 = new String(_fld0187, _fld017C[0], _fld017B[0] - _fld017C[0]);
        _fld0179._fld0176 = _fld017C[0];
        for (; _fld0185 >= 0; _fld0185--) {
            int i = _fld017C[_fld0185];
            if (i >= 0)
                _fld0179._fld0175[_fld0185] = i - _fld0179._fld0176;
            else
                _fld0179._fld0175[_fld0185] = -1;
            i = _fld017B[_fld0185];
            if (i >= 0)
                _fld0179._fld0174[_fld0185] = i - _fld0179._fld0176;
            else
                _fld0179._fld0174[_fld0185] = -1;
        }

        _fld0187 = null;
    }

    boolean _mth0192(Perl5Pattern perl5pattern, char ac[], int i, int j) {
        boolean flag;
label0:
        {
            int k = 0;
            int l = 0;
            _mth0194(perl5pattern, ac, i, j);
            flag = false;
            char ac1[] = perl5pattern._mustString;
            if (ac1 != null && ((perl5pattern._anchor & 0x1) == 0 || _fld018B && perl5pattern._back >= 0)) {
                _fld0182 = _mth0197(_fld0188, _fld0182, j, ac1);
                if (_fld0182 >= j) {
                    if ((perl5pattern._options & 0x8000) == 0)
                        perl5pattern._mustUtility++;
                    flag = false;
                    break label0;
                }
                if (perl5pattern._back >= 0)
                {
                    _fld0182 -= perl5pattern._back;
                    if (_fld0182 < i)
                        _fld0182 = i;
                    k = perl5pattern._back + ac1.length;
                }
                else
                if (!perl5pattern._isExpensive && (perl5pattern._options & 0x8000) == 0 && --perl5pattern._mustUtility < 0)
                {
                    ac1 = perl5pattern._mustString = null;
                    _fld0182 = i;
                }
                else
                {
                    _fld0182 = i;
                    k = ac1.length;
                }
            }
            if ((perl5pattern._anchor & 0x1) != 0)
            {
                if (_mth0191(perl5pattern, i))
                    flag = true;
                else
                if (_fld018B || (perl5pattern._anchor & 0x4) != 0)
                {
                    if (k > 0)
                        l = k - 1;
                    j -= l;
                    if (_fld0182 > i)
                        _fld0182--;
                    while(_fld0182 < j) 
                        if (_fld0188[_fld0182++] == '\n' && _fld0182 < j && _mth0191(perl5pattern, _fld0182))
                        {
                            flag = true;
                            break;
                        }

                }
                break label0;
            }
            if (perl5pattern._startString != null)
            {
                char ac2[] = perl5pattern._startString;
                if ((perl5pattern._anchor & 0x2) != 0)
                {
                    char c = ac2[0];
                    for (; _fld0182 < j; _fld0182++)
                    {
                        if (c != _fld0188[_fld0182])
                            continue;
                        if (_mth0191(perl5pattern, _fld0182))
                        {
                            flag = true;
                            break;
                        }
                        for (_fld0182++; _fld0182 < j && _fld0188[_fld0182] == c; _fld0182++);
                    }

                }
                else
                {
                    for (_fld0182++; (_fld0182 = _mth0197(_fld0188, _fld0182, j, ac2)) < j;)
                    {
                        if (!_mth0191(perl5pattern, _fld0182))
                            continue;
                        flag = true;
                        break;
                    }

                }
                break label0;
            }
            int i1;
            if ((i1 = perl5pattern._startClassOffset) != -1) {
                boolean flag1 = (perl5pattern._anchor & 0x2) == 0;
                if (k > 0)
                    l = k - 1;
                j -= l;
                boolean flag2 = true;
                switch(_fld0180[i1])
                {
                default:
                    break;

                case 9: /* '\t' */
                    i1 = _cls2._mth013D(i1);
                    for (; _fld0182 < j; _fld0182++)
                    {
                        char c1 = _fld0188[_fld0182];
                        if (c1 < '\u0100' && (_fld0180[i1 + (c1 >> 4)] & 1 << (c1 & 0xf)) == 0)
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }
                    }

                    break label0;

                case 20: /* '\024' */
                    if (k > 0) {
                        l++;
                        j--;
                    }
                    if (_fld0182 != i) {
                        char c2 = _fld0188[_fld0182 - 1];
                        flag2 = _cls2._mth0138(c2);
                    }
                    else
                    {
                        flag2 = _cls2._mth0138(_fld0189);
                    }
                    for (; _fld0182 < j; _fld0182++)
                    {
                        char c3 = _fld0188[_fld0182];
                        if (flag2 == _cls2._mth0138(c3))
                            continue;
                        flag2 = !flag2;
                        if (!_mth0191(perl5pattern, _fld0182))
                            continue;
                        flag = true;
                        break label0;
                    }

                    if ((k > 0 || flag2) && _mth0191(perl5pattern, _fld0182))
                        flag = true;
                    break label0;

                case 21: /* '\025' */
                    if (k > 0)
                    {
                        l++;
                        j--;
                    }
                    if (_fld0182 != i)
                    {
                        char c4 = _fld0188[_fld0182 - 1];
                        flag2 = _cls2._mth0138(c4);
                    }
                    else
                    {
                        flag2 = _cls2._mth0138(_fld0189);
                    }
                    for (; _fld0182 < j; _fld0182++)
                    {
                        char c5 = _fld0188[_fld0182];
                        if (flag2 != _cls2._mth0138(c5))
                        {
                            flag2 = !flag2;
                            continue;
                        }
                        if (!_mth0191(perl5pattern, _fld0182))
                            continue;
                        flag = true;
                        break label0;
                    }

                    if ((k > 0 || !flag2) && _mth0191(perl5pattern, _fld0182))
                        flag = true;
                    break label0;

                case 18: /* '\022' */
                    for (; _fld0182 < j; _fld0182++)
                    {
                        char c6 = _fld0188[_fld0182];
                        if (_cls2._mth0138(c6))
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break label0;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }
                    }

                    break label0;

                case 19: /* '\023' */
                    for (; _fld0182 < j; _fld0182++)
                    {
                        char c7 = _fld0188[_fld0182];
                        if (!_cls2._mth0138(c7))
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break label0;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }
                    }

                    break label0;

                case 22: /* '\026' */
                    for (; _fld0182 < j; _fld0182++)
                        if (Character.isWhitespace(_fld0188[_fld0182]))
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break label0;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }

                    break label0;

                case 23: /* '\027' */
                    for (; _fld0182 < j; _fld0182++)
                        if (!Character.isWhitespace(_fld0188[_fld0182]))
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break label0;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }

                    break label0;

                case 24: /* '\030' */
                    for (; _fld0182 < j; _fld0182++)
                        if (Character.isDigit(_fld0188[_fld0182]))
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break label0;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }

                    break label0;

                case 25: /* '\031' */
                    for (; _fld0182 < j; _fld0182++)
                        if (!Character.isDigit(_fld0188[_fld0182]))
                        {
                            if (flag2 && _mth0191(perl5pattern, _fld0182))
                            {
                                flag = true;
                                break label0;
                            }
                            flag2 = flag1;
                        }
                        else
                        {
                            flag2 = true;
                        }

                    break;

                }
            }
            else
            {
                if (k > 0)
                    l = k - 1;
                j -= l;
                do
                {
                    if (!_mth0191(perl5pattern, _fld0182))
                        continue;
                    flag = true;
                    break;
                }
                while(_fld0182++ < j);
            }
        }
        _fld018A = flag;
        _fld0179 = null;
        return flag;
    }

    boolean _mth0191(Perl5Pattern perl5pattern, int i) {
        _fld017E = i;
        _fld017D = 0;
        _fld017F = 0;
        
        if (_fld0185 > 0) {
            for (int j = 0; j <= _fld0185; j++)
            {
                _fld017C[j] = -1;
                _fld017B[j] = -1;
            }

        }
    
        if (_mth018F(1)) {
            _fld017C[0] = i;
            _fld017B[0] = _fld017E;
            return true;
        } else {
            return false;
        }
    }

    int _mth0190(int i, int j) {
        int k = _fld017E;
        int l = _fld0183;
        if (j != 65535 && j < l - k)
            l = k + j;
        int i1 = _cls2._mth013D(i);
label0:
        switch(_fld0180[i])
        {
        default:
            break;

        case 7: /* '\007' */
            for (; k < l && _fld0188[k] != '\n'; k++);
            break;

        case 8: /* '\b' */
            k = l;
            break;

        case 14: /* '\016' */
            for (i1++; k < l && _fld0180[i1] == _fld0188[k]; k++);
            break;

        case 9: /* '\t' */
            char c;
            if (k >= l || (c = _fld0188[k]) >= '\u0100')
                break;
            for (; (_fld0180[i1 + (c >> 4)] & 1 << (c & 0xf)) == 0; c = _fld0188[k])
                if (++k >= l)
                    break label0;

            break;

        case 18: /* '\022' */
            for (; k < l && _cls2._mth0138(_fld0188[k]); k++);
            break;

        case 19: /* '\023' */
            for (; k < l && !_cls2._mth0138(_fld0188[k]); k++);
            break;

        case 22: /* '\026' */
            for (; k < l && Character.isWhitespace(_fld0188[k]); k++);
            break;

        case 23: /* '\027' */
            for (; k < l && !Character.isWhitespace(_fld0188[k]); k++);
            break;

        case 24: /* '\030' */
            for (; k < l && Character.isDigit(_fld0188[k]); k++);
            break;

        case 25: /* '\031' */
            for (; k < l && !Character.isDigit(_fld0188[k]); k++);
            break;

        }
        int j1 = k - _fld017E;
        _fld017E = k;
        return j1;
    }

    boolean _mth018F(int i) {
        boolean flag = true;
        boolean flag1 = false;
        int j1 = _fld017E;
        flag = j1 < _fld0181;
        //int j = flag ? ((int) (_fld0188[j1])) : 65535;
        char j = flag ? ((_fld0188[j1])) : 65535;
        int l = i;
        int i1;
        
        for (int k1 = _fld0180.length; l < k1; l = i1) {
            i1 = _cls2._mth0139(_fld0180, l);
            char c;
            
            switch(c = _fld0180[l]) {
            case 13: /* '\r' */
            case 15: /* '\017' */
            default:
                break;

            case 1: /* '\001' */
            case 2: /* '\002' */
                if (j1 != _fld0184 ? !flag && j1 >= _fld0183 || _fld0188[j1 - 1] != '\n' && true : _fld0189 != '\n' && true)
                    return false;
                break;

            case 3: /* '\003' */
                if (j1 != _fld0184 || _fld0189 != '\n')
                    return false;
                break;

            case 30: /* '\036' */
                if (j1 != _fld0184)
                    return true;
                break;

            case 4: /* '\004' */
                if ((flag || j1 < _fld0183) && j != 10)
                    return false;
                if (!_fld018B && _fld0183 - j1 > 1)
                    return false;
                break;

            case 5: /* '\005' */
                if ((flag || j1 < _fld0183) && j != 10)
                    return false;
                break;

            case 6: /* '\006' */
                if ((flag || j1 < _fld0183) && j != 10)
                    return false;
                if (_fld0183 - j1 > 1)
                    return false;
                break;

            case 8: /* '\b' */
                if (!flag && j1 >= _fld0183)
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                break;

            case 7: /* '\007' */
                if (!flag && j1 >= _fld0183 || j == 10)
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 14: /* '\016' */
                int l1 = _cls2._mth013D(l);
                char c2 = _fld0180[l1++];
                if (_fld0180[l1] != j)
                    return false;
                if (_fld0183 - j1 < c2)
                    return false;
                if (c2 > '\001' && !_mth0198(_fld0180, l1, _fld0188, j1, c2))
                    return false;
                j1 += c2;
                flag = j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 9: /* '\t' */
                int i2 = _cls2._mth013D(l);
                if (j == 65535 && flag)
                    j = _fld0188[j1];
                if (j >= 256 || (_fld0180[i2 + (j >> 4)] & 1 << (j & 0xf)) != 0)
                    return false;
                if (!flag && j1 >= _fld0183)
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 18: /* '\022' */
                if (!flag)
                    return false;
                if (!_cls2._mth0138(j))
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 19: /* '\023' */
                if (!flag && j1 >= _fld0183)
                    return false;
                if (_cls2._mth0138(j))
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 20: /* '\024' */
            case 21: /* '\025' */
                boolean flag3;
                if (j1 == _fld0184)
                    flag3 = _cls2._mth0138(_fld0189);
                else
                    flag3 = _cls2._mth0138(_fld0188[j1 - 1]);
                boolean flag4 = _cls2._mth0138(j);
                if ((flag3 == flag4) == (_fld0180[l] == '\024'))
                    return false;
                break;

            case 22: /* '\026' */
                if (!flag && j1 >= _fld0183)
                    return false;
                if (!Character.isWhitespace(j))
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 23: /* '\027' */
                if (!flag)
                    return false;
                if (Character.isWhitespace(j))
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 24: /* '\030' */
                if (!Character.isDigit(j))
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 25: /* '\031' */
                if (!flag && j1 >= _fld0183)
                    return false;
                if (Character.isDigit(j))
                    return false;
                flag = ++j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 26: /* '\032' */
                char c3 = _cls2._mth013F(_fld0180, l);
                int j2 = _fld017C[c3];
                if (j2 == -1)
                    return false;
                if (_fld017B[c3] == -1)
                    return false;
                if (j2 == _fld017B[c3])
                    break;
                if (_fld0188[j2] != j)
                    return false;
                int k2 = _fld017B[c3] - j2;
                if (j1 + k2 > _fld0183)
                    return false;
                if (k2 > 1 && !_mth0198(_fld0188, j2, _fld0188, j1, k2))
                    return false;
                j1 += k2;
                flag = j1 < _fld0181;
                j = flag ? _fld0188[j1] : 0xFFFF;
                //j = flag ? ((int) (_fld0188[j1])) : 65535;
                break;

            case 27: /* '\033' */
                int l3 = _cls2._mth013F(_fld0180, l);
                _fld017C[l3] = j1;
                if (l3 > _fld017F)
                    _fld017F = l3;
                break;

            case 28: /* '\034' */
                int i4 = _cls2._mth013F(_fld0180, l);
                _fld017B[i4] = j1;
                if (i4 > _fld017D)
                    _fld017D = i4;
                break;

            case 11: /* '\013' */
                _cls4 _lcls4 = new _cls4();
                _lcls4._fld0199 = _fld0186;
                _fld0186 = _lcls4;
                _lcls4._fld01A1 = _fld017D;
                _lcls4._fld01A0 = -1;
                _lcls4._fld019F = _cls2._mth013F(_fld0180, l);
                _lcls4._fld019E = _cls2._mth013E(_fld0180, l);
                _lcls4._fld019C = _cls2._mth013B(l) + 2;
                _lcls4._fld019B = i1;
                _lcls4._fld019D = flag1;
                _lcls4._fld019A = -1;
                _fld017E = j1;
                flag1 = _mth018F(_cls2._mth013A(i1));
                _fld0186 = _lcls4._fld0199;
                return flag1;

            case 34: /* '"' */
                _cls4 _lcls4_1 = _fld0186;
                int j4 = _lcls4_1._fld01A0 + 1;
                _fld017E = j1;
                if (j1 == _lcls4_1._fld019A)
                {
                    _fld0186 = _lcls4_1._fld0199;
                    int l2 = _fld0186._fld01A0;
                    if (_mth018F(_lcls4_1._fld019B))
                    {
                        return true;
                    }
                    else
                    {
                        _fld0186._fld01A0 = l2;
                        _fld0186 = _lcls4_1;
                        return false;
                    }
                }
                if (j4 < _lcls4_1._fld019F)
                {
                    _lcls4_1._fld01A0 = j4;
                    _lcls4_1._fld019A = j1;
                    if (_mth018F(_lcls4_1._fld019C))
                    {
                        return true;
                    }
                    else
                    {
                        _lcls4_1._fld01A0 = j4 - 1;
                        return false;
                    }
                }
                if (_lcls4_1._fld019D)
                {
                    _fld0186 = _lcls4_1._fld0199;
                    int i3 = _fld0186._fld01A0;
                    if (_mth018F(_lcls4_1._fld019B))
                        return true;
                    _fld0186._fld01A0 = i3;
                    _fld0186 = _lcls4_1;
                    if (j4 >= _lcls4_1._fld019E)
                        return false;
                    _fld017E = j1;
                    _lcls4_1._fld01A0 = j4;
                    _lcls4_1._fld019A = j1;
                    if (_mth018F(_lcls4_1._fld019C))
                    {
                        return true;
                    }
                    else
                    {
                        _lcls4_1._fld01A0 = j4 - 1;
                        return false;
                    }
                }
                if (j4 < _lcls4_1._fld019E)
                {
                    _mth0196(_lcls4_1._fld01A1);
                    _lcls4_1._fld01A0 = j4;
                    _lcls4_1._fld019A = j1;
                    if (_mth018F(_lcls4_1._fld019C))
                        return true;
                    _mth0195();
                    _fld017E = j1;
                }
                _fld0186 = _lcls4_1._fld0199;
                int j3 = _fld0186._fld01A0;
                if (_mth018F(_lcls4_1._fld019B))
                {
                    return true;
                }
                else
                {
                    _lcls4_1._fld01A0 = j3;
                    _fld0186 = _lcls4_1;
                    _lcls4_1._fld01A0 = j4 - 1;
                    return false;
                }

            case 12: /* '\f' */
                if (_fld0180[i1] != '\f')
                {
                    i1 = _cls2._mth013B(l);
                    break;
                }
                int i5 = _fld017D;
                do
                {
                    _fld017E = j1;
                    if (_mth018F(_cls2._mth013B(l)))
                        return true;
                    int k4;
                    for (k4 = _fld017D; k4 > i5; k4--)
                        _fld017B[k4] = -1;

                    _fld017D = k4;
                    l = _cls2._mth0139(_fld0180, l);
                }
                while(l != -1 && _fld0180[l] == '\f');
                return false;

            case 29: /* '\035' */
                flag1 = true;
                break;

            case 10: /* '\n' */
            case 16: /* '\020' */
            case 17: /* '\021' */
                int k3;
                int l4;
                if (c == '\n')
                {
                    k3 = _cls2._mth013F(_fld0180, l);
                    l4 = _cls2._mth013E(_fld0180, l);
                    l = _cls2._mth013B(l) + 2;
                }
                else
                if (c == '\020')
                {
                    k3 = 0;
                    l4 = 65535;
                    l = _cls2._mth013B(l);
                }
                else
                {
                    k3 = 1;
                    l4 = 65535;
                    l = _cls2._mth013B(l);
                }
                int k;
                char c1;
                if (_fld0180[i1] == '\016')
                {
                    k = _fld0180[_cls2._mth013D(i1) + 1];
                    c1 = 0;
                }
                else
                {
                    k = 65535;
                    c1 = '\uFC18';
                }
                _fld017E = j1;
                if (flag1)
                {
                    boolean flag2 = false;
                    if (k3 > 0 && _mth0190(l, k3) < k3)
                        return false;
                    while(l4 >= k3 || l4 == 65535 && k3 > 0) 
                    {
                        if ((c1 == '\uFC18' || _fld017E >= _fld0181 || _fld0188[_fld017E] == k) && _mth018F(i1))
                            return true;
                        _fld017E = j1 + k3;
                        if (_mth0190(l, 1) != 0)
                        {
                            k3++;
                            _fld017E = j1 + k3;
                        }
                        else
                        {
                            return false;
                        }
                    }

                }
                else
                {
                    l4 = _mth0190(l, l4);
                    if (k3 < l4 && _cls2._fld0113[_fld0180[i1]] == '\004' && (!_fld018B || _fld0180[i1] == '\006'))
                        k3 = l4;
                    while(l4 >= k3) 
                    {
                        if ((c1 == '\uFC18' || _fld017E >= _fld0181 || _fld0188[_fld017E] == k) && _mth018F(i1))
                            return true;
                        l4--;
                        _fld017E = j1 + l4;
                    }

                }
                return false;

            case 0: /* '\0' */
            case 33: /* '!' */
                _fld017E = j1;
                return _fld017E != _fld0177;

            case 31: /* '\037' */
                _fld017E = j1;
                l = _cls2._mth013B(l);
                if (!_mth018F(l))
                    return false;
                break;

            case 32: /* ' ' */
                _fld017E = j1;
                l = _cls2._mth013B(l);
                if (_mth018F(l))
                    return false;
                break;

            }
        }

        return false;
    }

    public void setMultiline(boolean flag)
    {
        _fld018B = flag;
    }

    public boolean isMultiline()
    {
        return _fld018B;
    }

    char[] _mth018E(char ac[])
    {
        char ac1[] = new char[ac.length];
        System.arraycopy(ac, 0, ac1, 0, ac.length);
        ac = ac1;
        for (int i = 0; i < ac.length; i++)
            if (Character.isUpperCase(ac[i]))
                ac[i] = Character.toLowerCase(ac[i]);

        return ac;
    }

    public boolean matchesPrefix(char ac[], Pattern pattern, int i)
    {
        Perl5Pattern perl5pattern = (Perl5Pattern)pattern;
        _fld0187 = ac;
        if (perl5pattern._isCaseInsensitive)
            ac = _mth018E(ac);
        _mth0194(perl5pattern, ac, 0, ac.length);
        _fld018A = _mth0191(perl5pattern, 0);
        _fld0179 = null;
        return _fld018A;
    }

    public boolean matchesPrefix(char ac[], Pattern pattern)
    {
        return matchesPrefix(ac, pattern, 0);
    }

    public boolean matchesPrefix(String s, Pattern pattern)
    {
        return matchesPrefix(s.toCharArray(), pattern, 0);
    }

    public boolean matchesPrefix(PatternMatcherInput patternmatcherinput, Pattern pattern)
    {
        Perl5Pattern perl5pattern = (Perl5Pattern)pattern;
        _fld0187 = patternmatcherinput._fld0147;
        char ac[];
        if (perl5pattern._isCaseInsensitive)
        {
            if (patternmatcherinput._fld0146 == null)
                patternmatcherinput._fld0146 = _mth018E(_fld0187);
            ac = patternmatcherinput._fld0146;
        }
        else
        {
            ac = _fld0187;
        }
        _mth0194(perl5pattern, ac, patternmatcherinput._fld0143, patternmatcherinput._fld0144);
        _fld018A = _mth0191(perl5pattern, patternmatcherinput._fld0143);
        _fld0179 = null;
        return _fld018A;
    }

    public boolean matches(char ac[], Pattern pattern)
    {
        Perl5Pattern perl5pattern = (Perl5Pattern)pattern;
        _fld0187 = ac;
        if (perl5pattern._isCaseInsensitive)
            ac = _mth018E(ac);
        _mth0194(perl5pattern, ac, 0, ac.length);
        _fld018A = _mth0191(perl5pattern, 0) && _fld017B[0] == ac.length;
        _fld0179 = null;
        return _fld018A;
    }

    public boolean matches(String s, Pattern pattern)
    {
        return matches(s.toCharArray(), pattern);
    }

    public boolean matches(PatternMatcherInput patternmatcherinput, Pattern pattern)
    {
        Perl5Pattern perl5pattern = (Perl5Pattern)pattern;
        _fld0187 = patternmatcherinput._fld0147;
        char ac[];
        if (perl5pattern._isCaseInsensitive)
        {
            if (patternmatcherinput._fld0146 == null)
                patternmatcherinput._fld0146 = _mth018E(_fld0187);
            ac = patternmatcherinput._fld0146;
        }
        else
        {
            ac = _fld0187;
        }
        _mth0194(perl5pattern, ac, patternmatcherinput._fld0145, patternmatcherinput._fld0144);
        _fld0179 = null;
        if (_mth0191(perl5pattern, patternmatcherinput._fld0145) && (_fld017B[0] == patternmatcherinput._fld0144 || patternmatcherinput.length() == 0 || patternmatcherinput._fld0145 == patternmatcherinput._fld0144))
        {
            _fld018A = true;
            return true;
        }
        else
        {
            _fld018A = false;
            return false;
        }
    }

    public boolean contains(String s, Pattern pattern)
    {
        return contains(s.toCharArray(), pattern);
    }

    public boolean contains(char ac[], Pattern pattern)
    {
        Perl5Pattern perl5pattern = (Perl5Pattern)pattern;
        _fld0187 = ac;
        if (perl5pattern._isCaseInsensitive)
            ac = _mth018E(ac);
        return _mth0192(perl5pattern, ac, 0, ac.length);
    }

    public boolean contains(PatternMatcherInput patternmatcherinput, Pattern pattern)
    {
        if (patternmatcherinput._fld0143 > patternmatcherinput._fld0144)
            return false;
        Perl5Pattern perl5pattern = (Perl5Pattern)pattern;
        _fld0187 = patternmatcherinput._fld0147;
        _fld0187 = patternmatcherinput._fld0147;
        char ac[];
        if (perl5pattern._isCaseInsensitive)
        {
            if (patternmatcherinput._fld0146 == null)
                patternmatcherinput._fld0146 = _mth018E(_fld0187);
            ac = patternmatcherinput._fld0146;
        }
        else
        {
            ac = _fld0187;
        }
        _fld0177 = patternmatcherinput.getMatchEndOffset();
        boolean flag = _mth0192(perl5pattern, ac, patternmatcherinput._fld0143, patternmatcherinput._fld0144);
        if (flag)
        {
            patternmatcherinput.setCurrentOffset(_fld017B[0]);
            patternmatcherinput.setMatchOffsets(_fld017C[0], _fld017B[0]);
        }
        else
        {
            patternmatcherinput.setCurrentOffset(patternmatcherinput._fld0144 + 1);
        }
        _fld0177 = -100;
        return flag;
    }

    public boolean contains(Perl5StreamInput perl5streaminput, Perl5Pattern perl5pattern)
        throws IOException
    {
        boolean flag = false;
        _fld0177 = perl5streaminput._mth01AF();
        if (perl5streaminput._fld01A6 == 0 && perl5streaminput._fld01A7 == 0)
        {
            if (!perl5streaminput._mth01AD(perl5pattern._isCaseInsensitive))
            {
                _fld0177 = -100;
                return false;
            }
        }
        else
        if (perl5streaminput._fld01A5 >= perl5streaminput._fld01A7) {
            _fld0177 -= perl5streaminput._fld01A7;
            perl5streaminput._mth01AE(perl5streaminput._fld01A7, perl5pattern._isCaseInsensitive);
            perl5streaminput._fld01A5 = 0;
        }
        if (perl5streaminput._fld01A9)
        {
            _fld0177 = -100;
            return false;
        }
        int i = 0x7fffffff;
label0:
        do
        {
            do
            {
                if (perl5streaminput._fld01A7 < perl5streaminput._fld01A3.length)
                    i = perl5streaminput._fld01A7;
                try
                {
                    _fld0187 = perl5streaminput._fld01A2;
                    flag = _mth0192(perl5pattern, perl5streaminput._fld01A3, perl5streaminput._fld01A5, i);
                    break;
                }
                catch(ArrayIndexOutOfBoundsException ex)
                {
                    if (_fld0182 > perl5streaminput._fld01A7)
                    {
                        perl5streaminput._mth01AE(perl5streaminput._fld01A5, perl5pattern._isCaseInsensitive);
                    }
                    else
                    {
                        perl5streaminput._mth01AE(_fld0182, perl5pattern._isCaseInsensitive);
                        _fld0177 -= _fld0182;
                    }
                }
                if (perl5streaminput._fld01A9)
                {
                    if (i != 0x7fffffff)
                        break label0;
                    i = perl5streaminput._fld01A7;
                }
                perl5streaminput._fld01A5 = 0;
            }
            while(true);
            
            if (flag) {
                perl5streaminput._fld01A5 = _fld017B[0];
                perl5streaminput._mth01B0(_fld017B[0]);
                _fld0179._fld0176 = perl5streaminput._fld01A6 + _fld0182;
                break;
            }
            
            perl5streaminput._mth01AE(perl5streaminput._fld01A7, perl5pattern._isCaseInsensitive);
            perl5streaminput._fld01A5 = 0;
        }
        
        while (!perl5streaminput._fld01A9);
        _fld0177 = -100;
        return flag;
    }

    public MatchResult getMatch() {
        if (!_fld018A)
            return null;
        if (_fld0179 == null)
            _mth0193();
        return _fld0179;
    }

    public Perl5Matcher() {
        _fld018B = true;
        _fld018A = false;
        _fld017A = new Stack();
        _fld0177 = -100;
    }
}


