/*************************************************************************
 *
 *  $RCSfile: Util.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;

import java.util.Vector;

// Referenced classes of package com.sun.star.tool.starjar.regex:
//            Perl5Substitution, PatternMatcherInput, PatternMatcher, MatchResult, 
//            Substitution, Pattern

public final class Util {

    private Util() {}

    public static Vector split(PatternMatcher patternmatcher, Pattern pattern, String s, int i) {
        Vector vector = new Vector(20);
        PatternMatcherInput patternmatcherinput = new PatternMatcherInput(s);
        int j;
        MatchResult matchresult;
        for(j = 0; --i != 0 && patternmatcher.contains(patternmatcherinput, pattern); j = matchresult.endOffset(0))
        {
            matchresult = patternmatcher.getMatch();
            vector.addElement(s.substring(j, matchresult.beginOffset(0)));
        }

        vector.addElement(s.substring(j, s.length()));
        return vector;
    }

    public static Vector split(PatternMatcher patternmatcher, Pattern pattern, String s) {
        return split(patternmatcher, pattern, s, 0);
    }

    public static String substitute(PatternMatcher patternmatcher, Pattern pattern, Substitution substitution, String s, int i) {
        StringBuffer stringbuffer = new StringBuffer(s.length());
        PatternMatcherInput patternmatcherinput = new PatternMatcherInput(s);
        int j;
        int k;
        MatchResult matchresult;
        for(j = k = 0; i != 0 && patternmatcher.contains(patternmatcherinput, pattern); j = matchresult.endOffset(0))
        {
            i--;
            k++;
            matchresult = patternmatcher.getMatch();
            stringbuffer.append(s.substring(j, matchresult.beginOffset(0)));
            substitution.appendSubstitution(stringbuffer, matchresult, k, s, patternmatcher, pattern);
        }

        if(k == 0)
        {
            return s;
        }
        else
        {
            stringbuffer.append(s.substring(j, s.length()));
            return stringbuffer.toString();
        }
    }

    public static String substitute(PatternMatcher patternmatcher, Pattern pattern, Substitution substitution, String s)
    {
        return substitute(patternmatcher, pattern, substitution, s, 1);
    }

    public static String substitute(PatternMatcher patternmatcher, Pattern pattern, String s, String s1, int i, int j)
    {
        return substitute(patternmatcher, pattern, new Perl5Substitution(s, j), s1, i);
    }

    public static String substitute(PatternMatcher patternmatcher, Pattern pattern, String s, String s1, int i)
    {
        return substitute(patternmatcher, pattern, new Perl5Substitution(s, 0), s1, i);
    }

    public static String substitute(PatternMatcher patternmatcher, Pattern pattern, String s, String s1)
    {
        return substitute(patternmatcher, pattern, new Perl5Substitution(s, 0), s1, 1);
    }

    public static final int SUBSTITUTE_ALL = -1;
    public static final int SPLIT_ALL = 0;
    public static final int INTERPOLATE_ALL = 0;
    public static final int INTERPOLATE_NONE = -1;
}

