/*************************************************************************
 *
 *  $RCSfile: IEnvironment.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jbu $ $Date: 2002/01/18 14:06:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.uno;


import java.lang.reflect.InvocationTargetException;

import java.util.Enumeration;
import java.util.Hashtable;


/**
 * This is the interface which UNO environments have to implement. With this
 * interface objects can be registered and revoked from an environment.
 * <p>
 * @version 	$Revision: 1.3 $ $ $Date: 2002/01/18 14:06:54 $
 * @see         com.sun.star.uno.UnoRuntime
 * @see         com.sun.star.uno.IQueryInterface
 * @see         com.sun.star.uno.IBridge
 * @since       UDK1.0
 */
public interface IEnvironment {
	/**
	 * Gets the context of this environment.
	 * <p>
	 * @return    the context of the environment.
	 */
	Object getContext();
	
	/**
	 * Get the name of this environment.
	 * <p>
	 * @return    the name of the environment
	 */
	String getName();
	
	/**
	 * registers internal and external interfaces via this method. Internal interfaces are
	 * proxies that are used in an environment. External interfaces are interfaces that are
	 * exported to another environment, thus providing an object identifier for this task.
	 * This can be called an external reference.
	 * Interfaces are held weakly at an environment; they demand a final revokeInterface()
	 * call for each interface that has been registered.
	 * <p>
	 * @param object	  inout parameter for the registered object
	 * @param oId[]		  inout parameter for the corresponding object id
	 * @param type        type of this interface
	 */
	Object registerInterface(Object object, String oId[], Type type);
	
	/**
     * revokes a previously registered interface. If an interfaces has been revoked
     * as often as it has been registered, it can't be reached anymore via the
     * getRegisteredInterface method.
	 *<p>
	 * @param oId		  object id of interface to be revoked
	 * @param zInterface  type description of interface to be revoked
	 */
	void revokeInterface(String oId, Type type);

	/**
	 * Retrieves an registered interface identified by its object id and
     * type from this environment.
	 *<p>
	 * @param oId		 object id of interface to be retrieved
	 * @param xtypeDescr description of interface to be retrieved
	 */
	Object getRegisteredInterface(String oId, Type type);

	/**
	 * Retrieves the object identifier for a registered interface from this environment.
	 *<p>
	 * @param object      a registered interface
	 */
	String getRegisteredObjectIdentifier(Object object);


	/**
	 * For debug purposes. Lists the registered objects to stdout.
	 */
	void list();
}

