/*************************************************************************
 *
 *  $RCSfile: RmServer_test.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.remote;

import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.container.XSet;

import com.sun.star.container.XSet;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XElementAccess;

import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XInitialization;

import com.sun.star.loader.XImplementationLoader;

import com.sun.star.uno.IBridge;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;

import com.sun.star.bridge.XInstanceProvider;

import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;

import com.sun.star.comp.loader.JavaLoader;

public class RmServer_test {
	private static final String[] SERVICES = {
		"com.sun.star.comp.servicemanager.ServiceManager",
  		"com.sun.star.comp.connections.Acceptor",
	};
	
    JavaLoader        loader = null;
    ServiceManager    manager = null;
	
	public RmServer_test(String host, String port) {		
	    try {       	
        	JavaLoader loader = new JavaLoader();
        	
        	XImplementationLoader xImpLoader = (XImplementationLoader) UnoRuntime.queryInterface(XImplementationLoader.class, loader);
        	Object loaderobj = xImpLoader.activate("com.sun.star.comp.servicemanager.ServiceManager", null, null, null);
        	
        	XSingleServiceFactory xManagerFac = (XSingleServiceFactory) UnoRuntime.queryInterface(XSingleServiceFactory.class, loaderobj);

        	XMultiServiceFactory xMultiFac = (XMultiServiceFactory) UnoRuntime.queryInterface(
        			XMultiServiceFactory.class, 
        			xManagerFac.createInstance() );
        			
        	XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory) UnoRuntime.queryInterface(
        			XSingleServiceFactory.class, 
        			xImpLoader.activate("com.sun.star.comp.loader.JavaLoader", null, null, null));
        	
        	XInitialization xInit = (XInitialization) UnoRuntime.queryInterface( XInitialization.class, xImpLoader );
        	Object[] iniargs = { xMultiFac };
        	
        	xInit.initialize( iniargs ); 
        	
			XSet xSet = (XSet) UnoRuntime.queryInterface(XSet.class, xMultiFac);
			xSet.insert( xSingleServiceFactory );
        	
            System.err.println("create ServiceManager");
            System.err.println();
            
            manager = (ServiceManager) xSet;                        
                        
            manager.addFactories( SERVICES );
        
        	XAcceptor xAcceptor = (XAcceptor) UnoRuntime.queryInterface(XAcceptor.class, 
        										manager.createInstance("com.sun.star.connection.Acceptor"));
        										
			String conStr = "socket,host=";
			conStr += host;
			conStr += ",port=";
			conStr += port;
		
			XConnection xConnection = xAcceptor.accept("socket,host=localhost,port=6002");
			
			MyInstanceProvider instanceProvider = new MyInstanceProvider( manager );
			
			IBridge iBridge = UnoRuntime.getBridgeByName(
		               "java", null, "remote", null, 
			            new Object[]{"iiop", xConnection, instanceProvider});            
		}
		catch (Exception e) {
			System.err.println(e);
		}
	}
	
	private static void usage() {
		System.out.println("*******************************************************************");
		System.out.println();
		System.out.println("usage: java com.sun.star.comp.remote.RmServer_test host[:port]");
		System.out.println();
		System.out.println("host: the server will only accept connect requests to this host addresse (multi-homed host)");
		System.out.println("      If the host set to 0 the server will default accepting connections ");
		System.out.println("      on any/all local addresses");
		System.out.println("port [optional]: specifies the port. (default is set to 6001)");
		System.out.println();
		System.out.println("example:");
		System.out.println("  java com.sun.star.comp.remote.RmServer_test 0:6002");
		System.out.println();
		System.out.println("*******************************************************************");
		System.exit (-1);
	}
	
	public static void main( String args[] ) {
		String host = "localhost";
		String port = "6001";
		boolean wantHelp= false;
		
		if ( args.length != 1 ) 
			usage();
			
		if ( args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?") )
			usage();

		int index = args[0].lastIndexOf(':');
		
		if (index == -1)
			host = args[0];
		else {
			host = args[0].substring(0, index);
			try {
				port = args[0].substring( index+1 );
				Integer.parseInt( port );
			}
			catch (NumberFormatException e) {
				usage();
			}
		}
		new RmServer_test( host, port );					
	}
}


class MyInstanceProvider implements XInstanceProvider {
	XMultiServiceFactory m_multiFac = null;
	
	public MyInstanceProvider(XMultiServiceFactory msf) {
		m_multiFac = msf;
	}
	
	public Object getInstance( String sInstanceName )
			throws 	com.sun.star.container.NoSuchElementException, 
					com.sun.star.uno.RuntimeException
	{
		System.err.println( "get request for " + sInstanceName );
		
		return m_multiFac;
	}
	
}	
