/*************************************************************************
 *
 *  $RCSfile: CallMe_Impl.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.rmserver;


import test.TestBridgeException;
import test.XCallMe;


public class CallMe_Impl implements XCallMe {
	protected String sAttribute;

	public String getsAttribute() throws com.sun.star.uno.RuntimeException {
		return sAttribute;
	}
	
	public void setsAttribute( String _sattribute ) throws com.sun.star.uno.RuntimeException {
		sAttribute = _sattribute;
	}
	
	public void call(/*IN*/String s, /*IN*/int nToDo) throws TestBridgeException, com.sun.star.uno.RuntimeException {
		if(nToDo < 0) {
			System.err.println("##### CallMe_Impl.call: throwing exception...");
			throw new TestBridgeException("CallMe_Impl - TestBridgeException", this);
		}
	
		String sDummy = "";
		if(nToDo == 0)
			System.err.println(s);

		for(int i = 0; i < nToDo; ++ i)
			sDummy += s;
	}
	
	public void callOneway(/*IN*/String s, /*IN*/int nToDo) throws com.sun.star.uno.RuntimeException {
		String sDummy = "";

		for(int i = 0; i < nToDo; ++ i)
			sDummy += s; // just do something 
	}
	
	private Object sync = new Integer(1);

	public void callAgain(/*IN*/XCallMe callAgain, /*IN*/int nToCall) throws com.sun.star.uno.RuntimeException {
		synchronized(sync) {
			if((nToCall & 1) != 0)
				System.err.println("Deadlocktest pong:" + nToCall);
			else
				System.err.println("Deadlocktest ping:" + nToCall);
		}
	
		if(nToCall != 0)
			callAgain.callAgain(this, nToCall -1);
	}
}


