/*************************************************************************
 *
 *  $RCSfile: TestFactory_Impl.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.rmserver;


import com.sun.star.uno.UnoRuntime;

import test.TestBridgeException;
import test.XCallMe;
import test.XInterfaceTest;
import test.XTestFactory;

import com.sun.star.comp.rmserver.CallMe_Impl;


public class TestFactory_Impl implements XTestFactory {

    public XCallMe createCallMe() throws com.sun.star.uno.RuntimeException {
		XCallMe xCallMe = new CallMe_Impl();

		System.err.println("#### TestFactory_Impl.createCallMe:" + UnoRuntime.generateOid(xCallMe));

		return xCallMe;
	}


	public class InterfaceTest_Impl implements XInterfaceTest {
		protected XCallMe xCallMe;

		private void call() {
			try {
				if(xCallMe != null)
					xCallMe.call("This is my String during a callback!" , 5);
			}
			catch(TestBridgeException testBridgeException) {
				System.err.println("##### InterfaceTest_Impl.call - TestBridgeException:" + testBridgeException);
			}
		}

		public void setIn( /*IN*/XCallMe callback ) throws com.sun.star.uno.RuntimeException {
			this.xCallMe = callback;
			call();
		}

		public void setInOut( /*INOUT*/XCallMe[] callback ) throws com.sun.star.uno.RuntimeException {
			XCallMe r = xCallMe;
			xCallMe = callback[0];
			callback[0] = r;
			call();
		}

		public void getOut( /*OUT*/XCallMe[] callback ) throws com.sun.star.uno.RuntimeException {
			callback[0] = xCallMe;
		}

		public XCallMe get() throws com.sun.star.uno.RuntimeException {
			call();

			return xCallMe;
		}
	}

    public XInterfaceTest createInterfaceTest() throws com.sun.star.uno.RuntimeException {
		return new InterfaceTest_Impl();
	}
}

