/*************************************************************************
 *
 *  $RCSfile: DummyService.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.testcomp;


import java.awt.Frame;
import java.awt.FlowLayout;
import java.awt.Button;


import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.UnknownPropertyException;

import com.sun.star.comp.loader.FactoryHelper;

import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;

import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XTasksSupplier;
import com.sun.star.frame.XTask;
import com.sun.star.frame.XFrameActionListener;
import com.sun.star.frame.FrameActionEvent;
import com.sun.star.frame.FrameAction;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;

import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.InvalidRegistryException;

import com.sun.star.text.XText;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextCursor;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;


public class DummyService implements XText, 
									 XPropertySet, 
									  XPropertySetInfo, 
										XFrameActionListener
{
	final static boolean DEBUG = true;

	public final static String serviceName = "com.sun.star.comp.testcomp.DummyService";

  	protected class TaskButton extends Button
	{
		TaskButton(XTask task)
		{
			m_task = task;

			String title = "<unknown>";

	        XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, m_task);
	                
	        try
	        {
	            title = (String)xPropSet.getPropertyValue("Title");
	        }
	        catch (UnknownPropertyException e)
	        {
	        }
	        catch (WrappedTargetException e)
	        {
	        }

			setLabel(title);
		}

		public XTask getTask()
		{
			return m_task;
		}

		protected XTask m_task;
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object instanceof TaskButton)
			{
				XTask task = ((TaskButton) object).getTask();

				task.activate();				
			}
		}
	}

	protected XFrame m_xDesktop;
	protected SymAction m_lSymAction;

	public DummyService(XMultiServiceFactory xSMgr)
	{
		m_lSymAction = new SymAction();
		m_xSMgr = xSMgr;
		m_frame = new Frame("a Java Frame");

		m_frame.setLayout(new FlowLayout());

		try
		{
        	Object xIFace = m_xSMgr.createInstance("com.sun.star.frame.Desktop"); 
        	m_xDesktop = (XFrame) UnoRuntime.queryInterface(XFrame.class, xIFace);
		}
		catch( WrappedTargetException e )
		{
		}
		catch( com.sun.star.uno.Exception e )
		{
		}

		m_xDesktop.addFrameActionListener(this);
				
		updateTasks();

		m_frame.setSize(500, 100);
	}

	// XFrameActionListener
    public void frameAction(FrameActionEvent event)
    {
		if (
			(event.Action == FrameAction.COMPONENT_ATTACHED) ||
			(event.Action == FrameAction.COMPONENT_REATTACHED) ||
			(event.Action == FrameAction.FRAME_DEACTIVATING)
		   )
		{  	
	        updateTasks();
			m_frame.doLayout();
			m_frame.repaint();
		}
    }
    
    // XEventListener
    public void disposing(EventObject event)
    {
		m_xDesktop = null;
    }

    protected void updateTasks()
	{
		m_frame.removeAll();

		XTasksSupplier xTasksSupplier = (XTasksSupplier)UnoRuntime.queryInterface(XTasksSupplier.class, m_xDesktop);

		XEnumerationAccess xEnumerationAccess = xTasksSupplier.getTasks();

        XIndexAccess xIndex = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xEnumerationAccess);
        int i = 0;
        int n = xIndex.getCount();

		try
		{       
			XInterface xIFace = null;

			while (i < n)
			{
				xIFace = (XInterface)xIndex.getByIndex(i);
				TaskButton b = new TaskButton((XTask)UnoRuntime.queryInterface(XTask.class, xIFace));
            	m_frame.add(b);
				b.addActionListener(m_lSymAction);
            	i++;
        	}
		}
		catch( com.sun.star.lang.IndexOutOfBoundsException e )
		{
		}
		catch( WrappedTargetException e )
		{
		}
	}

	// XText
    public com.sun.star.text.XTextCursor createTextCursor()
	{
		return null;
	}

    public com.sun.star.text.XTextCursor createTextCursorByRange(com.sun.star.text.XTextRange aTextPosition)
	{
		return null;
	}

    public void insertString(com.sun.star.text.XTextRange xRange, String aString, boolean bAbsorb)
	{
	}

    public void insertControlCharacter(com.sun.star.text.XTextRange xRange, short nControlCharacter, boolean bAbsorb)
        throws com.sun.star.lang.IllegalArgumentException
	{
	}

    public void insertTextContent(com.sun.star.text.XTextRange xRange, com.sun.star.text.XTextContent xContent, boolean bAbsorb)
        throws com.sun.star.lang.IllegalArgumentException
	{
	}

    public void removeTextContent(com.sun.star.text.XTextContent xContent)
        throws com.sun.star.container.NoSuchElementException
	{
	}

    public void insertData(com.sun.star.uno.XInterface xData)
        throws com.sun.star.lang.IllegalArgumentException
	{
	}

	// XTextRange
    public com.sun.star.text.XText getText()
	{
		return null;
	}
    
    public com.sun.star.text.XTextRange getStart()
	{
		return null;
	}

    public com.sun.star.text.XTextRange getEnd()
	{
		return null;
	}

    public String getString()
	{
		return m_text;
	}

    public void setString(String aText)
	{
		m_text = aText;		
		m_frame.setTitle(m_text);
	}

	public boolean isVisible()
	{
		return m_isVisible;
	}

	public void setVisible(boolean bVisible)
	{
		m_isVisible = bVisible;
		if (m_isVisible) 
		{
			m_frame.show();
		}
		m_frame.setVisible(m_isVisible);
	}

	protected String m_text = "";
	protected com.sun.star.beans.Property m_textProperty = null;
	protected com.sun.star.beans.Property m_visibleProperty = null;
	protected boolean m_isVisible = false;

	protected Frame m_frame = null;

	protected void makePropertyValues()
	{
		if (m_xSMgr != null)
		{
//  			try
			{
//  				Object xIFace = m_xSMgr.createInstance("com.sun.star.uno.CoreReflection");
//  				XIdlReflection xRefl = (XIdlReflection)UnoRuntime.queryInterface(XIdlReflection.class, xIFace);
				
//  				if (xRefl != null)
				{
					m_textProperty = new com.sun.star.beans.Property(
		    			"Text",
		                0,
						com.sun.star.uno.Type.forName("java.lang.String"),
//  						xRefl.forName("string"),
		                (short)1
					);

					m_visibleProperty  = new com.sun.star.beans.Property(
		    			"Visible",
		                0,
						com.sun.star.uno.Type.forName("java.lang.Boolean"),
//  						xRefl.forName("boolean"),
		                (short)1
					);
				}
			}
//  			catch( ServiceNotRegisteredException e )
//  			{
//  			}
//  			catch( WrappedTargetException e )
//  			{				
//  			}
//  			catch( com.sun.star.uno.Exception e )
//  			{				
//  			}
		}
	}

    public com.sun.star.beans.Property[] getProperties()
	{
		com.sun.star.beans.Property[] ret = new com.sun.star.beans.Property[0];
		if (m_textProperty == null)
		{
			makePropertyValues();
			ret = new com.sun.star.beans.Property[2];
			ret[0] = m_textProperty;
			ret[1] = m_visibleProperty;
		}

		return ret;
	}

    public com.sun.star.beans.Property getProperty(String aPropertyName)
	{
		if (aPropertyName.equals("Text"))
		{
			if (m_textProperty == null)
			{
				makePropertyValues();
			}

			return m_textProperty;
		}
		else if (aPropertyName.equals("Visible"))
		{
			if (m_textProperty == null)
			{
				makePropertyValues();
			}

			return m_visibleProperty;
		}
		else
			return null;
	}

	// XPropertySet
    public com.sun.star.beans.XPropertySetInfo getPropertySetInfo()
	{
		return this;
	}

    public void setPropertyValue(String aPropertyName, Object aValue)
        throws com.sun.star.beans.UnknownPropertyException, com.sun.star.lang.IllegalArgumentException
	{
		if (aPropertyName.equals("Text"))
		{
			if (m_text.getClass().isInstance(aValue))
			{
				setString((String)aValue);
			}
			else
				throw new com.sun.star.lang.IllegalArgumentException();
		}
		else if (aPropertyName.equals("Visible"))
		{
			if ((new Boolean(true)).getClass().isInstance(aValue))
			{
				setVisible(((Boolean)aValue).booleanValue());
			}
			else
				throw new com.sun.star.lang.IllegalArgumentException();
		}
		else
			throw new com.sun.star.beans.UnknownPropertyException();
	}

    public Object getPropertyValue(String aPropertyName)
        throws com.sun.star.beans.UnknownPropertyException
	{
		Object result = null;

		if (aPropertyName.equals("Text"))
		{
			result = getString();
		}
		else if (aPropertyName.equals("Visible"))
		{
			result = new Boolean(isVisible());
		}
		else
			throw new com.sun.star.beans.UnknownPropertyException();

		return result;
	}
	
    public void addPropertyChangeListener(String aPropertyName, com.sun.star.beans.XPropertyChangeListener aListener)
        throws com.sun.star.beans.UnknownPropertyException
	{
	}

    public void removePropertyChangeListener(String aPropertyName, com.sun.star.beans.XPropertyChangeListener aListener)
        throws com.sun.star.beans.UnknownPropertyException
	{
	}

    public void addVetoableChangeListener(String aPropertyName, com.sun.star.beans.XVetoableChangeListener aListener)
        throws com.sun.star.beans.UnknownPropertyException
	{
	}

    public void removeVetoableChangeListener(String aPropertyName, com.sun.star.beans.XVetoableChangeListener aListener)
        throws com.sun.star.beans.UnknownPropertyException
	{
	}

	// XPropertySetInfo
    public com.sun.star.beans.Property getPropertyByName(String Name)
	{
		return null;
	}

    public boolean hasPropertyByName(String Name)
	{
		return false;
	}

	public void finalize()
	{
		System.err.print("#### DummyService:finalize:");
	}

	protected XMultiServiceFactory 	m_xSMgr = null;
//  	protected XIdlClass[] 			m_classes = null;




	public static XSingleServiceFactory getServiceFactory(String implName, 
														  XMultiServiceFactory multiFactory, 
														  XRegistryKey regKey)
	{
		XSingleServiceFactory xSingleServiceFactory = null;

	    if (implName.equals(DummyService.class.getName()) )
	        xSingleServiceFactory = FactoryHelper.getServiceFactory(DummyService.class,
																	multiFactory, 
																	regKey);
	    
	    return xSingleServiceFactory;
	}
	
	public static boolean writeRegistryServiceInfo(XRegistryKey regKey) {
		return FactoryHelper.writeRegistryServiceInfo(DummyService.class.getName(), serviceName, regKey);
    }
}

