/*************************************************************************
 *
 *  $RCSfile: TDMtest.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package test.com.sun.star.comp.typedescriptionmanager;

import test.*;

import com.sun.star.uno.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.reflection.*;
import com.sun.star.container.*;
import com.sun.star.comp.typedescriptionmanager.TypeDescriptionManager;


//==================================================================================================
class Parameter
{
	public boolean bIn;
	public boolean bOut;
	public String type;
	public String name;
	
	public Parameter( boolean bIn, boolean bOut, String type, String name )
	{
		this.bIn = bIn;
		this.bOut = bOut;
		this.type = type;
		this.name = name;
	}
}

//==================================================================================================
public class TDMtest
{
	private XHierarchicalNameAccess _xTDMgr = new TypeDescriptionManager();
	
	//______________________________________________________________________________________________
	private static void ASSERT( boolean c )
		throws java.lang.Exception
	{
		if (! c)
			throw new RuntimeException( "assertion failed!", null );
	}
	//______________________________________________________________________________________________
	private static void ENSURE( boolean c, String m )
		throws java.lang.Exception
	{
		if (! c)
			throw new RuntimeException( m, null );
	}
	
	//______________________________________________________________________________________________
	private void checkAttribute( XInterfaceMemberTypeDescription xMember, int nPos,
								 boolean bReadOnly, String type,
								 String memberName, String name, TypeClass typeClass )
		throws java.lang.Exception
	{
		XInterfaceAttributeTypeDescription xAttribute = (XInterfaceAttributeTypeDescription)xMember;
		ENSURE( xAttribute.getTypeClass() == TypeClass.INTERFACE_ATTRIBUTE,
				"attribute "+memberName+": wrong type class \""+xAttribute.getTypeClass()+
				"\" (should be \"INTERFACE_ATTRIBUTE\" !" );
		ENSURE( xAttribute.getMemberName().equals( memberName ),
				"attribute "+memberName+": wrong member name \""+xAttribute.getMemberName()+"\" !" );
		ENSURE( xAttribute.getName().equals( name ),
				"attribute "+memberName+": wrong name \""+xAttribute.getName()+"\" !" );
		ENSURE( xAttribute.getPosition() == nPos,
				"attribute "+memberName+": wrong position: "+xAttribute.getPosition()+" (should be "+nPos+")!" );
		
		ENSURE( xAttribute.isReadOnly() == bReadOnly,
				"attribute "+memberName+": read only flag differs!" );
		ENSURE( xAttribute.getType().getName().equals( type ),
				"attribute "+memberName+": wrong type \""+xAttribute.getType().getName()+
				"\" (should be \""+type+"\") !" );
		ENSURE( xAttribute.getType() == _xTDMgr.getByHierarchicalName( type ),
				"attribute "+memberName+": table type differs!" );
		ENSURE( xAttribute.getType().getTypeClass() == typeClass,
				"attribute "+memberName+": wrong type class \""+xAttribute.getType().getTypeClass()+
				"\" (should be \""+typeClass+"\" !" );
	}
	//______________________________________________________________________________________________
	private void checkMethod( XInterfaceMemberTypeDescription xMember, int nPos, boolean bOneWay,
							  String memberName, String name,
							  String returnType, Parameter[] params, String[] exceptions )
		throws java.lang.Exception
	{
		XInterfaceMethodTypeDescription xMethod = (XInterfaceMethodTypeDescription)xMember;
		ENSURE( xMethod.getTypeClass() == TypeClass.INTERFACE_METHOD,
				"method "+memberName+": wrong type class \""+xMethod.getTypeClass()+
				"\" (should be \"INTERFACE_METHOD\" !" );
		ENSURE( xMethod.getMemberName().equals( memberName ),
				"method "+memberName+": wrong member name \""+xMethod.getMemberName()+"\" !" );
		ENSURE( xMethod.getName().equals( name ),
				"method "+memberName+": wrong name \""+xMethod.getName()+"\" !" );
		ENSURE( xMethod.getPosition() == nPos,
				"method "+memberName+": wrong position: "+xMethod.getPosition()+
				" (should be "+nPos+")!" );
		// return type
		ENSURE( xMethod.getReturnType().getName().equals( returnType ),
				"method "+memberName+": wrong return type \""+xMethod.getReturnType().getName()+
				"\" (should be \""+returnType+"\") !" );
		ENSURE( xMethod.getReturnType() == _xTDMgr.getByHierarchicalName( returnType ),
				"method "+memberName+": table type differs!" );
		// exceptions
		XTypeDescription[] exc = xMethod.getExceptions();
		ENSURE( exc.length == exceptions.length,
				"method "+memberName+": exceptions lists length differ!" );
		int i;
		for ( i = 0; i < exc.length; ++i )
		{
			ENSURE( exc[i].getTypeClass() == TypeClass.EXCEPTION,
					"exception \""+exc[i].getName()+"\" has wrong typeclass \""+exc[i].getTypeClass()+"\" !" );
			ENSURE( exc[i].getName().equals( exceptions[i] ),
					"method "+memberName+": wrong exception types ["+i+
					"] (should be \""+exceptions[i]+"\") !" );
			ENSURE( exc[i] == _xTDMgr.getByHierarchicalName( exceptions[i] ),
					"method "+memberName+": table type differs!" );
		}
		// params
		XMethodParameter[] mparams = xMethod.getParameters();
		ENSURE( mparams.length == params.length,
				"method "+memberName+": parameter lists length differ!" );
		for ( i = 0; i < mparams.length; ++i )
		{
			XMethodParameter xParam = mparams[i];
			Parameter param = params[i];
			ENSURE( xParam.getPosition() == i,
					"method "+memberName+", parameter "+i+": position differs!" );
			ENSURE( xParam.isIn() == param.bIn,
					"method "+memberName+", parameter "+i+": IN flag differs!" );
			ENSURE( xParam.isOut() == param.bOut,
					"method "+memberName+", parameter "+i+": OUT flag differs!" );
			// param names get lost reading type description from java reflection... so
//  			ENSURE( xParam.getName().equals( param.name ),
//  					"method "+memberName+", parameter "+i+": name differs!" );
//  			ENSURE( xParam.getName().equals( "Parameter "+i ),
//  					"method "+memberName+", parameter "+i+": name differs!" );
			ENSURE( xParam.getType().getName().equals( param.type ),
					"method "+memberName+", parameter "+i+": wrong type \""+
					xParam.getType().getName()+"\" (should be \""+param.type+"\") !" );
			ENSURE( xParam.getType() == _xTDMgr.getByHierarchicalName( param.type ),
					"method "+memberName+", parameter "+i+": table type differs!" );
		}
	}
	
	//______________________________________________________________________________________________
	public void test()
		throws java.lang.Exception
	{
		XInterfaceTypeDescription xITD = (XInterfaceTypeDescription)_xTDMgr.getByHierarchicalName( "test.XLanguageBindingTest" );
		ASSERT( xITD.getName().equals( "test.XLanguageBindingTest" ) );
		ASSERT( _xTDMgr.getByHierarchicalName( "test.XLanguageBindingTest" ) == xITD );
		
		XInterfaceMemberTypeDescription[] members = xITD.getMembers();
		ASSERT( members.length == 4 );
		// attribute long RuntimeException
		checkAttribute( members[0], 23, false, "long", "RuntimeException", "test.XLanguageBindingTest::RuntimeException", TypeClass.LONG );
		// getFoo()
		checkMethod( members[1], 24, false /*oneway*/,
					 "getFoo", "test.XLanguageBindingTest::getFoo",
					 "test.XLBTestBase",
					 new Parameter[0], new String[] { "com.sun.star.uno.RuntimeException" } );
		// setFoo()
		checkMethod( members[2], 25, false /*oneway*/,
					 "setFoo", "test.XLanguageBindingTest::setFoo",
					 "unsigned hyper",
					 new Parameter[] {
						 new Parameter( true, true, "hyper", "h" ) },
					 new String[] { "com.sun.star.uno.RuntimeException" } );
		
		// raiseException()
		checkMethod( members[3], 26, false /*oneway*/,
					 "raiseException", "test.XLanguageBindingTest::raiseException",
					 "test.TestDataElements",
					 new Parameter[] {
						 new Parameter( false, true, "boolean", "bBool" ),
						 new Parameter( false, true, "char", "cChar" ),
						 new Parameter( false, true, "byte", "nByte" ),
						 new Parameter( false, true, "short", "nShort" ),
						 new Parameter( false, true, "unsigned short", "nUShort" ),
						 new Parameter( false, true, "long", "nLong" ),
						 new Parameter( false, true, "unsigned long", "nULong" ),
						 new Parameter( false, true, "hyper", "nHyper" ),
						 new Parameter( false, true, "unsigned hyper", "nUHyper" ),
						 new Parameter( false, true, "float", "fFloat" ),
						 new Parameter( false, true, "double", "fDouble" ),
						 new Parameter( false, true, "test.TestEnum", "eEnum" ),
						 new Parameter( false, true, "string", "aString" ),
						 new Parameter( false, true, "com.sun.star.uno.XInterface", "xInterface" ),
						 new Parameter( false, true, "any", "aAny" ),
						 new Parameter( false, true, "[]test.TestElement", "aSequence" ),
						 new Parameter( false, true, "test.TestDataElements", "aStruct" ) },
					 new String[] {
						 "com.sun.star.lang.IllegalArgumentException",
						 "com.sun.star.uno.RuntimeException" } );
		
		// base XLBTestBase
		xITD = (XInterfaceTypeDescription)xITD.getBaseType();
		ASSERT( xITD.getName().equals( "test.XLBTestBase" ) );
		ASSERT( xITD == _xTDMgr.getByHierarchicalName( "test.XLBTestBase" ) );
		members = xITD.getMembers();
		ASSERT( members.length == 20 );
		// attributes
		// [attribute] boolean					 Bool;
		checkAttribute( members[0], 3, false, "boolean", "Bool", "test.XLBTestBase::Bool", TypeClass.BOOLEAN );
		checkAttribute( members[1], 4, false, "byte", "Byte", "test.XLBTestBase::Byte", TypeClass.BYTE );
		checkAttribute( members[2], 5, false, "char", "Char", "test.XLBTestBase::Char", TypeClass.CHAR );
		checkAttribute( members[3], 6, false, "short", "Short", "test.XLBTestBase::Short", TypeClass.SHORT );
		checkAttribute( members[4], 7, false, "unsigned short", "UShort", "test.XLBTestBase::UShort", TypeClass.UNSIGNED_SHORT );
		checkAttribute( members[5], 8, false, "long", "Long", "test.XLBTestBase::Long", TypeClass.LONG );
		checkAttribute( members[6], 9, false, "unsigned long", "ULong", "test.XLBTestBase::ULong", TypeClass.UNSIGNED_LONG );
		checkAttribute( members[7], 10, false, "hyper", "Hyper", "test.XLBTestBase::Hyper", TypeClass.HYPER );
		checkAttribute( members[8], 11, false, "unsigned hyper", "UHyper", "test.XLBTestBase::UHyper", TypeClass.UNSIGNED_HYPER );
		checkAttribute( members[9], 12, false, "float", "Float", "test.XLBTestBase::Float", TypeClass.FLOAT );
		checkAttribute( members[10], 13, false, "double", "Double", "test.XLBTestBase::Double", TypeClass.DOUBLE );
		checkAttribute( members[11], 14, false, "test.TestEnum", "Enum", "test.XLBTestBase::Enum", TypeClass.ENUM );
		checkAttribute( members[12], 15, false, "string", "String", "test.XLBTestBase::String", TypeClass.STRING );
		checkAttribute( members[13], 16, false, "com.sun.star.uno.XInterface", "Interface", "test.XLBTestBase::Interface", TypeClass.INTERFACE );
		checkAttribute( members[14], 17, false, "any", "Any", "test.XLBTestBase::Any", TypeClass.ANY );
		checkAttribute( members[15], 18, false, "[]test.TestElement", "Sequence", "test.XLBTestBase::Sequence", TypeClass.SEQUENCE );
		checkAttribute( members[16], 19, false, "test.TestDataElements", "Struct", "test.XLBTestBase::Struct", TypeClass.STRUCT );
		// setValues()
		checkMethod( members[17], 20, true /*oneway*/,
					 "setValues", "test.XLBTestBase::setValues",
					 "void",
					 new Parameter[] {
						 new Parameter( true, false, "boolean", "bBool" ),
						 new Parameter( true, false, "char", "cChar" ),
						 new Parameter( true, false, "byte", "nByte" ),
						 new Parameter( true, false, "short", "nShort" ),
						 new Parameter( true, false, "unsigned short", "nUShort" ),
						 new Parameter( true, false, "long", "nLong" ),
						 new Parameter( true, false, "unsigned long", "nULong" ),
						 new Parameter( true, false, "hyper", "nHyper" ),
						 new Parameter( true, false, "unsigned hyper", "nUHyper" ),
						 new Parameter( true, false, "float", "fFloat" ),
						 new Parameter( true, false, "double", "fDouble" ),
						 new Parameter( true, false, "test.TestEnum", "eEnum" ),
						 new Parameter( true, false, "string", "aString" ),
						 new Parameter( true, false, "com.sun.star.uno.XInterface", "xInterface" ),
						 new Parameter( true, false, "any", "aAny" ),
						 new Parameter( true, false, "[]test.TestElement", "aSequence" ),
						 new Parameter( true, false, "test.TestDataElements", "aStruct" ) },
					 new String[] {
						 "com.sun.star.uno.RuntimeException" } );
		// setValues2()
		checkMethod( members[18], 21, false /*oneway*/,
					 "setValues2", "test.XLBTestBase::setValues2",
					 "test.TestDataElements",
					 new Parameter[] {
						 new Parameter( true, true, "boolean", "bBool" ),
						 new Parameter( true, true, "char", "cChar" ),
						 new Parameter( true, true, "byte", "nByte" ),
						 new Parameter( true, true, "short", "nShort" ),
						 new Parameter( true, true, "unsigned short", "nUShort" ),
						 new Parameter( true, true, "long", "nLong" ),
						 new Parameter( true, true, "unsigned long", "nULong" ),
						 new Parameter( true, true, "hyper", "nHyper" ),
						 new Parameter( true, true, "unsigned hyper", "nUHyper" ),
						 new Parameter( true, true, "float", "fFloat" ),
						 new Parameter( true, true, "double", "fDouble" ),
						 new Parameter( true, true, "test.TestEnum", "eEnum" ),
						 new Parameter( true, true, "string", "aString" ),
						 new Parameter( true, true, "com.sun.star.uno.XInterface", "xInterface" ),
						 new Parameter( true, true, "any", "aAny" ),
						 new Parameter( true, true, "[]test.TestElement", "aSequence" ),
						 new Parameter( true, true, "test.TestDataElements", "aStruct" ) },
					 new String[] {
						 "com.sun.star.uno.RuntimeException" } );
		// getValues()
		checkMethod( members[19], 22, false /*oneway*/,
					 "getValues", "test.XLBTestBase::getValues",
					 "test.TestDataElements",
					 new Parameter[] {
						 new Parameter( false, true, "boolean", "bBool" ),
						 new Parameter( false, true, "char", "cChar" ),
						 new Parameter( false, true, "byte", "nByte" ),
						 new Parameter( false, true, "short", "nShort" ),
						 new Parameter( false, true, "unsigned short", "nUShort" ),
						 new Parameter( false, true, "long", "nLong" ),
						 new Parameter( false, true, "unsigned long", "nULong" ),
						 new Parameter( false, true, "hyper", "nHyper" ),
						 new Parameter( false, true, "unsigned hyper", "nUHyper" ),
						 new Parameter( false, true, "float", "fFloat" ),
						 new Parameter( false, true, "double", "fDouble" ),
						 new Parameter( false, true, "test.TestEnum", "eEnum" ),
						 new Parameter( false, true, "string", "aString" ),
						 new Parameter( false, true, "com.sun.star.uno.XInterface", "xInterface" ),
						 new Parameter( false, true, "any", "aAny" ),
						 new Parameter( false, true, "[]test.TestElement", "aSequence" ),
						 new Parameter( false, true, "test.TestDataElements", "aStruct" ) },
					 new String[] {
						 "com.sun.star.uno.RuntimeException" } );
		// base XLBTestBase
		xITD = (XInterfaceTypeDescription)xITD.getBaseType();
		ASSERT( xITD.getName().equals( "com.sun.star.uno.XInterface" ) );
		ASSERT( xITD == _xTDMgr.getByHierarchicalName( "com.sun.star.uno.XInterface" ) );
		members = xITD.getMembers();
		ASSERT( members.length == 3 );
		// queryInterface()
		checkMethod( members[0], 0, false /*oneway*/,
					 "queryInterface", "com.sun.star.uno.XInterface::queryInterface",
					 "boolean",
					 new Parameter[] {
						 new Parameter( true, false, "com.sun.star.uno.Uik", "uik" ),
						 new Parameter( false, true, "any", "ifc" ) },
					 new String[] {
						 "com.sun.star.uno.RuntimeException" } );
		// acquire()
		checkMethod( members[1], 1, true /*oneway*/,
					 "acquire", "com.sun.star.uno.XInterface::acquire",
					 "void",
					 new Parameter[0],
					 new String[] {
						 "com.sun.star.uno.RuntimeException" } );
		// release()
		checkMethod( members[2], 2, true /*oneway*/,
					 "release", "com.sun.star.uno.XInterface::release",
					 "void",
					 new Parameter[0],
					 new String[] {
						 "com.sun.star.uno.RuntimeException" } );

		// compound types
		// test.TestDataElements
		XCompoundTypeDescription xTE = (XCompoundTypeDescription)_xTDMgr.getByHierarchicalName( "test.TestDataElements" );
		ASSERT( xTE.getTypeClass() == TypeClass.STRUCT );
		ASSERT( xTE.getName().equals( "test.TestDataElements" ) );
		ASSERT( xTE == _xTDMgr.getByHierarchicalName( "test.TestDataElements" ) );
		XTypeDescription[] cmembers = xTE.getMemberTypes();
		String[] cnames = xTE.getMemberNames();
		ASSERT( cmembers.length == cnames.length && cmembers.length == 1 );
		ASSERT( cmembers[0].getName().equals( "[]test.TestElement" ) &&
				cmembers[0] == _xTDMgr.getByHierarchicalName( "[]test.TestElement" ) &&
				cnames[0].equals( "Sequence" ) );
		// test.TestElement
		xTE = (XCompoundTypeDescription)xTE.getBaseType();
		ASSERT( xTE.getTypeClass() == TypeClass.STRUCT );
		ASSERT( xTE.getName().equals( "test.TestElement" ) );
		ASSERT( xTE == _xTDMgr.getByHierarchicalName( "test.TestElement" ) );
		cmembers = xTE.getMemberTypes();
		cnames = xTE.getMemberNames();
		ASSERT( cmembers.length == cnames.length && cmembers.length == 3 );
		ASSERT( cmembers[0].getName().equals( "string" ) &&
				cmembers[0] == _xTDMgr.getByHierarchicalName( "string" ) &&
				cnames[0].equals( "String" ) );
		ASSERT( cmembers[1].getName().equals( "com.sun.star.uno.XInterface" ) &&
				cmembers[1] == _xTDMgr.getByHierarchicalName( "com.sun.star.uno.XInterface" ) &&
				cnames[1].equals( "Interface" ) );
		ASSERT( cmembers[2].getName().equals( "any" ) &&
				cmembers[2] == _xTDMgr.getByHierarchicalName( "any" ) &&
				cnames[2].equals( "Any" ) );
		// test.TestSimple
		xTE = (XCompoundTypeDescription)xTE.getBaseType();
		ASSERT( xTE.getTypeClass() == TypeClass.STRUCT );
		ASSERT( xTE.getName().equals( "test.TestSimple" ) );
		ASSERT( xTE == _xTDMgr.getByHierarchicalName( "test.TestSimple" ) );
		cmembers = xTE.getMemberTypes();
		cnames = xTE.getMemberNames();
		ASSERT( cmembers.length == cnames.length && cmembers.length == 12 );
		ASSERT( cmembers[0].getName().equals( "boolean" ) &&
				cmembers[0] == _xTDMgr.getByHierarchicalName( "boolean" ) &&
				cnames[0].equals( "Bool" ) );
		ASSERT( cmembers[1].getName().equals( "char" ) &&
				cmembers[1] == _xTDMgr.getByHierarchicalName( "char" ) &&
				cnames[1].equals( "Char" ) );
		ASSERT( cmembers[2].getName().equals( "byte" ) &&
				cmembers[2] == _xTDMgr.getByHierarchicalName( "byte" ) &&
				cnames[2].equals( "Byte" ) );
		ASSERT( cmembers[3].getName().equals( "short" ) &&
				cmembers[3] == _xTDMgr.getByHierarchicalName( "short" ) &&
				cnames[3].equals( "Short" ) );
		ASSERT( cmembers[4].getName().equals( "unsigned short" ) &&
				cmembers[4] == _xTDMgr.getByHierarchicalName( "unsigned short" ) &&
				cnames[4].equals( "UShort" ) );
		ASSERT( cmembers[5].getName().equals( "long" ) &&
				cmembers[5] == _xTDMgr.getByHierarchicalName( "long" ) &&
				cnames[5].equals( "Long" ) );
		ASSERT( cmembers[6].getName().equals( "unsigned long" ) &&
				cmembers[6] == _xTDMgr.getByHierarchicalName( "unsigned long" ) &&
				cnames[6].equals( "ULong" ) );
		ASSERT( cmembers[7].getName().equals( "hyper" ) &&
				cmembers[7] == _xTDMgr.getByHierarchicalName( "hyper" ) &&
				cnames[7].equals( "Hyper" ) );
		ASSERT( cmembers[8].getName().equals( "unsigned hyper" ) &&
				cmembers[8] == _xTDMgr.getByHierarchicalName( "unsigned hyper" ) &&
				cnames[8].equals( "UHyper" ) );
		ASSERT( cmembers[9].getName().equals( "float" ) &&
				cmembers[9] == _xTDMgr.getByHierarchicalName( "float" ) &&
				cnames[9].equals( "Float" ) );
		ASSERT( cmembers[10].getName().equals( "double" ) &&
				cmembers[10] == _xTDMgr.getByHierarchicalName( "double" ) &&
				cnames[10].equals( "Double" ) );
		ASSERT( cmembers[11].getName().equals( "test.TestEnum" ) &&
				cmembers[11] == _xTDMgr.getByHierarchicalName( "test.TestEnum" ) &&
				cnames[11].equals( "Enum" ) );
		
		// enum type
		XEnumTypeDescription xEnum = (XEnumTypeDescription)_xTDMgr.getByHierarchicalName( "test.TestEnum" );
		ASSERT( xEnum.getTypeClass() == TypeClass.ENUM );
		ASSERT( xEnum.getName().equals( "test.TestEnum" ) );
		ASSERT( xEnum == _xTDMgr.getByHierarchicalName( "test.TestEnum" ) );
		int[] enumValues = xEnum.getEnumValues();
		String[] enumNames = xEnum.getEnumNames();
		ASSERT( enumNames.length == enumValues.length && enumValues.length == 7 );
		ASSERT( enumValues[0] == 0 && enumNames[0].equals( "TEST" ) );
		ASSERT( enumValues[1] == 1 && enumNames[1].equals( "ONE" ) );
		ASSERT( enumValues[2] == 2 && enumNames[2].equals( "TWO" ) );
		ASSERT( enumValues[3] == 3 && enumNames[3].equals( "CHECK" ) );
		ASSERT( enumValues[4] == 4 && enumNames[4].equals( "LOLA" ) );
		ASSERT( enumValues[5] == 5 && enumNames[5].equals( "PALOO" ) );
		ASSERT( enumValues[6] == 6 && enumNames[6].equals( "ZA" ) );
	}
	
	//______________________________________________________________________________________________
	public static void main( String args[] )
	{
		try
		{
			(new TDMtest()).test();
			System.out.println( "tdmanager test succeeded." );
		}
		catch (java.lang.Exception exc)
		{
			System.out.println( exc.getMessage() + " >> tdmanager test failed!" );
		}
	}
}

