/*************************************************************************
 *
 *  $RCSfile: Protocol_Test.java,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kr $ $Date: 2001/05/17 12:46:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.lib.uno.protocols;


import java.lang.reflect.Constructor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
//  import java.io.IOException;

import java.util.Vector;


import com.sun.star.bridge.XInstanceProvider;

import com.sun.star.lib.uno.environments.remote.IMessage;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;

import com.sun.star.lib.uno.typedesc.TypeDescription;

import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.Type;
import com.sun.star.uno.XInterface;


public class Protocol_Test {
	static ByteArrayInputStream sendRequest(IProtocol sender, 
											String oid, 
											TypeDescription typeDescription, 
											String operation, 
											ThreadId threadId, 
											Object params[], 
											Boolean synchron[],
											Boolean mustReply[]) throws Exception 
    {
		sender.writeRequest(oid, typeDescription, operation, threadId, params, synchron, mustReply);

		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);

		sender.flush(dataOutputStream);

		return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
	}

	static ByteArrayInputStream sendReply(IProtocol sender, boolean exception, ThreadId threadId, Object result) throws Exception {
  		sender.writeReply(exception, 
						  threadId, 
						  result);


		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);

		sender.flush(dataOutputStream);

		return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
	}

	static IMessage receiveMessage(IProtocol receiver, ByteArrayInputStream byteArrayInputStream) throws Exception {
		return receiver.readMessage(byteArrayInputStream);
	}

	static boolean testCall(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		System.err.println("\t\ttesting testCall:");
		// send an ordinary request
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "method", 
																  new ThreadId(new byte[]{0, 1}), 
																  new Object[0],
																  new Boolean[1],
																  new Boolean[1]));
		iMessage.getData(new Object[1][]);

		// send a reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 null));
		iMessage.getData(new Object[1][]);

		System.err.println("\t\tpassed? " + true);

		return true;
	}

	static boolean testCallWithInParameter(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWithInParameter:");
		// send an ordinary request
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "methodWithInParameter", 
																  new ThreadId(new byte[]{0, 1}), 
																  new Object[]{"hallo"},
																  new Boolean[1],
																  new Boolean[1]));
		Object t_params[][] = new Object[1][];
		iMessage.getData(t_params);
		System.err.println("\t\t\tgot in request: " + ((String)t_params[0][0]) + " expected: hallo");
		passed = passed && "hallo".equals((String)t_params[0][0]);

		// send a reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 null));
		iMessage.getData(new Object[1][]);

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static boolean testCallWithOutParameter(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWithOutParameter:");
		Object params[] = new Object[]{new String[1]};
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "methodWithOutParameter", 
																  new ThreadId(new byte[]{0, 1}), 
																  params,
																  new Boolean[1],
																  new Boolean[1]));


		Object t_params[][] = new Object[1][];
		iMessage.getData(t_params);
		((String [])t_params[0][0])[0] = "testString";

		// send an exception as reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 null));

		iMessage.getData(new Object[1][]);

		System.err.println("\t\t\tgot in reply:" + ((String [])params[0])[0] + " expected: testString");
		passed = passed && "testString".equals(((String [])params[0])[0]);

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static boolean testCallWithInOutParameter(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWithInOutParameter:");
		Object params[] = new Object[]{new String[]{"inString"}};
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "methodWithInOutParameter", 
																  new ThreadId(new byte[]{0, 1}), 
																  params,
																  new Boolean[1],
																  new Boolean[1]));


		Object t_params[][] = new Object[1][];
		iMessage.getData(t_params);
		System.err.println("\t\t\tgot in request:" + ((String [])t_params[0][0])[0] + " expected: inString");
		passed = passed && "inString".equals(((String [])t_params[0][0])[0]);

		// provide reply
		((String [])t_params[0][0])[0] = "outString";

		// send an exception as reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 null));

		iMessage.getData(new Object[1][]);

		System.err.println("\t\t\tgot in reply:" + ((String [])params[0])[0] + " expected: outString");
		passed = passed && "outString".equals(((String [])params[0])[0]);

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static boolean testCallWithResult(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWithResult:");
		// send an ordinary request
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "methodWithResult", 
																  new ThreadId(new byte[]{0, 1}), 
																  new Object[0],
																  new Boolean[1],
																  new Boolean[1]));
		iMessage.getData(new Object[1][]);

		// send a reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 "resultString"));
		Object result = iMessage.getData(new Object[1][]);

		System.err.println("\t\t\tgot as result:" + result + " expected: resultString");
		passed = passed && "resultString".equals(result);

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static boolean testCallWhichRaisesException(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWhichRaisesException:");

		// send a second request
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "method", 
																  new ThreadId(new byte[]{0, 1}), 
																  new Object[0],
																  new Boolean[1],
																  new Boolean[1]));
		iMessage.getData(new Object[1][]);

		// send an exception as reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 true,
													 new ThreadId(new byte[]{0, 1}), 
													 new com.sun.star.uno.RuntimeException("test the exception")));

		Object result = iMessage.getData(new Object[1][]);

		System.err.println("\t\t\tgot as result:" + result + " expected: a RuntimeException");
		passed = passed && (result instanceof com.sun.star.uno.RuntimeException);

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static boolean testCallWithIn_Out_InOut_Paramters_and_result(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWithIn_Out_InOut_Paramters_and_result:");

		Object params[] = new Object[]{"hallo", new String[1], new String[]{"inOutString"}};
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "methodWithIn_Out_InOut_Paramters_and_result", 
																  new ThreadId(new byte[]{0, 1}), 
																  params,
																  new Boolean[1],
																  new Boolean[1]));

		Object t_params[][] = new Object[1][];
		iMessage.getData(t_params);


		System.err.println("\t\t\tgot in request: " + ((String)t_params[0][0]) + " expected: hallo");
		passed = passed && "hallo".equals((String)t_params[0][0]);

		System.err.println("\t\t\tgot in request:" + ((String [])t_params[0][2])[0] + " expected: inOutString");
		passed = passed && "inOutString".equals(((String [])t_params[0][2])[0]);

		((String [])t_params[0][1])[0] = "outString";
		((String [])t_params[0][2])[0] = "inOutString_res";

		// send an exception as reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 "resultString"));

		Object result = iMessage.getData(new Object[1][]);
		System.err.println("\t\t\tgot in reply:" + ((String [])params[1])[0] + " expected: outString");
		passed = passed && "outString".equals(((String [])params[1])[0]);

		System.err.println("\t\t\tgot in reply:" + ((String [])params[2])[0] + " expected: inOutString_res");
		passed = passed && "inOutString_res".equals(((String [])params[2])[0]);

		System.err.println("\t\t\tgot as result:" + result + " expected: resultString");
		passed = passed && "resultString".equals(result);

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static boolean testCallWhichReturnsAny(IProtocol iSender, IProtocol iReciever, String oId) throws Exception {
		boolean passed = true;

		System.err.println("\t\ttesting testCallWhichReturnsAny:");

		System.err.println("\t\t\tvoid-any:");
		// send an ordinary request
		IMessage iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "returnAny", 
																  new ThreadId(new byte[]{0, 1}), 
																  null,
																  new Boolean[1],
																  new Boolean[1]));
		// send a reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 new com.sun.star.uno.Any(Void.class, null)));
		Object result = iMessage.getData(new Object[1][]);
		System.err.println("\t\t\tgot as result:" + result + " expected: void-any");
		boolean tmp_passed = (result instanceof Any) && (((Any)result).getType().getTypeDescription().getZClass() == void.class);
		System.err.println("\t\t\tpassed? " + tmp_passed);
		passed = passed && tmp_passed;

		System.err.println("\t\t\tnull interface:");
		// send an ordinary request
		iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "returnAny", 
																  new ThreadId(new byte[]{0, 1}), 
																  null,
																  new Boolean[1],
																  new Boolean[1]));
		// send a reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 new Any(XInterface.class, null)));
		result = iMessage.getData(new Object[1][]);
		System.err.println("\t\t\tgot as result:" + result + " expected: null interface");
		tmp_passed = result == null;
		System.err.println("\t\t\tpassed? " + tmp_passed);
		passed = passed && tmp_passed;

		System.err.println("\t\t\tinteger object:");
		// send an ordinary request
		iMessage = receiveMessage(iReciever, sendRequest(iSender,
																  oId, 
																  TypeDescription.getTypeDescription(test.XTestInterface.class), 
																  "returnAny", 
																  new ThreadId(new byte[]{0, 1}), 
																  null,
																  new Boolean[1],
																  new Boolean[1]));
		// send a reply
		iMessage = receiveMessage(iSender, sendReply(iReciever, 
													 false,
													 new ThreadId(new byte[]{0, 1}), 
													 new Integer(501)));
		result = iMessage.getData(new Object[1][]);
		System.err.println("\t\t\tgot as result:" + result + " expected: Integer(501)");
		tmp_passed = result.equals(new Integer(501));
		System.err.println("\t\t\tpassed? " + tmp_passed);
		passed = passed && tmp_passed;

		System.err.println("\t\tpassed? " + passed);

		return passed;
	}

	static public boolean test(Vector notpassed, String protocolDescription) throws Exception {
		System.err.println("\ttesting protocol:" + protocolDescription);

		IBridge iBrige = new TestBridge();

		Class protocol_class = Class.forName("com.sun.star.lib.uno.protocols." + protocolDescription + "." + protocolDescription);
		Constructor protocol_constructor = protocol_class.getConstructor(new Class[] {IBridge.class});

//  		XInstanceProvider xInstanceProvider = new InstanceProvider();
  		IProtocol iSender = (IProtocol)protocol_constructor.newInstance(new Object[]{iBrige});
  		IProtocol iReciever = (IProtocol)protocol_constructor.newInstance(new Object[]{iBrige});




		TestObject testObject = new TestObject();
		String oId = (String)iBrige.mapInterfaceTo(testObject, new Type(XInterface.class));


		boolean passed = true;

		passed = passed && testCall(iSender, iReciever, oId);
		passed = passed && testCallWithInParameter(iSender, iReciever, oId);
		passed = passed && testCallWithOutParameter(iSender, iReciever, oId);
		passed = passed && testCallWithInOutParameter(iSender, iReciever, oId);
  		passed = passed && testCallWithResult(iSender, iReciever, oId);
  		passed = passed && testCallWhichRaisesException(iSender, iReciever, oId);
  		passed = passed && testCallWithIn_Out_InOut_Paramters_and_result(iSender, iReciever, oId);
  		passed = passed && testCallWhichReturnsAny(iSender, iReciever, oId);

		System.err.println("\tProtocol_Test " + protocolDescription + " passed? " + passed);
		if(!passed && notpassed != null)
			notpassed.addElement("\tProtocol_Test " + protocolDescription + " passed? " + passed);

		return passed;
	}

	static public void main(String args[]) throws Exception {
		test(null, args[0]);
	}
}
