/*************************************************************************
 *
 *  $RCSfile: WeakTable_Test.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.lib.util;

import java.util.Vector;


public class WeakTable_Test {
	public interface Test_Interface {
		int getValue();
	}

	static class Test_Class implements Test_Interface {
		static int __released;
		
		int _value;
		
		Test_Class(int value) {
			_value = value;
		}
		
		public int getValue() {
			return _value;
		}
		
		public void finalize() {
			++ __released;
		}
	}

	/*
	** Test the weaktable 
	*/
	public static boolean test(Vector notpassed) throws Exception {
		System.err.println("WeakTable - doing tests...");

		boolean passed = true;

		WeakTable weakTable = new WeakTable();
		
		Test_Interface test1 = (Test_Interface)weakTable.put("test", new Test_Class(11), Test_Interface.class);
		Test_Interface test2 = (Test_Interface)weakTable.put("test", new Test_Class(12), Test_Interface.class);
		
		System.err.println("\tWeakTable - test:" + test1 + " " + test2);
		test1 = null;
		test2 = null;
		
		System.err.println("\twaiting for gc to remove objects...");
		while(weakTable.size() > 0) {
			System.gc();
			System.runFinalization();

			new Object();
		}
		
		weakTable.reset();

		System.err.println("WeakTable - tests passed?" + passed);

		if(!passed && notpassed != null)
			notpassed.addElement("WeakTable - tests passed?" + passed);

		return passed;
	}

	static public void main(String args[]) throws Exception {
		test(null);
	}
}
