/*************************************************************************
 *
 *  $RCSfile: ldapber.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STDLIB_H
#include <stdlib.h>
#endif

#ifndef _STRING_H
#include <string.h>
#endif

#ifndef _LDAPBER_LDAPASN_H
#include <ldapber/ldapasn.h>
#endif
#ifndef _LDAPBER_LDAPBER_H
#include <ldapber/ldapber.h>
#endif

/*========================================================================
 *
 * LDAP_ATTRIBUTE_VALUE_PAIR Implementation.
 *
 *======================================================================*/
/*
 * LDAP_ATTRIBUTE_VALUE_PAIR_new.
 */
LDAP_ATTRIBUTE_VALUE_PAIR* LDAP_ATTRIBUTE_VALUE_PAIR_new (void)
{
	LDAP_ATTRIBUTE_VALUE_PAIR *ret = NULL;
	return(ret);
}

/*
 * LDAP_ATTRIBUTE_VALUE_PAIR_free.
 */
void LDAP_ATTRIBUTE_VALUE_PAIR_free (LDAP_ATTRIBUTE_VALUE_PAIR *a)
{
	if (a == NULL) return;
	LDAP_ATTRIBUTE_TYPE_free  (a->attributeType);
	LDAP_ATTRIBUTE_VALUE_free (a->attributeValue);
	free (a);
}

/*
 * i2d_LDAP_ATTRIBUTE_VALUE_PAIR.
 */
int i2d_LDAP_ATTRIBUTE_VALUE_PAIR (LDAP_ATTRIBUTE_VALUE_PAIR *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_ATTRIBUTE_VALUE_PAIR.
 */
LDAP_ATTRIBUTE_VALUE_PAIR* d2i_LDAP_ATTRIBUTE_VALUE_PAIR (
	LDAP_ATTRIBUTE_VALUE_PAIR **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_ATTRIBUTES Implementation.
 *
 *======================================================================*/
/*
 * LDAP_ATTRIBUTES_new.
 */
LDAP_ATTRIBUTES* LDAP_ATTRIBUTES_new (void)
{
	LDAP_ATTRIBUTES *ret = NULL;
	return(ret);
}

/*
 * LDAP_ATTRIBUTES_free.
 */
void LDAP_ATTRIBUTES_free (LDAP_ATTRIBUTES *a)
{
	if (a == NULL) return;
	LDAP_ATTRIBUTE_TYPE_free (a->type);
	ASN1_COLLECTION_free (a->values, ASN1_BIT_STRING_free);
	free (a);
}

/*
 * i2d_LDAP_ATTRIBUTES.
 */
int i2d_LDAP_ATTRIBUTES (LDAP_ATTRIBUTES *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_ATTRIBUTES.
 */
LDAP_ATTRIBUTES* d2i_LDAP_ATTRIBUTES (
	LDAP_ATTRIBUTES **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_ENTRY Implementation.
 *
 *======================================================================*/
/*
 * LDAP_ENTRY_new.
 */
LDAP_ENTRY* LDAP_ENTRY_new (void)
{
	LDAP_ENTRY *ret = NULL;
	return(ret);
}

/*
 * LDAP_ENTRY_free.
 */
void LDAP_ENTRY_free (LDAP_ENTRY *a)
{
	if (a == NULL) return;
	LDAP_DN_free (a->objectName);
	ASN1_COLLECTION_free (a->attributes, LDAP_ATTRIBUTES_free);
	free (a);
}

/*
 * i2d_LDAP_ENTRY.
 */
int i2d_LDAP_ENTRY (LDAP_ENTRY *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_ENTRY.
 */
LDAP_ENTRY* d2i_LDAP_ENTRY (LDAP_ENTRY **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_SUBSTRING Implementation.
 *
 *======================================================================*/
/*
 * LDAP_SUBSTRING_new.
 */
LDAP_SUBSTRING* LDAP_SUBSTRING_new (void)
{
	LDAP_SUBSTRING *ret = NULL;
	return (ret);
}

/*
 * LDAP_SUBSTRING_type_new.
 */
LDAP_SUBSTRING* LDAP_SUBSTRING_type_new (int substringType)
{
	LDAP_SUBSTRING *ret = NULL;
	return(ret);
}

/*
 * LDAP_SUBSTRING_free.
 */
void LDAP_SUBSTRING_free (LDAP_SUBSTRING *a)
{
	if (a == NULL) return;
	switch (a->substringType)
	{
		case LDAP_SUBSTRING_TYPE_INITIAL:
		case LDAP_SUBSTRING_TYPE_ANY:
		case LDAP_SUBSTRING_TYPE_FINAL:
			LDAP_STRING_free ((LDAP_STRING *)(a->substring.ptr));
			break;

		default: /* memory leak */
			break;
	}
	free (a);
}

/*
 * i2d_LDAP_SUBSTRING.
 */
int i2d_LDAP_SUBSTRING (LDAP_SUBSTRING *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_SUBSTRING.
 */
LDAP_SUBSTRING* d2i_LDAP_SUBSTRING (
	LDAP_SUBSTRING **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_SUBSTRING_FILTER Implementation.
 *
 *======================================================================*/
/*
 * LDAP_SUBSTRING_FILTER_new.
 */
LDAP_SUBSTRING_FILTER* LDAP_SUBSTRING_FILTER_new (void)
{
	LDAP_SUBSTRING_FILTER *ret = NULL;
	return(ret);
}

/*
 * LDAP_SUBSTRING_FILTER_free.
 */
void LDAP_SUBSTRING_FILTER_free (LDAP_SUBSTRING_FILTER *a)
{
	if (a == NULL) return;
	LDAP_ATTRIBUTE_TYPE_free (a->type);
	ASN1_COLLECTION_free (a->substrings, LDAP_SUBSTRING_free);
	free (a);
}

/*
 * i2d_LDAP_SUBSTRING_FILTER.
 */
int i2d_LDAP_SUBSTRING_FILTER (LDAP_SUBSTRING_FILTER *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_SUBSTRING_FILTER.
 */
LDAP_SUBSTRING_FILTER* d2i_LDAP_SUBSTRING_FILTER (
	LDAP_SUBSTRING_FILTER **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_FILTER Implementation.
 *
 *======================================================================*/
/*
 * LDAP_FILTER_new.
 */
LDAP_FILTER* LDAP_FILTER_new (void)
{
	LDAP_FILTER *ret = NULL;
	return (ret);
}

/*
 * LDAP_FILTER_type_new.
 */
LDAP_FILTER* LDAP_FILTER_type_new (int filterType)
{
	LDAP_FILTER *ret = NULL;
	return(ret);
}

/*
 * LDAP_FILTER_free.
 */
void LDAP_FILTER_free (LDAP_FILTER *a)
{
	if (a == NULL) return;
	switch (a->m_filterType)
	{
		case LDAP_FILTER_TYPE_AND:
		case LDAP_FILTER_TYPE_OR:
			ASN1_COLLECTION_free (
				(ASN1_COLLECTION*)(a->m_filter.m_ptr), LDAP_FILTER_free);
			break;

		case LDAP_FILTER_TYPE_NOT:
			LDAP_FILTER_free (a->m_filter.m_not);
			break;

		case LDAP_FILTER_TYPE_EQUALITY_MATCH:
		case LDAP_FILTER_TYPE_GREATER_OR_EQUAL:
		case LDAP_FILTER_TYPE_LESS_OR_EQUAL:
		case LDAP_FILTER_TYPE_APPROX_MATCH:
			LDAP_ATTRIBUTE_VALUE_PAIR_free (
				(LDAP_ATTRIBUTE_VALUE_PAIR*)(a->m_filter.m_ptr));
			break;

		case LDAP_FILTER_TYPE_PRESENT:
			LDAP_ATTRIBUTE_TYPE_free (a->m_filter.m_present);
			break;

		case LDAP_FILTER_TYPE_SUBSTRINGS:
			LDAP_SUBSTRING_FILTER_free (a->m_filter.m_substrings);
			break;

		default: /* memory leak */
			break;
	}
	free (a);
}

/*
 * i2d_LDAP_FILTER.
 */
int i2d_LDAP_FILTER (LDAP_FILTER *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_FILTER.
 */
LDAP_FILTER* d2i_LDAP_FILTER (LDAP_FILTER **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_MODIFICATION Implementation.
 *
 *======================================================================*/
/*
 * LDAP_MODIFICATION_new.
 */
LDAP_MODIFICATION* LDAP_MODIFICATION_new (void)
{
	LDAP_MODIFICATION *ret = NULL;
	return(ret);
}

/*
 * LDAP_MODIFICATION_free.
 */
void LDAP_MODIFICATION_free (LDAP_MODIFICATION *a)
{
	if (a == NULL) return;
	ASN1_ENUMERATED_free (a->operation);
	LDAP_ATTRIBUTES_free (a->modification);
	free (a);
}

/*
 * i2d_LDAP_MODIFICATION.
 */
int i2d_LDAP_MODIFICATION (LDAP_MODIFICATION *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_MODIFICATION.
 */
LDAP_MODIFICATION* d2i_LDAP_MODIFICATION (
	LDAP_MODIFICATION **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_RESULT Implementation.
 *
 *======================================================================*/
/*
 * LDAP_RESULT_new.
 */
LDAP_RESULT* LDAP_RESULT_new (void)
{
	LDAP_RESULT *ret = NULL;
	return(ret);
}

/*
 * LDAP_RESULT_free.
 */
void LDAP_RESULT_free (LDAP_RESULT *a)
{
	if (a == NULL) return;
	ASN1_ENUMERATED_free (a->resultCode);
	LDAP_DN_free (a->matchedDN);
	LDAP_STRING_free (a->errorMessage);
	free (a);
}

/*
 * i2d_LDAP_RESULT.
 */
int i2d_LDAP_RESULT (LDAP_RESULT *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_RESULT.
 */
LDAP_RESULT* d2i_LDAP_RESULT (LDAP_RESULT **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_BIND_REQUEST Implementation.
 *
 *======================================================================*/
/*
 * LDAP_BIND_REQUEST_new.
 */
LDAP_BIND_REQUEST *LDAP_BIND_REQUEST_new (void)
{
	LDAP_BIND_REQUEST *ret = NULL;
	return(ret);
}

/*
 * LDAP_BIND_REQUEST_free.
 */
void LDAP_BIND_REQUEST_free (LDAP_BIND_REQUEST *a)
{
	if (a == NULL) return;
	ASN1_INTEGER_free (a->version);
	LDAP_DN_free (a->name);
	switch (a->authType)
	{
		case 0:
			ASN1_OCTET_STRING_free (a->authentication.simple);
			break;

		case 1:
			ASN1_OCTET_STRING_free (a->authentication.krbv42LDAP);
			break;

		case 2:
			ASN1_OCTET_STRING_free (a->authentication.krbv42DSA);
			break;

		default: /* memory leak */
			break;
	}
	free (a);
}

/*
 * i2d_LDAP_BIND_REQUEST.
 */
int i2d_LDAP_BIND_REQUEST (LDAP_BIND_REQUEST *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_BIND_REQUEST.
 */
LDAP_BIND_REQUEST* d2i_LDAP_BIND_REQUEST (
	LDAP_BIND_REQUEST **a, BYTE **pp, long length)
{
	return(0);
}

/*========================================================================
 *
 * LDAP_SEARCH_REQUEST Implementation.
 *
 *======================================================================*/
/*
 * LDAP_SEARCH_REQUEST_new.
 */
LDAP_SEARCH_REQUEST* LDAP_SEARCH_REQUEST_new (void)
{
	LDAP_SEARCH_REQUEST *ret = NULL;
	return(ret);
}

/*
 * LDAP_SEARCH_REQUEST_free.
 */
void LDAP_SEARCH_REQUEST_free (LDAP_SEARCH_REQUEST *a)
{
	if (a == NULL) return;
	LDAP_DN_free (a->baseObject);
	ASN1_ENUMERATED_free (a->scope);
	ASN1_ENUMERATED_free (a->derefAlias);
	ASN1_INTEGER_free (a->sizeLimit);
	ASN1_INTEGER_free (a->timeLimit);
	ASN1_BOOLEAN_free (a->attrsOnly);
	LDAP_FILTER_free (a->filter);
	ASN1_COLLECTION_free (a->attributes, ASN1_BIT_STRING_free);
	free (a);
}

/*
 * i2d_LDAP_SEARCH_REQUEST.
 */
int i2d_LDAP_SEARCH_REQUEST (LDAP_SEARCH_REQUEST *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_SEARCH_REQUEST.
 */
LDAP_SEARCH_REQUEST* d2i_LDAP_SEARCH_REQUEST (
	LDAP_SEARCH_REQUEST **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_MODIFY_REQUEST Implementation.
 *
 *======================================================================*/
/*
 * LDAP_MODIFY_REQUEST_new.
 */
LDAP_MODIFY_REQUEST *LDAP_MODIFY_REQUEST_new (void)
{
	LDAP_MODIFY_REQUEST *ret = NULL;
	return(ret);
}

/*
 * LDAP_MODIFY_REQUEST_free.
 */
void LDAP_MODIFY_REQUEST_free (LDAP_MODIFY_REQUEST *a)
{
	if (a == NULL) return;
	LDAP_DN_free (a->object);
	ASN1_COLLECTION_free (a->modifications, LDAP_MODIFICATION_free);
	free (a);
}

/*
 * i2d_LDAP_MODIFY_REQUEST.
 */
int i2d_LDAP_MODIFY_REQUEST (LDAP_MODIFY_REQUEST *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_MODIFY_REQUEST.
 */
LDAP_MODIFY_REQUEST* d2i_LDAP_MODIFY_REQUEST (
	LDAP_MODIFY_REQUEST **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_MODIFYRDN_REQUEST Implementation.
 *
 *======================================================================*/
/*
 * LDAP_MODIFYRDN_REQUEST_new.
 */
LDAP_MODIFYRDN_REQUEST* LDAP_MODIFYRDN_REQUEST_new (void)
{
	LDAP_MODIFYRDN_REQUEST *ret = NULL;
	return(ret);
}

/*
 * LDAP_MODIFYRDN_REQUEST_free.
 */
void LDAP_MODIFYRDN_REQUEST_free (LDAP_MODIFYRDN_REQUEST *a)
{
	if (a == NULL) return;
	LDAP_DN_free (a->entry);
	LDAP_DN_free (a->newrdn);
	ASN1_BOOLEAN_free (a->deleteoldrdn);
	free (a);
}

/*
 * i2d_LDAP_MODIFYRDN_REQUEST.
 */
int i2d_LDAP_MODIFYRDN_REQUEST (LDAP_MODIFYRDN_REQUEST *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_MODIFYRDN_REQUEST.
 */
LDAP_MODIFYRDN_REQUEST* d2i_LDAP_MODIFYRDN_REQUEST (
	LDAP_MODIFYRDN_REQUEST **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_COMPARE_REQUEST Implementation.
 *
 *======================================================================*/
/*
 * LDAP_COMPARE_REQUEST_new.
 */
LDAP_COMPARE_REQUEST* LDAP_COMPARE_REQUEST_new (void)
{
	LDAP_COMPARE_REQUEST *ret = NULL;
	return(ret);
}

/*
 * LDAP_COMPARE_REQUEST_free.
 */
void LDAP_COMPARE_REQUEST_free (LDAP_COMPARE_REQUEST *a)
{
	if (a == NULL) return;
	LDAP_DN_free (a->entry);
	LDAP_ATTRIBUTE_VALUE_PAIR_free (a->ava);
	free (a);
}

/*
 * i2d_LDAP_COMPARE_REQUEST.
 */
int i2d_LDAP_COMPARE_REQUEST (LDAP_COMPARE_REQUEST *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_COMPARE_REQUEST.
 */
LDAP_COMPARE_REQUEST* d2i_LDAP_COMPARE_REQUEST (
	LDAP_COMPARE_REQUEST **a, BYTE **pp, long length)
{
	return(NULL);
}

/*========================================================================
 *
 * LDAP_MESSAGE Implementation.
 *
 *======================================================================*/
/*
 * LDAP_MESSAGE_new.
 */
LDAP_MESSAGE* LDAP_MESSAGE_new (void)
{
	LDAP_MESSAGE *ret = NULL;
	return(ret);
}

LDAP_MESSAGE* LDAP_MESSAGE_type_new (int messageType)
{
	LDAP_MESSAGE *ret = NULL;
	return(ret);
}

/*
 * LDAP_MESSAGE_free.
 */
void LDAP_MESSAGE_free (LDAP_MESSAGE *a)
{
	if (a == NULL) return;
	ASN1_INTEGER_free (a->messageID);
	switch (a->messageType)
	{
		case LDAP_MESSAGE_TYPE_BIND_REQUEST:
			LDAP_BIND_REQUEST_free (a->protocolOp.bindRequest);
			break;

		case LDAP_MESSAGE_TYPE_BIND_RESPONSE:
			LDAP_BIND_RESPONSE_free (a->protocolOp.bindResponse);
			break;

		case LDAP_MESSAGE_TYPE_UNBIND_REQUEST:
			LDAP_UNBIND_REQUEST_free (a->protocolOp.unbindRequest);
			break;

		case LDAP_MESSAGE_TYPE_SEARCH_REQUEST:
			LDAP_SEARCH_REQUEST_free (a->protocolOp.searchRequest);
			break;

		case LDAP_MESSAGE_TYPE_SEARCH_ENTRY:
			LDAP_SEARCH_ENTRY_free (a->protocolOp.searchEntry);
			break;

		case LDAP_MESSAGE_TYPE_SEARCH_RESULT:
			LDAP_SEARCH_RESULT_free (a->protocolOp.searchResult);
			break;

		case LDAP_MESSAGE_TYPE_MODIFY_REQUEST:
			LDAP_MODIFY_REQUEST_free (a->protocolOp.modifyRequest);
			break;

		case LDAP_MESSAGE_TYPE_MODIFY_RESPONSE:
			LDAP_MODIFY_RESPONSE_free (a->protocolOp.modifyResponse);
			break;

		case LDAP_MESSAGE_TYPE_ADD_REQUEST:
			LDAP_ADD_REQUEST_free (a->protocolOp.addRequest);
			break;

		case LDAP_MESSAGE_TYPE_ADD_RESPONSE:
			LDAP_ADD_RESPONSE_free (a->protocolOp.addResponse);
			break;

		case LDAP_MESSAGE_TYPE_DELETE_REQUEST:
			LDAP_DELETE_REQUEST_free (a->protocolOp.deleteRequest);
			break;

		case LDAP_MESSAGE_TYPE_DELETE_RESPONSE:
			LDAP_DELETE_RESPONSE_free (a->protocolOp.deleteResponse);
			break;

		case LDAP_MESSAGE_TYPE_MODIFYRDN_REQUEST:
			LDAP_MODIFYRDN_REQUEST_free (a->protocolOp.modifyRDNRequest);
			break;

		case LDAP_MESSAGE_TYPE_MODIFYRDN_RESPONSE:
			LDAP_MODIFYRDN_RESPONSE_free (a->protocolOp.modifyRDNResponse);
			break;

		case LDAP_MESSAGE_TYPE_COMPARE_REQUEST:
			LDAP_COMPARE_REQUEST_free (a->protocolOp.compareRequest);
			break;

		case LDAP_MESSAGE_TYPE_COMPARE_RESPONSE:
			LDAP_COMPARE_RESPONSE_free (a->protocolOp.compareResponse);
			break;

		case LDAP_MESSAGE_TYPE_ABANDON_REQUEST:
			LDAP_ABANDON_REQUEST_free (a->protocolOp.abandonRequest);
			break;

		default: /* memory leak */
			break;
	}
	free (a);
}

/*
 * i2d_LDAP_MESSAGE.
 */
int i2d_LDAP_MESSAGE (LDAP_MESSAGE *a, BYTE **pp)
{
	return(0);
}

/*
 * d2i_LDAP_MESSAGE.
 */
LDAP_MESSAGE* d2i_LDAP_MESSAGE (LDAP_MESSAGE **a, BYTE **pp, long length)
{
	return(NULL);
}

