/*************************************************************************
 *
 *  $RCSfile: DemoComponent.java,v $
 *
 *  $Revision: 1.3.16.2 $
 *
 *  last change: $Author: jsc $ $Date: 2003/02/17 10:18:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.demo;


import java.util.Enumeration;


import com.sun.star.comp.loader.FactoryHelper;

import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;

import com.sun.star.registry.XRegistryKey;

import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lib.uno.helper.WeakBase;

import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;

import com.sun.star.uno.XNamingService;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowAttribute;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.WindowEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XTopWindowListener;
import com.sun.star.awt.XWindowListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.EventObject;


/**
 * This is a demo component, which exports two services.
 * <p>
 * @version 	$Revision: 1.3.16.2 $ $ $Date: 2003/02/17 10:18:50 $
 * @author 	    Kay Ramme
 * @since       UDK2.0
 */
public class DemoComponent {
	static private final boolean DEBUG = true;


	static public class _Implementation extends WeakBase implements  XServiceInfo, 
           XInitialization, 
           XWindowListener, 
           XActionListener,
           XTopWindowListener
	{
		static private final String __serviceName = "com.sun.star.demo.DemoComponent";

		private XMultiServiceFactory _xMultiServiceFactory;
		private XComponent  _window_xComponent;

		public _Implementation(XMultiServiceFactory xMultiServiceFactory) {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".<init>:" + xMultiServiceFactory);
		
			_xMultiServiceFactory = xMultiServiceFactory;


			try {

			Object toolkit = xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
			XToolkit toolkit_xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, toolkit);

			WindowDescriptor windowDescriptor = new WindowDescriptor();
			windowDescriptor.Type = WindowClass.TOP;
			windowDescriptor.WindowServiceName = "Window";
			windowDescriptor.Bounds = new Rectangle(10, 10, 80, 80);
			windowDescriptor.WindowAttributes = WindowAttribute.SHOW  
                                              | WindowAttribute.BORDER
				                              | WindowAttribute.MOVEABLE
				                              | WindowAttribute.CLOSEABLE;
				
			XWindowPeer window_xWindowPeer = toolkit_xToolkit.createWindow(windowDescriptor);
			_window_xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, window_xWindowPeer);
			_window_xComponent.addEventListener(this);

			XWindow  window_xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, window_xWindowPeer);
			window_xWindow.addWindowListener(this);

			XTopWindow window_xTopWindow = (XTopWindow)UnoRuntime.queryInterface(
                XTopWindow.class, window_xWindow);
			window_xTopWindow.addTopWindowListener(this);

			windowDescriptor = new WindowDescriptor();
			windowDescriptor.Type = WindowClass.SIMPLE;
			windowDescriptor.WindowServiceName = "pushButton";
			windowDescriptor.Parent = window_xWindowPeer;
			windowDescriptor.Bounds = new Rectangle(5, 5, 70, 20);
			windowDescriptor.WindowAttributes = WindowAttribute.SHOW;

			XWindowPeer button1_xWindowPeer = toolkit_xToolkit.createWindow(windowDescriptor);
			XButton button1_xButton = (XButton)UnoRuntime.queryInterface(XButton.class, button1_xWindowPeer);
			button1_xButton.addActionListener(this);
			button1_xButton.setLabel("calc demo");
			button1_xButton.setActionCommand("com.sun.star.demo.SCalcDemo");


			windowDescriptor.Bounds = new Rectangle(5, 30, 70, 20);
			XWindowPeer button2_xWindowPeer = toolkit_xToolkit.createWindow(windowDescriptor);
			XButton button2_xButton = (XButton)UnoRuntime.queryInterface(XButton.class, button2_xWindowPeer);
			button2_xButton.addActionListener(this);
			button2_xButton.setLabel("writer demo");
			button2_xButton.setActionCommand("com.sun.star.demo.SWriterDemo");


			windowDescriptor.Bounds = new Rectangle(5, 55, 70, 20);
			XWindowPeer button3_xWindowPeer = toolkit_xToolkit.createWindow(windowDescriptor);
			XButton button3_xButton = (XButton)UnoRuntime.queryInterface(XButton.class, button3_xWindowPeer);
			button3_xButton.addActionListener(this);
			button3_xButton.setLabel("draw demo");
			button3_xButton.setActionCommand("com.sun.star.demo.SDrawDemo");

			System.err.println("------asdfasfa:" + button1_xButton);

			}
			catch(com.sun.star.uno.Exception exception) {
				System.err.println("--------------------------- _Implementation - exception:" + exception);
			}

		}

		// XInitialization
		public void initialize(Object[] aArguments) throws com.sun.star.uno.Exception {
			if(DEBUG) {
				System.err.println("##### " + getClass().getName() + ".initialize;");

				for(int i = 0; i < aArguments.length; ++ i)
					System.err.println("##### " + aArguments[i]);
			}
		}

		// XServiceInfo
		public String getImplementationName() {
			return getClass().getName();
		}

		public boolean supportsService(String serviceName) {
			return __serviceName.equals(serviceName);
		}

		public String[] getSupportedServiceNames() {
			return new String[] {__serviceName};
		}


		// XEventListener
		public void disposing(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".disposing:" + eventObject);
                }

		// XActionListener
		public void actionPerformed(ActionEvent actionEvent) {
			System.err.println("##### " + getClass().getName() + ".actionPerformed:" + actionEvent.ActionCommand);

			try {
				_xMultiServiceFactory.createInstance(actionEvent.ActionCommand);
			}
			catch(Exception exception) {
				System.err.println(getClass().getName() + ".actionPerformed - exception:" + exception);
			}
		}

		// XWindowListener
		public void windowResized(WindowEvent windowEvent) {
			System.err.println("##### " + getClass().getName() + ".windowResized:" + windowEvent);
		}

		public void windowMoved(WindowEvent windowEvent) {
			System.err.println("##### " + getClass().getName() + ".windowMoved:" + windowEvent);
		}

		public void windowShown(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowShown:" + eventObject);
		}

		public void windowHidden(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowHidden:" + eventObject);
		}


		// XTopWindowListener
		public void windowOpened(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowOpened:" + eventObject);
		}

		public void windowClosing(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowClosing:" + eventObject);

 			_window_xComponent.dispose();
		}

		public void windowClosed(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowClosed:" + eventObject);
		}

		public void windowMinimized(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowMinimized:" + eventObject);
		}

		public void windowNormalized(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowNormalized:" + eventObject);
		}

		public void windowActivated(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowActivated:" + eventObject);
		}

		public void windowDeactivated(EventObject eventObject) {
			System.err.println("##### " + getClass().getName() + ".windowDeactivated:" + eventObject);
		}

	}

	/**
	 * Gives a factory for creating the service.
	 * This method is called by the <code>JavaLoader</code>
	 * <p>
	 * @return  returns a <code>XSingleServiceFactory</code> for creating the component
	 * @param   implName     the name of the implementation for which a service is desired
	 * @param   multiFactory the service manager to be uses if needed
	 * @param   regKey       the registryKey
	 * @see                  com.sun.star.comp.loader.JavaLoader
	 */
	public static XSingleServiceFactory __getServiceFactory(String implName, 
															XMultiServiceFactory multiFactory, 
															XRegistryKey regKey)
	{
		if(DEBUG) System.err.println("##### DemoComponent.__getServiceFactory:" + implName);

		XSingleServiceFactory xSingleServiceFactory = null;

  	    if (implName.equals(_Implementation.class.getName()))
	        xSingleServiceFactory = FactoryHelper.getServiceFactory(_Implementation.class,
																	_Implementation.__serviceName,
																	multiFactory, 
																	regKey);
	    
  	    else if (implName.equals(SCalcDemo.class.getName()))
	        xSingleServiceFactory = FactoryHelper.getServiceFactory(SCalcDemo.class,
																	SCalcDemo.__serviceName,
																	multiFactory, 
																	regKey);
  	    else if (implName.equals(SDrawDemo.class.getName()))
	        xSingleServiceFactory = FactoryHelper.getServiceFactory(SDrawDemo.class,
																	SDrawDemo.__serviceName,
																	multiFactory, 
																	regKey);
  	    else if (implName.equals(SWriterDemo.class.getName()))
	        xSingleServiceFactory = FactoryHelper.getServiceFactory(SWriterDemo.class,
																	SWriterDemo.__serviceName,
																	multiFactory, 
																	regKey);
	    
	    return xSingleServiceFactory;
	}
	
	/**
	 * Writes the service information into the given registry key.
	 * This method is called by the <code>JavaLoader</code>
	 * <p>
	 * @return  returns true if the operation succeeded
	 * @param   regKey       the registryKey
	 * @see                  com.sun.star.comp.loader.JavaLoader
	 */
	public static boolean __writeRegistryServiceInfo(XRegistryKey regKey) {
		if(DEBUG) System.err.println("##### DemoComponent.__writeRegistryServiceInfo:" + regKey);

		boolean result = true;

		result = result && FactoryHelper.writeRegistryServiceInfo(_Implementation.class.getName(), _Implementation.__serviceName, regKey);
		result = result && FactoryHelper.writeRegistryServiceInfo(SCalcDemo.class.getName(), SCalcDemo.__serviceName, regKey);
		result = result && FactoryHelper.writeRegistryServiceInfo(SDrawDemo.class.getName(), SDrawDemo.__serviceName, regKey);
		result = result && FactoryHelper.writeRegistryServiceInfo(SWriterDemo.class.getName(), SWriterDemo.__serviceName, regKey);

		return result;
    }

}

