
package org.netbeans.modules.openoffice;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.MapFormat;


/**
 *
 * @author  Michael Bohn, Bertram Nolte
 *
 */


public class OOIDLCompilerGroup extends ExternalCompilerGroup {
    /** Add the (one) compiler to the group.
     * @param c must be a make compiler
     * @throws IllegalArgumentException if not
     */
    public void add(Compiler c) throws IllegalArgumentException {
        if (! (c instanceof OOIDLCompiler))
            throw new IllegalArgumentException();
        super.add(c);
        OOIDLCompiler mc = (OOIDLCompiler) c;
    }
    
    /** Create the process to run make.
     * @param desc the command template
     * @param files must be one filename
     * @throws IOException if not, or any other problem
     * @return the process
     */
    protected Process createProcess(NbProcessDescriptor desc, String[] files)
    throws IOException {
//        TopManager.getDefault().notify(new NotifyDescriptor.Message(files[0]));
        
        // Declare a string array for the environment variables.
        String[] stringEnvironmentVariables = null;
        
        if ( System.getProperty( "os.name" ).indexOf( "Windows" ) != -1 ) {
            // Create environment variables for windows in a string array.
            stringEnvironmentVariables = new String[] { "LIB="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program;"
            + OOIDLGlobalSettings.getDefault().getSDKDirectory()
            + System.getProperty( "file.separator" ) + "windows"
            + System.getProperty( "file.separator" ) + "lib",
            "PATH="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program;"
            + OOIDLGlobalSettings.getDefault().getSDKDirectory()
            + System.getProperty( "file.separator" ) + "windows"
            + System.getProperty( "file.separator" ) + "bin",
            "TEMP="
            + System.getProperty( "env-temp" ),
            "TMP="
            + System.getProperty( "env-tmp" )
            };
        }
        else if ( ( System.getProperty( "os.name" ).indexOf( "Linux" ) != -1 )
        || ( System.getProperty( "os.name" ).indexOf( "SunOS" ) != -1 ) ) {
            // Create environment variables for Linux or Solaris in a string
            // array.
            stringEnvironmentVariables = new String []{ "LD_LIBRARY_PATH="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program" };
        }
        
        return desc.exec( new Format(files[0]),
        stringEnvironmentVariables );
    }
    
    /** Formats files and directory tags.
     */
    public static class Format extends MapFormat {
        /** Tag for the idl fiel basename.
         */
        
        public static final String TAG_IDL_FILE = "idlfile";
        /** Tag for the idl files containing directory.
         */
        public static final String TAG_OUTPUT_DIRECTORY = "outputdirectory";
        
        /** Tag for the path name which contains the udk idl files.
         */
        public static final String TAG_IDL_INCLUDE_DIRECTORY = 
        "idl_include_directory";
        /** Tag for the path name which contains the custom idl files.
         */
        public static final String TAG_ADDITIONALY_IDL_INCLUDE_DIRECTORY = 
        "custom_idl_include_directory";
        
        public static final String TAG_UDKINSTALL_DIRECTORY = 
        "udk_install_directory";
        
        /** Creates the format.
         * @param file the makefile
         * @param target the make target
         */
        public Format(String file) {
            super ( new HashMap( 5 ) );
//            TopManager.getDefault().notify( 
//            new NotifyDescriptor.Message( file ) );
            OOIDLGlobalSettings oGlobalSettings = 
            OOIDLGlobalSettings.getDefault();
            
            File f = new File( file );
            
//            TopManager.getDefault().notify( new NotifyDescriptor.Message(
//            OOTools.getFilesystemName( f ) ) );
            
            getMap().put( TAG_IDL_FILE, f.getName() );
            
            getMap().put( TAG_OUTPUT_DIRECTORY, f.getParent() );
            
            getMap().put( TAG_ADDITIONALY_IDL_INCLUDE_DIRECTORY,
            OOTools.getFilesystemName( f ) );
            
            getMap().put( TAG_IDL_INCLUDE_DIRECTORY, 
            oGlobalSettings.getSDKDirectory() 
            + System.getProperty( "file.separator" ) + "idl" );
            
            getMap().put( TAG_UDKINSTALL_DIRECTORY, 
            oGlobalSettings.getSDKDirectory() 
            + System.getProperty( "file.separator" ) 
            + OOTools.getODKSystemDirectory() );
        }
    }
}
