/*************************************************************************
 *
 *  $RCSfile: macro.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kr $ $Date: 2001/11/01 16:39:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "macro.hxx"

#include <osl/profile.hxx>
#include <rtl/ustrbuf.hxx>
#include <rtl/bootstrap.hxx>

#include <hash_set>


using namespace ::osl;
using namespace ::rtl;

struct ArgParserState
{
	OUStringBuffer _result; // accumulate the result here
	OUStringBuffer _term;   // the active chunk of the to parsing string
	OUString _first_part;   // first part of an ini-reference
	OUString _second_part;  // second part of an ini-reference

	sal_Bool _lookUp;       // determines if we have to lookup _term during expand
	rtlBootstrapHandle _handle;

	// expand _term and add it to _result
	void expandTerm(sal_Bool nextLookUp);
};


struct OUStringEqual
{
	sal_Bool operator () (const OUString & op1, const OUString & op2) const
    {
		return op1 == op2;
	}
};

typedef ::std::hash_set < OUString , OUStringHash , OUStringEqual > OUString_hash_set;

// global set to detect recursion during macro expansion
static OUString_hash_set __lookups;

void ArgParserState::expandTerm(sal_Bool nextLookUp) 
{
	if(_first_part.getLength()) // look up ini?
	{
		OUString file    = expandMacros(_handle, _first_part);	             // get file name
		OUString section = expandMacros(_handle, _second_part);               // get section name
		OUString key     = expandMacros(_handle, _term.makeStringAndClear()); // get key name
		
		// clear strings
		_first_part = _term.makeStringAndClear();
		_second_part = _first_part;

		OUString value;

		if(section.getLength()) { // do we have a section? -> expand from profile
			Profile profile(file);
			value = OStringToOUString(profile.readString(OUStringToOString(section, RTL_TEXTENCODING_ASCII_US),
														 OUStringToOString(key, RTL_TEXTENCODING_ASCII_US),
														 OString("")),
									  RTL_TEXTENCODING_ASCII_US);
		}
		else { // expand from ini
			Bootstrap bootstrap(file);
			
			bootstrap.getFrom(key, value);
		}

		_result.append(value);
	}
	else if(_lookUp) // variable look up?
	{
		OUString name = _term.makeStringAndClear();
		OUString value;

		OUString_hash_set::const_iterator it = __lookups.find(name);

		if(it != __lookups.end()) // found, so it must be a recursion
			value = OUString(RTL_CONSTASCII_USTRINGPARAM("***RECURSION DETECTED***"));

		else
		{
			__lookups.insert(name);
			rtl_bootstrap_get_from_handle(_handle, name.pData, &value.pData, NULL);
			__lookups.erase(name);
		}

		_result.append(value);
	}
	else // no look up at all
		_result.append(_term.makeStringAndClear());

	_lookUp = nextLookUp;
}

OUString SAL_CALL expandMacros(rtlBootstrapHandle handle, const OUString & argstr) 
{
	ArgParserState argParserState;

	sal_Int32 length = argstr.getLength();
	const sal_Unicode * ustr = argstr.getStr();

	argParserState._lookUp = sal_False;
	argParserState._handle = handle;
	sal_Bool quote = sal_False;

	sal_Int32 i = 0;
	sal_Int32 deepness;

	while(i < length) 
	{
		if(quote) // quote next char?
		{
			if(ustr[i] == 'u') // a unicode character?
			{
				sal_Unicode code = 0;

				for(sal_Int32 j = 3; j >= 0 && i < length; -- j)
				{
					++ i;

					if(ustr[i] >= 'a' && ustr[i] <= 'z')
						code += (ustr[i] - 'a' + 10) << (j * 4);

					else if(ustr[i] >= 'A' && ustr[i] <= 'Z')
						code += (ustr[i] - 'A' + 10) << (j * 4);

					else if(ustr[i] >= '0' && ustr[i] <= '9')
						code += (ustr[i] - '0') << (j * 4);
				}

				argParserState._term.append(&code, 1);
			}
			else
				argParserState._term.append(ustr + i, 1);

			quote = sal_False;
		}
		else 
		{
			switch(ustr[i])
			{
			case '$': // expand via look up
 				argParserState.expandTerm(sal_True);
				break;
					
			case '\\': // quote
				quote = sal_True;
				break;
				
			case '{': // brackets
				deepness = 1;
				++ i;
				while(i < length && deepness > 0)
				{
					if(ustr[i] == ':' && deepness == 1)
					{
						if(!argParserState._first_part.getLength())
							argParserState._first_part = argParserState._term.makeStringAndClear();

						else if(!argParserState._second_part.getLength())
							argParserState._second_part = argParserState._term.makeStringAndClear();
					}
					else if(ustr[i] == '}')
					{
						-- deepness;
						if(deepness)
							argParserState._term.append(ustr + i, 1);
					}
					else if(ustr[i] == '{')
					{
						++ deepness;
						argParserState._term.append(ustr + i, 1);
					}
					else
						argParserState._term.append(ustr + i, 1);

					if(deepness)
						++ i;
				}
				argParserState.expandTerm(sal_False);
				
				break;
				
			case '-': // delimeter
			case ';':
			case '/':
				argParserState.expandTerm(sal_False);
					
				argParserState._term.append(ustr + i, 1);
				break;

			default: // just add
				argParserState._term.append(ustr + i, 1);
			}
		}

		++ i;
	}

	argParserState.expandTerm(sal_False);

	return argParserState._result.makeStringAndClear();
}
