/*************************************************************************
 *
 *  $RCSfile: shidlist.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

HRESULT WINAPI SHGetFolderFromIDList( LPCITEMIDLIST pidl, LPSHELLFOLDER *ppFolder )
{
	IShellFolder	*pRootFolder = NULL;
	HRESULT			hResult;

	if ( SUCCEEDED(hResult = SHGetDesktopFolder( &pRootFolder )) )
	{
		if ( !ILIsRoot( pidl ) )
		{
			hResult = pRootFolder->BindToObject( pidl, NULL, IID_IShellFolder, (LPVOID *)ppFolder );
			pRootFolder->Release();
		}
	}

	return hResult;
}


HRESULT WINAPI SHGetSpecialFolder( int nFolder, LPSHELLFOLDER *ppFolder )
{
	LPITEMIDLIST	pidl = NULL;
	HRESULT			hResult;
	
	if ( CSIDL_DESKTOP == nFolder )
		hResult = SHGetDesktopFolder( ppFolder );
	else if ( SUCCEEDED(hResult = SHGetSpecialFolderLocation( (HWND)NULL, nFolder, &pidl )) )
	{
		hResult = SHGetFolderFromIDList( pidl, ppFolder );
		ILFree( pidl );
	}

	return hResult;
}

HRESULT WINAPI SHGetFolderFromPathA( LPCSTR lpszPath, LPSHELLFOLDER *ppFolder )
{
	LPITEMIDLIST	pidl = NULL;
	HRESULT			hResult = SHILCreateFromPathA( lpszPath, &pidl, NULL );

	if ( SUCCEEDED(hResult) )
	{
		hResult = SHGetFolderFromIDList( pidl, ppFolder );
		ILFree( pidl );
	}

	return hResult;
}

HRESULT WINAPI SHGetFolderFromPathW( LPCWSTR lpszPath, LPSHELLFOLDER *ppFolder )
{
	LPITEMIDLIST	pidl = NULL;
	HRESULT			hResult = SHILCreateFromPathW( lpszPath, &pidl, NULL );

	if ( SUCCEEDED(hResult) )
	{
		hResult = SHGetFolderFromIDList( pidl, ppFolder );
		ILFree( pidl );
	}

	return hResult;
}

HRESULT WINAPI SHILCreateFromPathW( LPCWSTR lpszPath, LPITEMIDLIST *ppidl, LPDWORD pdwAttributes )
{
	IShellFolder	*pFolder = NULL;
	HRESULT			hResult;
	
	if ( SUCCEEDED(hResult = SHGetDesktopFolder( &pFolder )) && pFolder )
	{
		ULONG	chEaten = 0;

		hResult = pFolder->ParseDisplayName( NULL, NULL, lpszPath, &chEaten, ppidl, pdwAttributes );
		pFolder->Release();
	}

	return hResult;
}


HRESULT WINAPI SHILCreateFromPathA( LPCSTR lpszPath, LPITEMIDLIST *ppidl, LPDWORD pdwAttributes )
{
	IShellFolder	*pFolder = NULL;
	HRESULT			hResult;
	
	if ( SUCCEEDED(hResult = SHGetDesktopFolder( &pFolder )) && pFolder )
	{
		ULONG	chEaten = 0;
		int		nPathSize = 0;
		LPWSTR	lpszPathW = lpszPath ? (LPWSTR)calloc( nPathSize = MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, NULL, 0 ), sizeof(WCHAR)) : NULL;

		if ( lpszPatzhW )
			MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, lpszPathW, nPathSize );

		hResult = pFolder->ParseDisplayName( NULL, NULL, lpszPathW, &chEaten, ppidl, pdwAttributes );

		if ( lpszPatzhW )
			free( lpszPathW );

		pFolder->Release();
	}

	return hResult;
}


LPITEMIDLIST WINAPI ILCreateFromPathA( LPCSTR lpszPath )
{
	LPITEMIDLIST	pidl = NULL;

	SHILCreateFromPathA( lpszPath, &pidl, NULL );

	return pidl;
}


LPITEMIDLIST WINAPI ILCreateFromPathW( LPCWSTR lpszPath )
{
	LPITEMIDLIST	pidl = NULL;

	SHILCreateFromPathW( lpszPath, &pidl, NULL );

	return pidl;
}


extern "C" LPITEMIDLIST WINAPI SHSimpleIDListFromPath( LPVOID lpPath );

LPITEMIDLIST WINAPI SHSimpleIDListFromPathA( LPCSTR lpszPath )
{
	LPITEMIDLIST	pidl;

	if ( IsWinNT() )
	{
		int		nPathSize;
		LPWSTR	lpszPathW = lpszPath ? (LPWSTR)calloc( nPathSize = MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, NULL, 0 ), sizeof(WCHAR)) : NULL;

		if ( lpszPatzhW )
			MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, lpszPathW, nPathSize );

		pidl = SHSimpleIDListFromPath( lpszPathW );

		if ( lpszPatzhW )
			free( lpszPathW );
	}
	else
		pidl = SHSimpleIDListFromPath( lpszPath );

	return pidl;
}


LPITEMIDLIST WINAPI SHSimpleIDListFromPathW( LPCWSTR lpszPath )
{
	LPITEMIDLIST	pidl;

	if ( IsWinNT() )
		pidl = SHSimpleIDListFromPath( lpszPath );
	else
	{
		int		nPathSize;
		LPSTR	lpszPathA = lpszPath ? (LPWSTR)calloc( nPathSize = WideCharToMultiByte( CP_ACP, 0, lpszPath, -1, NULL, 0, NULL, NULL ), sizeof(CHAR)) : NULL;

		if ( lpszPathA )
			WideCharToMultiByte( CP_ACP, 0, lpszPath, -1, lpszPathA, nPathSize, NULL, NULL );

		pidl = SHSimpleIDListFromPath( lpszPathA );

		if ( lpszPatzhA )
			free( lpszPathA );
	}

	return pidl;
}



