/************************************************************************* 
# 
#   $RCSfile: osl_apitest_mutex.cxx,v $ 
# 
#   $Revision: 1.3 $ 
# 
#   last change: $Author: ganaya $ $Date: 2001/05/25 21:39:10 $ 
# 
#   The Contents of this file are made available subject to the terms of 
#   either of the following licenses 
# 
#          - GNU Lesser General Public License Version 2.1 
#          - Sun Industry Standards Source License Version 1.1 
# 
#   Sun Microsystems Inc., October, 2000 
# 
#   GNU Lesser General Public License Version 2.1 
#   ============================================= 
#   Copyright 2000 by Sun Microsystems, Inc. 
#   901 San Antonio Road, Palo Alto, CA 94303, USA 
# 
#   This library is free software; you can redistribute it and/or 
#   modify it under the terms of the GNU Lesser General Public 
#   License version 2.1, as published by the Free Software Foundation. 
# 
#   This library is distributed in the hope that it will be useful, 
#   but WITHOUT ANY WARRANTY; without even the implied warranty of 
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#   Lesser General Public License for more details. 
# 
#   You should have received a copy of the GNU Lesser General Public 
#   License along with this library; if not, write to the Free Software 
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA 
# 
# 
#   Sun Industry Standards Source License Version 1.1 
#   ================================================= 
#   The contents of this file are subject to the Sun Industry Standards 
#   Source License Version 1.1 (the "License"); You may not use this file 
#   except in compliance with the License. You may obtain a copy of the 
#   License at http://www.openoffice.org/license.html. 
# 
#   Software provided under this License is provided on an "AS IS" basis, 
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, 
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS, 
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING. 
#   See the License for the specific provisions governing your rights and 
#   obligations concerning the Software. 
# 
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc. 
# 
#   Copyright: 2000 by Sun Microsystems, Inc. 
# 
#   All Rights Reserved. 
# 
#   Contributor(s): _______________________________________ 
# 
# 
# 
#*************************************************************************/

#ifndef _TESTS_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _OSL_MUTEX_H_
#include <osl/mutex.h>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <stdio.h>

using namespace rtl;


//oslMutex SAL_CALL osl_createMutex(void); 

extern "C" void SAL_CALL test_osl_mutex_osl_createMutex(TestResult *oRes)
{
    oslMutex mutex = NULL;

    oRes->state( (mutex = osl_createMutex()) != NULL );

    if (mutex) {
        osl_destroyMutex(mutex);
    }
}



//void SAL_CALL osl_destroyMutex(oslMutex Mutex); 

extern "C" void SAL_CALL test_osl_mutex_osl_destroyMutex(TestResult *oRes) 
{
    oslMutex mutex = NULL; 

    mutex = osl_createMutex(); 

    if (mutex) { 
        osl_destroyMutex(mutex); 
	oRes->state(1);
    }  else {
        oRes->state(0);
    }
}



//sal_Bool SAL_CALL osl_acquireMutex(oslMutex Mutex); 

extern "C" void SAL_CALL test_osl_mutex_osl_acquireMutex(TestResult *oRes)
{
    oslMutex mutex = NULL;

    mutex = osl_createMutex();

    if (mutex) {
        oRes->state(osl_acquireMutex(mutex) == sal_True);
    } else {
        oRes->state(0);
    }

    if (mutex) {
	osl_destroyMutex(mutex);
    }
}

//Need case where another thread already has acquired the Mutex.



//sal_Bool SAL_CALL osl_tryToAcquireMutex(oslMutex Mutex); 

extern "C" void SAL_CALL test_osl_mutex_osl_tryToAcquireMutex(TestResult *oRes) 
{
//Need case where Mutex cannot be acquired.
    oslMutex mutex = NULL; 

    mutex = osl_createMutex(); 

    if (mutex) {
        oRes->state(osl_tryToAcquireMutex(mutex) == sal_True); 
    } else { 
        oRes->state(0); 
    }

    if (mutex) {
	osl_destroyMutex(mutex);
    }
}




//sal_Bool SAL_CALL osl_releaseMutex(oslMutex Mutex); 

extern "C" void SAL_CALL test_osl_mutex_osl_releaseMutex(TestResult *oRes)
{
//Need case where Mutex cannot be released.
    oslMutex mutex = NULL;  

    mutex = osl_createMutex();  

    if (mutex) {  
        oRes->state(osl_releaseMutex(mutex) == sal_True);  
    } else {  
        oRes->state(0);  
    }  

    if (mutex) {  
    	osl_destroyMutex(mutex);
    }
}



//oslMutex * SAL_CALL osl_getGlobalMutex(); 

extern "C" void SAL_CALL test_osl_mutex_osl_getGlobalMutex(TestResult *oRes)
{
    oslMutex *mutex = NULL;

    mutex = osl_getGlobalMutex();
    oRes->state( mutex != NULL);
}

//Need test case where global Mutex cannot be gotten


using namespace osl;

//Mutex::Mutex()

extern "C" void SAL_CALL test_osl_mutex_Mutex_ctor(TestResult *oRes)
{
    Mutex *mutex = NULL;

    mutex = new Mutex();

    if (mutex) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (mutex) {
        delete mutex;
    }
}


//Mutex::~Mutex()

extern "C" void SAL_CALL test_osl_mutex_Mutex_dtor(TestResult *oRes) 
{
    Mutex *mutex = NULL;

    mutex = new Mutex();

    delete mutex;
    oRes->state( 1 );
}


//sal_Bool Mutex::acquire()

extern "C" void SAL_CALL test_osl_mutex_Mutex_acquire(TestResult *oRes)
{
//Need case wheret this fails
   Mutex *mutex = NULL;

   mutex = new Mutex();

   if (mutex) {
       oRes->state(mutex->acquire() == sal_True);
   } else {
       oRes->state(0);
   }
   if (mutex) {
       delete mutex;
   }
}


//sal_Bool Mutex::tryToAcquire()

extern "C" void SAL_CALL test_osl_mutex_Mutex_tryToAcquire(TestResult *oRes)
{
//Need case where this fails
   Mutex *mutex = NULL;

   mutex = new Mutex();

   if (mutex) {
       oRes->state(mutex->tryToAcquire() == sal_True);
   } else {
       oRes->state(0);
   }

   if (mutex) {
       delete mutex;
   }
}


//sal_Bool Mutex::releaseMutex(mutex)

extern "C" void SAL_CALL test_osl_mutex_Mutex_release(TestResult *oRes) 
{ 
//Need case where this fails
    Mutex *mutex = NULL;   

    mutex = new Mutex();   

    if (mutex) {   
        oRes->state(mutex->release() == sal_True);   
    } else {   
        oRes->state(0);   
    }
   
    if (mutex) {   
	delete mutex;
    }
} 


//static Mutex *getGlobalMutex()

extern "C" void SAL_CALL test_osl_mutex_Mutex_getGlobalMutex(TestResult *oRes)
{
//Need case where this fails
    Mutex *mutex = NULL;

    mutex = Mutex::getGlobalMutex();
    oRes->state( mutex != NULL);
}



//Not sure what to do with template classes:
//Guard and ClearableGuard
