/************************************************************************* 
# 
#   $RCSfile: osl_apitest_pipe.cxx,v $ 
# 
#   $Revision: 1.2 $ 
# 
#   last change: $Author: ganaya $ $Date: 2001/06/26 21:11:42 $ 
# 
#   The Contents of this file are made available subject to the terms of 
#   either of the following licenses 
# 
#          - GNU Lesser General Public License Version 2.1 
#          - Sun Industry Standards Source License Version 1.1 
# 
#   Sun Microsystems Inc., October, 2000 
# 
#   GNU Lesser General Public License Version 2.1 
#   ============================================= 
#   Copyright 2000 by Sun Microsystems, Inc. 
#   901 San Antonio Road, Palo Alto, CA 94303, USA 
# 
#   This library is free software; you can redistribute it and/or 
#   modify it under the terms of the GNU Lesser General Public 
#   License version 2.1, as published by the Free Software Foundation. 
# 
#   This library is distributed in the hope that it will be useful, 
#   but WITHOUT ANY WARRANTY; without even the implied warranty of 
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#   Lesser General Public License for more details. 
# 
#   You should have received a copy of the GNU Lesser General Public 
#   License along with this library; if not, write to the Free Software 
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA 
# 
# 
#   Sun Industry Standards Source License Version 1.1 
#   ================================================= 
#   The contents of this file are subject to the Sun Industry Standards 
#   Source License Version 1.1 (the "License"); You may not use this file 
#   except in compliance with the License. You may obtain a copy of the 
#   License at http://www.openoffice.org/license.html. 
# 
#   Software provided under this License is provided on an "AS IS" basis, 
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, 
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS, 
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING. 
#   See the License for the specific provisions governing your rights and 
#   obligations concerning the Software. 
# 
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc. 
# 
#   Copyright: 2000 by Sun Microsystems, Inc. 
# 
#   All Rights Reserved. 
# 
#   Contributor(s): _______________________________________ 
# 
# 
# 
#*************************************************************************/

#ifndef _TESTS_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _OSL_PIPE_H_
#include <osl/pipe.h>
#endif

#ifndef _OSL_PIPE_HXX_
#include <osl/pipe.hxx>
#endif

#include "sal/types.h"

#include <iostream.h>

using namespace rtl;



//oslPipe SAL_CALL osl_createPipe(rtl_uString *strPipeName,
//                           oslPipeOptions Options, oslSecurity Security); 

extern "C" void SAL_CALL test_osl_pipe_osl_createPipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe) {
        oRes->state((pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL)) != NULL);
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//void    SAL_CALL osl_releasePipe( oslPipe );

extern "C" void SAL_CALL test_osl_pipe_osl_releasePipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        (pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
	osl_releasePipe(pPipe);
	oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//void    SAL_CALL osl_acquirePipe( oslPipe Pipe ); 

extern "C" void SAL_CALL test_osl_pipe_osl_acquirePipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        (pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
        osl_acquirePipe(pPipe);
	oRes->state(1);
	osl_releasePipe(pPipe);
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//void    SAL_CALL osl_closePipe( oslPipe );

extern "C" void SAL_CALL test_osl_pipe_osl_closePipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        (pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
	osl_closePipe(pPipe);
	oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//oslPipe SAL_CALL osl_acceptPipe(oslPipe Pipe);

extern "C" void SAL_CALL test_osl_pipe_osl_acceptPipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        (pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
      //        oRes->state(osl_acceptPipe(pPipe) != NULL);
      //This call just hangs
        oRes->state(osl_acceptPipe(NULL) == NULL, "This test is partially valid");
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//sal_Int32 SAL_CALL osl_sendPipe(oslPipe Pipe, const void* pBuffer,
//                                             sal_Int32 BufferSize); 

extern "C" void SAL_CALL test_osl_pipe_osl_sendPipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;
    char pBuffer[24] = "Hi there";
    sal_Int32 pSent = 0;
    sal_Int32 pSentRC = 0;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
	(pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
        oRes->state(pSentRC = osl_sendPipe(pPipe, pBuffer, 4), "This test is partially valid");
	//This call return -1, not sure how to send to a pipe
	//	cerr << "SentRC: " << pSentRC << endl;
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//sal_Int32 SAL_CALL osl_receivePipe(oslPipe Pipe, void* pBuffer,
//                                          sal_Int32 BufferSize);
 
extern "C" void SAL_CALL test_osl_pipe_osl_receivePipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;
    char pBuffer[24] = "Hi there";
    char pReceiveBuffer[1024];
    sal_Int32 pSent = 0;
    sal_Int32 pSentRC = 0;
    sal_Int32 pRead = 0;
    sal_Int32 pReadRC = 0;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
	(pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
        pSentRC = osl_sendPipe(pPipe, pBuffer, 4);
	//This call returns -1, not sure how to send to a pipe
	//	cerr << "SentRC: " << pSentRC << endl;
        oRes->state(pReadRC = osl_receivePipe(pPipe, pReceiveBuffer, 2), "This test is partially valid");
	//This call returns -1, not sure how to receive from a pipe
	//	cerr << "ReceiveRC: " << pReadRC << endl;
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//sal_Int32 SAL_CALL osl_readPipe( oslPipe Pipe, void *pBuffer,
//                                        sal_Int32 BufferSize);
 
extern "C" void SAL_CALL test_osl_pipe_osl_readPipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;
    char pBuffer[24] = "Hi there";
    char pReceiveBuffer[1024];
    sal_Int32 pSent = 0;
    sal_Int32 pSentRC = 0;
    sal_Int32 pRead = 0;
    sal_Int32 pReadRC = 0;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
	(pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
        pSentRC = osl_writePipe(pPipe, pBuffer, 4);
	//This call returns 0, not sure how to write to a pipe
	//cerr << "SentRC: " << pSentRC << endl;
        oRes->state((pReadRC = osl_readPipe(pPipe, pReceiveBuffer, 2) == 0), "This test is partially valid");
	//This call returns 0, not sure how to read from a pipe
	//	cerr << "ReceiveRC: " << pReadRC << endl;
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//sal_Int32 SAL_CALL osl_writePipe( oslPipe Pipe, const void *pBuffer,
//                                               sal_Int32 BufferSize );
 
extern "C" void SAL_CALL test_osl_pipe_osl_writePipe(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;
    char pBuffer[24] = "Hi there";
    sal_Int32 pSent = 0;
    sal_Int32 pSentRC = 0;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
	(pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
        oRes->state((pSentRC = osl_writePipe(pPipe, pBuffer, 4) == 0), "This test is partially valid");
	//This call returns -1, not sure how to write to a pipe
	//	cerr << "SentRC: " << pSentRC << endl;
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}


//oslPipeError SAL_CALL osl_getLastPipeError(oslPipe Pipe);

extern "C" void SAL_CALL test_osl_pipe_osl_getLastPipeError(TestResult *oRes)
{
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        (pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL))) {
        oRes->state(osl_getLastPipeError(pPipe) == osl_Pipe_E_invalidError, "This test is partially valid");
	osl_releasePipe(pPipe);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
}

using namespace osl;

//class Pipe methods:

//ctor Pipe()

extern "C" void SAL_CALL test_osl_pipe_Pipe_ctor(TestResult *oRes)
{
    Pipe *pP  = NULL;
    
    if ((pP = new Pipe()) != NULL) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pP) {
        delete pP;
    }
}


//ctor Pipe(const ::rtl::OUString& strName, oslPipeOptions Options)

extern "C" void SAL_CALL test_osl_pipe_Pipe_ctor_02(TestResult *oRes)
{
    Pipe *pP  = NULL;
    rtl_uString *strName;
    ::rtl::OUString oustrName;
    
    rtl_uString_newFromAscii(&strName, "testPipe");

    if (strName && (oustrName.pData = strName) &&
	((pP = new Pipe(oustrName, osl_Pipe_CREATE)) != NULL)) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pP) {
        delete pP;
    }
}


//ctor Pipe(const ::rtl::OUString& strName, oslPipeOptions Options,const Security & rSecurity)

extern "C" void SAL_CALL test_osl_pipe_Pipe_ctor_03(TestResult *oRes)
{
    Pipe *pP  = NULL;
    rtl_uString *strName;
    //    ::rtl::OUString oustrName;
    //    Security secSec;
    
    rtl_uString_newFromAscii(&strName, "testPipe");

    //    if (strName && (oustrName.pData = strName) &&
    //	((pP = new Pipe(oustrName, osl_Pipe_CREATE, secSec)) != NULL)) {
    //        oRes->state(1);
    //    } else {
        oRes->state(0);
	//    }

   if (pP) {
       delete pP;
   }
}


//ctor Pipe(const Pipe& pipe)

extern "C" void SAL_CALL test_osl_pipe_Pipe_ctor_04(TestResult *oRes)
{
    Pipe *pP1  = NULL;
    Pipe *pP2  = NULL;
    rtl_uString *strName;
    //    ::rtl::OUString oustrName;
    //    Security secSec;
    
    rtl_uString_newFromAscii(&strName, "testPipe");

    //    if (strName && (oustrName.pData = strName) &&
    //	((pP1 = new Pipe(oustrName, osl_Pipe_CREATE, secSec)) != NULL) &&
    //	((pP2 = new Pipe(*pP1)) != NULL)) {
    //        oRes->state(1);
    //    } else {
        oRes->state(0);
	//    }

   if (pP1) {
       delete pP1;
   }
   if (pP2) {
       delete pP2;
   }
}


//ctor Pipe( oslPipe pipe, __sal_NoAcquire noacquire )

extern "C" void SAL_CALL test_osl_pipe_Pipe_ctor_05(TestResult *oRes)
{
    Pipe *pP  = NULL;
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        ((pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL)) != NULL) &&
	((pP = new Pipe(pPipe, SAL_NO_ACQUIRE)) != NULL)) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (strPipe) {
        rtl_uString_release(strPipe);
    }
    if (pPipe) {
        osl_releasePipe(pPipe);
    }
}


//ctor Pipe(oslPipe Pipe)

extern "C" void SAL_CALL test_osl_pipe_Pipe_ctor_06(TestResult *oRes)
{
    Pipe *pP  = NULL;
    rtl_uString *strPipe = NULL;
    oslPipe pPipe = NULL;

    rtl_uString_newFromAscii(&strPipe, "testPipe");

    if (strPipe &&
        (pPipe = osl_createPipe(strPipe, osl_Pipe_CREATE, NULL)) &&
	(pP = new Pipe(pPipe))) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

   if (strPipe) {
       rtl_uString_release(strPipe);
   }
   if (pPipe) {
       osl_releasePipe(pPipe);
   }
}


//dtor ~Pipe()

extern "C" void SAL_CALL test_osl_pipe_Pipe_dtor(TestResult *oRes)
{
    Pipe *pP  = NULL;

    if ((pP = new Pipe()) != NULL) {
        delete pP;
        oRes->state(1);
    } else {
            oRes->state(0);
    }
}


//inline sal_Bool SAL_CALL is() const;

extern "C" void SAL_CALL test_osl_pipe_Pipe_is(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Bool create( const ::rtl::OUString & strName, 
//                        oslPipeOptions Options, const Security &rSec ); 

extern "C" void SAL_CALL test_osl_pipe_Pipe_create(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Bool create( const ::rtl::OUString & strName, oslPipeOptions Options = osl_Pipe_OPEN );

extern "C" void SAL_CALL test_osl_pipe_Pipe_create_02(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline void SAL_CALL clear();

extern "C" void SAL_CALL test_osl_pipe_Pipe_clear(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline Pipe& SAL_CALL operator= (const Pipe& pipe);

extern "C" void SAL_CALL test_osl_pipe_Pipe_operator_equal(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline Pipe& SAL_CALL operator= (const oslPipe pipe );

extern "C" void SAL_CALL test_osl_pipe_Pipe_operator_equal_02(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Bool SAL_CALL isValid() const;

extern "C" void SAL_CALL test_osl_pipe_Pipe_isValid(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Bool SAL_CALL operator==( const Pipe& rPipe ) const;

extern "C" void SAL_CALL test_osl_pipe_Pipe_operator_equalequal(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline void SAL_CALL close();

extern "C" void SAL_CALL test_osl_pipe_Pipe_close(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline oslPipeError SAL_CALL accept(StreamPipe& Connection);

extern "C" void SAL_CALL test_osl_pipe_Pipe_accept(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline oslPipeError SAL_CALL getError() const;

extern "C" void SAL_CALL test_osl_pipe_Pipe_getError(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline oslPipe SAL_CALL getHandle() const;

extern "C" void SAL_CALL test_osl_pipe_Pipe_getHandle(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}




//class StreamPipe methods:

//ctor StreamPipe();

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_ctor(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//ctor StreamPipe(oslPipe Pipe);

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_ctor_02(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//ctor StreamPipe(const StreamPipe& Pipe);

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_ctor_03(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//ctor StreamPipe(const ::rtl::OUString& strName, oslPipeOptions Options = osl_Pipe_OPEN);

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_ctor_04(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//ctor StreamPipe(const ::rtl::OUString& strName, oslPipeOptions Options, const Security &rSec );

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_ctor_05(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//ctor StreamPipe( oslPipe pipe, __sal_NoAcquire noacquire );

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_ctor_06(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline StreamPipe & SAL_CALL operator=(oslPipe Pipe);

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_operator_equal(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline StreamPipe& SAL_CALL operator=(const Pipe& pipe);

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_operator_equal_02(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Int32 SAL_CALL recv(void* pBuffer, sal_Int32 BytesToRead) const;

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_recv(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Int32 SAL_CALL send(const void* pBuffer, sal_Int32 BytesToSend) const;

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_send(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


//inline sal_Int32 SAL_CALL read(void* pBuffer, sal_Int32 n) const;

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_read(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}


// sal_Int32 SAL_CALL write(const void* pBuffer, sal_Int32 n) const;

extern "C" void SAL_CALL test_osl_pipe_StreamPipe_write(TestResult *oRes)
{
  oRes->state(0, "This test not implemented");
}
