/*************************************************************************
#
#   $RCSfile: rtl_OUString.cxx,v $
#
#   $Revision: 1.6 $
#
#   last change: $Author: bmahbod $ $Date: 2001/06/29 19:37:19 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************/

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

#ifndef _TESTS_TRES_HXX_
	#include <rtl/tres.hxx>
#endif

#ifndef _RTL_STRING_HXX_
	#include <rtl/string.hxx>
#endif

#ifndef _RTL_USTRING_H_
	#include <rtl/ustring.h>
#endif

#ifndef _RTL_USTRING_HXX_
	#include <rtl/ustring.hxx>
#endif

#ifndef _RTL_TEXTENC_H
	#include <rtl/textenc.h>
#endif

#ifndef _STRING_HXX
        #include <tools/string.hxx>
#endif

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Char *kTestStr1 = "Sun Microsystems";
static const sal_Char *kTestStr2 = "Sun Microsystems Java Technology";

static const sal_Int32 kTestStr1Len  = 16;
static const sal_Int32 kTestStr2Len  = 32;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const rtl_TextEncoding kEncoding = RTL_TEXTENCODING_ASCII_US;

static const sal_uInt32 kConvertFlags = OSTRING_TO_OUSTRING_CVTFLAGS;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static const sal_Int32 kCompareAStringToUStringErr        = -2;
static const sal_Int32 kCompareNAStringToUStringErr       = -3;
static const sal_Int32 kCompareAStringToRTLUStringErr     = -4;
static const sal_Int32 kCompareAStringToRTLUStringGetErr  = -5;
static const sal_Int32 kCompareNAStringToRTLUStringErr    = -6;
static const sal_Int32 kCompareNAStringToRTLUStringGetErr = -7;
static const sal_Int32 kCompareAStringToStringErr         = -8;
static const sal_Int32 kCompareNAStringToStringErr        = -9;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

using namespace rtl;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

static sal_uInt32 AStringLen( const sal_Char *pAStr )
{
	sal_uInt32  nStrLen = 0;

	if ( pAStr != NULL )
	{
		const sal_Char *pTempStr = pAStr;

		while( *pTempStr )
		{
			pTempStr++;
		} // while

		nStrLen = (sal_uInt32)( pTempStr - pAStr );
	} // if

	return nStrLen;
} // AStringLen

//------------------------------------------------------------------------------------------------------

sal_uInt32 UStringLen( const sal_Unicode *pUStr )
{
	sal_uInt32 nUStrLen = 0;

	if ( pUStr != NULL )
	{
		const sal_Unicode *pTempUStr = pUStr;

		while( *pTempUStr )
		{
			pTempUStr++;
		} // while

		nUStrLen = (sal_uInt32)( pTempUStr - pUStr );
	} // if

	return nUStrLen;
} // UStringLen

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringIsValid( const sal_Char  *pAStr )
{
	if ( pAStr != NULL )
	{
		sal_uInt32 nLen  = AStringLen( pAStr );
		sal_uChar  uChar = 0;

		while ( ( nLen >= 0 ) && ( *pAStr ) )
		{
			uChar = (unsigned char)*pAStr;
			
			if ( uChar > 127 )
			{
				return sal_False;
			} // if

			pAStr++;

			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.

			if ( nLen > 0 )
			{
				nLen--;
			} // if
			else
			{
				break;
			} // else
		} // while
	} // if
	
	return sal_True;
} // AStringIsValid

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringNIsValid( const sal_Char   *pAStr, 
                                 const sal_uInt32  nStrLen 
                               )
{
	sal_uInt32 nLen  = nStrLen;
	sal_uChar  uChar = 0;

	while ( ( nLen >= 0 ) && ( *pAStr ) )
	{
		uChar = (unsigned char)*pAStr;
		
		if ( uChar > 127 )
		{
			return sal_False;
		} // if

		pAStr++;

		// Since we are dealing with unsigned integers
		// we want to make sure that the last number is
		// indeed zero.

		if ( nLen > 0 )
		{
			nLen--;
		} // if
		else
		{
			break;
		} // else
	} // while

	return sal_True;
} // AStringNIsValid

//------------------------------------------------------------------------------------------------------

static inline sal_Int32 ACharToUCharCompare( const sal_Unicode *pUStr, 
                                             const sal_Char    *pAStr 
                                           )
{
	sal_Int32  nCmp   = 0;
	sal_Int32  nUChar = (sal_Int32)*pUStr;
	sal_Int32  nChar  = (sal_Int32)((unsigned char)*pAStr);

	nCmp = nUChar - nChar;

	return  nCmp;
} // ACharToUCharCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToUStringCompare( const sal_Unicode *pUStr, 
                                          const sal_Char    *pAStr 
                                        )
{
 	sal_Int32 nCmp = kCompareAStringToUStringErr;

	if ( ( pUStr != NULL ) && ( pAStr != NULL ) )
	{
		nCmp = ACharToUCharCompare( pUStr, pAStr );

		while ( ( nCmp == 0 ) && ( *pAStr ) )
		{
			pUStr++;
			pAStr++;

			nCmp = ACharToUCharCompare( pUStr, pAStr );
		} // while
	} // if

	return nCmp;
} // AStringToUStringCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToUStringNCompare( const sal_Unicode  *pUStr, 
                                           const sal_Char     *pAStr,
                                           const sal_uInt32    nAStrCount 
                                         )
{
	sal_Int32 nCmp = kCompareNAStringToUStringErr;

	if ( ( pUStr != NULL ) && ( pAStr != NULL ) )
	{
		sal_uInt32 nCount = nAStrCount;

		nCmp = ACharToUCharCompare( pUStr, pAStr );

		while ( ( nCmp == 0 ) && ( *pAStr ) && ( nCount ) )
		{	
			pUStr++;
			pAStr++;

			nCmp = ACharToUCharCompare( pUStr, pAStr );

			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.

			if ( nCount > 0 )
			{
				nCount--;
			} // if
			else
			{
				break;
			} // else
		} // while
	} // if

	return nCmp;
} // AStringToUStringNCompare

//------------------------------------------------------------------------------------------------------

static inline sal_Int32 ACharToSCharCompare( const String      &rStr, 
                                             const sal_Char    *pAStr,
                                             const sal_uInt32   nIndex
                                           )
{
	sal_Int32  nCmp   = 0;
	sal_Int32  nChar1 = (sal_Int32)((unsigned char)*pAStr);
	sal_Int32  nChar2 = (sal_Int32)(rStr.GetChar(nIndex));

	nCmp = nChar2 - nChar1;

	return  nCmp;
} // ACharToSCharCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToStringCompare( const String    &rStr, 
                                         const sal_Char  *pAStr 
                                       )
{
 	sal_Int32 nCmp = kCompareAStringToStringErr;

	if ( pAStr != NULL )
	{
		sal_uInt32 nIndex = 0;	
		
		nCmp = ACharToSCharCompare( rStr, pAStr, nIndex );

		while ( ( nCmp == 0 ) && ( *pAStr ) )
		{
			pAStr++;

			nIndex++;
			
			nCmp = ACharToSCharCompare( rStr, pAStr, nIndex );
		} // while
	} // if

	return nCmp;
} // AStringToStringCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToStringNCompare( const String      &rStr, 
                                          const sal_Char    *pAStr,
                                          const sal_uInt32   nAStrCount 
                                        )
{
	sal_Int32 nCmp = kCompareNAStringToStringErr;

	if ( pAStr != NULL )
	{
		sal_uInt32 nCount = nAStrCount;
		sal_Int32  nIndex = 0;

		nCmp = ACharToSCharCompare( rStr, pAStr, nIndex );
		
		while ( ( nCmp == 0 ) && ( *pAStr ) && ( nCount ) )
		{	
			pAStr++;

			nIndex++;
			
			nCmp = ACharToSCharCompare( rStr, pAStr, nIndex );

			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.
			
			if ( nCount > 0 )
			{
				nCount--;
			} // if
			else
			{
				break;
			} // else
		} // while
	} // if

	return nCmp;
} // AStringToStringNCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToRTLUStringCompare( const rtl_uString  *pRTLUStr,
                                             const sal_Char     *pAStr
                                           ) 
{
	sal_Int32 nCmp = kCompareAStringToRTLUStringErr;

	if ( ( pRTLUStr != NULL ) && ( pAStr != NULL ) )
	{
		rtl_uString *pRTLUStrCopy = NULL;
		
		rtl_uString_newFromString( &pRTLUStrCopy, pRTLUStr );
		
		nCmp = kCompareAStringToRTLUStringGetErr;
		
		if ( pRTLUStrCopy != NULL )
		{
			const sal_Unicode *pUStr = rtl_uString_getStr( pRTLUStrCopy );
		
			if ( pUStr != NULL )
			{
				nCmp = AStringToUStringCompare( pUStr, pAStr );
			} // if
			
			rtl_uString_release( pRTLUStrCopy );
			
			pRTLUStrCopy = NULL;
		} // if
	} // if
	
	return nCmp;
} // AStringToRTLUStringCompare

//------------------------------------------------------------------------------------------------------

static sal_Int32 AStringToRTLUStringNCompare( const rtl_uString  *pRTLUStr,
                                              const sal_Char     *pAStr,
                                              const sal_uInt32    nAStrCount
                                            ) 
{
	sal_Int32 nCmp = kCompareNAStringToRTLUStringErr;

	if ( ( pRTLUStr != NULL ) && ( pAStr != NULL ) )
	{
		rtl_uString *pRTLUStrCopy = NULL;
		
		rtl_uString_newFromString( &pRTLUStrCopy, pRTLUStr );
		
		nCmp = kCompareNAStringToRTLUStringGetErr;
			
		if ( pRTLUStrCopy != NULL )
		{
			const sal_Unicode  *pUStr = rtl_uString_getStr( pRTLUStrCopy );
			
			if ( pUStr != NULL )
			{
				nCmp = AStringToUStringNCompare( pUStr, pAStr, nAStrCount );
			} // if
			
			rtl_uString_release( pRTLUStrCopy );
			
			pRTLUStrCopy = NULL;
		} // if
	} // if
	
	return nCmp;
} // AStringToRTLUStringNCompare

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringToUStringCopy( sal_Unicode     *pDest, 
                                      const sal_Char  *pSrc
                                    )
{
	sal_Bool    bCopied = sal_False;
	sal_uInt32  nCount  = AStringLen( pSrc );
	sal_uInt32  nLen    = nCount;
	
	if (    ( pDest != NULL ) 
	     && ( pSrc  != NULL ) 
	     && ( AStringNIsValid( pSrc, nLen ) )
	   )
	{
		while ( nCount >= 0 )
		{
			*pDest = (unsigned char)*pSrc;

			pDest++;
			pSrc++;
			
			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.

			if ( nCount > 0 )
			{
				nCount--;
			} // if
			else
			{
				break;
			} // else
		} // while
		
		if ( nCount == 0 )
		{
			bCopied = sal_True;
		} // if
	} // if
	
	return  bCopied;
} // AStringToUStringCopy

//------------------------------------------------------------------------------------------------------

static sal_Bool AStringToUStringNCopy( sal_Unicode       *pDest, 
                                       const sal_Char    *pSrc,
                                       const sal_uInt32   nSrcLen 
                                     )
{
	sal_Bool    bCopied = sal_False;
	sal_uInt32  nCount    = nSrcLen;
	sal_uInt32  nLen    = nSrcLen;

	if (    ( pDest != NULL ) 
	     && ( pSrc  != NULL ) 
	     && ( AStringNIsValid( pSrc, nLen ) )
	   )
	{
		while ( nCount >= 0 )
		{
			*pDest = (unsigned char)*pSrc;

			pDest++;
			pSrc++;
			
			// Since we are dealing with unsigned integers
			// we want to make sure that the last number is
			// indeed zero.

			if ( nCount > 0 )
			{
				nCount--;
			} // if
			else
			{
				break;
			} // else
		} // while
		
		if ( nCount == 0 )
		{
			bCopied = sal_True;
		} // if
	} // if
	
	return  bCopied;
} // AStringToUStringNCopy

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------
//
// testing conaStructors
//
//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_001( TestResult *oRes )
{
	::rtl::OUString aStr;

	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	oRes->setVerbosityLevel(eVerbose);

	bTCState = aStr == NULL;
    
	oRes->logPrintf( bTCState,
                     bTCPrintName, 
                     "New OUString containing no characters.\n" 
                   );

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_002( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	sal_Unicode aStr1[kTestStr1Len+1];

	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			::rtl::OUString aStr2( kTestStr1,
			                      kTestStr1Len,
			                      kEncoding,
			                      kConvertFlags
			                    );

			bTCState = aStr2 == aStr1;
	    
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "New OUString from an ascii string.\n"
			               );
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "Comparing an ascii string with a unicode string!\n"
			               );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a unicode string!\n"
		               );
	} // else
	
	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_003( TestResult *oRes )
{
	sal_Unicode  aStr1[kTestStr1Len+1];

	sal_Bool     bTCState     = false;
	sal_Bool     bTCPrintName = true;
   
	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			rtl_uString  *aStr2 = NULL;

			rtl_uString_newFromAscii( &aStr2, kTestStr1 );

			if ( aStr2 != NULL )
			{
				if ( AStringToRTLUStringNCompare( aStr2, kTestStr1, kTestStr1Len ) == 0 )
				{
					::rtl::OUString aStr3( aStr2 );

					bTCState = aStr3 == aStr1;
		    
					oRes->logPrintf( bTCState,
					                 bTCPrintName,
					                 "New OUString from OUString data.\n"
					               );
				} // if
				else
				{
					oRes->logPrintf( bTCState,
					                 bTCPrintName,
					                 "Comparing of a RTL UString with an ascii string!\n"
					               );
				} // else
					
				rtl_uString_release( aStr2 );
					
				aStr2 = NULL;
			} // if
			else
			{
				oRes->logPrintf( bTCState,
				                 bTCPrintName,
				                 "Creating a RTL UString from an ascii string!\n"
				               );
			} // else
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "Comparing an ascii string with a unicode string!\n"
			               );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a unicode string!\n"
		               );
	} // else

	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_004( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	sal_Unicode aStr1[kTestStr1Len+1];

	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			::rtl::OUString aStr2( aStr1 );

			bTCState = aStr2 == aStr1;
	    
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "New OUString from a unicode string.\n"
			               );
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "Comparing an ascii string with a unicode string!\n" 
	                       );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a unicode string!\n"
		               );
	} // else
	
	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_005( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	sal_Unicode aStr1[kTestStr1Len+1];

	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			sal_Unicode aStr2[kTestStr2Len+1];

			if ( AStringToUStringNCopy( aStr2, kTestStr2, kTestStr2Len ) )
			{
				if ( AStringToUStringNCompare( aStr2, kTestStr2, kTestStr2Len ) == 0 )
				{
					::rtl::OUString aStr3( aStr2, kTestStr1Len );
					
					const sal_Char  *kTCMessage[2] = { "New OUString from the first n characters of",
					                                   "a unicode string."
					                                 };

					bTCState = aStr3 == aStr1;
		    
					oRes->logPrintf( bTCState,
					                 bTCPrintName,
					                 "%s\n   %s\n",
					                 kTCMessage[0],
					                 kTCMessage[1]
					               );
				} // if
				else
				{
					oRes->logPrintf( bTCState,
					                 bTCPrintName,
					                 "[2] Comparing an ascii string with a unicode string!\n"
					               );
				} // else
			} // if
			else
			{
				oRes->logPrintf( bTCState,
				                 bTCPrintName,
				                 "[2] Copying an ascii string to a unicode string!\n"
				               );
			} // else
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "[1] Comparing an ascii string with a unicode string!\n"
			               );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "[1] Copying an ascii string to a unicode string!\n"
		               );
	} // else
	
	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_006( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	sal_Unicode aStr1[kTestStr1Len+1];

	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			::rtl::OUString aStr2( aStr1 );

			bTCState = aStr2 == aStr1;

			if ( bTCState )
			{
	 			::rtl::OUString aStr3( aStr2 );

				bTCState = aStr3 == aStr2;
	   
				oRes->logPrintf( bTCState,
				                 bTCPrintName,
				                 "New OUString from another OUString.\n"
				               );
			} // if
			else
			{
				oRes->logPrintf( bTCState,
				                 bTCPrintName,
				                 "Creating a OUString from a unicode string!"
				               );
			} // else
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "Comparing an ascii string with a unicode string!\n"
			               );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a unicode string!\n"
		               );
	} // else
	
	return bTCState;
}

//------------------------------------------------------------------------------------------------------

sal_Bool test_rtl_OUString_ctors_007( TestResult *oRes )
{
	sal_Bool bTCState     = false;
	sal_Bool bTCPrintName = true;

	sal_Unicode aStr1[kTestStr1Len+1];

	oRes->setVerbosityLevel(eVerbose);

	if ( AStringToUStringNCopy( aStr1, kTestStr1, kTestStr1Len ) )
	{
		if ( AStringToUStringNCompare( aStr1, kTestStr1, kTestStr1Len ) == 0 )
		{
			String aStr2( kTestStr1, kEncoding );

			bTCState = AStringToStringCompare( aStr2, kTestStr1 ) == 0;

			if ( bTCState )
			{
	 			::rtl::OUString aStr3( aStr2 );

				bTCState = aStr3 == aStr1;
	   
				oRes->logPrintf( bTCState,
				                 bTCPrintName,
				                 "New OUString from a String.\n"
				               );
			} // if
			else
			{
				oRes->logPrintf( bTCState,
				                 bTCPrintName,
				                 "Creating a String from an ansii string!\n"
				               );
			} // else
		} // if
		else
		{
			oRes->logPrintf( bTCState,
			                 bTCPrintName,
			                 "Comparing an ascii string with a unicode string!\n"
			               );
		} // else
	} // if
	else
	{
		oRes->logPrintf( bTCState,
		                 bTCPrintName,
		                 "Copying an ascii string to a unicode string!\n"
		               );
	} // else
	
	return bTCState;
}

//------------------------------------------------------------------------------------------------------

extern "C" void SAL_CALL test_rtl_OUString_ctors( TestResult *oRes )
{		
	sal_Bool bTCState = false;

	bTCState =    test_rtl_OUString_ctors_001( oRes ) 
	           && test_rtl_OUString_ctors_002( oRes ) 
	           && test_rtl_OUString_ctors_003( oRes ) 
	           && test_rtl_OUString_ctors_004( oRes ) 
	           && test_rtl_OUString_ctors_005( oRes )
	           && test_rtl_OUString_ctors_006( oRes )
	           && test_rtl_OUString_ctors_007( oRes );

	oRes->state( bTCState );
}

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
