/*************************************************************************
 *
 *  $RCSfile: XclTools.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/30 16:08:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLTOOLS_HXX
#include "XclTools.hxx"
#endif

#include <math.h>

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif


//___________________________________________________________________
// class XclTools

double XclTools::GetDoubleFromRK( sal_uInt32 nRKValue )
{
    double fVal;

    if( nRKValue & EXC_RK_INTFLAG )
        fVal = (double) (*((sal_Int32*) &nRKValue) >> 2);   // integer
    else
    {
        // 64-Bit IEEE-Float
#ifdef __BIGENDIAN
        *((sal_uInt32*) &fVal + 1) = 0;                     // lower 32 bits = 0
        *((sal_uInt32*) &fVal) = nRKValue & 0xFFFFFFFC;     // bit 0, 1 = 0
#else
        *((sal_uInt32*) &fVal) = 0;                         // lower 32 bits = 0
        *((sal_uInt32*) &fVal + 1) = nRKValue & 0xFFFFFFFC; // bit 0, 1 = 0
#endif
    }

    if( nRKValue & EXC_RK_100FLAG )
        fVal *= 0.01;

    return fVal;
}

sal_Bool XclTools::GetRKFromDouble( sal_Int32& rnRKValue, double fValue )
{
    double fFrac, fInt;

    // integer
    fFrac = modf( fValue, &fInt );
    if( (fFrac == 0.0) && (fInt >= -536870912.0) && (fInt <= 536870911.0) ) // 2^29 =  536870912
    {
        rnRKValue = (INT32) fInt;
        rnRKValue <<= 2;
        rnRKValue |= EXC_RK_INT;
        return sal_True;
    }

    // integer/100
    fFrac = modf( fValue * 100.0, &fInt );
    if( (fFrac == 0.0) && (fInt >= -536870912.0) && (fInt <= 536870911.0) )
    {
        rnRKValue = static_cast< sal_Int32 >( fInt );
        rnRKValue <<= 2;
        rnRKValue |= EXC_RK_INT100;
        return sal_True;
    }

    // double
    return sal_False;
}



sal_Int32 XclTools::GetScRotation( sal_uInt16 nExcRot )
{
    if( nExcRot > 180 )
        return 27000;
    return static_cast< sal_Int32 >( 100 * ((nExcRot > 90) ? 450 - nExcRot : nExcRot) );
}

sal_uInt16 XclTools::GetExcRotation( sal_uInt32 nScRot )
{
    sal_uInt32 nExcRot = nScRot / 100;
    if( nExcRot <= 90 )
        return static_cast< sal_uInt16 >( nExcRot );
    if( nExcRot < 180 )
        return static_cast< sal_uInt16 >( 270 - nExcRot );
    if( nExcRot < 270 )
        return static_cast< sal_uInt16 >( nExcRot - 180 );
    if( nExcRot < 360 )
        return static_cast< sal_uInt16 >( 450 - nExcRot );
    return 0;
}



XclBoolError XclTools::ErrorToEnum( double& rfDblValue, sal_uInt8 bErrOrBool, sal_uInt8 nValue )
{
    XclBoolError eType;
    if( bErrOrBool )
    {
        // Error Value
        switch( nValue )
        {
            case 0x00:  eType = xlErrNull;      break;
            case 0x07:  eType = xlErrDiv0;      break;
            case 0x0F:  eType = xlErrValue;     break;
            case 0x17:  eType = xlErrRef;       break;
            case 0x1D:  eType = xlErrName;      break;
            case 0x24:  eType = xlErrNum;       break;
            case 0x2A:  eType = xlErrNA;        break;
            default:    eType = xlErrUnknown;
        }
        rfDblValue = 0.0;
    }
    else
    {
        // Boolean Value
        eType = nValue ? xlErrTrue : xlErrFalse;
        rfDblValue = nValue ? 1.0 : 0.0;
    }
    return eType;
}



const sal_Char* XclTools::GetBuiltInName( sal_Unicode nIndex )
{
    static const sal_Char* pNames[] =
    {
        "BuiltIn_Consolidate_Area",
        "BuiltIn_Auto_Open",
        "BuiltIn_Auto_Close",
        "BuiltIn_Extract",
        "BuiltIn_Database",
        "BuiltIn_Criteria",
        "BuiltIn_Print_Area",
        "BuiltIn_Print_Titles",
        "BuiltIn_Recorder",
        "BuiltIn_Data_Form",
        "BuiltIn_Auto_Activate",
        "BuiltIn_Auto_Deactivate",
        "BuiltIn_SheetTitle",
        "BuiltIn_AutoFilter",
        "BuiltIn_UNKNOWN"
    };
    DBG_ASSERT( sizeof( pNames ) / sizeof( sal_Char* ) == EXC_BUILTIN_UNKNOWN + 1,
        "XclTools::GetBuiltInName - Built-in name list modified" );
    if( (nIndex < 0x00) || (nIndex > EXC_BUILTIN_UNKNOWN) )
        nIndex = EXC_BUILTIN_UNKNOWN;
    return pNames[ nIndex ];
}

void XclTools::GetBuiltInName( String& rName, sal_Unicode nIndex, sal_uInt16 nSheet )
{
    rName.AssignAscii( GetBuiltInName( nIndex ) );
    rName.AppendAscii( "___" );
    rName += String::CreateFromInt32( nSheet );
}

sal_Bool XclTools::IsBuiltInName( sal_uInt16& rnSheet, const String& rName, sal_Unicode nIndex )
{
    String aBuiltIn;
    aBuiltIn.AssignAscii( GetBuiltInName( nIndex ) );
    aBuiltIn.AppendAscii( "___" );
    if( !rName.EqualsIgnoreCaseAscii( aBuiltIn, 0, aBuiltIn.Len() ) )
        return sal_False;
    sal_Int32 nTab = rName.Copy( aBuiltIn.Len() ).ToInt32();
    if( (nTab < 1) || (nTab > MAXTAB + 1) )
        return sal_False;
    if( String::CreateFromInt32( nTab ).Len() != (rName.Len() - aBuiltIn.Len()) )
        return sal_False;
    rnSheet = static_cast< sal_uInt16 >( nTab );
    return sal_True;
}



long XclTools::CalcX( sal_uInt16 nT, sal_uInt16 nC, sal_uInt16 nOC, double f, ScDocument* pDoc )
{
    return ( long ) (
        ( ( double ) pDoc->GetColOffset( nC, nT )
            + ( double ) pDoc->GetColWidth( nC, nT ) * ( ( double ) Min( nOC, (sal_uInt16) 1024 ) / 1024.0 ) )
        * f );
}

long XclTools::CalcY( sal_uInt16 nT, sal_uInt16 nR, sal_uInt16 nOR, double f, ScDocument* pDoc )
{
    return ( long ) (
        ( ( double ) pDoc->GetRowOffset( nR, nT )
            + ( double ) pDoc->GetRowHeight( nR, nT ) * ( ( double ) Min( nOR, (sal_uInt16) 256 ) / 256.0 ) )
        * f );
}



void XclTools::WriteUnicodeBuffer( SvStream& rStrm, const sal_uInt16* pBuffer, sal_uInt32 nChars, sal_Bool b16Bit )
{
    if( !pBuffer || !nChars ) return;

    if( b16Bit )
        for( sal_uInt32 nIndex = 0; nIndex < nChars; ++nIndex )
            rStrm << pBuffer[ nIndex ];
    else
        for( sal_uInt32 nIndex = 0; nIndex < nChars; ++nIndex )
            rStrm << static_cast< sal_uInt8 >( pBuffer[ nIndex ] );
}



//___________________________________________________________________
// class XclFontData

XclFontData::XclFontData() :
    eUnderline( xlUnderlNone ),
    eEscapem( xlEscNone ),
    nHeight( 0 ),
    nColor( EXC_FONTCOL_IGNORE ),
    nWeight( EXC_FONTWGHT_NORMAL ),
    nFamily( EXC_FONTFAM_DONTKNOW ),
    nCharSet( EXC_FONTCSET_DONTKNOW ),
    bItalic( sal_False ),
    bStrikeout( sal_False ),
    bOutline( sal_False ),
    bShadow( sal_False )
{
}

XclFontData::XclFontData( const XclFontData& rCopy ) :
    aName( rCopy.aName ),
    eUnderline( rCopy.eUnderline ),
    eEscapem( rCopy.eEscapem ),
    nHeight( rCopy.nHeight ),
    nColor( rCopy.nColor ),
    nWeight( rCopy.nWeight ),
    nFamily( rCopy.nFamily ),
    nCharSet( rCopy.nCharSet ),
    bItalic( rCopy.bItalic ),
    bStrikeout( rCopy.bStrikeout ),
    bOutline( rCopy.bOutline ),
    bShadow( rCopy.bShadow )
{
}



//___________________________________________________________________

