/*************************************************************************
 *
 *  $RCSfile: XclImpObjects.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/23 12:59:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SC_XCLIMPOBJECTS_HXX
#define _SC_XCLIMPOBJECTS_HXX

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _MSDFFIMP_HXX
#include <svx/msdffimp.hxx>
#endif

#ifndef _SC_FILTERTOOLS_HXX
#include "FilterTools.hxx"
#endif
#ifndef _SC_FILTERPROGRESSBAR_HXX
#include "FilterProgressBar.hxx"
#endif

#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif
#ifndef _CHRTDEFS_HXX
#include "chrtdefs.hxx"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif


class XclImpStream;
class XclImpChart;
class Biff8MSDffManager;


//___________________________________________________________________

struct XclImpStreamNode
{
    sal_uInt32                  nPos;
    sal_uInt32                  nSize;
    XclImpStreamNode*           pPrev;
};


//___________________________________________________________________

class XclImpStreamConsumer
{
private:
    SvMemoryStream              aStrm;
    DffRecordHeader             aHd;
    XclImpStreamNode*           pNode;
    sal_uInt32                  nBytesLeft;

    void                        UpdateNode( const DffRecordHeader& rHd );
    void                        RemoveNode();

public:
                                XclImpStreamConsumer();
                                ~XclImpStreamConsumer();

    const DffRecordHeader*      ConsumeRecord( XclImpStream& rSrcStrm );
    sal_Bool                    AppendData( sal_Char* pBuf, sal_uInt32 nLen );

    inline sal_Bool             HasData() const { return aStrm.Tell() > 0; }
    inline sal_uInt32           Tell() const    { return aStrm.Tell(); }
    inline SvStream&            GetStream()     { return aStrm; }
};


//___________________________________________________________________
// object type

enum XclImpObjectType
{
    otUnknown = 0,
    otChart,
    otPicture,
    otTxo,
    otNote,
    otOle,
    otCtrl
};


//___________________________________________________________________
// base class for Escher objects

class XclImpEscherObj : public ExcRoot
{
protected:
    Rectangle*                  pAnchor;
    SdrObject*                  pSdrObj;
    XclImpObjectType            eType;
    sal_uInt32                  nStrmStart;
    sal_uInt32                  nStrmEnd;
    sal_uInt16                  nTab;
    sal_uInt16                  nId;

public:
                                XclImpEscherObj(
                                    sal_uInt32 _nStrmStart, sal_uInt32 _nStrmEnd,
                                    RootData& rRootData,
                                    XclImpObjectType _eType = otUnknown );
                                // rCopy.pSdrObj is copied to this and becomes NULL!
                                XclImpEscherObj(
                                    XclImpEscherObj& rCopy,
                                    XclImpObjectType _eType = otUnknown );

    virtual                     ~XclImpEscherObj();

    void                        SetAnchor( const Rectangle& rAnchor );
    virtual void                SetSdrObj( SdrObject* pNewSdrObj );
    inline void                 SetType( XclImpObjectType _eType )  { eType = _eType; }
    inline void                 SetId( sal_uInt16 nNewId )          { nId = nNewId; }

    inline const Rectangle*     GetAnchor() const           { return pAnchor; }
    inline const SdrObject*     GetSdrObj() const           { return pSdrObj; }
    inline XclImpObjectType     GetObjType() const          { return eType; }
    inline sal_uInt32           GetStrmStart() const        { return nStrmStart; }
    inline sal_uInt32           GetStrmEnd() const          { return nStrmEnd; }
    inline sal_uInt16           GetTab() const              { return nTab; }
    inline sal_uInt16           GetId() const               { return nId; }

    virtual void                Apply();

    void                        MorpheFrom( XclImpEscherObj*& rpMAD );
};


//___________________________________________________________________

class XclImpEscherChart : public XclImpEscherObj
{
protected:
    XclImpChart*                pChrtData;

public:
                                XclImpEscherChart( XclImpEscherObj*& rpCAD );
    virtual                     ~XclImpEscherChart();

    inline XclImpChart*         GetChartData()      { return pChrtData; }
    void                        SetChartData( XclImpChart* pNewChart );

    void                        InitProgress( ScfProgressBar& rProgress );

    virtual void                Apply();
};


//___________________________________________________________________

class XclImpEscherOle : public XclImpEscherObj
{
private:
    String                      aStorageName;
    sal_uInt32                  nBlipId;
    sal_Bool                    bAsSymbol   : 1;
    sal_Bool                    bLinked     : 1;

public:
                                XclImpEscherOle( XclImpEscherObj*& rpCAD );
    virtual                     ~XclImpEscherOle();

    virtual void                Apply();

    inline void                 SetAsSymbol( sal_Bool bVal )    { bAsSymbol = (bVal != 0); }
    inline void                 SetLinked( sal_Bool bVal )      { bLinked = (bVal != 0); }
    inline void                 SetBlipId( sal_uInt32 nVal )    { nBlipId = nVal; }

    void                        ReadPictFmla( XclImpStream& rIn, sal_uInt16 nLen );
    void                        CreateSdrOle( Biff8MSDffManager& rDffMan, sal_uInt32 nOLEImpFlags = 0 );
};


//___________________________________________________________________

class XclImpEscherDrwObj : public XclImpEscherObj
{
public:
                                XclImpEscherDrwObj( XclImpEscherObj*& rpCAD );
    virtual                     ~XclImpEscherDrwObj();
};


//___________________________________________________________________

class XclImpEscherTxo : public XclImpEscherObj
{
protected:
    String*                     pText;
    EditTextObject*             pFormText;
    sal_Bool                    bIsApplied;

    void                        ApplyTextOnObject( SdrObject* pTextObj = NULL );

public:
                                XclImpEscherTxo( XclImpEscherObj*& rpCAD );
    virtual                     ~XclImpEscherTxo();

    virtual void                SetSdrObj( SdrObject* pNewSdrObj );

    void                        SetText( const String& rText );
    inline const String*        GetText() const     { return pText; }

    void                        TakeText( String* pNewText, EditTextObject* pNewFormText );

    virtual void                Apply();
    void                        Apply( SdrObject* pTextObj );
                                // also set bIsApplied, but doesn't put on drawing layer!
};


//___________________________________________________________________

class XclImpEscherNote : public XclImpEscherTxo
{
public:
                                XclImpEscherNote( XclImpEscherObj*& rpCAP );

    virtual void                Apply();
};


//___________________________________________________________________
// client anchor data

struct XclImpAnchorData
{
    sal_uInt32                  nObjNum;
    sal_uInt16                  nTab;

    sal_uInt16                  nCol;
    sal_uInt16                  nX;
    sal_uInt16                  nRow;
    sal_uInt16                  nY;
    sal_uInt16                  nDCol;
    sal_uInt16                  nDX;
    sal_uInt16                  nDRow;
    sal_uInt16                  nDY;

    inline                      XclImpAnchorData( sal_uInt16 _nTab );
    inline                      XclImpAnchorData( const XclImpAnchorData& rCopy );
};

inline XclImpAnchorData::XclImpAnchorData( sal_uInt16 _nTab )
{
    memset( this, 0x00, sizeof( XclImpAnchorData ) );
    nTab = _nTab;
}

inline XclImpAnchorData::XclImpAnchorData( const XclImpAnchorData& rCopy )
{
    memcpy( this, &rCopy, sizeof( XclImpAnchorData ) );
}

SvStream& operator>>( SvStream& rStrm, XclImpAnchorData& rAnchor );


//___________________________________________________________________
// stores Escher stream position and client anchor data of an object

class XclImpObjData
{
public:
    XclImpEscherObj*            pEscherObj;
    XclImpAnchorData*           pAnchorData;
    sal_uInt32                  nStart;
    sal_uInt32                  nEnd;
    sal_uInt32                  nObjNum;
    sal_uInt16                  nTab;

    inline                      XclImpObjData(
                                    XclImpEscherObj* pObj,
                                    sal_uInt32 _nObjNum );
    inline                      ~XclImpObjData();

    inline XclImpAnchorData*    GetAnchorDataAccess();
    inline sal_Bool             IsInRange( sal_uInt32 nStrmPos ) const;
};

inline XclImpObjData::XclImpObjData( XclImpEscherObj* pObj, sal_uInt32 _nObjNum ) :
    pEscherObj( pObj ),
    pAnchorData( NULL ),
    nObjNum( _nObjNum ),
    nStart( pObj->GetStrmStart() ),
    nEnd( pObj->GetStrmEnd() ),
    nTab( pObj->GetTab() )
{
}

inline XclImpObjData::~XclImpObjData()
{
    if( pEscherObj )
        delete pEscherObj;
    if( pAnchorData )
        delete pAnchorData;
}

inline XclImpAnchorData* XclImpObjData::GetAnchorDataAccess()
{
    if( !pAnchorData )
        pAnchorData = new XclImpAnchorData( nTab );
    return pAnchorData;
}

inline sal_Bool XclImpObjData::IsInRange( sal_uInt32 nStrmPos ) const
{
    return (nStrmPos >= nStart) && (nStrmPos <= nEnd);
}


//___________________________________________________________________
// list of all read Escher objects

class XclImpEscherObjList : private ExcRoot
{
private:
    ScfObjList< XclImpObjData > aObjDataList;
    sal_uInt32                  nLastReqTabStart;
    sal_uInt16                  nLastReqTab;

    XclImpObjData*              GetFromStream( sal_uInt32 nStrmPos ) const;

    sal_Bool                    SetTabStart( sal_uInt16 nNewTab );

public:
                                XclImpEscherObjList( RootData& rRootData );

    void                        Append( XclImpEscherObj* pObj );
    void                        MorpheLastObj( XclImpEscherObj* pObj );

    sal_Bool                    GetObjNum( sal_uInt32 nStrmPos, sal_uInt32& rnObjNum ) const;

    XclImpAnchorData*           GetAnchorDataAccess( sal_uInt32 nStrmPos );
    const XclImpAnchorData*     GetAnchorData( sal_uInt32 nStrmPos ) const;

    inline                      GetObjCount() const     { return aObjDataList.Count(); }
    XclImpEscherObj*            GetObj( sal_uInt32 nObjNum, sal_uInt16 nTab = EXC_TAB_INVALID ) const;
    XclImpEscherObj*            GetObjFromStream( sal_uInt32 nStrmPos );

    void                        Apply( ScfProgressBar& rProgress );
};


//___________________________________________________________________
// stores all Escher objects and additional data

class XclImpObjectManager : private ExcRoot
{
private:
    XclImpStreamConsumer        aStreamConsumer;
    XclImpEscherObjList         aEscherObjList;

    XclImpEscherObj*            pCurrEscherObj;

    sal_Bool                    bLeadingTxo;
    sal_Bool                    bMaybeTxo;
    sal_Bool                    bStartWithDummy;

    static inline sal_Bool      IsType( const XclImpEscherObj* pObj, XclImpObjectType eType );

                                // OBJ subrecords
    XclImpEscherObj*            ReadObjFtCmo( XclImpStream& rStrm );
    void                        ReadObjFtPioGrbit( XclImpStream& rStrm, XclImpEscherObj* pObj );
    void                        ReadObjFtPictFmla( XclImpStream& rStrm, XclImpEscherObj* pObj, sal_uInt16 nLen );

public:
                                XclImpObjectManager( RootData& rRootData );
                                ~XclImpObjectManager();

    inline sal_Bool             HasEscherStream()   { return aStreamConsumer.HasData(); }
    inline SvStream&            GetEscherStream()   { return aStreamConsumer.GetStream(); }

    inline sal_uInt32           GetObjCount() const;
    inline const XclImpEscherObj* GetObj( sal_uInt32 nObjNum, sal_uInt16 nTab ) const;
    const XclImpEscherNote*     GetObjNote( sal_uInt32 nObjNum, sal_uInt16 nTab ) const;

    inline XclImpEscherObj*     GetObjFromStream( sal_uInt32 nStrmPos );
    XclImpEscherTxo*            GetTxoFromStream( sal_uInt32 nStrmPos );

    inline XclImpAnchorData*    GetAnchorDataAccess( sal_uInt32 nStrmPos );
    inline const XclImpAnchorData* GetAnchorData( sal_uInt32 nStrmPos ) const;

    inline XclImpEscherObj*     GetCurrObj() const  { return pCurrEscherObj; }
    void                        AppendCurrObjToList();

    inline sal_Bool             IsCurrObjChart() const;
    void                        SetNewCurrObjChart();

    inline XclImpChart*         GetCurrChartData() const;
    XclImpChart*                ReplaceChartData( XclImpStream& rStrm, XclChartType eNewType );

    void                        ReadMsodrawinggroup( XclImpStream& rStrm );
    void                        ReadMsodrawing( XclImpStream& rStrm );
    void                        ReadMsodrawingselection( XclImpStream& rStrm );

    void                        ReadObj( XclImpStream& rStrm );
    void                        ReadTxo( XclImpStream& rStrm );

    inline void                 InsertDummyObj()
                                    { bStartWithDummy = sal_True; }

    void                        Apply();
};

inline sal_Bool XclImpObjectManager::IsType( const XclImpEscherObj* pObj, XclImpObjectType eType )
{
    return pObj && (pObj->GetObjType() == eType);
}

inline sal_uInt32 XclImpObjectManager::GetObjCount() const
{
    return aEscherObjList.GetObjCount();
}

inline const XclImpEscherObj* XclImpObjectManager::GetObj( sal_uInt32 nObjNum, sal_uInt16 nTab ) const
{
    return aEscherObjList.GetObj( nObjNum, nTab );
}

inline XclImpEscherObj* XclImpObjectManager::GetObjFromStream( sal_uInt32 nStrmPos )
{
    return aEscherObjList.GetObjFromStream( nStrmPos );
}

inline XclImpAnchorData* XclImpObjectManager::GetAnchorDataAccess( sal_uInt32 nStrmPos )
{
    return aEscherObjList.GetAnchorDataAccess( nStrmPos );
}

inline const XclImpAnchorData* XclImpObjectManager::GetAnchorData( sal_uInt32 nStrmPos ) const
{
    return aEscherObjList.GetAnchorData( nStrmPos );
}

inline sal_Bool XclImpObjectManager::IsCurrObjChart() const
{
    return IsType( pCurrEscherObj, otChart );
}

inline XclImpChart* XclImpObjectManager::GetCurrChartData() const
{
    return IsType( pCurrEscherObj, otChart ) ? ((XclImpEscherChart*)pCurrEscherObj)->GetChartData() : NULL;
}



//___________________________________________________________________

class Biff8MSDffManager : public SvxMSDffManager, protected ExcRoot
{
private:
    XclImpObjectManager&        rObjManager;

protected:
    virtual void                ProcessClientAnchor2( SvStream&, DffRecordHeader&, void*, DffObjData& );
    virtual SdrObject*          ProcessObj(
                                    SvStream&,
                                    DffObjData&,
                                    void* pData,
                                    Rectangle& rTextRect,
                                    SdrObject* pObj = NULL );
    virtual sal_uInt32          Calc_nBLIPPos( sal_uInt32 nOrgVal, sal_uInt32 nStreamPos ) const;
    virtual FASTBOOL            GetColorFromPalette( sal_uInt16 nIndex, Color& rColor ) const;
    virtual sal_Bool            ShapeHasText( sal_uInt32 nShapeId, sal_uInt32 nFilePos ) const;

public:
                                Biff8MSDffManager(
                                    RootData&               rRootData,
                                    XclImpObjectManager&    rObjMan,
                                    sal_Int32               nOffsDgg,
                                    SvStream*               pStData,
                                    SdrModel*               pSdrModel_          = 0,
                                    sal_Int32               nApplicationScale   = 0,
                                    ColorData               mnDefaultColor_     = COL_DEFAULT,
                                    sal_uInt32              nDefaultFontHeight_ = 24,
                                    SvStream*               pStData2_           = 0 );

    virtual                     ~Biff8MSDffManager();

    void                        SetSdrObject(
                                    XclImpEscherObj* pEscherObj,
                                    sal_uInt32 nId,
                                    SvxMSDffImportData& rData );
};

#endif

