/*************************************************************************
 *
 *  $RCSfile: XclTools.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/30 16:05:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_XCLTOOLS_HXX
#define _SC_XCLTOOLS_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif


class ScDocument;
class SvStream;


//___________________________________________________________________

/** An enumeration for all Excel file format types (BIFF types). */
enum XclBiff
{
    xlBiff2, xlBiff3, xlBiff4, xlBiff5, xlBiff7, xlBiff8
};

#define ASSERT_UNKNOWNBIFF()    DBG_ERRORFILE( "Unknown BIFF type!" )


//___________________________________________________________________

/** An enumeration for all Excel error codes and the values TRUE and FALSE. */
enum XclBoolError
{
    xlErrNull,                                  /// The error code #NULL!
    xlErrDiv0,                                  /// The error code #DIV/0!
    xlErrValue,                                 /// The error code #VALUE!
    xlErrRef,                                   /// The error code #REF!
    xlErrName,                                  /// The error code #NAME?
    xlErrNum,                                   /// The error code #NUM!
    xlErrNA,                                    /// The error code #N/A!
    xlErrTrue,                                  /// The Boolean TRUE
    xlErrFalse,                                 /// The Boolean FALSE
    xlErrUnknown                                /// For unknown codes and values.
};


//___________________________________________________________________

/** This class contains static helper methods for the Excel import and export filters. */
class XclTools
{
private:
                                XclTools();
                                XclTools( const XclTools& );
    XclTools&                   operator=( const XclTools& );

public:
                                /** Calculates the double value from an RK value (encoded integer or double). */
    static double               GetDoubleFromRK( sal_uInt32 nRKValue );
                                /** Calculates an RK value (encoded integer or double) from a double value.
                                    @param  rnRKValue
                                    Return: The calculated RK value.
                                    @param  fValue:
                                    The double value.
                                    @return  sal_True, if an RK value could be created. */
    static sal_Bool             GetRKFromDouble( sal_Int32& rnRKValue, double fValue );

                                /** Calculates an angle (in 1/100 of degrees) from an Excel angle value. */
    static sal_Int32            GetScRotation( sal_uInt16 nExcRot );
                                /** Calculates the Excel angle value from an angle in 1/100 of degrees. */
    static sal_uInt16           GetExcRotation( sal_uInt32 nScRot );

                                /** Gets a translated error code or Boolean value from Excel error codes.
                                    @param  rfDblValue
                                    Return: 0.0 for error codes or the value of a Boolean (0.0 or 1.0).
                                    @param  bErrorOrBool
                                    sal_False = nError is a Boolean value; sal_True = is an error value.
                                    @param  nValue
                                    The error code or Boolean value. */
    static XclBoolError         ErrorToEnum( double& rfDblValue, sal_uInt8 bErrOrBool, sal_uInt8 nValue );

                                /// @return  An Excel built-in name used in NAME records.
    static const sal_Char*      GetBuiltInName( sal_Unicode nIndex );
                                /** Stores an Excel built-in name and appends a sheet index.
                                    @param  rName
                                    The built-in name will be stored here.
                                    @param  nIndex
                                    Index of the built-in name.
                                    @param  nSheet
                                    This number will be appended to the string, separated by 3 underline characters. */
    static void                 GetBuiltInName( String& rName, sal_Unicode nIndex, sal_uInt16 nSheet );
                                /** Tests on valid built-in name with sheet index.
                                    @param  rnSheet
                                    Here the parsed sheet index is returned.
                                    @param  rString
                                    The string to be determined.
                                    @param  nIndex
                                    Index to built-in name to be compared with the string
                                    @return  sal_True, if the string is valid. */
    static sal_Bool             IsBuiltInName( sal_uInt16& rnSheet, const String& rName, sal_Unicode nIndex );

                                /** Calculates an X position in Calc twips from Excel anchor position. */
    static long                 CalcX( sal_uInt16 nT, sal_uInt16 nC, sal_uInt16 nOC, double f, ScDocument* pDoc );
                                /** Calculates an Y position in Calc twips from Excel anchor position. */
    static long                 CalcY( sal_uInt16 nT, sal_uInt16 nR, sal_uInt16 nOR, double f, ScDocument* pDoc );

                                /** Write the character buffer as 8-bit or 16-bit character array.
                                    @param  pBuffer
                                    The Unicode character buffer.
                                    @param  nChars
                                    The number of characters to write.
                                    @param  b16Bit
                                    sal_False = write as 8-bit characters; sal_True = 16-bit characters. */
    static void                 WriteUnicodeBuffer(
                                    SvStream& rStrm,
                                    const sal_uInt16* pBuffer,
                                    sal_uInt32 nChars,
                                    sal_Bool b16Bit );
};


//___________________________________________________________________

/** This struct stores all Excel compatible properties of a font:
    name, family, character set, height, color, boldness, posture, script,
    underline, strikeout, outline, shadow. Derived classes support reading and
    writing Excel fonts. */
struct XclFontData
{
private:
    XclFontData&                operator=( const XclFontData& );

public:
    String                      aName;          /// Font name.
    XclUnderline                eUnderline;     /// Underline style.
    XclEscapement               eEscapem;       /// Super-/subscript.
    sal_uInt16                  nHeight;        /// Font height in twips (1/20 of a point).
    sal_uInt16                  nColor;         /// Index to color palette.
    sal_uInt16                  nWeight;        /// Boldness: 400=normal, 700=bold.
    sal_uInt8                   nFamily;        /// Font family.
    sal_uInt8                   nCharSet;       /// Character set.
    sal_Bool                    bItalic;        /// sal_True = italic.
    sal_Bool                    bStrikeout;     /// sal_True = struck out.
    sal_Bool                    bOutline;       /// sal_True = outlined.
    sal_Bool                    bShadow;        /// sal_True = shadowed.

                                XclFontData();
                                XclFontData( const XclFontData& rCopy );
};



//___________________________________________________________________

#endif

