/*************************************************************************
 *
 *  $RCSfile: fontbuff.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:41:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FONTBUFF_HXX
#define _FONTBUFF_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef SC_ITEMS_HXX
#include "scitems.hxx"
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX
#include <svx/colritem.hxx>
#endif

#ifndef _ROOT_HXX
#include "root.hxx"
#endif



struct ColBuffEntry
{
	BYTE				nR;
	BYTE				nG;
	BYTE				nB;
};




class ColorBuffer : public ExcRoot
{
private:
	SvxColorItem**			pArray;
	SvxColorItem*			pDefault;
	UINT16					nMax;
	UINT16					nCount;
	const ColBuffEntry*		pDefArray;
	const static UINT16		nAnzDef;			// ...und Anzahl
	const static UINT16		nIndCorrect;		// Index-Korrektur
	BOOL					bAuto;
public:
							ColorBuffer( RootData *pRD );
							~ColorBuffer();

	void					Reset();
	BOOL					NewColor( UINT16 nR, UINT16 nG, UINT16 nB );
	const SvxColorItem*		GetColor( UINT16 nIndex, const BOOL bOptionalGetDefault = TRUE );

	BOOL					Auto() const { return bAuto; }
	inline BYTE				GetRed( UINT16 nIndex );
	inline BYTE				GetGreen( UINT16 nIndex );
	inline BYTE				GetBlue( UINT16 nIndex );
	inline static UINT16	GetAnz( void );
	inline static UINT16	GetIndCorrect( void );

	void					SetDefaults( void );	// use, after Biff version is detected
};



inline BYTE ColorBuffer::GetRed( UINT16 nIndex )
{
	BYTE	nVal;
	if( nIndex < nAnzDef )
		nVal = pDefArray[ nIndex ].nR;
	else
		nVal = 0;
	return nVal;
}


inline BYTE ColorBuffer::GetGreen( UINT16 nIndex )
{
	BYTE	nVal;
	if( nIndex < nAnzDef )
		nVal = pDefArray[ nIndex ].nG;
	else
		nVal = 0;
	return nVal;
}


inline BYTE ColorBuffer::GetBlue( UINT16 nIndex )
{
	BYTE	nVal;
	if( nIndex < nAnzDef )
		nVal = pDefArray[ nIndex ].nB;
	else
		nVal = 0;
	return nVal;
}


inline UINT16 ColorBuffer::GetAnz( void )
{
	return nAnzDef;
}


inline UINT16 ColorBuffer::GetIndCorrect( void )
{
	return nIndCorrect;
}


#endif
