# // generiert aus SC scfkenus.src ein File, das den GECAP Konventionen
# // zum Sprachen uebersetzen genuegt
# // eingefuegt wird "Text [ENGLISH] = "
# // das muss mit dem Pattern in regensrc.awk korrespondieren!
BEGIN {
	badexit = 0
	TranslateKeys = 1		# // auf 0 setzen, wenn function keywords
							# // nicht uebersetzt werden sollen
	syntax = "gawk -f gensrc.awk scfkenus.src generate.src"
	if ( ARGC < 3 )
	{
		print "Syntax: " syntax
		badexit = 1
		exit
	}
	outf = ARGV[ARGC-1]
	--ARGC
	FS = ";"
	prefix = "Text [ENGLISH] = "
	BeginFunc = 1
	DoesContinue = 0
	printf("") >outf
	print "// " syntax >>outf
	print "// generated resource file for GECAP translation" >>outf
	printf("\n") >>outf
}

{
	# // alle Zeilen, die ein ';' enthalten oder mit einem '"' anfangen
	if ( NF > 1 ||
			(NF == 1 && index( $1, "\"") &&
			index( $1, "\"") <= match( $1, "[^ \t]" )) )
	{
		if ( (ipos = match( $1, "[^ \t]" )) > 1 )
			indent = substr( $1, 1, ipos-1 )
		else
			indent = ""
		if ( $NF != "" )
			NumberOfFields = NF			# // letzter ohne Semikolon => next line
		else
			NumberOfFields = NF - 1
		for ( cnt = 1; cnt <= NumberOfFields; ++cnt )
		{
			printf( indent ) >>outf
			pos = index( $cnt, "\"" )	# // vielleicht ein String
			if ( pos > 1 )
				if ( (x = substr( $cnt, pos-1, 1 )) != " " && x != "\t" )
					--pos				# // nicht nur white space davor..
			if ( pos && substr( $cnt, pos, 1 ) == "\"" )
			{
				epos = length( $cnt )
				while ( epos && substr( $cnt, epos, 1 ) != "\"" )
				{
					while ( (x = substr( $cnt, epos, 1 )) == " " || x == "\t" )
						--epos
					if ( epos && substr( $cnt, epos, 1 ) != "\"" )
					{					# // ';' im String gewesen, join fields
						$cnt = $cnt ";" $(cnt+1)
						for ( j = cnt+1; j < NF; ++j )
							$j = $(j+1)
						--NumberOfFields
						--NF
						epos = length( $cnt )
					}
				}
				# // function keywords sind immer das zweite Token
				if ( cnt == 2 && BeginFunc )
				{
					BeginFunc = 0
					if ( TranslateKeys )
						printf( prefix ) >>outf
				}
				else if ( !DoesContinue )
					printf( prefix ) >>outf
				if ( cnt == 1 )
					printf( substr( $cnt, ipos ) ) >>outf
				else
					printf( $cnt ) >>outf
				if ( cnt == NF )
					DoesContinue = 1
				else
				{
					DoesContinue = 0
					printf( ";" ) >>outf
				}
				printf( "\n" ) >>outf
			}
			else						# // kein String
			{
				if ( cnt == 1 )
					print substr( $cnt, ipos ) ";" >>outf
				else
				{
					printf( $cnt ) >>outf
					if ( cnt != NF )
						printf( ";" ) >>outf
					printf( "\n" ) >>outf
				}
			}
			if ( $cnt ~ /ID_FUNCTION_HELP_START/ )
				BeginFunc = 1
		}
	}
	else
	{									# // Leerzeile, Kommentar etc., ohne ;
		print >>outf
	}
}

END {
	exit(badexit)
}
