/*************************************************************************
 *
 *  $RCSfile: viewshel.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: bm $ $Date: 2002/01/09 16:17:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_VIEWSHEL_HXX
#define _SCH_VIEWSHEL_HXX
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------

#ifndef _TOOLS_TABLE_HXX //autogen
#include <tools/table.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _VIEWFAC_HXX //autogen
#include <sfx2/viewfac.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <sfx2/viewsh.hxx>
#endif
#ifndef _TRANSFER_HXX //autogen
#include <svtools/transfer.hxx>
#endif
#ifndef _SV_EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif
#ifndef _SCH_GLOB_HXX
#include "glob.hxx"
#endif

// UI Features
#define SCH_UI_FEATURE_THREE_D          1
#define SCH_UI_FEATURE_OWN_DATA         2

class SchFuPoor;
class SchView;
class SchChartDocShell;
class ChartModel;
class SchWindow;
class SvxRuler;

class TransferableDataHelper;
class TransferableClipboardListener;

/*************************************************************************
|*
|* Ableitung von SchViewShell fuer Drawing
|*
\************************************************************************/

class SchViewShell : public SfxViewShell
{
protected:
	BOOL			  bUserKnowsTranslation;
	SchView*          pChView;
	SchFuPoor*        pFuActual;
	SchFuPoor*        pFuOld;
	SchFuPoor*        pTempFuActual;
	SchChartDocShell* pDocSh;

	Table        aShellTable;              // fuer die ObjectBarShells
	USHORT       nCurrentObjectBar;        // ResourceID des aktuellen Object Bar
	BOOL         bObjectBarSwitchEnabled;  // zum Unterdruecken des Switchens
	Point        aMDPos;
	BOOL         bFirstStart;
	BOOL         bRepaintPossible;

			void Construct(SchChartDocShell& rDocSh);
	virtual void Activate(BOOL IsMDIActivate);
	virtual void Deactivate(BOOL IsMDIActivate);

	virtual void InnerResizePixel(const Point &rOfs, const Size &rSize);
	virtual void OuterResizePixel(const Point &rOfs, const Size &rSize);

	virtual Size GetOptimalSizePixel() const;

	virtual void SetZoomFactor(const Fraction& rZoomX, const Fraction& rZoomY);

public:
	TYPEINFO();

	SFX_DECL_VIEWFACTORY(SchViewShell);
	SFX_DECL_INTERFACE(SCH_IF_CHARTVIEWSHELL);

	SchViewShell(SfxViewFrame* pFrame, const SchViewShell& rShell);
	SchViewShell(SfxViewFrame* pFrame, Window* pParent);
	SchViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell);
	virtual ~SchViewShell();

	virtual SchView* GetView() const;

	virtual void PreparePrint(PrintDialog* pPrintDialog = 0);
	virtual USHORT Print(SfxProgress &rProgress, PrintDialog* pPrintDialog);
	virtual SfxPrinter* GetPrinter(BOOL bCreate = FALSE);
	virtual USHORT SetPrinter(SfxPrinter* pNewPrinter,
							  USHORT nDiffFlags = SFX_PRINTER_ALL);

	virtual USHORT PrepareClose(BOOL bUI = TRUE,BOOL b=FALSE); //#63638#

    // Mouse- & Key-Events
	virtual void Paint(const Rectangle& rRect);
	virtual FASTBOOL KeyInput(const KeyEvent& rKEvt);
	virtual FASTBOOL MouseMove(const MouseEvent& rMEvt);
	virtual FASTBOOL MouseButtonUp(const MouseEvent& rMEvt);
	virtual FASTBOOL MouseButtonDown(const MouseEvent& rMEvt);
	virtual FASTBOOL Command(const CommandEvent& rCEvt);

	virtual void Draw(OutputDevice &rDev, const Region &rReg) {}

	void    SetRepaintPossible (BOOL bNewRepaint) { bRepaintPossible = bNewRepaint; }
	void    SelectionHasChanged();

	void    GetMenuState(SfxItemSet &rSet);
	void    ExecStatusBar(SfxRequest& rReq);
	void    GetStatusBarState(SfxItemSet& rSet);
	void    GetAttrState(SfxItemSet &rSet);

	void    FuTemporary(SfxRequest &rReq);
	void    FuTemp2(SfxRequest &rReq);
	void    FuPermanent(SfxRequest &rReq);
	void    FuSupport(SfxRequest &rReq);
	void    Cancel();

	void    SetZoom(long nZoom);
	USHORT  SwitchObjectBar(USHORT nResId);
	USHORT  GetObjectBar() { return nCurrentObjectBar; }

#ifndef NOOLDSV
	void    DrawMarkRect(const Rectangle& rRect, const Pen& rPen);
	void    DrawFilledRect(const Rectangle& rRect, const Pen& rPen, const Brush& rFillInBrush) const;
#endif
	void    DrawMarkRect(const Rectangle& rRect, const Color& rColor );
	void    DrawFilledRect(const Rectangle& rRect, const Color& rColor, const Color& rFillColor ) const;

	void    ExecReq(SfxRequest& rReq);

	SchWindow* GetWindow() const { return (SchWindow*)SfxViewShell::GetWindow(); }
	void    SetMousePos (Point &rMDPos) { aMDPos = rMDPos; }

	SchChartDocShell* GetDocSh() const { return pDocSh; }
	
	// drag and drop
	virtual sal_Int8 AcceptDrop( const AcceptDropEvent& rEvt, SchWindow* pWin );
	virtual sal_Int8 ExecuteDrop( const ExecuteDropEvent& rEvt, SchWindow* pWin );
	
	virtual	BOOL HasUIFeature( ULONG nFeature );

private:
	/**	@descr	This item set is used as a reference to determine those items that 
			where changed by the	3D flyer.
	*/
	SfxItemSet	*	mp3DFlyerReference;

	/**
		@descr	Set the given item set to the given object.  Handle the
			necessary special cases, like clearing data point item sets when
			setting their row's item set.
		@param	pObject	The object whose item set is to be changed.  If this
			pointer is NULL, then nothing is done.
		@param	aSet	The item set that replaces the object's item set.
		@return	Inform the caller wether a call to BuildChart() is necessary to
			reflect the changes made by setting the item set.
		@note	defined in source/ui/view/viewshe1.cxx
	*/
	BOOL	SetItemSet	(SdrObject * pObject, const SfxItemSet & aSet)	const;

    /// listener for changes of the system clipboard
	TransferableClipboardListener* mpClipEvtLstnr;
    /// reflects if the current content of the system clipboard can be pasted
	BOOL			mbPastePossible;
    /// reflects if the current content of the system clipboard can be pasted in edit mode
	BOOL			mbTextPastePossible;

	DECL_LINK( ClipboardChanged, TransferableDataHelper* );
};



#endif          // _SCH_VIEWSHEL_HXX

