/*************************************************************************
 *
 *  $RCSfile: chaxis.cxx,v $
 *
 *  $Revision: 1.24.6.2 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:10:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ITEMID_DOUBLE           0
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#define ITEMID_CHARTDATADESCR   SCHATTR_DATADESCR_DESCR

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif

#ifndef _XPOLY_HXX //autogen
#include <svx/xpoly.hxx>
#endif

#include "itempool.hxx"

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _TOOLS_SOLMATH_HXX 
#include <tools/solmath.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _OUTLINER_HXX //autogen
#include <svx/svdoutl.hxx>
#endif
#ifndef _XLNCLIT_HXX
#include <svx/xlnclit.hxx>
#endif

#ifndef _XLNWTIT_HXX
#include <svx/xlnwtit.hxx>
#endif
#ifndef _XFLCLIT_HXX
#include <svx/xflclit.hxx>
#endif
#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif

#define ITEMID_FONT        EE_CHAR_FONTINFO
#define ITEMID_COLOR       EE_CHAR_COLOR
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT

#include <svx/fontitem.hxx>
#include <svx/fhgtitem.hxx>
#include <svx/colritem.hxx>
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif

#include "float.h"
#include "chaxis.hxx"
#include "pairs.hxx"
#include "chtmodel.hxx"
#include "glob.hrc"
#include "schresid.hxx"
#include "axisobj.hxx"
#include "globfunc.hxx"
#include	<algorithm>
#include	<limits>

void ChartAxis::SetDefaults()
{
	Font aLatinFont( OutputDevice::GetDefaultFont( DEFAULTFONT_LATIN_SPREADSHEET, mpModel->GetLanguage( EE_CHAR_LANGUAGE ), DEFAULTFONT_FLAGS_ONLYONE ) );
	SvxFontItem aSvxFontItem( aLatinFont.GetFamily(), aLatinFont.GetName(), aLatinFont.GetStyleName(), aLatinFont.GetPitch(),
		                      aLatinFont.GetCharSet(), EE_CHAR_FONTINFO );

	Font aCJKFont( OutputDevice::GetDefaultFont( DEFAULTFONT_CJK_SPREADSHEET, mpModel->GetLanguage( EE_CHAR_LANGUAGE_CJK ), DEFAULTFONT_FLAGS_ONLYONE ) );
	SvxFontItem aSvxFontItemCJK( aCJKFont.GetFamily(), aCJKFont.GetName(), aCJKFont.GetStyleName(), aCJKFont.GetPitch(),
		                         aCJKFont.GetCharSet(), EE_CHAR_FONTINFO_CJK );

	Font aCTLFont( OutputDevice::GetDefaultFont( DEFAULTFONT_CTL_SPREADSHEET, mpModel->GetLanguage( EE_CHAR_LANGUAGE_CTL ), DEFAULTFONT_FLAGS_ONLYONE ) );
	SvxFontItem aSvxFontItemCTL( aCTLFont.GetFamily(), aCTLFont.GetName(), aCTLFont.GetStyleName(), aCTLFont.GetPitch(),
		                         aCTLFont.GetCharSet(), EE_CHAR_FONTINFO_CTL );

	//	Attention!  If the size of the three fonts below is changed from 7pt to
	//	some other value, change also the font scaling in globfunc.cxx:ItemsToFont.
	mpAxisAttr->Put(aSvxFontItem);
	mpAxisAttr->Put(SvxFontHeightItem( 247, 100, EE_CHAR_FONTHEIGHT	));	// 7pt
	mpAxisAttr->Put(aSvxFontItemCJK);
	mpAxisAttr->Put(SvxFontHeightItem( 247, 100, EE_CHAR_FONTHEIGHT_CJK	));	// 7pt
	mpAxisAttr->Put(aSvxFontItemCTL);
	mpAxisAttr->Put(SvxFontHeightItem( 247, 100, EE_CHAR_FONTHEIGHT_CTL	));	// 7pt

	mpAxisAttr->Put(SvxColorItem(RGBColor(COL_BLACK)));
	mpAxisAttr->Put(XLineStyleItem(XLINE_SOLID));
	mpAxisAttr->Put(XLineWidthItem(0));
	mpAxisAttr->Put(XLineColorItem( String(), RGBColor(COL_BLACK)));
	mpAxisAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_TEXT_OVERLAP,FALSE));

	mpAxisAttr->Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_AUTO_MIN, TRUE));
	mpAxisAttr->Put(SvxDoubleItem(0.0, SCHATTR_AXIS_MIN));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_AUTO_MAX, TRUE));
	mpAxisAttr->Put(SvxDoubleItem(0.0, SCHATTR_AXIS_MAX));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_AUTO_STEP_MAIN, TRUE));
	mpAxisAttr->Put(SvxDoubleItem(0.0, SCHATTR_AXIS_STEP_MAIN));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_AUTO_STEP_HELP, TRUE));
	mpAxisAttr->Put(SvxDoubleItem(0.0, SCHATTR_AXIS_STEP_HELP));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM, FALSE));
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_AUTO_ORIGIN, (mnId==CHART_AXIS_Y)?FALSE:TRUE));
	mpAxisAttr->Put(SvxDoubleItem(0.0, SCHATTR_AXIS_ORIGIN));
	mpAxisAttr->Put(SfxInt32Item(SCHATTR_AXISTYPE, mnId));
	mpAxisAttr->Put(SfxInt32Item(SCHATTR_AXIS_TICKS, CHAXIS_MARK_OUTER));
	ShowAxis(TRUE);
	ShowDescr(TRUE);

}
void ChartAxis::SetAttributes(const SfxItemSet &rAttr)
{
	mpAxisAttr->Put(rAttr);

	//Erst immer Auto-attr holen, damit evtl. berechnete Werte nicht berschrieben werden.
	ReadAutoAttr();
	ReadAttr();
};
void ChartAxis::SetAttributes(SfxItemSet *pSet)
{
	if(pSet)
		SetAttributes(*pSet);
};
ChartAxis::~ChartAxis()
{
	if(mpTotal)
		delete [] mpTotal;

	if(mpColStack)
		delete [] mpColStack;

	delete mpAxisAttr;
	mpAxisAttr=NULL;
	mpModel=NULL;
	if(mpTextAttr)
		delete mpTextAttr;
}

ChartAxis::ChartAxis(ChartModel* pModel,long nId,long nUId) :
	mnInnerPos(-1),
	mbInnerPos(FALSE),
	mbCenterText(FALSE),
	mbColText(FALSE),
	mnUId(nUId),
	mbAlternativIdUsed(FALSE),
	mnAlternateId(0),
	mnTickLen(150),
	mnHelpTickLen(100),
	mpAxisList(NULL),
	mpAxisObj(NULL),
	mbSecondary(FALSE),
	mpGridAttr(NULL),
	mpTextAttr(NULL),
	mpNumFormatter(NULL),
	mpModel(pModel),
	mbPercent(FALSE),
	mbRadial(FALSE),
	mpAxisAttr(NULL),
	mnId(nId),
	mbFlippedXY(FALSE),
	mnPosition(0),
	maArea(0,0,0,0),
	mfMin(0.0),
	mfMax(0.0),
	mfStep(0.0),
	mfStepHelp(0.0),
	mfOrigin(0.0),
	mbAutoMin(FALSE),
	mbAutoMax(FALSE),
	mbAutoOrigin(FALSE),
	mbAutoStep(FALSE),
	mbAutoStepHelp(FALSE),
	mbLogarithm(FALSE),
    meTextOrient( CHTXTORIENT_AUTOMATIC ),
	mnTotalSize(0),
	mpTotal(NULL),
	mbTotalActual(FALSE),
	mbTotalAlloc(FALSE),
	mbColStackOK(FALSE),
	mpColStack(NULL),
	mbShowDescr(FALSE),
	mnTicks(CHAXIS_MARK_OUTER),
	mnHelpTicks(0),
	mbPercentCol(TRUE),
	mnMaxTextWidth(-1)
{
	mpAxisAttr=new SfxItemSet(mpModel->GetPool(),nAxisWhichPairs);
	SetDefaults();  //attribute fuellen
	ReadAutoAttr(); //automatik? aus ItemSet holen
	ReadAttr();		//evtl. defaults aus Itemset uebernehmen (etwas Overhead, aber sicher)
}

long ChartAxis::GetUpper(double fData,BOOL bConstrained)
{
	long nData;
	if(fData < mfOrigin)
		nData = GetPos(mfOrigin);
	else
		nData = GetPos(fData);

	if(!bConstrained)
		return nData;

	if(IsVertical())
		return Max(maRefArea.Top(),nData);
	else
		return Min(maRefArea.Right(),nData);
}
long ChartAxis::GetLower(double fData,BOOL bConstrained)
{
	long nData;

	if(fData > mfOrigin)
		nData = GetPos(mfOrigin);
	else
		nData = GetPos(fData);

	if(!bConstrained)
		return nData;

	if(IsVertical())
		return Min(maRefArea.Bottom(),nData);
	else
		return Max(maRefArea.Left(),nData);
}
Pair ChartAxis::Stack(double fData,BOOL bConstrained)
{
	double fTop,fBottom;

	if (fData < 0.0)//mfOrigin
	{
		fTop = mfDataBottom;
			mfDataBottom += fData;
		fBottom = mfDataBottom;
	}
	else
	{
		fBottom = mfDataTop;
			mfDataTop += fData;
		fTop = mfDataTop;
	}

	if(bConstrained)
	{
		if(IsVertical())
			return Pair(Max(maRefArea.Top(),GetPos(fTop))
					  , Min(maRefArea.Bottom(),GetPos(fBottom)) );
		else
			return Pair(Max(maRefArea.Left(),GetPos(fBottom))
					   ,Min(maRefArea.Right(),GetPos(fTop))     );
	}
	else
	{
		return Pair(GetPos(fTop),GetPos(fBottom));
	}
}
BOOL ChartAxis::IsVertical()
{
	return( (mnId==CHART_AXIS_Y && !mbFlippedXY)
		  ||(mnId==CHART_AXIS_X && mbFlippedXY));
}


void ChartAxis::ResizeTotal(long nSize)
{
	if(nSize && !mbTotalAlloc)
	{
		if(nSize!=mnTotalSize)
		{
			if(mpTotal)
				delete [] mpTotal;
			mnTotalSize = nSize;
			mpTotal = new double[mnTotalSize];
		}

		while(nSize--)
			mpTotal[nSize]=0.0;
	}
	mbTotalAlloc=TRUE;
};
double ChartAxis::Data2Percent(double fData,long nCol,long nRow)
{
	double fTotal=GetTotal( mbPercentCol ? nCol : nRow);

	return fTotal ? ( (fabs(fData) / fTotal) * 100.0 ) : DBL_MIN;
}
double ChartAxis::GetTotal(long n)
{
	if(!mbTotalActual)
		CreateTotal();

	return mpTotal[n];
}
void ChartAxis::CreateTotal()
{
	if(mbTotalActual)
		return ;

	double fData;

	long nColCnt=mpModel->GetColCount();
	long nRowCnt=mpModel->GetRowCount();


	if(mbPercentCol) //Prozent auf Datenreihe beziehen!
	{
		ResizeTotal(nColCnt); //Array anlegen und auf 0.0 setzen
	}
	else
	{
		ResizeTotal(nRowCnt); //Array anlegen und auf 0.0 setzen
	}


	long nId,nCol;
	for(long nRow=0;nRow<nRowCnt;nRow++)
	{
		nId=((const SfxInt32Item &)(mpModel->GetDataRowAttr(nRow).Get(SCHATTR_AXIS))).GetValue();
		if(nId==mnUId)
		{
			for(nCol=0;nCol<nColCnt;nCol++)
			{
				fData=mpModel->GetData(nCol,nRow);
				mpTotal[ mbPercentCol ? nCol : nRow] += fabs(fData);
			}
		}
	}
	mbTotalActual=TRUE; //einmal und nie wieder (whrend eines BuildChart zumindest)
};

void ChartAxis::AdjustOrigin()
{
	if (mfMax > 0.0)
	{
		if (mfMin > 0.0)
		{
			mfOrigin = mfMin;
		}
		else
		{
			mfOrigin = 0.0;
		}
	}
	else
	{
		mfOrigin = mfMax;
	}
}
BOOL ChartAxis::IsOriginInRange() const
{
	return  ((mfMin <= mfOrigin) && (mfOrigin <= mfMax));
}

// Stapeln der Werte je Col (fr Liniencharts)
void ChartAxis::InitColStacking(long nColCnt)
{


	if(mpColStack)
		delete [] mpColStack;
	mpColStack=new double[nColCnt];
	while(nColCnt--)
		mpColStack[nColCnt]=0.0;//mfOrigin ????;
}
//Stapeln der Werte je Column (Stapeln bei LinienCharts)
double ChartAxis::StackColData(double fData,long nCol,long nColCnt)
{
	if(!mbColStackOK)
		InitColStacking(nColCnt);//falls noch nicht geschehen
	mbColStackOK=TRUE;//wird bei Initialise auf FALSE gesetzt

	mpColStack[nCol]+=fData;
	return mpColStack[nCol];
}
//Dies Funktion wird u.A. von Initialise gerufen (sehr frh im Buildvorgang)
//Attribute innerer Schleifen (CretaeMarks, etc.) knnen hier in Variablen
//gewandelt werden
void ChartAxis::ReadAttr()
{

	//Art der Markierungen (innen/aussen)
	mnTicks     = ((const SfxInt32Item&)mpAxisAttr->Get(SCHATTR_AXIS_TICKS)).GetValue();
	mnHelpTicks = ((const SfxInt32Item&)mpAxisAttr->Get(SCHATTR_AXIS_HELPTICKS)).GetValue();

	long nFak = IsVertical() ? -1 : 1;
	if(mbSecondary)
		nFak*=-1;

	long nHelpFak=nFak;

	mnTickLen=nFak*150;
	mnHelpTickLen=nHelpFak*100;

	// WICHTIG! Diese Methode darf keine Member, die Automatisch sind, ueberschreiben!
	if (!mbAutoMin)
		if ((mbLogarithm && (((const SvxDoubleItem&) mpAxisAttr->Get(SCHATTR_AXIS_MIN)).GetValue() != 0.0)) || !mbLogarithm)
		mfMin   =((const SvxDoubleItem&) mpAxisAttr->Get(SCHATTR_AXIS_MIN)).GetValue();
	if (!mbAutoMax)
		mfMax   =((const SvxDoubleItem&) mpAxisAttr->Get(SCHATTR_AXIS_MAX)).GetValue();
	if (!mbAutoOrigin)
		mfOrigin=((const SvxDoubleItem&) mpAxisAttr->Get(SCHATTR_AXIS_ORIGIN)).GetValue();
	if(!mbAutoStep)
		mfStep  =((const SvxDoubleItem&) mpAxisAttr->Get(SCHATTR_AXIS_STEP_MAIN)).GetValue();
	if(!mbAutoStepHelp)
		mfStepHelp=((const SvxDoubleItem&) mpAxisAttr->Get(SCHATTR_AXIS_STEP_HELP)).GetValue();

}

void ChartAxis::ReadAutoAttr() //OK
{
	mbLogarithm    = ((const SfxBoolItem&) mpAxisAttr->Get(SCHATTR_AXIS_LOGARITHM)).GetValue();
	mbAutoStep     = ((const SfxBoolItem&) mpAxisAttr->Get(SCHATTR_AXIS_AUTO_STEP_MAIN)).GetValue();
	mbAutoStepHelp = ((const SfxBoolItem&) mpAxisAttr->Get(SCHATTR_AXIS_AUTO_STEP_HELP)).GetValue();
	mbAutoMin      = ((const SfxBoolItem&) mpAxisAttr->Get(SCHATTR_AXIS_AUTO_MIN)).GetValue();
	mbAutoMax      = ((const SfxBoolItem&) mpAxisAttr->Get(SCHATTR_AXIS_AUTO_MAX)).GetValue();
	mbAutoOrigin   = ((const SfxBoolItem&) mpAxisAttr->Get(SCHATTR_AXIS_AUTO_ORIGIN)).GetValue();
}

//ToDo: dies Fkt. ueberfluessig machen
void ChartAxis::ReadMembers(const ChartAxis& other)
{
	mfMin=other.mfMin;
	mfMax=other.mfMax;
	mfStep=other.mfStep;
	mfStepHelp=other.mfStepHelp;
	mfOrigin=other.mfOrigin;
}

/* ************************************************************************
|*
|* Minimum und Maximum berechnen, Wertebereich
|*
|* ToDo: Dies Methode muss komplett auf Verbundcharts umgestellt werden,
	Damit faellt meStackMode weg, es muss fuer jede Reihe geprueft werden,
	wie diese gezeichnet werden soll!
\*********************************************************************** */
inline double ChartAxis::GetRowError(long nRow)
{
   switch((SvxChartKindError)((const SfxInt32Item &)mpModel->GetDataRowAttr(nRow).Get(SCHATTR_STAT_KIND_ERROR)).GetValue())
	{
		case CHERROR_VARIANT :
			return mpModel->GetVariantY(nRow);
			break;

		case CHERROR_SIGMA :
			return mpModel->GetSigmaY(nRow);
			break;

		case CHERROR_BIGERROR :
			return mpModel->GetBigErrorY(nRow,
				((const SvxDoubleItem &)mpModel->GetDataRowAttr(nRow).Get(SCHATTR_STAT_BIGERROR)).GetValue());
			break;

		default :
		  break;
	}
   return 0.0;
}
inline BOOL ChartAxis::IsDataOnAxis(long nRow)
{
	return(mnUId == ((const SfxInt32Item &)mpModel->GetDataRowAttr(nRow)
		.Get(SCHATTR_AXIS)).GetValue()) ;
}

BOOL ChartAxis::GetMinMaxFromData()
{
	BOOL bOK=FALSE;

	long   nColCnt = mpModel->GetColCount();
	long   nRowCnt = mpModel->GetRowCount();
	long   nCol,nRow;

	BOOL bInitialise=TRUE; //statt dem nCol=0&&nRow=0-Unsinn, damit ungltige Daten bercksichtigt werden

	double fMin = 0.0;
	double fMax = 0.0;

	//Verbundchart Typ 2, letzte Reihe ist Linie, nach switch(meStackMode)
	//folgt dann die beruecksichtigung dieser Linie
	long nLines = Min((long)mpModel->GetNumLinesColChart(),(long)(nRowCnt-1));;//#50212#

	if(mpModel->ChartStyle() == CHSTYLE_2D_LINE_STACKEDCOLUMN)
		nRowCnt-=nLines;
	else
		nLines=0;

	switch (meStackMode)
	{
		//Min = Min(0,Summe aller negativen Daten)
		//Max = Max(0,Summe aller positiven Daten)
		case CHSTACK_MINMAX:
			for (nCol = 0; nCol < nColCnt; nCol++)
			{
				double fMinTotal = 0.0;
				double fMaxTotal = 0.0;

				for (nRow = 0; nRow < nRowCnt; nRow++)
				{

					if(IsDataOnAxis(nRow))
					{
						bOK=TRUE;

						double fData = GetData(nCol, nRow);//mpModel->GetData(nCol, nRow, mbPercent);

						if (fData != DBL_MIN)
							if (fData < 0.0)
								fMinTotal += fData;
							else if (fData > 0.0)
								fMaxTotal += fData;
					}
				}

				if (nCol == 0) //nicht gut, aber hier kann man sowas machen, irgendne Reihe hat Daten!
				{
					fMin = fMinTotal;
					fMax = fMaxTotal;
				}
				else
				{
					if (fMin > fMinTotal)
						fMin = fMinTotal;
					if (fMax < fMaxTotal)
						fMax = fMaxTotal;
				}
			}
			break;

		//Min = Min(0,Min(Daten))
		//Max = Max(0,Summe aller Daten)
		case CHSTACK_OVERLAP:
			for (nCol = 0; nCol < nColCnt; nCol++)
			{
				double fTotal = 0.0;

				for (nRow = 0; nRow < nRowCnt; nRow++)
				{
					if(IsDataOnAxis(nRow))
					{
						bOK=TRUE;

						double rTemp = GetData(nCol, nRow);//mpModel->GetData(nCol, nRow, mbPercent);

						if (rTemp != DBL_MIN)
						{
							if(fMin > rTemp)
							   fMin = rTemp;
							fTotal += rTemp;
						}
					}
				}

				if(fMax < fTotal)
				   fMax = fTotal;
			}
			break;

		default:
			if (mpModel->IsXYChart ())
			{
				if(mnId == CHART_AXIS_X)
				{
					// here: x axis values are in row 0, so just iterate over col
					for( nCol = 0; nCol < nColCnt; nCol++ )
					{
						double fData = GetData( nCol, 0 );

						if (fData != DBL_MIN)
							if (nCol == 0)    //naja, so eigentlich nicht.... aber die X-Achse sollte eh vollstndig sein
							{
								fMin = fData;
								fMax = fData;
							}
							else
							{
								//if ((fMin > fData) && !mbLogarithm || (fData > 0.0) && mbLogarithm)
								if( (fMin > fData)
								&& (!mbLogarithm || fData > 0.0) )
									fMin = fData;

								if (fMax < fData)
									fMax = fData;
						   }
					}
				}
				else // y axis
				{
					// #69912# use x axis range for determining the auto values for y axis
					ChartAxis* pXAxis = mpModel->GetAxisByUID( CHART_AXIS_PRIMARY_X );
					double fXMin = pXAxis->GetMin();
					double fXMax = pXAxis->GetMax();

					// set min and max to 0/1 resp. in case the x range is empty
					fMin = 0.0;
					fMax = 1.0;

					for (nRow = 1; nRow < nRowCnt; nRow++)
					{
						//if(IsDataOnAxis(nRow)) //#63904#: 2,77%
						const SfxItemSet& rDataRowAttr = mpModel->GetDataRowAttr(nRow);
						if(mnUId == ((const SfxInt32Item &)rDataRowAttr.Get(SCHATTR_AXIS)).GetValue())
						{
							bOK=TRUE;

							double fDiffUp   = 0.0;
							double fDiffDown = 0.0;
							fDiffUp=fDiffDown=GetRowError(nRow); // rm1

							for (nCol = 0; nCol < nColCnt; nCol++)
							{
								// #69912#
								double xVal = GetData( nCol, 0 );
								if( fXMin <= xVal && xVal <= fXMax )
								{
									double fData    = GetData( nCol, nRow );

									if (fData != DBL_MIN)
									{
										double fDataMin = fData;
										double fDataMax = fData;

										//#63904#neu:	(18.8 ms ->  7.28 ms )
//										SfxItemSet aDataPointAttr(rDataRowAttr);
//										mpModel->MergeDataPointAttr(aDataPointAttr,nCol, nRow);
//									SfxItemSet aDataPointAttr(mpModel->GetFullDataPointAttr(nCol, nRow));//#63904#71% 69,66%
										const SfxItemSet * pDataPointItemSet = mpModel->GetRawDataPointAttr (nCol,nRow);
										BOOL bDataPointItemSetValid = (pDataPointItemSet!=NULL);

										switch (static_cast<SvxChartKindError>(
											static_cast<const SfxInt32Item&>(sch::GetItem(
												SCHATTR_STAT_KIND_ERROR, 
												rDataRowAttr,
												*pDataPointItemSet, bDataPointItemSetValid)).GetValue ()))
										{
											case CHERROR_PERCENT :
												fDiffUp   =
													fDiffDown = fData * static_cast<const SvxDoubleItem&>(sch::GetItem(
														SCHATTR_STAT_PERCENT,
														rDataRowAttr,
														*pDataPointItemSet, bDataPointItemSetValid)).GetValue ()
														/ 100.0;
												break;

											case CHERROR_CONST :
												fDiffUp   = fData + static_cast<const SvxDoubleItem&>(sch::GetItem(
														SCHATTR_STAT_CONSTPLUS,
														rDataRowAttr,
														*pDataPointItemSet, bDataPointItemSetValid)).GetValue ();
												fDiffDown = fData + static_cast<const SvxDoubleItem&>(sch::GetItem(
														SCHATTR_STAT_CONSTMINUS,
														rDataRowAttr,
														*pDataPointItemSet, bDataPointItemSetValid)).GetValue ();
												break;

											default :
												;
										}

										switch (static_cast<SvxChartIndicate>(
											static_cast<const SfxInt32Item&>(sch::GetItem(
												SCHATTR_STAT_INDICATE, 
												rDataRowAttr,
												*pDataPointItemSet, bDataPointItemSetValid)).GetValue ()))
										{
											case CHINDICATE_BOTH :
												fDataMin -= fDiffDown;
												fDataMax += fDiffUp;
												break;

											case CHINDICATE_UP :
												fDataMax += fDiffUp;
												break;

											case CHINDICATE_DOWN :
												fDataMin -= fDiffDown;
												break;

											case CHINDICATE_NONE :
											default :
												;
										}


										//if ((nCol == 0) && (nRow == 1)) //und wenn hier mal DBL_MIN steht????
										if(bInitialise)
										{
											bInitialise=FALSE;
											fMin = fDataMin;
											fMax = fDataMax;
										}
										else
										{
											if ( (fMin > fDataMin)
												 && (!mbLogarithm || fDataMin > 0.0) )
												fMin = fDataMin;

											if (fMax < fDataMax)
												fMax = fDataMax;
										}
									}
								}
							}
						}
					}
				}
			}
			else // ! XY-Chart ... Hier landen auch die StockCharts
			{
				for (nRow = 0; nRow < nRowCnt; nRow++)
				{
					//if(IsDataOnAxis(nRow)) //#63904#neu:
					const SfxItemSet& rDataRowAttr = mpModel->GetDataRowAttr(nRow);
					if(mnUId == ((const SfxInt32Item &)rDataRowAttr.Get(SCHATTR_AXIS)).GetValue())
					{
						bOK=TRUE;

						double fDiffUp   = 0.0;
						double fDiffDown = 0.0;

						fDiffUp=fDiffDown=GetRowError(nRow);//rm3

						for (nCol = 0; nCol < nColCnt; nCol++)
						{
							double fData    = GetData(nCol, nRow);

							if (fData != DBL_MIN)
							{
								double fDataMin = fData;
								double fDataMax = fData;

								//#63904#
//								SfxItemSet aDataPointAttr(rDataRowAttr);
//								mpModel->MergeDataPointAttr(aDataPointAttr,nCol, nRow);
								//SfxItemSet aDataPointAttr(mpModel->GetFullDataPointAttr(nCol, nRow));
								const SfxItemSet * pDataPointItemSet = mpModel->GetRawDataPointAttr (nCol,nRow);
								BOOL bDataPointItemSetValid = (pDataPointItemSet!=NULL);

								switch (static_cast<SvxChartKindError>(
									static_cast<const SfxInt32Item&>(sch::GetItem(
										SCHATTR_STAT_KIND_ERROR, 
										rDataRowAttr,
										*pDataPointItemSet, bDataPointItemSetValid)).GetValue ()))
								{
									case CHERROR_PERCENT :
										fDiffUp   =
										fDiffDown = fData * static_cast<const SvxDoubleItem&>(sch::GetItem(
												SCHATTR_STAT_PERCENT,
												rDataRowAttr,
												*pDataPointItemSet, bDataPointItemSetValid)).GetValue ()
												/ 100.0;
										break;

									case CHERROR_CONST :
										fDiffUp   = fData + static_cast<const SvxDoubleItem&>(sch::GetItem(
												SCHATTR_STAT_CONSTPLUS,
												rDataRowAttr,
												*pDataPointItemSet, bDataPointItemSetValid)).GetValue ();
										fDiffDown = fData + static_cast<const SvxDoubleItem&>(sch::GetItem(
												SCHATTR_STAT_CONSTMINUS,
												rDataRowAttr,
												*pDataPointItemSet, bDataPointItemSetValid)).GetValue ();
										break;

									default :
										;
								}

								switch (static_cast<SvxChartIndicate>(
									static_cast<const SfxInt32Item&>(sch::GetItem(
										SCHATTR_STAT_INDICATE, 
										rDataRowAttr,
										*pDataPointItemSet, bDataPointItemSetValid)).GetValue ()))
								{
									case CHINDICATE_BOTH :
										fDataMin -= fDiffDown;
										fDataMax += fDiffUp;
										break;

									case CHINDICATE_UP :
										fDataMax += fDiffUp;
										break;

									case CHINDICATE_DOWN :
										fDataMin -= fDiffDown;
										break;

									case CHINDICATE_NONE :
									default :
									   ;
								}

								//if ((nCol == 0) && (nRow == 0))//und wenn hier mal DBL_MIN steht????
								if(bInitialise)
								{
									bInitialise=FALSE;
									fMin = fDataMin;
									fMax = fDataMax;
								}
								else
								{
									if ((fMin > fDataMin)
									&& (!mbLogarithm ||(fDataMin > 0.0)))
										fMin = fDataMin;
									if (fMax < fDataMax)
										fMax = fDataMax;
								}
							}
						}
					}
				}
			}

		break;
	}//switch meStackMode


	// bei CHSTYLE_2D_LINE_STACKEDCOLUMN muessen die Linien nochmal extra berechnet
	// werden Letzte Linie = nRowCnt, da oben nRowCnt-=n   #50212#
	long nIndex=nRowCnt;//ab hier liegen evtl. linien vor
	while(nLines)       //nLines ist 0 wenn kein CHSTYLE_2D_LINE_STACKEDCOLUMN
	{

		if(IsDataOnAxis(nIndex))
			UpdateRowMinMax(nIndex,nColCnt,mbPercent);
		nLines--;
		nIndex++;//naechste Linie
	}
	if (mbPercent)
	{
		fMin = 0.0;
		if (fMax > 100.0)
			fMax = 100.0;
	}

    if( mbAutoMin )
        mfMin = fMin;

    if( mbAutoMax )
        mfMax = fMax;

	return bOK;
}

//Ab jetzt wird die Achse gebaut, die meisten Werte  knnen nicht mehr gendert werden,
//da wir uns im BuildChart (genauer: zumeist in Create<n>DBackplanes) befinden.
//allerdings wird die Area noch verndert. Davn unabhngige Werte, z.B. Items knnen
//in Variablen gebuffert werden
void ChartAxis::Initialise(const Rectangle &rRect,BOOL bFlippedXY
						   ,long eStackmode,BOOL bPercent
						   ,BOOL bRadial,BOOL bPercentCol)

{
	mnMaxTextWidth=-1;
	mbInnerPos=FALSE;
	mbAlternativIdUsed=FALSE;
	mbTextOverlap= ((const SfxBoolItem&)mpAxisAttr->Get(SCHATTR_TEXT_OVERLAP)).GetValue();
	mbPercentCol=bPercentCol;
	mbPercent=bPercent;
	maArea=rRect;
	mbFlippedXY=bFlippedXY;
	meStackMode=eStackmode;
	mbRadial=bRadial;
	mbShowDescr=HasDescription();

	mbColStackOK=FALSE;     //noch nix gestapelt, noch nicht initialisiert
	mbTotalActual=FALSE; //anzahl cols/daten knnten verndert sein!
	mbTotalAlloc =FALSE; //anzahl cols/daten knnten verndert sein!

	mpMainGridList=NULL;
	mpHelpGridList=NULL;
	mpAxisList=NULL;

	//Atribute auslesen, etwas Overhead, ToDo: optimieren
	ReadAutoAttr();
	ReadAttr();
	// #84601# set Min/Max etc. at the local item set!
	if( mpAxisAttr )
		GetMembersAsAttr( *mpAxisAttr );
};

void ChartAxis::GetMembersAsAttr(SfxItemSet& rSet) const
{
	rSet.Put(SfxUInt32Item(SID_ATTR_NUMBERFORMAT_VALUE,((ChartAxis*)this)->GetNumFormat()));
	rSet.Put(SvxDoubleItem(mfMin		, SCHATTR_AXIS_MIN));
	rSet.Put(SvxDoubleItem(mfMax		, SCHATTR_AXIS_MAX));
	rSet.Put(SvxDoubleItem(mfStep		, SCHATTR_AXIS_STEP_MAIN));
	rSet.Put(SvxDoubleItem(mfStepHelp	, SCHATTR_AXIS_STEP_HELP));
	rSet.Put(SvxDoubleItem(mfOrigin		, SCHATTR_AXIS_ORIGIN));
}

void ChartAxis::CalcMinMaxValue()
{

	if (mbAutoMin || mbAutoMax) //Dann alle Werte generieren
	{
		if(!GetMinMaxFromData() && mnAlternateId && /*#63904#:*/(IsVisible()||HasDescription()))
		{
			long tmp=mnUId;
			mnUId=mnAlternateId;
			GetMinMaxFromData();
			mbAlternativIdUsed=TRUE;
			mnUId=tmp;
		}
	}

	if (mfMin > mfMax) //ToDo: Korrektur, sollte aber ueberfluessig sein
	{
		double fTemp = mfMin;
		mfMin=mfMax;
		mfMax=fTemp;
	}

	ReadAttr();    //Alle nicht-automatischen Wertze werden jetzt geholt

	if ((mfMin != DBL_MIN) || (mfMax != DBL_MIN))
	{
		if (mfMin > mfMax) //noch ne Korrektur, diese ist aber noetig!
		{
            if( mbAutoMax )
                mfMax = mfMin;
            else if( mbAutoMin )
                mfMin = mfMax;
            else
            {
                DBG_ERROR( "Minimum is greater than Maximum" );
                double fTemp = mfMin;

                mfMin = mfMax;
                mfMax = fTemp;
            }
		}

		if (mbLogarithm)
		{
			if (mbAutoMin)
			{
				if (mfMin > 1.0)
				{
					double fVal = 1.0;

					while (fVal < mfMin)
						fVal *= 10.0;

					if (fVal > mfMin) fVal /= 10.0;
					mfMin = fVal;
				}
				else if (mfMin > 0.0)
					 {
						 double fVal = 1.0;

						 while (fVal > mfMin)
							 fVal /= 10.0;

						 mfMin = fVal;
					 }
					 else mfMin = 1.0;
			}

			if (mbAutoMax)
			{
				if (mfMax > 1.0)
				{
					double fVal = 1.0;

					while (fVal < mfMax)
						fVal *= 10.0;

					mfMax = fVal;
				}
				else if (mfMax > 0.0)
					 {
						 double fVal = 1.0;

						 while (fVal > mfMax)
							 fVal /= 10.0;

						 if (fVal < mfMax) fVal *= 10.0;
						 mfMax = fVal;
					 }
					 else mfMax = 1.0;
			}

			if (mfMax - mfMin == 0.0) mfMax = mfMin * 10.0;
			if (mfOrigin != mfMin) mfOrigin = mfMin;
		}
		else
		{
			if (!mpModel->IsNegativeChart() && (mfMin < 0.0) ||
				mbAutoMin && (mfMin > 0.0)) mfMin = SizeBounds (mfMin, mfMax, FALSE);
			if (mbAutoMax && (mfMax < 0.0)) mfMax = SizeBounds (mfMin, mfMax, TRUE);

			if (mfMax - mfMin == 0.0) mfMax = mfMin + 1.0;

			if (mbAutoOrigin)
			{
				mfOrigin = 0.0;
				if (mfOrigin < mfMin) mfOrigin = mfMin;
				else if (mfOrigin > mfMax) mfOrigin = mfMax;
			}
			else
			{
				if (mfOrigin < mfMin) mfMin = mfOrigin;
				if (mfOrigin > mfMax) mfMax = mfOrigin;
			}
		}
	}
}

/* ************************************************************************
|*
|* Faktor fuer Koordinaten-Multiplikation berechnen
|* abart der globalen Funktion mit den ChartAxis-Membervariablen
|*
\*********************************************************************** */
void ChartAxis::LoadMemberCompat(SvStream& rIn)
{
	rIn >> mfMin;
	rIn >> mfMax;
	rIn >> mfStep;
	rIn >> mfStepHelp;
	rIn >> mfOrigin;


	mpAxisAttr->Put(SvxDoubleItem(mfMin		, SCHATTR_AXIS_MIN));
	mpAxisAttr->Put(SvxDoubleItem(mfMax		, SCHATTR_AXIS_MAX));
	mpAxisAttr->Put(SvxDoubleItem(mfStep		, SCHATTR_AXIS_STEP_MAIN));
	mpAxisAttr->Put(SvxDoubleItem(mfStepHelp	, SCHATTR_AXIS_STEP_HELP));
	mpAxisAttr->Put(SvxDoubleItem(mfOrigin		, SCHATTR_AXIS_ORIGIN));

	CHART_TRACE2( "ChartAxis::LoadMemberCompat min=%lf, max=%lf", mfMin, mfMax );
	CHART_TRACE3( "... step=%lf, help=%lf, origin=%lf", mfStep, mfStepHelp, mfOrigin );
}

void ChartAxis::StoreMemberCompat(SvStream& rOut) const
{
	rOut << mfMin;
	rOut << mfMax;
	rOut << mfStep;
	rOut << mfStepHelp;
	rOut << mfOrigin;
}
//ToDo: nLen ist maArea.Width(),Height, oder das ganze bei NetChart /2 (vermutlich)
long ChartAxis::GetLength() const
{
	if(mbRadial)//&& Achse=Y (ist aber immer so bei NetCharts)
		return maArea.GetHeight () / 2;

	switch(mnId)
	{
		case CHART_AXIS_X:
			return mbFlippedXY ? maArea.GetHeight() : maArea.GetWidth();
			break;
		case CHART_AXIS_Y:
			return mbFlippedXY ? maArea.GetWidth() : maArea.GetHeight();
			break;
		case CHART_AXIS_Z:
			return (maArea.GetWidth() * 4) / 6; //ToDo: Das hier ist doch quark... kein Flipped?:;
			break;
	}
	DBG_ERROR("ChartAxis::GetLenght() implementation error - ZAxis failure");
	return maArea.GetWidth();
}




/**
	@descr	Calculate the size of the bounding box of a text string.  The size 
			is measured with respect to the coordinate axes.
	
	@param	rTextAttr	Attributes of the font to use.
	@param	aString		The "typical" description.
	
	@return	Returns the size of the bounding box of the text.
*/
Size	ChartAxis::CalcDescriptionSize	(const SfxItemSet * rTextAttr,
										const String & aString)
{
	//	Get output device, store old page size and set paper size to 
	//	maximal size to inhibit line breaks.
	Outliner	*	pOutliner = mpModel->GetOutliner();
	pOutliner->SetUpdateMode (FALSE);
	Size	aOldPaperSize (pOutliner->GetPaperSize());
	pOutliner->SetPaperSize (Size (100000,100000));	//	Maximal paper size ?

	//	Save first paragraphs attributes, switch off hyphenation, and
	//	set the font attributes.	
	SfxItemSet aOldAttr (pOutliner->GetParaAttribs(0));
	SfxItemSet aNewAttr	(aOldAttr);
	aNewAttr.Put (SfxBoolItem(EE_PARA_HYPHENATE, FALSE));
	aNewAttr.Put (*rTextAttr);
	mpModel->SetTextAttributes (aNewAttr);

    // synchronize item with member
	meTextOrient = ((const SvxChartTextOrientItem&)
		mpAxisAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue();
    //	Determine the size of the texts bounding box.
	if (meTextOrient == CHTXTORIENT_STACKED)
		pOutliner->SetText (StackString(aString), pOutliner->GetParagraph (0));
	else
		pOutliner->SetText(aString, pOutliner->GetParagraph (0));
	pOutliner->SetUpdateMode (TRUE);
	Size aSize = pOutliner->CalcTextSize();
    // remove content and attributes
    pOutliner->Clear();
	pOutliner->SetUpdateMode (FALSE);

	//	Restore the old font and old paper size.
	mpModel->SetTextAttributes (aOldAttr);
	pOutliner->SetPaperSize (aOldPaperSize);
	pOutliner->SetUpdateMode (TRUE);

	return (aSize);
}




/**
	@descr	Calculate the expected size of a "typical" description.  The size 
			is measured along the axis.  The axis orientation is taken into 
			account.
	@precond CalcMinMaxValue() has to have been called already.
	
	@param	rAttr	Attributes of the font to use.
	
	@return	Returns the size of the text projected onto the axis.
*/
long int	ChartAxis::CalcTypicalDescriptionSize	(const SfxItemSet * rAttr)
{
	String		aString;
	Color	*	pDummy = NULL;
	Size		aSize,
				aMaxSize;
	
	//	As typical text we use the minimum and maximum and some randomly
	//	chose value in between.  This relies on a previous call to 
	//	CalcMinMaxValue().
	mpNumFormatter->GetOutputString (mfMin, GetNumFormat(), aString, &pDummy);
	aMaxSize = CalcDescriptionSize (rAttr, aString);
	
	mpNumFormatter->GetOutputString (mfMax, GetNumFormat(), aString, &pDummy);
	aSize = CalcDescriptionSize (rAttr, aString);
	if (aSize.Width() > aMaxSize.Width())
		aMaxSize.Width() = aSize.Width();
	if (aSize.Height() > aMaxSize.Height())
		aMaxSize.Height() = aSize.Height();

	double	fPos = 0.53,	//	Arbitrary position between mfMin and mfMax.
			fValue = (1-fPos) * mfMin + fPos * mfMax;
	mpNumFormatter->GetOutputString (fValue, GetNumFormat(), aString, &pDummy);
	aSize = CalcDescriptionSize (rAttr, aString);
	if (aSize.Width() > aMaxSize.Width())
		aMaxSize.Width() = aSize.Width();
	if (aSize.Height() > aMaxSize.Height())
		aMaxSize.Height() = aSize.Height();

	//	Select the right coordinate and return it.
	if (IsVertical())
		return (aMaxSize.Height());
	else
		return (aMaxSize.Width());
}


/**
	@descr	Calculate the intervall delimited by mfMin and mfMax for which
			tick marks are drawn, its origin (mfOrigin), which is either zero
			if inside the intervall or mfMin or mfMax otherwise.  The 
			distance between two adjacent tick marks of the main grid is 
			stored into mfStep and the distance for the help grid into 
			mfStepHelp.
*/
void	ChartAxis::CalcValueSteps	(void)
{
	long nLen=GetLength();

	ReadAutoAttr(); //mbAuto* aus mpAxisAttr lesen

	CalcMinMaxValue(); //Min und Max bestimmen

	if (mfMax == DBL_MIN)
	{
		mfMax		=
		mfOrigin    =
		mfMin       =
		mfStep		=
		mfStepHelp  =  0.0;
	}
	else
	{
		double	fRange = mfMax-mfMin,
				fApproximateDescriptionSize 
					= 2.5 * CalcTypicalDescriptionSize(mpAxisAttr);
					//	former value: (mpModel->GetLineHeight(*mpAxisAttr) * 3)
		long	nMaxSteps = (long int)(nLen / fApproximateDescriptionSize);

		if (mbLogarithm)
		{
			if (mbAutoStep)
				mfStep = 10.0;
		}
		else
		{
			if (mbAutoStep)
			{
				//	Find smallest power of 10 lower than or equal to fRange,
				//	that scales fFactor into the interval [1,10].
				double	fFactor = pow (10, floor (log10 (fRange)));
				fRange /= fFactor;
				
				//	Calculate mfStep so that the number of divisions (nSteps)
				//	is 'not much' higher than nMaxSteps.  The value of nSteps
				//	is increased succesively to multiples of 2*10^k, 4*10^k, 
				//	5*10^k, and 10*10^k, with k>=0.
				long nSteps = 1;
				mfStep = 10.0;
				if (nSteps < nMaxSteps)
				{
					short nDepth = 0;

					do
					{
						if (nDepth % 4 == 2) mfStep = mfStep * 4.0 / 5.0;
						else mfStep /= 2.0;

						nSteps = (long)(fRange / mfStep);
						nDepth++;
					}
					while (nSteps < nMaxSteps);
				}
				else
				{
					if (mfStep > fRange)
					{
						short  nDepth = 0;
						double fStep  = mfStep;

						do
						{
							if (nDepth % 4 == 2) fStep = fStep * 4.0 / 5.0;
							else fStep /= 2.0;

							if (fStep >= fRange) mfStep = fStep;

							nDepth++;
						}
						while (fStep > fRange);
					}
				}
				mfStep *= fFactor;
				
				//	Special treatment for dates and times.
				short int	nNumberFormat = mpNumFormatter->GetType (
					GetNumFormat());
				BOOL		bIsDate = (nNumberFormat & NUMBERFORMAT_DATE) != 0;
				BOOL		bIsTime = (nNumberFormat & NUMBERFORMAT_TIME) != 0;
				//	At the moment the only special case is this:
				//	Dates without time are spaced whole days apart.
				if (bIsDate && ! bIsTime)
				{
					mfStep = ceil(mfStep);
					if (mfStep < 1)
						mfStep = 1;
				}
			}
			
            //	Make sure that the step width is positive and not equal to 
            //	zero.
			if ((mfStep<0) || (mfMin+mfStep==mfMin) || (mfMax+mfStep==mfMax))
			{
				DBG_ERROR( "Decrement of <= 0.0 not allowed" );
				mfStep = 1.0;			  // to prevent loop
			}

			if (mbAutoMin)
			{
				double fMin = 0.0;
				
				//	Adjust mfMin to the largest value that is lower than or
				//	equal to its current value and is an integer multiple of 
				//	mfSteps away of fMin.
				if (fMin > mfMin)
					mfMin = fMin - mfStep * ceil((fMin - mfMin) / mfStep);
				else if (fMin < mfMin)
					mfMin = fMin + mfStep * floor((mfMin - fMin) / mfStep);

				if ((mfMin >= 0.0) && (mfMin < mfOrigin))
					mfOrigin = mfMin;
			}

			if (mbAutoMax)
			{
				double fMax = 0.0;

				//	Adjust mfMax to the smallest value that is higher than or
				//	equal to its current value and is an integer multiple of 
				//	mfSteps away of fMax.
				if (fMax < mfMax)
					mfMax = fMax + mfStep * ceil((mfMax - fMax) / mfStep);
				else if (fMax > mfMax)
					mfMax = fMax - mfStep * floor ((fMax - mfMax) / mfStep);

				if ((mfMax <= 0.0) && (mfMax > mfOrigin))
					mfOrigin = mfMax;
			}
		}

		if(mbAutoStepHelp)
		{
			mfStepHelp = mbLogarithm ? (mfStep / 10) : (mfStep / 2);
		}
		VerifySteps();
	}

/*	//NetCharts, nur absolutwerte (was passiert bei gemischt ?)
	//Sollte sowas nicht vor die Berechnung der Steps?
	if (mbRadial)
	{
		mfMin = std::max (mfMin, 0);
		mfMax = std::max (mfMax, 0);
		if (mfMin > mfMax)
		{
			double fTemp = mfMin;

			mfMin = mfMax;
			mfMax = fTemp;
		}
	}
*/
}


void ChartAxis::VerifySteps()
{
	//#38835# Sicherheitsueberpruefung der Werte, es werden beide Achsen gleichbehandelt
	//Es sollte nur mit Double gerechnet werden da bei Fehlern der Bereich nicht reicht
	//(deshalb double nVarName,
	//ToDo: GetLenght benutzen! Wir kennen ja in dieser Klasse mittlerweile die Laenge

	double fRange=(mfMax - mfMin);

	double nLimit=Max(maArea.GetWidth(),maArea.GetHeight());

	if(nLimit < 0.0)
	{
		DBG_ERROR( "negative value for nLimit, check maArea!" );
		nLimit=1.0;
	}
	nLimit=nLimit/100.0; //Minimum 1 mm Abstand

	if(nLimit && !mbLogarithm)
	{
		if(mfStep!=0.0 )
		{
			double fSteps=fRange/mfStep;
			while(fSteps>nLimit)
			{
				mfStep*=10;
				fSteps=fRange / mfStep;
			}
		}
		nLimit*=10; //Min fuer Hilfsticks: 0,1 mm bzw. 10 Hilfsticks immer moeglich

		if(mfStepHelp!=0.0)
		{
			double fSteps=fRange/mfStepHelp;
			while(fSteps>nLimit)
			{
				mfStepHelp*=10;
				fSteps=fRange/mfStepHelp;
			}
		}
	}
}
long ChartAxis::GetPosConstrained(double fData)
{
	long nPos=GetPos(fData);

	if(IsVertical())
	{
		if(nPos < maRefArea.Top())
			return maRefArea.Top();
		if(nPos > maRefArea.Bottom())
			return maRefArea.Bottom();
	}
	else
	{
		if(nPos < maRefArea.Left())
			return maRefArea.Left();
		if(nPos > maRefArea.Right())
			return maRefArea.Right();
	}

	return nPos;
}

long ChartAxis::GetPos(double fData)
{
	switch(mnId)
	{
		case CHART_AXIS_X:
			if(mbFlippedXY)
				return maRefArea.Bottom() - (long)(CalcFact(fData) * maRefArea.GetHeight());
			else
				return maRefArea.Left()   + (long)(CalcFact(fData) * maRefArea.GetWidth());

		case CHART_AXIS_Y:
			if(!mbFlippedXY)
				return maRefArea.Bottom() - (long)(CalcFact(fData) * maRefArea.GetHeight());
			else
				return maRefArea.Left() +   (long)(CalcFact(fData) * maRefArea.GetWidth());

		case CHART_AXIS_Z:
			DBG_ERROR("ChartAxis - no z pos");
	}
	return 0;
}
BOOL ChartAxis::SetArea(const Rectangle &rRect)
{
	BOOL bRet=TRUE;
	if(rRect==maRefArea)
		bRet=FALSE;
	maRefArea=rRect;

	SetPosition(mbSecondary ? CHAXIS_POS_B :CHAXIS_POS_A);

#ifdef DBG_UTIL
	if(maArea!=maRefArea)
		DBG_TRACE("ChartAxis:: maArea!=maRefArea!!!");
#endif
	return bRet;
}

void ChartAxis::UpdateRowMinMax(const long nRow,const long nColCnt,const BOOL mbPercent)
{
	double fDiffUp   = 0.0;
	double fDiffDown = 0.0;
	long nCol;

	fDiffUp=fDiffDown=GetRowError(nRow); //rm2

	for (nCol = 0; nCol < nColCnt; nCol++)
	{
		double fData    = GetData(nCol, nRow);//mpModel->GetData(nCol, nRow, mbPercent);

		if (fData != DBL_MIN)
		{
			double fDataMin = fData;
			double fDataMax = fData;
			SfxItemSet aDataPointAttr(mpModel->GetFullDataPointAttr(nCol, nRow));//#63904#71%

			switch ((SvxChartKindError) ((const SfxInt32Item &) aDataPointAttr.
										 Get (SCHATTR_STAT_KIND_ERROR)).GetValue ())
			{
				case CHERROR_PERCENT :
					fDiffUp   =
					fDiffDown = fData * ((const SvxDoubleItem &) aDataPointAttr.
										 Get (SCHATTR_STAT_PERCENT)).GetValue () / 100.0;
					break;

				case CHERROR_CONST :
					fDiffUp   = fData + ((const SvxDoubleItem &) aDataPointAttr.
										 Get (SCHATTR_STAT_CONSTPLUS)).GetValue ();
					fDiffDown = fData + ((const SvxDoubleItem &) aDataPointAttr.
										Get (SCHATTR_STAT_CONSTMINUS)).GetValue ();
					break;

				default :
					;
			}

			switch ((SvxChartIndicate) ((const SfxInt32Item &) aDataPointAttr.
										Get (SCHATTR_STAT_INDICATE)).GetValue ())
			{
				case CHINDICATE_BOTH :
					fDataMin -= fDiffDown;
					fDataMax += fDiffUp;
					break;

				case CHINDICATE_UP :
					fDataMax += fDiffUp;
					break;

				case CHINDICATE_DOWN :
					fDataMin -= fDiffDown;
					break;

				case CHINDICATE_NONE :
				default :
				   ;
			}

			if ((nCol == 0) && (nRow == 0))
			{
				mfMin = fDataMin;
				mfMax = fDataMax;
			}
			else
			{
				if ((mfMin > fDataMin) && !mbLogarithm ||(fDataMin > 0.0) && mbLogarithm)
					mfMin = fDataMin;
				if (mfMax < fDataMax)
					mfMax = fDataMax;
			}
		}
	}

}


/* ************************************************************************
|*
|* Liefert die maximale Werte-Text-Gre
|*
\*********************************************************************** */
Size ChartAxis::CalcMaxTextSize()
{
	return CalcMaxTextSize(((const SvxChartTextOrientItem&)mpAxisAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue());
}

Size ChartAxis::CalcMaxTextSize(SvxChartTextOrient eOrient)
{
	meTextOrient = eOrient;
	maMaxTextSize=Size(0,0);

	if(!mbShowDescr)
		return maMaxTextSize;

	BOOL bStepIsValid = mbLogarithm ? (mfStep > 1.0) : (mfStep > 0.0);

	if( mfMin != mfMax && bStepIsValid )
	{
		OutputDevice *pOut = mpModel->GetOutliner()->GetRefDevice();
		Font aNewFont;
		ItemsToFont(*mpAxisAttr,aNewFont);
		Font aOldFont(pOut->GetFont());
		pOut->SetFont(aNewFont);

		double fAct = mfMin;

        if( SolarMath::IsINF( mfMax ) || SolarMath::IsINF( mfMin ))
        {
            DBG_ERROR( "maximum or minumum is infinity" );
        }
        else
        {
            while (fAct <= mfMax)
            {
                String aNumStr;
                Color* pDummy = NULL;

                if(mbColText)
                {
                    long nCol = long(fAct);
                    if(nCol<mpModel->GetColCount())
                        aNumStr=mpModel->ColText(nCol);
                }
                else
                {
                    mpNumFormatter->GetOutputString(mbPercent ? fAct / 100.0: fAct,
                                                    GetNumFormat(), aNumStr, &pDummy);
                }

                Size aSize;
                if (meTextOrient == CHTXTORIENT_STACKED)
                {
                    aSize.Width() = pOut->GetTextWidth( ::StackString( aNumStr ));
                    aSize.Height() = pOut->GetTextHeight();
                }
                else
                {
                    aSize.Width() = pOut->GetTextWidth( aNumStr );
                    aSize.Height() = pOut->GetTextHeight();
                }

                aSize.Height() += TEXTHEIGHT_OFS;
                aSize.Width () = (aSize.Width () * 6) / 5;

                if (aSize.Width() > maMaxTextSize.Width())
                    maMaxTextSize.Width() = aSize.Width();
                if (aSize.Height() > maMaxTextSize.Height())
                    maMaxTextSize.Height() = aSize.Height();

                IncValue(fAct, mfStep, mbLogarithm);
            }
            maMaxTextSize = GetRotatedTextSize( maMaxTextSize,
                                GetTextRotation( *mpAxisAttr, meTextOrient ));
        }

		//Evtl. muss hier noch ein Umbruch eingeplant werden!

		pOut->SetFont(aOldFont);
	}
	RecalcTextPos();
	return maMaxTextSize;
}

void ChartAxis::RecalcTextPos()
{
	//Textabstand:
	long nExtra = -100; //+1mm
	if((mbSecondary && IsVertical()) || (!mbSecondary && !IsVertical()))
		nExtra=100;

	if(mnTicks&CHAXIS_MARK_OUTER)
	{
		mnTextPos = mnPos + nExtra + mnTickLen; //LONGMARKS;
	}
	else
	{
		mnTextPos = mnPos + nExtra;

		if(mnHelpTicks&CHAXIS_MARK_OUTER)
			mnTextPos +=mnHelpTickLen;
	}
}

void ChartAxis::SetPosition(long nPos)
{
	mbSecondary=(BOOL)(nPos==CHAXIS_POS_B);

	if(nPos<0)
	{
		if(IsVertical())
		{
			if(mbSecondary)
				mnPos=maRefArea.Right();
			else
				mnPos=maRefArea.Left();
		}
		else
		{
			if(mbSecondary)
				mnPos=maRefArea.Top();
			else
				mnPos=maRefArea.Bottom();
		}
	}
	else
	{
		mnPos=nPos;
	}

	RecalcTextPos();
}

//Wenn Ticks nach innen und/oder nach aussen gerichtet sind, wird ein SdrObject returned,
//sollen in keine Richtung Ticks gezeichnet werden, gbts den Nullpointer zurck
SdrObject *ChartAxis::CreateMarks(long nPosition,long nLen,long nWhichTicks)
{
	XPolygon saLine(2);

	long nLen2=(nWhichTicks&CHAXIS_MARK_INNER) ? nLen : 0;

	if(!(nWhichTicks&CHAXIS_MARK_OUTER))
		nLen=0;

	if(!nLen && !nLen2)
		return NULL;

	if(IsVertical())
	{
		saLine[0].X() = mnPos + nLen;
		saLine[1].X() = mnPos - nLen2;
		saLine[0].Y() = saLine[1].Y() = nPosition;
	}
	else
	{
		saLine[0].Y() = mnPos + nLen;
		saLine[1].Y() = mnPos - nLen2;
		saLine[0].X() = saLine[1].X() = nPosition;
	}

	return SetObjectAttr (new SdrPathObj(OBJ_PLIN,saLine),CHOBJID_LINE,TRUE,TRUE,mpAxisAttr);
}
void ChartAxis::CreateMarkDescr(double fData,long nPosition)
{
	String aNumStr;
	Color* pTextColor = NULL;

	if(mbColText)
	{
		long nCol = long(fData);
		long nColCnt=mpModel->GetColCount();
		if(IsVertical())
			nCol=nColCnt-nCol; //andere Reihenfolge wegen Bildschirmkoordinaten

		if(nCol<nColCnt && nCol>=0)
			CreateMarkDescr(mpModel->ColText(nCol) ,nPosition, pTextColor);
	}
	else
	{
		mpNumFormatter->GetOutputString(mbPercent ? fData/100.0:fData,GetNumFormat()
			,aNumStr,&pTextColor);
		CreateMarkDescr(aNumStr, nPosition, pTextColor);
	}

}

// BM #60999# new parameter pTextColor, if using red text for negative numbers
void ChartAxis::CreateMarkDescr(const String& rString, long nPosition, Color *pTextColor)
{
	SvxColorItem* pOldTextColor = NULL;

	if(!mpTextAttr)
	{
		DBG_ERROR("ChartAxis: description uninitialised!!!!");
		CreateTextAttr();
	}

	if( pTextColor )
	{
		pOldTextColor = (SvxColorItem*)mpTextAttr->GetItem( EE_CHAR_COLOR );
		mpTextAttr->Put(SvxColorItem( *pTextColor ));
	}

	//Bei z.B. Barcharts ist der Text verschoben (sozusagen unter der Hilfsmarkierung)
	long nTextOffset=0;
	if(!mbCenterText && mbColText)
		nTextOffset+=GetDescrWidth()/2;

	ChartAdjust eAdj;
	SdrTextObj *pText=NULL;
	if(IsVertical())
	{
		Point aPos(mnTextPos,nPosition+nTextOffset);
		if(mbStepValue)
		{
			if(mbValueDown)
			{
				if(mbSecondary)
					aPos.X() += maMaxTextSize.Width();
				else
					aPos.X() -= maMaxTextSize.Width();
			}
			mbValueDown = !mbValueDown;
		}
		eAdj = mbSecondary ? CHADJUST_CENTER_LEFT : CHADJUST_CENTER_RIGHT;
		pText=mpModel->CreateTextObj(CHOBJID_TEXT,aPos,rString,*mpTextAttr,FALSE,eAdj,mnMaxTextWidth);
	}
	else //horizontal
	{
		Point aPos(nPosition+nTextOffset,mnTextPos);
		if (mbStepValue)
		{
			if(mbValueDown)
			{
				if(mbSecondary)
					aPos.Y() -= maMaxTextSize.Height();
				else
					aPos.Y() += maMaxTextSize.Height();
			}
			mbValueDown = !mbValueDown;
		}
		eAdj = mbSecondary ? CHADJUST_BOTTOM_CENTER : CHADJUST_TOP_CENTER;
		pText=mpModel->CreateTextObj(CHOBJID_TEXT,aPos,rString,*mpTextAttr,FALSE,eAdj,mnMaxTextWidth);
	}

	if( pOldTextColor )
	{
		mpTextAttr->Put(*pOldTextColor);
	}

	CreateMarkDescr(pText,nPosition);
}
void ChartAxis::CreateMarkDescr(SdrTextObj *pTextObj,long nPosition)
{
	if(pTextObj && mpAxisList )
	{
		Rectangle aTextBoundRect(pTextObj->GetBoundRect());
		Rectangle aIntersect1(maRectA);
		Rectangle aIntersect2(maRectB);

		if(!mbTextOverlap && ! (aIntersect1.Intersection(aTextBoundRect).IsEmpty() &&
			  aIntersect2.Intersection(aTextBoundRect).IsEmpty()) )
		{
			delete (SdrObject *)pTextObj;
			pTextObj=NULL;
		}

		if (pTextObj)
		{
			SdrObject *pObj=CreateMarks(nPosition,mnTickLen,mnTicks);
			SdrObjList* pList = mpAxisList;
			if(pObj)
				pList->NbcInsertObject(pObj);

			pList->NbcInsertObject(pTextObj);
			maRectA = maRectB;
			maRectB = aTextBoundRect;
			return; //fertig -> Abbruch (die Marks muessen zuerst, dann die Texte)
		}
	}
	//kein Textobjekt oder der Text wrde berlappen
	SdrObject *pObj=CreateMarks(nPosition,mnTickLen,mnTicks);
	if(pObj && mpAxisList)
		mpAxisList->NbcInsertObject(pObj);
}
void ChartAxis::InsertMark(long nPos,long nLen,long nWhichTicks)
{
	SdrObject *pObj=CreateMarks(nPos,nLen,nWhichTicks);
	if(pObj && mpAxisList)
		mpAxisList->NbcInsertObject(pObj);
}


//hnlich zu SubtractDescrSize, jedoch wird der Umbruch sowie nderungen am Rect bei
//sehr langen spaltenunterschriften bercksichtigt.
void ChartAxis::SubtractDescrSize_X(Rectangle& rRect,const Rectangle& rOldRect)
{
	long nDescrWidth=GetDescrWidth();
	mnMaxTextWidth = (long) (nDescrWidth * 0.8);

	//Breite des ersten und letzten Textes der Achse, war mal ChartModel::nWidthOfFirst(Last)XAxisText
	//A() = erster, B()=letzter
	Pair aFirstAndLastTextWidth;

	Size aPageSize(mpModel->GetPage(0)->GetSize());

	//unschn, SID_TEXTBREAK sollte ein SCHATTR_... werden!
	BOOL bTextBreak=mpModel->GetFormatXAxisTextInMultipleLinesIfNecessary();
	if(!bTextBreak)  // Dann wird kein Umbruch erzeugt.
	   mnMaxTextWidth = -1;

	meTextOrient = ((const SvxChartTextOrientItem&)
		mpAxisAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue();

	BOOL bStepDescr;

	// FG: Falls die X-Achsenbeschriftung aus Zahlen besteht, wird dies beruecksichtigt.
	UINT32  nNumberFormatXAxisDescr  = GetNumFormat();//0;

	// FG: Jetzt wird der Rand des Charts so eingestellt, dass die Beschriftung der X-Achse
	//     garantiert nicht aus dme Chart heraus oder ins Diagramm hineinlaeuft. Hier
	//     muessen alle Faelle der Textausrichtung beruecksichtigt werden.
	//     Hier wird erstmal die maximale Textgroesse und die Textgroesse der ersten und letzten Spalte
	//     berechnet (letzteres wird in CalcMaxDescrSize versteckt durchgezogen)


	if (HasDescription())//#47500#
	{
		if (IsVertical())
		{
			// FG: hier wird erstmal die urspruengliche Textgroesse berechnet, sie wird abhaengig
			//     vom Ergebnis nachkorrigiert. Die Textbreite ab der umgebrochen wird darf nichts
			//     mit der Spaltenbreite zu tun haben falls der Text links neben dem Chart steht
			//     und von links nach rechts laeuft.
			maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, mbPercent, mnUId, -1, &aFirstAndLastTextWidth );
			// FG: Falls man den Text umbrechen darf, so muss nur noch beachtet werden, in welche
			//     Richtung der Text verlaufen soll (senkrecht, waagrecht) und ob die Groesse der
			//     Beschriftung das restliche Chart zu klein machen wird. Die groesste Beschriftung
			//     darf nicht mehr als 25% der Breite oder Hoehe einnehmen, je nach Ausrichtung des
			//     Textes.
			if  (bTextBreak)
			{
				if (   (meTextOrient == CHTXTORIENT_BOTTOMTOP)
					|| (meTextOrient == CHTXTORIENT_TOPBOTTOM)
					|| (meTextOrient == CHTXTORIENT_STACKED))
				{
					if ((aPageSize.Height() / 4) < maMaxTextSize.Width())
					{
						mnMaxTextWidth = aPageSize.Height() / 4;
						maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, nNumberFormatXAxisDescr,
															mnUId, mnMaxTextWidth,
															&aFirstAndLastTextWidth );
					}
					// FG: sonst kann die erste Berechnung beibehalten werden.
				}
				else
				{
					if ((aPageSize.Width() / 4) < maMaxTextSize.Width()) // waagrechte Ausrichtung
					{
						// FG. Dann ist also der Platz fuer die Beschriftung groesser als 1/4 des Charts
						mnMaxTextWidth = aPageSize.Width() / 4;
					}
					maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, nNumberFormatXAxisDescr,
																mnUId, mnMaxTextWidth,
																&aFirstAndLastTextWidth );
				}
			}
			else  // FG: Falls der Umbruch nicht erlaubt ist, der Text aber breiter als 1/3 des Charts wird,
			{     //     wird trotzdem umgebrochen. Dann muss dei maximale Hoehe und Breite der groessten
				  //     uns insbesondere der 1. und letzten Beschriftung neu berechnet werden.
				  //     Das laesst sich sicher besser machen als nochmal ueber die gesamte Liste von Texten
				  //     zu iterieren.
				if (   (   (meTextOrient == CHTXTORIENT_BOTTOMTOP)
						|| (meTextOrient == CHTXTORIENT_TOPBOTTOM)
						|| (meTextOrient == CHTXTORIENT_STACKED)  )
					 && ((aPageSize.Height() / 3) < maMaxTextSize.Width()))
				{
					// FG. Dann ist also der Platz fuer die Beschriftung groesser als 1/4 des Charts
					mnMaxTextWidth = aPageSize.Height() / 3;
					maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, nNumberFormatXAxisDescr,
													   mnUId, mnMaxTextWidth,
													   &aFirstAndLastTextWidth );
				}
			}
		}
		else  // FG: Der Text steht also unter dem Chart.
		{
			// FG: Fuer den Fall dass die Beschriftung nicht unter jeden Datenpunkt gesetzt
			//     wird, weil zu viele Daten vorhanden sind, eignet sich eine vertikale
			//     Textausrichtung besser (im Falle dass die Ausrichtung automatisch
			//     erfolgen soll.
			maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, nNumberFormatXAxisDescr,
											   mnUId, mnMaxTextWidth,
											   &aFirstAndLastTextWidth );

			if (   (meTextOrient == CHTXTORIENT_BOTTOMTOP)
				|| (meTextOrient == CHTXTORIENT_TOPBOTTOM)
				|| (meTextOrient == CHTXTORIENT_STACKED))
			{
				if ((aPageSize.Width() / 2) < maMaxTextSize.Height())
				{
					mnMaxTextWidth = aPageSize.Height() / 2;
					maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, nNumberFormatXAxisDescr,
													   mnUId, mnMaxTextWidth,
													   &aFirstAndLastTextWidth );
				}
				if (  ( (aPageSize.Width() / 4) < maMaxTextSize.Height()) &&
				   (bTextBreak))
				{
					mnMaxTextWidth = aPageSize.Height() / 4;
					maMaxTextSize = mpModel->CalcMaxDescrSize( FALSE, meTextOrient, nNumberFormatXAxisDescr,
													   mnUId, mnMaxTextWidth,
													   &aFirstAndLastTextWidth);
				}
			}
		}


		SvxChartTextOrder eDescrOrder;

		// FG: Einfachere Abfrage ob die Ausrichtung vom Programm vorgegeben wird oder vom Benutzer
		// #65364# (BM) text order is now independent from text orientation
/*        if (meTextOrient != CHTXTORIENT_AUTOMATIC)
		{
*/
			eDescrOrder = ((const SvxChartTextOrderItem&)
				mpAxisAttr->Get(SCHATTR_TEXT_ORDER)).GetValue();
/*        }
		else
		{
			eDescrOrder = CHTXTORDER_SIDEBYSIDE;
		}
*/
		// FG: Hier wird nur abgefragt, ob die Beschriftung der X-Achse (der Datenachse)
		//     so erfolgen soll, dass Text abwechselnd hoch-tief gesetzt werden, oder nicht.
		long nMaxWidth = IsVertical() ? maMaxTextSize.Height() : maMaxTextSize.Width();
		BOOL bHelp = (nMaxWidth > nDescrWidth * 8.1 / 10);
		bStepDescr =  ( bHelp &&
						   (eDescrOrder == CHTXTORDER_AUTO) &&
						   (meTextOrient == CHTXTORIENT_STANDARD)) ||
						   (eDescrOrder == CHTXTORDER_UPDOWN) ||
						   (eDescrOrder == CHTXTORDER_DOWNUP);

		// FG: Hier wird aufgrund der Beschriftung der obere und der untere Rand nachgeregelt.
		//     und zwar nur hier.

//BEGIN_RECT_CHANGES

		if (IsVertical())
		{
			if (! bTextBreak)
			{
				if (   (meTextOrient == CHTXTORIENT_BOTTOMTOP)
					|| (meTextOrient == CHTXTORIENT_TOPBOTTOM)
					|| (meTextOrient == CHTXTORIENT_STACKED))
				{
					// FG: In diesem Fall muss man nachregeln, der Text wird ohne Umruch formatiert
					if ((rRect.Bottom() - rOldRect.Bottom()) < (aFirstAndLastTextWidth.B() / 2))
					{
						rRect.Bottom() -= aFirstAndLastTextWidth.B() / 2;
					}
					if ((rRect.Top() - rOldRect.Top()) < (aFirstAndLastTextWidth.A() / 2))
					{
						rRect.Top() -= aFirstAndLastTextWidth.A() / 2;
					}
				}
			}
		}
		else
		{
			// FG: Der Text steht unter dem Chart, egal ob er von links nach rechts oder von oben nach
			//     unten verlaeuft aMaxDescrSize muss vorher richtig berechnet worden sein.
			if(mbSecondary)
			   rRect.Top() += maMaxTextSize.Height() + mnTickLen + 100;
			else
			   rRect.Bottom() -= maMaxTextSize.Height() + mnTickLen + 100;
		}

		if (bStepDescr)  // FG: Dann erfolgt die Beschriftung hoch- und tief abwechselnd (wie in der Dialogbox)
		{
				// dann hat man mehr Platz pro Zeile (eigentlich 2 mal soviel) aber der Platz zwischen den
				// Beschriftungen steht auch noch zur Verfuegung (jeweils 0,2 * nDescrWidth)
			mnMaxTextWidth = 2 * mnMaxTextWidth + 0,4 * nDescrWidth;
				// Man braucht auch 2 mal soviel Platz in unten am Chart.
			if(mbSecondary)
				rRect.Top() += maMaxTextSize.Height() + mnTickLen;
			else
				rRect.Bottom() -= maMaxTextSize.Height() + mnTickLen;
		}
	}
		// FG (14.2.97): Hier wird der linke Rand nachgeregelt, und zwar je nach Diagrammtyp unterschiedlich.
	if (mpModel->IsDescriptionCenteredUnderDataPoint())
	{
			// Nun jetzt weiss ich dass die Beschriftung zentriert unter einem Datenpunkt steht.
			// jetzt muss der linke Rand nachgeregelt werden: Genau die Haelfte des
			// Spaltentextes mit Nummer 0 muss nach links noch Platz sein.
		if (IsVertical())
		{
			if ((rRect.Left() - rOldRect.Left()) < maMaxTextSize.Width())
			{
				rRect.Left()    += maMaxTextSize.Width();
			}
			// FG: Ein Nachregeln des rechten Randes ist nicht noetig, da die Beschriftung
			//     nie rechts neben dem Chart stehen kann.
		}
		else
		{
			if(! (     (meTextOrient == CHTXTORIENT_BOTTOMTOP)
					|| (meTextOrient == CHTXTORIENT_TOPBOTTOM)
					|| (meTextOrient == CHTXTORIENT_STACKED)) )
			{
				if ((rRect.Left() - rOldRect.Left()) < (aFirstAndLastTextWidth.A() / 2))
				{
					rRect.Left() += aFirstAndLastTextWidth.A() / 2;
				}
				if (mpModel->InitialSize().Width() - rRect.Right() < (aFirstAndLastTextWidth.B() / 2))
				{
					rRect.Right() -= aFirstAndLastTextWidth.B() / 2;
				}
			}
		}
	}
	else
	{
		// FG: Im anderen Fall wird gerade so umgebrochen, dass kein zusaetzlicher Rand gelassen werden muss.
		//     Es sei denn im Dialog wurde eingestellt, dass man keinen Umbruch wollte.
		if (!bTextBreak)
		{
			if ((rRect.Left() - rOldRect.Left()) < (aFirstAndLastTextWidth.A() / 2))
			{
				rRect.Left() += aFirstAndLastTextWidth.A() / 2;
			}
			if (mpModel->InitialSize().Width() - rRect.Right() < (aFirstAndLastTextWidth.B() / 2))
			{
				rRect.Right() -= aFirstAndLastTextWidth.B() / 2;
			}
		}
	}
//END RECT_CHANGES ********************************************************************
}




void ChartAxis::SubtractDescrSize(Rectangle& rRect)
{
	if(!mbShowDescr)
		return;

	long nLong = (mnTicks&CHAXIS_MARK_OUTER) ? 150 : (mnHelpTicks&CHAXIS_MARK_OUTER) ? 100 : 0;

	if(mbSecondary)
	{
		if(!IsVertical())
		{
			rRect.Top() += mbStepValue
								  ? maMaxTextSize.Height() * 2
								  : maMaxTextSize.Height();
			rRect.Top() += nLong;
		}
		else
		{
			rRect.Right() -= mbStepValue
								? maMaxTextSize.Width() * 2
								: maMaxTextSize.Width();
			rRect.Right() -= nLong;
		}
	}
	else
	{
		if(!IsVertical())
		{
			rRect.Bottom() -= mbStepValue
								  ? maMaxTextSize.Height() * 2
								  : maMaxTextSize.Height();
			rRect.Bottom() -= nLong;
		}
		else
		{
			rRect.Left() += mbStepValue
								? maMaxTextSize.Width() * 2
								: maMaxTextSize.Width();
			rRect.Left() += nLong;
		}
	}
}
//Bisher nur Y-Achse:
void ChartAxis::InitDescr()
{
	InitDescr(meTextOrient,mnMaxTextWidth);
}
void ChartAxis::InitDescr(SvxChartTextOrient &rValueOrient,long nMaxTextWidth)
{
	mnMaxTextWidth=nMaxTextWidth;//-1;

	BOOL bAutoValue = (rValueOrient == CHTXTORIENT_AUTOMATIC);

	if(!mbShowDescr)
		return;

	if (bAutoValue)
		rValueOrient = CHTXTORIENT_STANDARD;

	// #65364# (BM) text order is now independent from text orientation
	SvxChartTextOrder eValueOrder = /*( bAutoValue
									||( mbFlippedXY && (rValueOrient != CHTXTORIENT_STANDARD))
									||(!mbFlippedXY && (rValueOrient == CHTXTORIENT_STANDARD)))
										 ? CHTXTORDER_SIDEBYSIDE
										 :*/
									((const SvxChartTextOrderItem&)mpAxisAttr->Get(SCHATTR_TEXT_ORDER)).GetValue();

	mbStepValue = (eValueOrder != CHTXTORDER_SIDEBYSIDE);
	mbValueDown = (eValueOrder == CHTXTORDER_DOWNUP);

	meTextOrient = rValueOrient;

	CreateTextAttr();
}
void ChartAxis::InitDescr_X()
{
	if(!mbShowDescr)
		return;

	SvxChartTextOrder eValueOrder;

	// FG: Einfachere Abfrage ob die Ausrichtung vom Programm vorgegeben wird oder vom Benutzer
	// #65364# (BM) text order is now independent from text orientation
/*    if (meTextOrient != CHTXTORIENT_AUTOMATIC)
	{
*/
		eValueOrder = ((const SvxChartTextOrderItem&)
			mpAxisAttr->Get(SCHATTR_TEXT_ORDER)).GetValue();
/*    }
	else
	{
		eValueOrder = CHTXTORDER_SIDEBYSIDE;
	}
*/
	// FG: Hier wird nur abgefragt, ob die Beschriftung der X-Achse (der Datenachse)
	//     so erfolgen soll, dass Text abwechselnd hoch-tief gesetzt werden, oder nicht.
	long nMaxWidth = IsVertical() ? maMaxTextSize.Height() : maMaxTextSize.Width();
	BOOL bHelp=	(nMaxWidth > GetDescrWidth() * 8.1 / 10);
	mbStepValue = (bHelp &&
				  (eValueOrder == CHTXTORDER_AUTO) &&
				  (meTextOrient == CHTXTORIENT_STANDARD)) ||
				  (eValueOrder == CHTXTORDER_UPDOWN) ||
				  (eValueOrder == CHTXTORDER_DOWNUP);


	mbValueDown = (eValueOrder == CHTXTORDER_DOWNUP);
//	meTextOrient = rValueOrient;

	CreateTextAttr();
}




void ChartAxis::CreateTextAttr()
{
	if(!mpTextAttr)
		mpTextAttr=new SfxItemSet((const SfxItemSet &)*mpAxisAttr);
	else
		mpTextAttr->Put(*mpAxisAttr); //Update

	mpTextAttr->Put(SvxChartTextOrientItem(meTextOrient));
	mpTextAttr->Put(XLineStyleItem(XLINE_NONE));
	mpTextAttr->Put(XLineWidthItem(0));
}

void ChartAxis::CreateAxis(SdrObjList& rList,long nChObjId)
{
	if(IsVisible() || HasDescription())
	{
		mpAxisObj = new SchAxisObj( mpModel );
		SetObjectAttr( mpAxisObj, USHORT(nChObjId), TRUE, TRUE, 0 );
		SetAxisList( mpAxisObj->GetSubList() );

		rList.NbcInsertObject( mpAxisObj, CONTAINER_APPEND );

		if( IsVisible())
			CreateAxis();
	}
}

void ChartAxis::CreateAxis(const long nPos,BOOL bBorderAxis,BOOL bInnerAxis)
{
	//Position der X-Achse.... aber nicht der Ticks
	//(nicht ganz verstndlich bei XY-Diagrammen)
	//was ist mit bShow?Descr ?
	mnInnerPos=nPos;

	long nPos1 = 0;
	if(bBorderAxis)
		nPos1=CreateAxis();
	else
	{
		mbInnerPos=TRUE; //ungenutzt.... evtl. wegen SetArea(){...SetPosition()...}
		SetPosition(nPos);
	}
	mnInnerPos=nPos;

	if(bInnerAxis &&(!bBorderAxis || nPos1!=nPos)) //nur eine Achse oder 2 Achsen an versch. Positionen
	{

		XPolygon aLine(2);
		if (IsVertical())
		{
			aLine[0].X() = aLine[1].X() = nPos;
			aLine[0].Y() = maRefArea.Bottom();
			aLine[1].Y() = maRefArea.Top();
		}
		else
		{
			aLine[0].Y() = aLine[1].Y() = nPos;
			aLine[0].X() = maRefArea.Left();
			aLine[1].X() = maRefArea.Right();
		}
		if (mpAxisList)
			mpAxisList->NbcInsertObject(SetObjectAttr (new SdrPathObj(OBJ_PLIN, aLine),
			CHOBJID_LINE, TRUE, TRUE,mpAxisAttr));
	}
/* alter Original-Source, siehe ###hier###
	if (bSwitchColRow)
	{
		VERTICAL_LINE;
		if ((nPos != rRect.Left()) && (bShowYDescr ))
		{
			aLine[0].X() = aLine[1].X() = rRect.Left ();

			rObjList.InsertObject(SetObjectAttr(new SdrPathObj(OBJ_PLIN, aLine),
				CHOBJID_DIAGRAM_X_AXIS,TRUE, TRUE, pXGridMainAttr));
		}
		aLine[0].X() = aLine[1].X() = nPos;
	}
	else //!bSwitchColRow
	{
		HORIZONTAL_LINE;
		if ((nPos != rRect.Bottom()) && (bShowXDescr))
		{
			if(pChartYAxis->GetMin() < 0.0)
			{
				//###hier### ist jetzt anders!

				aLine[0].Y()=aLine[1].Y()= (pChartYAxis->GetMax()>0.0)
							? rRect.Bottom ()
							: rRect.Top ();

			}
			else
				aLine[0].Y()=aLine[1].Y()= rRect.Bottom ();

			HORIZONTAL_LINE;
			rObjList.InsertObject(SetObjectAttr (new SdrPathObj(OBJ_PLIN, aLine),
				CHOBJID_DIAGRAM_X_AXIS,TRUE, TRUE, pXGridMainAttr));
		}
		aLine[0].Y() = aLine[1].Y() = nPos;
	}
*/
}

long ChartAxis::CreateAxis()
{
	XPolygon aLine(2);
	long nPos;

	if (IsVertical())
	{
		if(mbSecondary)
		{
			aLine[0].X() = aLine[1].X() = maRefArea.Right();
		}
		else
		{
			aLine[0].X() = aLine[1].X() = maRefArea.Left();
		}
		aLine[0].Y() = maRefArea.Bottom();
		aLine[1].Y() = maRefArea.Top();
		nPos=aLine[0].X();
	}
	else
	{
		if(mbSecondary)
		{
			aLine[0].Y() = aLine[1].Y() = maRefArea.Top();
		}
		else
		{
			aLine[0].Y() = aLine[1].Y() = maRefArea.Bottom();
		}
		aLine[0].X() = maRefArea.Left();
		aLine[1].X() = maRefArea.Right();
		nPos=aLine[0].Y();
	}

	if (mpAxisList && IsVisible())
		mpAxisList->NbcInsertObject(SetObjectAttr (new SdrPathObj(OBJ_PLIN, aLine),
		CHOBJID_LINE, TRUE, TRUE,mpAxisAttr));

	return nPos;

}
void ChartAxis::SetMainGrid(SdrObjList* pList,SfxItemSet*pAttr)
{
	mpMainGridList=pList;
	mpMainGridAttr=pAttr;
	switch(mnId)
	{
		case CHART_AXIS_X:
			mnIdMainGrid=CHOBJID_DIAGRAM_Y_GRID_MAIN;
			break;
		case CHART_AXIS_Y:
			mnIdMainGrid=CHOBJID_DIAGRAM_X_GRID_MAIN;
			break;
		case CHART_AXIS_Z:
			mnIdMainGrid=CHOBJID_DIAGRAM_Z_GRID_MAIN;
			break;
	}
}
void ChartAxis::SetHelpGrid(SdrObjList* pList,SfxItemSet*pAttr)
{
	mpHelpGridList=pList;
	mpHelpGridAttr=pAttr;
	switch(mnId)
	{
		case CHART_AXIS_X:
			mnIdHelpGrid=CHOBJID_DIAGRAM_Y_GRID_HELP;
			break;
		case CHART_AXIS_Y:
			mnIdHelpGrid=CHOBJID_DIAGRAM_X_GRID_HELP;
			break;
		case CHART_AXIS_Z:
			mnIdHelpGrid=CHOBJID_DIAGRAM_Z_GRID_HELP;
			break;
	}
}

void ChartAxis::GridLine(XPolygon& aLine,long nPos)
{
	if(IsVertical())
	{
		aLine[0].Y() = aLine[1].Y() = nPos;
		aLine[0].X() = maRefArea.Left();
		aLine[1].X() = maRefArea.Right();
	}
	else
	{
		aLine[0].X() = aLine[1].X() = nPos;
		aLine[0].Y() = maRefArea.Bottom();
		aLine[1].Y() = maRefArea.Top();
	}
}

void ChartAxis::ShowDescr(BOOL b)
{
    mbShowDescr=b;
    mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_SHOWDESCR,b));
}

void ChartAxis::ShowAxis(BOOL b)
{
    mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_SHOWAXIS,b));
}

void ChartAxis::DrawGrids()
{
	XPolygon aLine(2);
	long nPos;

	if(!mpMainGridList && !mpHelpGridList && !mpAxisList)
		return ; //nothing to do


	// if the x-axis has no numbers as description, the meaning of main and help ticks might
	// be interpreted the other way round
	long   nTicksBack		=mnTicks;
	long   nHelpTicksBack	=mnHelpTicks;
	long   nTickLenBack		=mnTickLen;
	long   nHelpTickLenBack	=mnHelpTickLen;

	// ...Back is for storing original values
	double fMinBack	 = mfMin;
	double fMaxBack	 = mfMax;
	double fStepBack	 = mfStep;
	double fStepHelpBack= mfStepHelp;
	BOOL   bLogarithmBack = mbLogarithm;

	if(mbColText) //... da hier modifiziert werden kann, aber die Werte nicht
	{			  //in den Attrset sollen (also nicht persistent). In wie weit das ntig ist, ist ne andere Frage...
		mfMin=0;
		mfStep=1;
		mbLogarithm = FALSE;
		mfMax=mpModel->GetColCount();
		if(mbCenterText && mfMax>1.0)
		{
			mfMax-=1;

			//Die Markierungen sind bei Linien und Area-Charts verschoben
			//=> dies entspricht gewissermassem dem Swap von Help und MainTicks
			mnTicks=0;//nHelpTicksBack; //HelpTicks bzw. innen/aussen noch nicht per GUI zugnglich, daher fixe Werte
			mnHelpTicks=CHAXIS_MARK_OUTER;//nTicksBack;
			mnHelpTickLen=nTickLenBack;
			mnTickLen=nHelpTickLenBack;

			//	Now we have to copy with the case of to many tick marks.
			//	The problem lies in the fact, that creating to many tick
			//	marks results in an overrun of pool item reference counters.
			//	Creating them without these items leaves them unchangeable.
			//	The best solution is to generalize the data set, i.e.
			//	to draw only a part of the tick marks (and draw only a part
			//	of the data).  The number of tick marks to draw should ideally 
			//	depend on the real window size measured in pixel.  This is (at
			//	the moment) not possible because we don't have access to the
			//	view and therefore no access to it's output device.
			//	Leaving a clean solution for the new chart for now we
			//	set a fixed number as the maximal count of tick marks.
			//	This solution has one advantage: output to the screen and to 
			//	the printer has the same number of tick marks.
			const double maximum_number_of_tick_marks = 1000.0;
			mfStep =(mfMax - mfMin) / ::std::min< double > (maximum_number_of_tick_marks, (mfMax - mfMin));
		}
		else
		{
			mnHelpTicks=0; //nicht per Gui mglich, daher fixe Werte
			mnTicks=CHAXIS_MARK_OUTER;
		}

		mfStepHelp = mfStep / 2;
	}

	// #69810# prevent infinite loop if step wouldn't change the value of fAct
	BOOL bStepIsOK = mbLogarithm? (fabs(mfStep) > 1.0): (mfStep != 0.0);

//	DBG_ASSERT( bStepIsOK, "Axis increment is ineffective and would cause loop" );

	if( mfMax!=mfMin && ( bStepIsOK ) )
	{
		double fAct     = mfMin;
		double fActHelp = mfMin;

        // in the worst case the threshhold is 1/1000th of the height of the
        // diagram this is just done because of minor inaccuracies that may
        // occur, because in the following loop the current value is achieved by
        // repeatedly adding the main step value where small errors might
        // accumulate
        double fThreshold = ::std::min( mfMax, ::std::min( mfStep, mfStepHelp )) / 1000.0;

        if( SolarMath::IsINF( mfMax ) || SolarMath::IsINF( mfMin ))
        {
            DBG_ERROR( "maximum or minumum is infinity" );
        }
        else
        {
            while (fAct <= mfMax + fThreshold)
            {
                long nMainPos = GetPos(fAct);

                GridLine(aLine,nMainPos);

                if (mpMainGridList)
                    mpMainGridList->NbcInsertObject(SetObjectAttr(new SdrPathObj(OBJ_PLIN,aLine),
                                                                  USHORT(mnIdMainGrid),TRUE,TRUE,mpMainGridAttr));

                if(mpHelpGridList || (mpAxisList && mnHelpTicks) )
                {
                    if(mbLogarithm)
                    {
                        fActHelp = mfStep / mfStepHelp * fAct;

                        double fNext = fAct;
                        IncValue(fNext,mfStep,mbLogarithm);

                        while (fActHelp < fNext)
                        {
                            if(CalcFact(fActHelp) > 1.0)
                                break;

                            GridLine(aLine,nPos=GetPos(fActHelp));

                            if(mpHelpGridList)
                                mpHelpGridList->NbcInsertObject(SetObjectAttr(new SdrPathObj(OBJ_PLIN,aLine),
                                                                              USHORT(mnIdHelpGrid),TRUE,TRUE,mpHelpGridAttr));

                            InsertMark(nPos,mnHelpTickLen,mnHelpTicks);

                            fActHelp+=mfStep/mfStepHelp*fAct;
                        }
                    }
                    else
                    {
                        while(fActHelp <= fAct)
                        {
                            if(CalcFact(fActHelp) > 1.0)
                                break;

                            GridLine(aLine,nPos=GetPos(fActHelp));

                            if(mpHelpGridList)
                                mpHelpGridList->NbcInsertObject(SetObjectAttr(new SdrPathObj(OBJ_PLIN, aLine),
                                                                              USHORT(mnIdHelpGrid),TRUE,TRUE,mpHelpGridAttr));

                            InsertMark(nPos,mnHelpTickLen,mnHelpTicks);

                            fActHelp+=mfStepHelp;
                        }
                        //	If the main grid is drawn then skip the coinciding help grid lines.
                        if ((fActHelp == fAct) && mpMainGridList || mbColText)
                            fActHelp+=mfStepHelp;
                    }
                }

                if (mpAxisList)
                {
                    if(mbShowDescr)
                        CreateMarkDescr(fAct,nMainPos);
                    else
                        InsertMark(nMainPos,mnTickLen,mnTicks);
                }
                IncValue( fAct, mfStep, mbLogarithm );
            }
        }
	}

	// restore original values. Might be obsolete
	mfMin	   = fMinBack;
	mfMax      = fMaxBack;
	mfStep     = fStepBack;
	mfStepHelp = fStepHelpBack;

	mnTicks			=nTicksBack;
	mnHelpTicks		=nHelpTicksBack;
	mnTickLen		=nTickLenBack;
	mnHelpTickLen	=nHelpTickLenBack;
	mbLogarithm		=bLogarithmBack;
}

inline double ChartAxis::GetData(long nCol,long nRow)
{
	double fData=mpModel->GetData(nCol,nRow);
	if(mbPercent)
		fData=Data2Percent(fData,nCol,nRow);
	return fData;
};
// Falls es sich um eine gespiegelte Achse handelt, ist es nicht mglich,
// einmal Logarithmus zu setzen, das andere mal nicht.
// Die anderen Werte mssen evtl. (bei automatik) angepasst werden.
// allerdings darf hier gendert werden, um z.B. links 0-10 Volt
// und rechts 0-1000 mV an der Achse zu setzen. Das die Werte dann trotzdem
// identisch sind, liegt in diesem Fall dann in der Verantwortung des Users.
BOOL ChartAxis::AttachIfNoOwnData(const ChartAxis* pAxis)
{
	if(!mbAlternativIdUsed) //Hat eigene Daten!
		return FALSE;

	//es macht keinen Sinn, unsichtbare Achsen zu kopieren:
	if(!pAxis->IsVisible() && !pAxis->HasDescription())
		return FALSE;

	ReadAutoAttr();

	mbLogarithm    = pAxis->mbLogarithm;
	mpAxisAttr->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM,mbLogarithm));

	if(mbAutoStep)
		mfStep=pAxis->mfStep;
	if(mbAutoStepHelp)
		mfStepHelp=pAxis->mfStepHelp;
	if(mbAutoMin)
		mfMin=pAxis->mfMin;
	if(mbAutoMax)
		mfMax=pAxis->mfMax;
	if(mbAutoOrigin)
		mfOrigin=pAxis->mfOrigin;

	FillItemSet();

	return TRUE;

}
double ChartAxis::NumStepsMain()
{
	if( mbLogarithm )
	{
		DBG_ASSERT( mfStep > 1.0, "ChartAxis: argument of log must be greater than 1" );
		return log( mfMax - mfMin ) / log( mfStep );
	}

	return (mfMax - mfMin) / mfStep;
};

long ChartAxis::GetDescrWidth()
{
	double fAllTextLen = IsVertical() ? (double)maRefArea.GetHeight()
									  : (double)maRefArea.GetWidth();
	long   nDescrWidth=0;

	if(!mbColText) //z.B. bei XY-Charts gelangt man hier hin!
	{
		if(mfStep!=0.0)
		{
			double fCnt = NumStepsMain();
			if (mbCenterText)
				fCnt -= 1.0;

			nDescrWidth  = (long) (fAllTextLen / fCnt);
		}
	}
	else //Area, Bar etc.
	{
		long  nColCnt=mpModel->GetColCount();

		if (mbCenterText && nColCnt > 1)
				nColCnt--;

		nDescrWidth = (long) (fAllTextLen / (double)nColCnt);
	}
	return nDescrWidth;
}

UINT32 ChartAxis::GetNumFormat( BOOL bPercent )
{
	return ((const SfxUInt32Item&)mpAxisAttr->Get(bPercent
		? SCHATTR_AXIS_NUMFMTPERCENT : SCHATTR_AXIS_NUMFMT)).GetValue();
}

void ChartAxis::SetNumFormat( BOOL bPercent, long nId )
{
	mpAxisAttr->Put( SfxUInt32Item( bPercent
                                    ? SCHATTR_AXIS_NUMFMTPERCENT
                                    : SCHATTR_AXIS_NUMFMT,
                                    USHORT( nId )));
}

BOOL ChartAxis::IsValueInRange( double fValue ) const
{
	return  ((mfMin <= fValue) && (fValue <= mfMax));	
}

BOOL ChartAxis::TranslateMergedNumFormat( SvULONGTable* pTransTable )
{
	ULONG nFmt, nMrgFmt;
	BOOL bRet =FALSE;

	nFmt = GetNumFormat( mbPercent );
	nMrgFmt = mpNumFormatter->GetMergeFmtIndex( nFmt );
	if( nFmt != nMrgFmt )
	{
		SetNumFormat( mbPercent, nMrgFmt );
		bRet = TRUE;
	}

	nFmt = GetNumFormat( ! mbPercent );
	nMrgFmt = mpNumFormatter->GetMergeFmtIndex( nFmt );
	if( nFmt != nMrgFmt )
		SetNumFormat( ! mbPercent, nMrgFmt );

	return bRet;
}

void ChartAxis::SetAxisList( SdrObjList *pList )
{
	mpAxisList = pList;
	maRectA = maRectB = Rectangle();
}

long ChartAxis::GetUniqueIdByObjectId( long nObjectId )
{
    long nResult = CHAXIS_AXIS_UNKNOWN;

    switch( nObjectId )
    {
        case CHOBJID_DIAGRAM_X_AXIS:
            nResult = CHAXIS_AXIS_X;
            break;
        case CHOBJID_DIAGRAM_Y_AXIS:
            nResult = CHAXIS_AXIS_Y;
            break;
        case CHOBJID_DIAGRAM_Z_AXIS:
            nResult = CHAXIS_AXIS_Z;
            break;
        case CHOBJID_DIAGRAM_A_AXIS:
            nResult = CHAXIS_AXIS_A;
            break;
        case CHOBJID_DIAGRAM_B_AXIS:
            nResult = CHAXIS_AXIS_B;
            break;
    }

    return nResult;
}
