/*************************************************************************
 *
 *  $RCSfile: chtmod2a.cxx,v $
 *
 *  $Revision: 1.18.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:39:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma optimize("",off)

#pragma hdrstop

#include <svx/eeitem.hxx>
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif

#ifndef _SVDOCIRC_HXX //autogen
#include <svx/svdocirc.hxx>
#endif
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif
#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>
#endif
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH
#include <svx/fwdtitem.hxx>
#include <svx/fhgtitem.hxx>
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#include "globfunc.hxx"
#endif
#ifndef _SCH_SCHGROUP_HXX
#include "schgroup.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif

#include "strings.hrc"
#include "glob.hrc"
#include <math.h>
#include <float.h>


#include "pairs.hxx"
#include "chtmodel.hxx"
#include "globfunc.hxx"

#ifndef _SVX_FILLITEM_HXX //autogen
#include <svx/xfillit.hxx>
#endif

#ifndef _SVX_XLINIIT_HXX //autogen
#include <svx/xlineit.hxx>
#endif
// header for Line
#ifndef _SV_LINE_HXX
#include <vcl/line.hxx>
#endif

#include "chaxis.hxx"
#include "chdescr.hxx"
#include "calculat.hxx"

#define SCH_SIN(a)		(sin((double)a * F_PI / 18000.0))
#define SCH_COS(a)		(cos((double)a * F_PI / 18000.0))

/*************************************************************************
|*
|* DataDescription Array initialisieren (loeschen)
|*
\************************************************************************/
void ChartModel::ClearDataDescription(DataDescription *pDescription,long nElements)
{
	while(nElements)
	{
		nElements--;
		pDescription[nElements].bSymbol		= FALSE;
		pDescription[nElements].pLabelObj	= NULL;
		pDescription[nElements].fValue		= DBL_MIN;
		pDescription[nElements].aTextPos2D	= Point(0,0);
	}
}
/*************************************************************************
|*
|* Kreisdiagramm erzeugen
|*
\************************************************************************/
SdrObjGroup* ChartModel::Create2DPieChart(Rectangle aRect)
{
	SchObjGroup *pGroup;
	SdrObjList  *pList;

	CreateChartGroup (pGroup, pList);

	// pie charts always have row number 0 for now
	const long			nRow = 0;

	double				fTotal	= 0.0;
	long				nColCnt	= GetColCount();
	long				nSegOfsMax = 0;
	
	SchObjGroup*		pDescrGroup  = NULL;
	SdrObjList			*pDescrList  = NULL;
	DataDescription*	pDescription = NULL;
	long				nCol;
	Size				aDescrOfs;
	BOOL        		bInserted  = FALSE;

	//	Pie charts may not have titles of axes.
	bShowXAxisTitle = FALSE;
	bShowYAxisTitle = FALSE;
	bShowZAxisTitle = FALSE;

	// determine the space required by the chart. For this chart type
	// the labelling is also taken into the calculation
	pDescrList = 0;

	for (nCol = 0; nCol < nColCnt; nCol++)
	{
		double fData = GetData (nCol, nRow);
		if (fData != DBL_MIN) fTotal += fabs(fData);
	}

	for( nCol = 0; nCol < nColCnt; nCol++ )
	{
		SfxItemSet aDataPointAttr( GetFullDataPointAttr( nCol, nRow ));
		double     fData	= GetData( nCol, nRow );
		long       nIndex	= nCol + nRow * nColCnt;

		nSegOfsMax = Max( PieSegOfs( nCol ), nSegOfsMax );

		SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)aDataPointAttr.
									Get(SCHATTR_DATADESCR_DESCR)).GetValue();

		if( (eDescr != CHDESCR_NONE) && bShowDataDescr )
		{
			// data description required
			if (!pDescription)
			{
				pDescription = new DataDescription[ nColCnt ];
				ClearDataDescription( pDescription, nColCnt );
			}

			pDescription[ nIndex ].eDescr  = eDescr;
			pDescription[ nIndex ].eAdjust = CHADJUST_CENTER_CENTER;

			if ((pDescription [nIndex].eDescr == CHDESCR_PERCENT) ||
				(pDescription [nIndex].eDescr == CHDESCR_TEXTANDPERCENT))
			{
				if (fTotal != 0.0)
					pDescription[ nIndex ].fValue = (fabs (fData) / fTotal ) * 100.0;
				else
					pDescription[ nIndex ].fValue = 0.0;
			}
			else
			{
				pDescription [nIndex].fValue = fData;
			}

			if( !bInserted )
			{
				pDescrGroup = (SchObjGroup*) CreateSimpleGroup( CHOBJID_DIAGRAM_DESCRGROUP, TRUE, TRUE );

				pDescrGroup->InsertUserData( new SchDataRow( nRow ) );
				pDescrList = pDescrGroup->GetSubList();
				bInserted = TRUE;
			}

			pDescription[ nIndex ].bSymbol = ((const SfxBoolItem&)aDataPointAttr.
											  Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();

			// create the text
			CreateDataDescr( pDescription[nIndex], nCol, nRow, pChartYAxis, FALSE, TRUE );

			pDescription[ nIndex ].pLabelObj->RecalcBoundRect();

			Size aObjSize = pDescription[ nIndex ].pLabelObj->GetBoundRect().GetSize();

			// determine the space required
			aObjSize.Width ()  = (aObjSize.Width() * 6) / 5;
			aDescrOfs.Width()  = Max( aObjSize.Width(), aDescrOfs.Width() );
			aDescrOfs.Height() = Max( aObjSize.Height(), aDescrOfs.Height() );
		}
	}

	// shrink rectangle if labels are printed beside the pies
	if (pDescription)
	{
		// shrink by size of description text plus a
		// percentage of the rect size as text offset
		long nShrinkX = aDescrOfs.Width() + (aRect.GetWidth() / 20);
		long nShrinkY = aDescrOfs.Height() + (aRect.GetHeight() / 20);

		aRect.Left()   += nShrinkX;
		aRect.Right()  -= nShrinkX;
		aRect.Top()    += nShrinkY;
		aRect.Bottom() -= nShrinkY;
	}

	SdrPage* pPage=GetPage(0);
	Size aPageSize = pPage->GetSize();

	// make sure the pie rectangle is a square
	// shrink rect
	if (aRect.GetWidth() > aRect.GetHeight())
	{
		aRect.Left() += (aRect.GetWidth() - aRect.GetHeight()) / 2;
		aRect.Right() = aRect.Left() + aRect.GetHeight();
	}
	else if (aRect.GetHeight() > aRect.GetWidth())
	{
		aRect.Top() += (aRect.GetHeight() - aRect.GetWidth()) / 2;
		aRect.Bottom() = aRect.Top() + aRect.GetWidth();
	}

	long nEndAng = 9000;
	long nSegOfs;

	Rectangle aDefaultCircRect = aRect;
	Rectangle aCircRect;

	// shrink default circle rectangle (square) to allow exploded pie segments
	if( nSegOfsMax )
	{
		double fRadius = (double)(aDefaultCircRect.GetWidth()) / 2.0;
		long   nRadiusDiff = (long)(fRadius * (1.0 - (1.0  / (1.0 + ((double)nSegOfsMax / 100.0)))));
		aDefaultCircRect.Left()		+= nRadiusDiff;
		aDefaultCircRect.Right()	-= nRadiusDiff;

		aDefaultCircRect.Top()		+= nRadiusDiff;
		aDefaultCircRect.Bottom()	-= nRadiusDiff;		
	}
	nPieRadius = aDefaultCircRect.GetWidth() / 2;	// member set to query radius of pie segments

	// create all pie objects
	for( nCol = 0; nCol < nColCnt; nCol++ )
	{
		long       nStartAng      = nEndAng;
		SfxItemSet aDataPointAttr( GetFullDataPointAttr( nCol, nRow ));
		long       nIndex         = nCol + nRow * nColCnt;
		double     fData          = fabs( GetData( nCol, nRow ));

		if (fData != DBL_MIN)
		{
			if( nCol == nColCnt - 1 )
			{
                // ensure that the circle is closed even if we start at 90 degrees
				nEndAng = 9000 + 36000;
			}
			else if( fTotal != 0.0 )
			{
				nEndAng += (long)((fData / fTotal) * 36000);
			}

			aCircRect = aDefaultCircRect;

			nSegOfs = PieSegOfs(nCol);
			if( nSegOfs )
			{
				double fSegShift = (double)(nPieRadius * nSegOfs) / 100.0;

				Point aCircPos = aCircRect.TopLeft();

				long nAngleDiff;
				long nAngleHook;

				// determine the bisector angle
				if (nStartAng > nEndAng)
				{
					nAngleDiff = (nEndAng + 36000 - nStartAng) / 2;
					nAngleHook = (nStartAng + nAngleDiff) % 36000;
				}
				else
				{
					nAngleDiff = (nEndAng - nStartAng) / 2;
					nAngleHook = nStartAng + nAngleDiff;
				}

				// set the text position according to the position of the pie
				if (nStartAng < 9000)
				{
					long   nAngle = nAngleDiff + nStartAng;

					aCircPos.X() += (long) (SCH_COS( nAngle ) * fSegShift);
					aCircPos.Y() -= (long) (SCH_SIN( nAngle ) * fSegShift);
				}
				else if (nStartAng < 18000)
				{
					long   nAngle = nAngleDiff + (nStartAng - 9000);

					aCircPos.X() -= (long) (SCH_SIN( nAngle ) * fSegShift);
					aCircPos.Y() -= (long) (SCH_COS( nAngle ) * fSegShift);
				}
				else if (nStartAng < 27000)
				{
					long   nAngle = nAngleDiff + (nStartAng - 18000);

					aCircPos.X() -= (long) (SCH_COS( nAngle ) * fSegShift);
					aCircPos.Y() += (long) (SCH_SIN( nAngle ) * fSegShift);
				}
				else
				{
					long   nAngle = nAngleDiff + (nStartAng - 27000);

					aCircPos.X() += (long) (SCH_SIN( nAngle ) * fSegShift);
					aCircPos.Y() += (long) (SCH_COS( nAngle ) * fSegShift);
				}

				aCircRect.SetPos(aCircPos);
			}

			// pies and description are not grouped
			if( fData > 0 )
			{
				SdrObject* pObj = CreatePieSegment( aDataPointAttr, aCircRect, nCol, nRow,
													nStartAng, nEndAng, GetColCount() );
				pObj->SetMoveProtect( FALSE );		// bm allow dragging pies
				pList->NbcInsertObject( pObj );
			}

			if( pDescription && pDescrList && pDescription[ nIndex ].pLabelObj )
			{
				SegmentDescr( pDescription[ nIndex ], aCircRect, nStartAng, nEndAng, 0, aCircRect.GetWidth() / 2,
							  aCircRect.GetWidth() / 2);
			}
		}
		else if( pDescription )
		{
			pDescription[ nIndex ].fValue = DBL_MIN;
		}
	}

	if(pDescrGroup)
		pList->NbcInsertObject(pDescrGroup);

	pGroup->GetSubList ()->SetRectsDirty ();

	// resize of pie charts is allowed proportionally only
	SdrObjTransformInfoRec aInfo;
	aInfo.bResizeFreeAllowed    = FALSE;
	aInfo.bResizePropAllowed    = TRUE;
	aInfo.bRotateFreeAllowed    = FALSE;
	aInfo.bRotate90Allowed      = FALSE;
	aInfo.bMirrorFreeAllowed    = FALSE;
	aInfo.bMirror45Allowed      = FALSE;
	aInfo.bMirror90Allowed      = FALSE;
	aInfo.bShearAllowed         = FALSE;
	pGroup->SetObjInfo(aInfo);

	Dirty2D (1, nColCnt, &pDescrList, FALSE, pDescription);

	delete[] pDescription;

	return pGroup;
}
/*************************************************************************
|*
|* Donutdiagramm erzeugen
|*
\************************************************************************/
SdrObjGroup* ChartModel::Create2DDonutChart(Rectangle aRect)
{
	SchObjGroup *pGroup;
	SdrObjList  *pList;

	CreateChartGroup (pGroup, pList);

	long              nCol;
	long              nRow;

	long              nColCnt       = GetColCount() ;
	long              nRowCnt       = GetRowCount() ;

	double	          *pTotal       = new double [nColCnt];
	SdrObjList        **pRowLists   = new SdrObjList* [nRowCnt];
	SdrObjList        **pDescrLists = new SdrObjList* [nRowCnt];
	DataDescription*  pDescription = NULL;
	Size              aDescrOfs;

	//	Donut charts may not have titles of axes.
	bShowXAxisTitle = FALSE;
	bShowYAxisTitle = FALSE;
	bShowZAxisTitle = FALSE;

	SchObjGroup**    pDescrGroups=new SchObjGroup*[nRowCnt];
	for(nRow=0;nRow<nRowCnt;nRow++)
		pDescrGroups[nRow]=NULL;

	//Summiere ueber alle Elemente der gleichen Spalte (nicht Reihe!),
	for (nCol = 0; nCol < nColCnt; nCol++)
	{
	   pTotal [nCol]     = 0.0;
	   for (nRow = 0; nRow < nRowCnt; nRow++)
		{
			double fData = GetData (nCol, nRow);
			if (fData != DBL_MIN) pTotal [nCol] += fabs(fData);
	   }
	}

	// FG: 22.3.97 Als erstes wird der Platzbedarf der Beschriftung berechnet.
	//     Bei diesem Chart-Typ ist die Beschriftung mit in die Berechnung der
	//     Chartgroesse einbezogen worden.
	for (nRow = 0; nRow < nRowCnt; nRow++)
	{
		SchObjGroup *pRowGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_ROWGROUP, TRUE, TRUE);
		BOOL        bInserted  = FALSE;

		pRowGroup->InsertUserData(new SchDataRow((short)nRow));
		pList->NbcInsertObject(pRowGroup);
		pRowLists[nRow]   = pRowGroup->GetSubList();
		pDescrLists[nRow] = 0;

		// ******************** Data Descriptions erstellen ******************************
		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow));
			double     fData           = GetData (nCol, nRow);
			long       nIndex          = nCol + nRow * nColCnt;

			SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)aDataPointAttr.
											 Get(SCHATTR_DATADESCR_DESCR)).GetValue();

			if( (eDescr != CHDESCR_NONE) && bShowDataDescr)
			{
				/**************************************************************
				* DataDescription erforderlich
				**************************************************************/
				if (!pDescription)
				{
					// DataDescription noch nicht vorhanden -> erzeugen
					pDescription = new DataDescription [nRowCnt * nColCnt];
					ClearDataDescription(pDescription,(nRowCnt * nColCnt));
				}

				pDescription [nIndex].eDescr = eDescr;
				pDescription [nIndex].eAdjust  = CHADJUST_CENTER_CENTER;

				// Prozente sollten immer gesondert behandelt werden (Prost !)
				if ((pDescription [nIndex].eDescr == CHDESCR_PERCENT) ||
					(pDescription [nIndex].eDescr == CHDESCR_TEXTANDPERCENT))
				{
					if (pTotal[nCol] != 0.0)
					{
						pDescription [nIndex].fValue =
						((fabs (fData) / pTotal [nCol]) * 10000.0) / 100.0;
					}
					else
					{
						pDescription [nIndex].fValue = 0.0;
					}
				}
				else
				{
					pDescription [nIndex].fValue = fData;
				}

				if (! bInserted)
				{
					pDescrGroups[nRow] = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_DESCRGROUP, TRUE, TRUE);

					pDescrGroups[nRow]->InsertUserData(new SchDataRow((short)nRow));
					pDescrLists[nRow] = pDescrGroups[nRow]->GetSubList();
					bInserted         = TRUE;
				}

				pDescription [nIndex].bSymbol = ((const SfxBoolItem&)aDataPointAttr.
												Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
				CreateDataDescr(pDescription[nIndex],nCol,nRow,pChartYAxis,FALSE,TRUE);

				pDescription [nIndex].pLabelObj->RecalcBoundRect();

				Size aObjSize = pDescription [nIndex].pLabelObj->GetBoundRect ().GetSize ();

				// wie gross ist der max. Platzbedarf ?
				aObjSize.Width () = (aObjSize.Width () * 6) / 5;
				aDescrOfs.Width() = Max (aObjSize.Width(), aDescrOfs.Width());
				aDescrOfs.Height() = Max (aObjSize.Height(), aDescrOfs.Height());
			}
		} //*************************** END DESCRIPTIONS ***********************************
	}//End for nRow

	// Das Rechteck wird dann etwas kleiner, da Text ausgegeben wird
	if (pDescription)
	{
		aRect.Left()   += aDescrOfs.Width();
		aRect.Top()    += aDescrOfs.Height();
		aRect.Right()  -= aDescrOfs.Width();
		aRect.Bottom() -= aDescrOfs.Height();

		// prozentual verkleinern wir es noch etwas, um einen Offset zum Text zu bekommen
		long nWidth  = (aRect.GetWidth () * 1) / 20;
		long nHeight = (aRect.GetHeight () * 1) / 20;

		aRect.Left ()   += nWidth;
		aRect.Right ()  -= nWidth;
		aRect.Top ()    += nHeight;
		aRect.Bottom () -= nHeight;
	}

	SdrPage* pPage=GetPage(0);
	Size aPageSize = pPage->GetSize();
	if (GetDiagramHasBeenMovedOrResized() && (aInitialSize != aPageSize))
	{                                           //  in dem Fall hat ein Resize stattgefunden
		if (aInitialSize.Width() > aPageSize.Width())
		{
			if (aRect.GetWidth() > aRect.GetHeight())
			{
				aRect.Left() += (aRect.GetWidth() - aRect.GetHeight()) / 2;
				aRect.Right() = aRect.Left() + aRect.GetHeight();
			}
			else if (aRect.GetHeight() > aRect.GetWidth())
			{
				aRect.Top() += (aRect.GetHeight() - aRect.GetWidth()) / 2;
				aRect.Bottom() = aRect.Top() + aRect.GetWidth();
			}
		}
		else
		{
			if (aInitialSize.Height() > aPageSize.Height())
			{
				if (aRect.GetWidth() > aRect.GetHeight())
				{
					aRect.Left() += (aRect.GetWidth() - aRect.GetHeight()) / 2;
					aRect.Right() = aRect.Left() + aRect.GetHeight();
				}
				else if (aRect.GetHeight() > aRect.GetWidth())
				{
					aRect.Top() += (aRect.GetHeight() - aRect.GetWidth()) / 2;
					aRect.Bottom() = aRect.Top() + aRect.GetWidth();
				}
			}
			else
			{
				if (aRect.GetWidth() > aRect.GetHeight())
				{
					aRect.Top() += (aRect.GetHeight() - aRect.GetWidth()) / 2;
					aRect.Bottom() = aRect.Top() + aRect.GetWidth();
				}
				else if (aRect.GetHeight() > aRect.GetWidth())
				{
					aRect.Left() += (aRect.GetWidth() - aRect.GetHeight()) / 2;
					aRect.Right() = aRect.Left() + aRect.GetHeight();
				}
			}
		}
	}
	else  // *************  nicht gemoved oder resized *****************************
	{
		// FG: Hier wird dafuer gesorgt, dass die Chart-Groesse immer ein Rechteck ist.
		if (aRect.GetWidth() > aRect.GetHeight())
		{
			aRect.Left() += (aRect.GetWidth() - aRect.GetHeight()) / 2;
			aRect.Right() = aRect.Left() + aRect.GetHeight();
		}
		else if (aRect.GetHeight() > aRect.GetWidth())
		{
			aRect.Top() += (aRect.GetHeight() - aRect.GetWidth()) / 2;
			aRect.Bottom() = aRect.Top() + aRect.GetWidth();
		}
	}

	ULONG nSegWidth = (aRect.Right() - aRect.Left()) / (2 * (nColCnt + 1));

	for (nCol = 0; nCol < nColCnt; nCol++) //alle Ringe des Donuts
	{
		long nStartAng, nEndAng      = 9000; //90 Grad

		double fTotal = pTotal[nCol];

		for (nRow = 0; nRow < nRowCnt; nRow++) //Alle Datenreihen
		{
			nStartAng      = nEndAng;
			SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow));
			long      nIndex          = nCol + nRow * nColCnt;//            long       nIndex         = nRow + nRowCnt * nCol ;


			double fData = fabs(GetData(nCol, nRow));

			if (fData != DBL_MIN)
			{
				//letzte Datenreihe ?? (eigentlich Unsinn, nur wegen evtl. Rundungsfehler  notwendig?
				if (nRow == nRowCnt - 1)
				{
					nEndAng = 9000;
				}
				else if (fTotal != 0.0)
				{
					nEndAng += (long)((fData / fTotal) * 36000);
				}

				Rectangle aCircRect = aRect;

				if( fData > 0.0 )
					// Die Segmente einer Reihe werden nicht gruppiert!
					// Diese Ausnahme besteht, da sonst eine Reihe Segmente anderer Reihen
					// verdeckt (Gruppenobjekte koennen nicht ineinnander greifen (Problem
					// des Drawinglayer), vorher: pRowLists[nRow]-> ...
					pList->NbcInsertObject( CreateDonutSegment( aDataPointAttr,
															 aCircRect, nSegWidth,
															 nCol, nRow,
															 nStartAng, nEndAng, nRowCnt));
				
				if (pDescription && pDescrLists[nRow] && pDescription [nIndex].pLabelObj)
				{
					//	Draw the description centered into it's segment.
					SegmentDescr (pDescription [nIndex], aCircRect, nStartAng, nEndAng,
						aCircRect.GetWidth () / 2 - nSegWidth / 2);
				}
			}
			else if (pDescription)
			{
				pDescription [nIndex].fValue = DBL_MIN;
			}

		}//Alle Datenreihen

		//Jetzt wird die Flaeche verkleinert, um den naechst-inneren Pie zu zeichnen,
		//Ein Donut ist nichts anderes als ein Tuerme-von-Hanoi artiger Pie-Stapel
		aRect.Left()   += nSegWidth;
		aRect.Top()    += nSegWidth;
		aRect.Right()  -= nSegWidth;
		aRect.Bottom() -= nSegWidth;
	}//Alle Ringe

	const XFillStyleItem &rFillStyleItem = (const XFillStyleItem &) pDiagramAreaAttr->Get (XATTR_FILLSTYLE);
	SfxItemSet           aAreaAttr (*pDiagramAreaAttr);

	if (rFillStyleItem.GetValue () == XFILL_NONE)
	{
		aAreaAttr.Put(XFillStyleItem(XFILL_SOLID));
		aAreaAttr.Put(XFillColorItem(String(), RGBColor(COL_WHITE)));
	}

	aAreaAttr.Put(XLineStyleItem(XLINE_SOLID));
	aAreaAttr.Put(XLineWidthItem(0));
	aAreaAttr.Put(XLineColorItem(String(), RGBColor(COL_BLACK)));

	SdrCircObj* pCirc = new SdrCircObj(OBJ_CIRC, aRect);
	pList->NbcInsertObject(SetObjectAttr( pCirc, CHOBJID_DIAGRAM_AREA, TRUE, TRUE, &aAreaAttr));

	//Descriptions zuletzt, da sie sonst verdeckt sind!
	for(nRow=0;nRow<nRowCnt;nRow++)
	{
		if(pDescrGroups[nRow])
		{
			 pList->NbcInsertObject(pDescrGroups[nRow]);
		}
	}

	pGroup->GetSubList()->SetRectsDirty();

	// Ein Kreisdiagramm soll man nur proportional Resizen koennen (vorerst)
	SdrObjTransformInfoRec aInfo;
	aInfo.bResizeFreeAllowed    = FALSE;
	aInfo.bResizePropAllowed    = TRUE;
	aInfo.bRotateFreeAllowed    = FALSE;
	aInfo.bRotate90Allowed      = FALSE;
	aInfo.bMirrorFreeAllowed    = FALSE;
	aInfo.bMirror45Allowed      = FALSE;
	aInfo.bMirror90Allowed      = FALSE;
	aInfo.bShearAllowed         = FALSE;
	pGroup->SetObjInfo(aInfo);

    Dirty2D (nRowCnt, nColCnt, pDescrLists, TRUE, pDescription);

	delete[] pTotal;
	delete[] pDescription;
	delete[] pDescrLists;
	delete[] pRowLists;
	delete[] pDescrGroups;


	return pGroup;
}
/*************************************************************************
|*
|* XY-Diagramm erzeugen
|*
\************************************************************************/
SdrObjGroup* ChartModel::Create2DXYChart(Rectangle aRect)
{
	long	nColCnt = GetColCount();
    long    nRowCnt = GetRowCount();

	long	nCol, nRow;

	// ask for sorting
	
	BOOL	bSortTable = FALSE;
	BOOL	bRepaint   = FALSE;

	if( IsXYChart() && ! ISFLAGSET( nChartStatus, CHS_USER_NOQUERY ) )	// in this case ask for sorting
	{
		double	fTemp	   = GetData( 0, 0, FALSE );

		// is data unsorted?
		for( nCol = 1; nCol < nColCnt; nCol ++ )
		{
			if( GetData( nCol, 0, FALSE ) < fTemp )
			{
				bSortTable = TRUE;
				break;
			}
			fTemp = GetData( nCol, 0, FALSE );
		}

		// show querybox
		if( bSortTable )
		{
			// if we are not inside the auto-pilot we don't get the Window (View)
			// so NULL is used to create a system window
			// ToDo: the core modules should never create any dialogs
			Window* pDefParent = NULL;
			if( pAutoPilot )
				pDefParent = pAutoPilot;
					
			QueryBox aQueryBox( pDefParent, WB_YES_NO, String(SchResId( STR_QUERY_SORT )));	// #46895#
			bSortTable = (aQueryBox.Execute() == RET_YES);
			bRepaint = TRUE;				  					// repaint necessary after dialog box

			SETFLAG( nChartStatus, CHS_USER_NOQUERY );	// don't ask again
		}

		// user confirmed: now do sorting
		if( bSortTable )
		{
			if( bSwitchData )
				pChartData->SortTableRows(0);
			else
				pChartData->SortTableCols(0);
		}
	}

	SchObjGroup *pGroup;
	SdrObjList  *pList;
	SdrObject   *pObj;
    SdrPathObj  *pLineObject = NULL;

	CreateChartGroup (pGroup, pList);

	SdrPage* pPage = GetPage(0);
	Size aPageSize = pPage->GetSize();

	Create2DBackplane(aRect, *pList, TRUE,CHSTACK_NONE);

	SdrObjList      ** pRowLists   = new SdrObjList*[nRowCnt];
	SdrObjList      ** pStatLists  = new SdrObjList*[nRowCnt];
	Size            aLegendSize (((SvxFontWidthItem &) pLegendAttr->Get (EE_CHAR_FONTWIDTH)).GetWidth (),
								 ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight ());


	ChartDataDescription aDescr(nColCnt,nRowCnt,pList,this,bShowDataDescr);

	//#54884# Was soll das hier? //Create2DXYChart
	if(pRefOutDev)
		aLegendSize = pRefOutDev->PixelToLogic (pRefOutDev->LogicToPixel (aLegendSize));
	else
		DBG_ERROR("ChartModel: no RefDevice");

	long nLegendHeight = aLegendSize.Height () * 9 / 10;

	pRowLists [0]  =
	pStatLists [0] = 0;

	XPolygon aPolygon ((unsigned short)nColCnt);
	XPolygon *pSpline = new XPolygon (nColCnt * nGranularity);

	SfxItemSet aLineAttr(*pItemPool, XATTR_LINE_FIRST, XATTR_LINE_LAST, 0);

	ChartAxis* pAxis=pChartYAxis;
	BOOL    bLogarithmY   = pAxis->IsLogarithm();
	BOOL    bLogarithmX   = pChartXAxis->IsLogarithm();

	// for some reason the ChartRect is one pixel too small
	Rectangle aClipRect( aRect );
	aClipRect.Right() += 1;
	aClipRect.Top() -= 1;

	//	Iterate in reverse order over the data series so that the first one is displayed
	//	in the front and the last one in the back.
	for( nRow = nRowCnt-1; nRow >= 1; nRow-- )
	{
		SchObjGroup* pRowGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_ROWGROUP, TRUE, TRUE);

		pRowGroup->InsertUserData(new SchDataRow((short)nRow));
		pList->NbcInsertObject(pRowGroup);
		pRowLists[nRow] = pRowGroup->GetSubList();

		SchObjGroup* pStatGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_STATISTICS_GROUP, TRUE, TRUE);

		pStatGroup->InsertUserData(new SchDataRow((short)nRow));
		pList->NbcInsertObject(pStatGroup);
		pStatLists [nRow] = pStatGroup->GetSubList ();

		const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);

		pAxis=GetAxisByUID(((const SfxInt32Item&)rDataRowAttr.Get(SCHATTR_AXIS)).GetValue());
		bLogarithmY = pAxis->IsLogarithm();

		long nPos    = aRect.Left();
		long nPoints = 0;
        pLineObject  = NULL;

		if( ((const SfxBoolItem &) rDataRowAttr.Get( SCHATTR_STAT_AVERAGE )).GetValue() )
			pStatLists[ nRow ]->NbcInsertObject( AverageValueY( nRow, FALSE, aRect,
																pAxis->CalcFact( GetAverageValueY( nRow ))));

		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			SfxItemSet aDataPointAttr(rDataRowAttr);//#63904#
			MergeDataPointAttr(aDataPointAttr,nCol,nRow);

			Point  aPoint;
			double fDataY    = GetData(nCol, nRow, FALSE);
			double fDataX    = GetData(nCol, 0, FALSE);

            if (((fDataX != DBL_MIN) && (!bLogarithmX || bLogarithmX && (fDataX > 0.0))) &&
				((fDataY != DBL_MIN) && (!bLogarithmY || bLogarithmY && (fDataY > 0.0))))
			{
				long nXPos = pChartXAxis->GetPos(fDataX);
				long nYPos = pAxis->GetPos(fDataY);

                // expect nPoints to be 0 on first entry of the for loop
                // insert the empty polygon now, so that symbols are painted over the line
                if( nPoints == 0 &&
                    IsLine( nRow ))
                {
                    XPolyPolygon aSeriesPoly;
                    pLineObject = new SdrPathObj( OBJ_PLIN, aSeriesPoly );
                    pRowLists[ nRow ]->NbcInsertObject( pLineObject);
                }
				aPolygon [(USHORT) nPoints].X () = nXPos;
				aPolygon [(USHORT) nPoints].Y () = nYPos;
				nPoints ++;

				aPoint.X () = nXPos;
				aPoint.Y () = nYPos;

				// draw symbols only if they are contained in the diagrams boundrect
				if( aClipRect.IsInside( aPoint ) )
				{
					if(HasSymbols(nRow))
					{
						pObj = CreateSymbol (aPoint, nRow, nCol, aDataPointAttr, nLegendHeight);
						if(pObj)
						{
							pObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));
							pRowLists[nRow]->NbcInsertObject(pObj);
						}
					}

					if ((SvxChartKindError)
						((const SfxInt32Item &) aDataPointAttr.Get (SCHATTR_STAT_KIND_ERROR)).GetValue () != CHERROR_NONE)
						AverageErrorY(nRow,fDataY,aPoint,FALSE,aDataPointAttr,pStatLists[nRow],pAxis);

					if(aDescr.Enabled())
					{
						Point aPos(aPolygon[(USHORT)nPoints-1]);
						aPos.Y () -= 150;
						aDescr.Insert(nCol,nRow,aDataPointAttr,aPos,FALSE,CHADJUST_BOTTOM_CENTER,pAxis);
					}
				}

			}
		}

		if(nPoints && IsLine(nRow))
		{
			long nFill;
			for( nFill = nPoints; nFill < nColCnt; nFill ++ )
				aPolygon[ (USHORT) nFill ] = aPolygon[ (USHORT) nPoints - 1 ];

            // clear old items from last loop pass
            aLineAttr.ClearItem();
			aLineAttr.Put(rDataRowAttr);

			if( nPoints > 1 )
			{
				XPolyPolygon aSeriesPoly;

				if( IsSplineChart () )
				{
					if ((eChartStyle == CHSTYLE_2D_CUBIC_SPLINE_XY) || (eChartStyle == CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY))
						CubicSpline (aPolygon, nPoints - 1, nGranularity,*pSpline);
					else
						approxMesh (nGranularity, *pSpline, aPolygon, nPoints - 1, nSplineDepth);

					long nFillEnd  = nColCnt * nGranularity;
					long nFillFrom = (nPoints - 1) * nGranularity - 1;

					for (nFill = (nPoints - 1) * nGranularity;nFill < nFillEnd;nFill ++)
						(*pSpline)[(USHORT) nFill] = (*pSpline)[(USHORT) nFillFrom];

					SchCalculationHelper::IntersectPolygonWithRectangle( *pSpline, aClipRect, aSeriesPoly );

                    if( pLineObject )
                        pLineObject->NbcSetPathPoly( aSeriesPoly );
                    else
                    {
                        pLineObject = new SdrPathObj( OBJ_PLIN, aSeriesPoly );
                        pRowLists[ nRow ]->NbcInsertObject( pLineObject);
                    }
				}
				else		// series consits of lines
				{
					SchCalculationHelper::IntersectPolygonWithRectangle( aPolygon, aClipRect, aSeriesPoly );

                    if( pLineObject )
                        pLineObject->NbcSetPathPoly( aSeriesPoly );
                    else
                    {
                        pLineObject = new SdrPathObj( OBJ_PLIN, aSeriesPoly );
                        pRowLists[ nRow ]->NbcInsertObject( pLineObject);
                    }
				}

				pLineObject->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_ROWSLINE ));
				pLineObject->InsertUserData( new SchDataRow( (short)nRow ));

//-/				pObj->NbcSetAttributes( aLineAttr, FALSE );
				pLineObject->SetItemSet( aLineAttr);

			}
		}

		// insert regression curve if necessary
		// ------------------------------------
		if (((const SfxInt32Item &) rDataRowAttr.Get (SCHATTR_STAT_REGRESSTYPE)).GetValue () != CHREGRESS_NONE)
		{
			double fConst;
			double fReg;
			double fCorr;

			RegressionYX(nRow,fConst,fReg,fCorr,(SvxChartRegress)((const SfxInt32Item &)
				rDataRowAttr.Get(SCHATTR_STAT_REGRESSTYPE)).GetValue ());

			pObj = NULL;

			if ( !bLogarithmY && !bLogarithmX &&
			   ((const SfxInt32Item &) rDataRowAttr.Get (SCHATTR_STAT_REGRESSTYPE)).GetValue () == CHREGRESS_LINEAR)
			{
				Point aStart, aEnd;

				double fLeft  = GetData( 0, 0, FALSE );
				double fRight = GetData( nColCnt - 1, 0, FALSE );

				for( nCol = 0; nCol < nColCnt; nCol++ )
				{
					double fTemp = GetData (nCol, 0, FALSE);

					if( fLeft > fTemp )
						fLeft = fTemp;
					if( fRight < fTemp )
						fRight = fTemp;
				}

				aStart.X() = pChartXAxis->GetPos( fLeft );
				aStart.Y() = pAxis->GetPos( fConst + fReg * fLeft );

				aEnd.X()   = pChartXAxis->GetPos( fRight );
				aEnd.Y()   = pAxis->GetPos( fConst + fReg * fRight );

				Line aRegLine( aStart, aEnd );
				if( SchCalculationHelper::ClipLineAtRectangle( aRegLine, aClipRect ) )
				{
					pObj = new SdrPathObj( aRegLine.GetStart(), aRegLine.GetEnd() );
				}
			}
			else
			{
				XPolygon aRegression (nColCnt * 10 + 1);

				for (nCol = 0;nCol < nColCnt - 1;nCol ++)
				{
					double fValXAct1 = GetData(nCol + 1, 0, FALSE);
					double fValXAct  = GetData(nCol, 0, FALSE);
					long   nEnd  = (nCol < nColCnt - 2) ? 10: 11;

                    //	Step width (for ten steps) depends on the bLogartihmX
                    //	flag.  If set then IncValue increases the current value
                    //	by multiplying it with fStep, else addition is used.
                    //	The step width is calculated accordingly.
					double fStep;
                    if (bLogarithmX)
                    	//	10-th root of ratio.
                    	fStep = pow(fValXAct1 / fValXAct, 1.0 / 10);
                    else
                    	//	10-th part of difference.
						fStep = (fValXAct1 - fValXAct) / 10;

					for (long nStep = 0;nStep < nEnd;nStep ++)
					{
						aRegression [nCol*10+(USHORT)nStep].X()=pChartXAxis->GetPos(fValXAct);//= aRect.Left() + (long)(pChartXAxis->CalcFact(fValXAct) * aRect.GetWidth());

						double fValY1;

						switch (((const SfxInt32Item &) rDataRowAttr.Get(SCHATTR_STAT_REGRESSTYPE)).GetValue ())
						{
							case CHREGRESS_LINEAR :
								fValY1 = fConst + fReg * fValXAct;
								break;

							case CHREGRESS_LOG :
								fValY1 = fConst + fReg * log (fValXAct);
								break;

							case CHREGRESS_EXP :
								fValY1 = fConst * exp (fReg * fValXAct);
								break;

							case CHREGRESS_POWER :
								fValY1 = fConst * exp (fReg * log (fValXAct));

						}
						aRegression [nCol*10+(USHORT)nStep].Y() = pAxis->GetPos(fValY1);
						IncValue(fValXAct, fStep, bLogarithmX);
					}
				}

				XPolyPolygon aPolyPoly;
				SchCalculationHelper::IntersectPolygonWithRectangle( aRegression, aClipRect, aPolyPoly );

				pObj = new SdrPathObj( OBJ_PLIN, aPolyPoly );
			}

			if( pObj )
			{
				pObj->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_REGRESSION ) );
				pObj->InsertUserData( new SchDataRow( (short)nRow ) );
				pList->NbcInsertObject( pObj );

//-/				pObj->NbcSetAttributes( GetRegressAttr( nRow ), FALSE );
				pObj->SetItemSet(GetRegressAttr(nRow));

			}
		}
	}

	aDescr.Build(TRUE);

	if( bRepaint )
		pPage->SendRepaintBroadcast();
	
	delete[] pRowLists;
	delete[] pStatLists;
	delete pSpline;
	return pGroup;
}


/*************************************************************************
|*
|* Netzdiagramm erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::Create2DNetChart(Rectangle aRect)
{
	//vorlaeufiger Hack, bis logarithmus-Ueberpruefung eingebaut (autokorrektur):
	pChartXAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM,FALSE));
	pChartYAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM,FALSE));

	//ToDo: vorlaeufig
	SfxItemSet* pXAxisAttr=&GetAttr(CHOBJID_DIAGRAM_X_AXIS);
	SfxItemSet* pYAxisAttr=&GetAttr(CHOBJID_DIAGRAM_Y_AXIS);

	SchObjGroup *pGroup;
	SdrObjList  *pList;
	SdrObject   *pObj;

	CreateChartGroup (pGroup, pList);

	long 	nColCnt = GetColCount();
	long 	nRowCnt = GetRowCount();
	long 	nCol, nRow;

	BOOL    bPercent   = IsPercent();
	BOOL    bStacked   = IsStacked();

	// bPercent => bStacked ... ersetzt: (bPercent || bStacked)  durch bStacked
	USHORT  eStackMode =  bStacked ? CHSTACK_MINMAX : CHSTACK_NONE;

	Size            aYDescrSize;
	SdrObjList      ** pRowLists    = new SdrObjList*[nRowCnt];
	SdrObjList      ** pDescrLists  = new SdrObjList*[nRowCnt];
	DataDescription* pDescription   = NULL;
	SdrObjList      *pYAxisList     = pChartYAxis->IsVisible()
										  ? CreateGroup (*pList, CHOBJID_DIAGRAM_Y_AXIS, 0)
										  : NULL;
	SdrObjList      *pXGridMainList = bShowXGridMain
										  ? CreateGroup (*pList, CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP, 0)
										  : 0;
	SdrObjList      *pXGridHelpList = bShowXGridHelp
										  ? CreateGroup (*pList, CHOBJID_DIAGRAM_X_GRID_HELP_GROUP, 0)
										  : 0;

	XPolygon aDataLine (nColCnt + 1);
	SfxItemSet aLineAttr(*pItemPool, XATTR_LINE_FIRST, XATTR_LINE_LAST, 0);
	SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
	aTextAttr.Put(*pYAxisAttr);

	if (aRect.GetWidth() > aRect.GetHeight())
	{
		aRect.Left() += (aRect.GetWidth() - aRect.GetHeight()) / 2;
		aRect.Right() = aRect.Left() + aRect.GetHeight();
	}
	else if (aRect.GetHeight() > aRect.GetWidth())
	{
		aRect.Top() += (aRect.GetHeight() - aRect.GetWidth()) / 2;
		aRect.Bottom() = aRect.Top() + aRect.GetWidth();
	}

	if (pChartYAxis->HasDescription())
	{
		aYDescrSize = Size (((SvxFontWidthItem &) pYAxisTitleAttr->Get (EE_CHAR_FONTWIDTH)).GetWidth (),
							((SvxFontHeightItem &) pYAxisTitleAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight ());

		aRect.Bottom () -= (aYDescrSize.Height () * 12) / 5;
		aRect.Top ()    += (aYDescrSize.Height () * 12) / 5;
	}

	long   nLength    = aRect.GetHeight () / 2;
	long   nOffsetX   = aRect.Left () + aRect.GetWidth () / 2;
	long   nOffsetY   = aRect.Top () + aRect.GetHeight () / 2;
	double fAngleStep = F_PI * 2 / nColCnt;
	long   aOldPos    = 0;


	BOOL bSwitchColRow=IsDataSwitched();
	pChartYAxis->Initialise(aRect,bSwitchColRow,eStackMode,bPercent,TRUE);
	pChartYAxis->CalcValueSteps();

	Size aMaxValueSizeY = pChartYAxis->CalcMaxTextSize(CHTXTORIENT_STANDARD);
	//nur zu test zwecken

	XPolygon aLine (2);
	double fSteps = pChartYAxis->GetMax();
	double* fOldData = new double[nColCnt];
	double fAngle = F_PI / 2;

	Size aLegendSize (((SvxFontWidthItem &) pLegendAttr->Get (EE_CHAR_FONTWIDTH)).GetWidth (),
					  ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight ());

	//#54884# Was soll das hier? Create2DNetChart
	if(pRefOutDev)
		aLegendSize = pRefOutDev->PixelToLogic (pRefOutDev->LogicToPixel (aLegendSize));
	else
		DBG_ERROR("ChartModel: no RefDevice");

	long nLegendHeight = aLegendSize.Height () * 9 / 10;

	if (pChartYAxis->HasDescription())
		while (fSteps >= pChartYAxis->GetMin())
		{
			double fLength = nLength * pChartYAxis->CalcFact(fSteps);

			for (nCol = 0; nCol < nColCnt; nCol++)
			{
				double fCos = cos (fAngle);
				double fSin = sin (fAngle);

				aLine [1].X () = (long) (nOffsetX + fLength * fCos + nMarkLen * fSin);
				aLine [1].Y () = (long) (nOffsetY - fLength * fSin + nMarkLen * fCos);
				aLine [0].X () = (long) (nOffsetX + fLength * fCos - nMarkLen * fSin);
				aLine [0].Y () = (long) (nOffsetY - fLength * fSin - nMarkLen * fCos);

				pYAxisList->NbcInsertObject(SetObjectAttr (new SdrPathObj(OBJ_PLIN, aLine), CHOBJID_LINE,
														   TRUE, TRUE, pAxisAttr));

				if (fSteps == pChartYAxis->GetMax())
				{
					Point aTextPos ((long) (nOffsetX + nLength * fCos),
									(long) (nOffsetY - nLength * fSin));
					ChartAdjust eAdjust;

					if (fAngle > 0 && fAngle < F_PI / 4)
					{
						eAdjust = CHADJUST_CENTER_LEFT;
						aTextPos.X () = (long) (nOffsetX + nLength * fCos + (aYDescrSize.Height () * 6) / 5);
					}
					else if (fAngle >= F_PI / 4 && fAngle <= 3 * F_PI / 4)
						 {
							 eAdjust = CHADJUST_BOTTOM_CENTER;
							 aTextPos.Y () = (long) (nOffsetY - nLength * fSin - (aYDescrSize.Height () * 6) / 5);
						 }
						 else if (fAngle > 3 * F_PI / 4 && fAngle <= 5 * F_PI / 4)
							  {
								  eAdjust = CHADJUST_CENTER_RIGHT;
								  aTextPos.X () = (long) (nOffsetX + nLength * fCos - (aYDescrSize.Height () * 6) / 5);
							  }
							  else if (fAngle > 5 * F_PI / 4 && fAngle <= 7 * F_PI / 4)
								   {
									   eAdjust = CHADJUST_TOP_CENTER;
									   aTextPos.Y () = (long) (nOffsetY - nLength * fSin + (aYDescrSize.Height () * 6) / 5);
								   }
								   else
								   {
									   eAdjust = CHADJUST_CENTER_LEFT;
									   aTextPos.X () = (long) (nOffsetX + nLength * fCos + (aYDescrSize.Height () * 6) / 5);
								   }

					pYAxisList->NbcInsertObject(CreateTextObj(CHOBJID_TEXT, aTextPos,
															  ColText(nCol),
															  aTextAttr,
															  FALSE, eAdjust));
				}

				fAngle += fAngleStep;
			}

			if (pChartYAxis->HasDescription())
			{
				Color* pDummy = NULL;
				String aNumStr;
				Point aPos;

				pNumFormatter->GetOutputString((bPercent)?fSteps/100.0:fSteps,
					GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,bPercent),aNumStr,&pDummy);

				aPos.X() = (long) (nOffsetX + nMarkLen);
				aPos.Y() = (long) (nOffsetY - fLength);

					if (aPos.Y () - aMaxValueSizeY.Height () > aOldPos)
					{
						pYAxisList->NbcInsertObject(CreateTextObj(CHOBJID_TEXT, aPos, aNumStr,
																  aTextAttr, FALSE, CHADJUST_CENTER_LEFT));
						aOldPos = aPos.Y ();
					}
			}

			if (pXGridMainList)
			{
				Rectangle aCircRect ((long) (nOffsetX - fLength),
									 (long) (nOffsetY - fLength),
									 (long) (nOffsetX + fLength),
									 (long) (nOffsetY + fLength));

				SfxItemSet aCircAttr (*pItemPool,
									  XATTR_LINE_FIRST, XATTR_LINE_LAST,
									  XATTR_FILL_FIRST, XATTR_FILL_LAST,
									  0);

				aCircAttr.Put (XLineColorItem (String (),
							   ((XLineColorItem &) pXGridMainAttr->Get (XATTR_LINECOLOR)).GetValue ()));
				aCircAttr.Put (XFillColorItem (String (),
							   ((XFillColorItem &) pXGridMainAttr->Get (XATTR_FILLCOLOR)).GetValue ()));
				aCircAttr.Put (XLineStyleItem (((XLineStyleItem &) pXGridMainAttr->Get (XATTR_LINESTYLE)).
											   GetValue ()));
				aCircAttr.Put (XLineWidthItem (((XLineWidthItem &) pXGridMainAttr->Get (XATTR_LINEWIDTH)).
											   GetValue ()));
				aCircAttr.Put (XFillStyleItem(XFILL_NONE));
				SdrCircObj* pCirc = new SdrCircObj( OBJ_CIRC, aCircRect );
				pCirc->SetModel( this );
				pXGridMainList->NbcInsertObject(SetObjectAttr( pCirc,
															   CHOBJID_DIAGRAM_NET, TRUE, TRUE,
															   &aCircAttr));
			}

			DecValue(fSteps, pChartYAxis->GetStep(), FALSE);

			if (pChartYAxis->GetStep() == 0.0) break;
		}

	fSteps = pChartYAxis->GetMax();

	if (pXGridHelpList)
		while (fSteps >= pChartYAxis->GetMin())
		{
			double fLength = nLength * pChartYAxis->CalcFact(fSteps);

			Rectangle aCircRect ((long) (nOffsetX - fLength),
								 (long) (nOffsetY - fLength),
								 (long) (nOffsetX + fLength),
								 (long) (nOffsetY + fLength));

			SfxItemSet aCircAttr (*pItemPool,
								  XATTR_LINE_FIRST, XATTR_LINE_LAST,
								  XATTR_FILL_FIRST, XATTR_FILL_LAST,
								  0);

			aCircAttr.Put (XLineColorItem (String (),
						   ((XLineColorItem &) pXGridHelpAttr->Get (XATTR_LINECOLOR)).GetValue ()));
			aCircAttr.Put (XFillColorItem (String (),
						   ((XFillColorItem &) pXGridHelpAttr->Get (XATTR_FILLCOLOR)).GetValue ()));
			aCircAttr.Put (XLineStyleItem (((XLineStyleItem &) pXGridHelpAttr->Get (XATTR_LINESTYLE)).
										   GetValue ()));
			aCircAttr.Put (XLineWidthItem (((XLineWidthItem &) pXGridHelpAttr->Get (XATTR_LINEWIDTH)).
										   GetValue ()));
			aCircAttr.Put (XFillStyleItem(XFILL_NONE));

			SdrCircObj* pCirc = new SdrCircObj( OBJ_CIRC, aCircRect );
			pCirc->SetModel( this );
			pXGridHelpList->NbcInsertObject(SetObjectAttr( pCirc,
														   CHOBJID_DIAGRAM_X_GRID_HELP, TRUE, TRUE,
														   &aCircAttr));

			DecValue(fSteps, pChartYAxis->GetStep(), FALSE);

			if (pChartYAxis->GetStep() == 0.0) break;
		}

	fSteps = pChartYAxis->GetMin();

	for (nRow = 0; nRow < nRowCnt; nRow++)
	{
		const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);
		Point aFirstPoint;
		fAngle = F_PI / 2;
		long nPoints = 0;

		SchObjGroup* pRowGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_ROWGROUP, TRUE, TRUE);

		pRowGroup->InsertUserData(new SchDataRow((short)nRow));
		pList->NbcInsertObject(pRowGroup);
		pRowLists[nRow] = pRowGroup->GetSubList();
		pDescrLists[nRow] = 0;

		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			SfxItemSet aDataPointAttr(rDataRowAttr);//#63904#
			MergeDataPointAttr(aDataPointAttr,nCol,nRow);

			long nIndex = nCol + nRow * nColCnt;
//			double fData = fabs(GetData(nCol, nRow, bPercent));
			double fData = GetData(nCol, nRow, bPercent);

			if (pYAxisList)
			{
				if (!nRow)
				{
					aLine [0].X () = (long) (nOffsetX + nLength * cos (fAngle));
					aLine [0].Y () = (long) (nOffsetY - nLength * sin (fAngle));
					aLine [1].X () = nOffsetX;
					aLine [1].Y () = nOffsetY;

					pYAxisList->NbcInsertObject(SetObjectAttr (new SdrPathObj(OBJ_PLIN, aLine),
															   CHOBJID_LINE, TRUE, TRUE, pYAxisAttr));
				}
			}

			SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)aDataPointAttr.
											Get(SCHATTR_DATADESCR_DESCR)).GetValue();

			if( (eDescr != CHDESCR_NONE) && bShowDataDescr)
			{
				/**************************************************************
				* DataDescription erforderlich
				**************************************************************/
				if (!pDescription)
				{
					// DataDescription noch nicht vorhanden -> erzeugen
					pDescription = new DataDescription [nRowCnt * nColCnt];
					ClearDataDescription(pDescription,(nRowCnt * nColCnt));
				}

				pDescription [nIndex].eDescr = eDescr;
				pDescription [nIndex].bSymbol = ((const SfxBoolItem&)aDataPointAttr.
												Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();

				if (!pDescrLists[nRow])
				{
					SchObjGroup* pDescrGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_DESCRGROUP, TRUE, TRUE);

					pDescrGroup->InsertUserData(new SchDataRow((short)nRow));
					pList->NbcInsertObject(pDescrGroup);
					pDescrLists[nRow] = pDescrGroup->GetSubList();
				}
			}

			if (bStacked && !nRow) fOldData[nCol] = pChartYAxis->GetOrigin();

			if (fData != DBL_MIN)
			{
				if (bStacked && nRow) fData += fOldData[nCol];

				double fLength = nLength * pChartYAxis->CalcFact(fData);

				aDataLine [(USHORT) nPoints].X () = (long) (nOffsetX + fLength * cos (fAngle));
				aDataLine [(USHORT) nPoints].Y () = (long) (nOffsetY - fLength * sin (fAngle));

				if (!nCol)
				{
					aFirstPoint.X () = aDataLine [(USHORT) nPoints].X();
					aFirstPoint.Y () = aDataLine [(USHORT) nPoints].Y();
				}

				nPoints ++;

				if(HasSymbols(nRow)) // if ((eChartStyle == CHSTYLE_2D_NET_SYMBOLS) ||(eChartStyle == CHSTYLE_2D_NET_SYMBOLS_STACK) ||(eChartStyle == CHSTYLE_2D_NET_SYMBOLS_PERCENT))
				{
					SdrObject *pNewObj = CreateSymbol (aDataLine[nPoints - 1], nRow, nCol,
													   (SfxItemSet &) rDataRowAttr, nLegendHeight);
					if(pNewObj)
					{
						pNewObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));
						pRowLists[nRow]->NbcInsertObject(pNewObj);
					}
				}

				fOldData [nCol] = fData;

				ChartAdjust eAdjust;

				if (fAngle > 0 && fAngle < F_PI / 4)
				{
					eAdjust = CHADJUST_CENTER_LEFT;
				}
				else if (fAngle >= F_PI / 4 && fAngle <= 3 * F_PI / 4)
					 {
						 eAdjust = CHADJUST_BOTTOM_CENTER;
					 }
					 else if (fAngle > 3 * F_PI / 4 && fAngle <= 5 * F_PI / 4)
						  {
							  eAdjust = CHADJUST_CENTER_RIGHT;
						  }
						  else if (fAngle > 5 * F_PI / 4 && fAngle <= 7 * F_PI / 4)
							   {
								   eAdjust = CHADJUST_TOP_CENTER;
							   }
							   else
							   {
								   eAdjust = CHADJUST_CENTER_LEFT;
							   }

				if (pDescription)
				{
					pDescription [nIndex].fValue = GetData(nCol,nRow,FALSE);//#55586# fData;
					pDescription [nIndex].aTextPos2D.X () = aDataLine [nPoints - 1].X ();
					pDescription [nIndex].aTextPos2D.Y () = aDataLine [nPoints - 1].Y ();
					pDescription [nIndex].eAdjust         = eAdjust;
					CreateDataDescr(pDescription[nIndex],nCol,nRow,pChartYAxis,FALSE);
				}
			}
			else
			{
				if (nPoints)
				{
					for (long nFill = nPoints;nFill < nColCnt;nFill ++)
						aDataLine [(USHORT) nFill] = aDataLine [(USHORT) nPoints - 1];

					aLineAttr.Put(rDataRowAttr);

					pObj = new SdrPathObj(OBJ_PLIN, aDataLine);
					pObj->InsertUserData(new SchObjectId (CHOBJID_DIAGRAM_ROWSLINE));
					pObj->InsertUserData(new SchDataRow((short)nRow));
					pRowLists[nRow]->NbcInsertObject(pObj,0); //#54870# Linie nach hinten

//-/					pObj->NbcSetAttributes(aLineAttr, FALSE);
					pObj->SetItemSet(aLineAttr);

					nPoints = 0;
				}

				if (pDescription)
				{
					pDescription [nIndex].fValue = DBL_MIN;
				}
			}

			fAngle += fAngleStep;
			if (fAngle > 2 * F_PI) fAngle -= 2 * F_PI;
		}

		if (nPoints)
		{
			for (long nFill = nPoints;nFill < nColCnt;nFill ++)
				aDataLine [(USHORT) nFill] = aDataLine [(USHORT) nPoints - 1];

			if (aFirstPoint.X () && aFirstPoint.Y ())
			{
				aDataLine [(unsigned short)nColCnt].X () = aFirstPoint.X ();
				aDataLine [(unsigned short)nColCnt].Y () = aFirstPoint.Y ();
			}
			else
			{
				aDataLine [(unsigned short)nColCnt].X () = aDataLine [nColCnt - 1].X ();
				aDataLine [(unsigned short)nColCnt].Y () = aDataLine [nColCnt - 1].Y ();
			}

			aLineAttr.Put(rDataRowAttr);

			pObj = new SdrPathObj(OBJ_PLIN, aDataLine);
			pObj->InsertUserData(new SchObjectId (CHOBJID_DIAGRAM_ROWSLINE));
			pObj->InsertUserData(new SchDataRow((short)nRow));
			pRowLists[nRow]->NbcInsertObject(pObj,0);//#54870# hinter die Symbole mit der Linie

//-/			pObj->NbcSetAttributes(aLineAttr, FALSE);
			pObj->SetItemSet(aLineAttr);

		}

		IncValue(fSteps, pChartYAxis->GetStep(), FALSE);

		if (pChartYAxis->GetStep() == 0.0) break;
	}

	Dirty2D (nRowCnt, nColCnt, pDescrLists, TRUE/*FALSE*/, pDescription);

	delete[] pDescription;
	delete[] pDescrLists;
	delete[] pRowLists;
	delete[] fOldData;
	return pGroup;
}

/*************************************************************************
|*
|* Frisiere die % auf 100%
|*
\************************************************************************/

void ChartModel::Dirty2D (long            nRowCnt,
						  long            nColCnt,
						  SdrObjList      **pDescrLists,
						  BOOL            bRowDescr,
						  DataDescription *pDescription)
{
    if (!pDescription)
		return;

	long nStart = IsXYChart() ? 1 : 0;

	if (bRowDescr)
	{
		for (long nCols = 0;nCols < nColCnt;nCols ++)
		{
			double fTotal = 0.0;
			double fMax   = 0.0;
			long   nDirty = 0;

            //	Calculate the total of all segements with percentage value and 
			//	remember the largest segment's index in nDirty and its value in fMax.
			for (long nRows = nStart;nRows < nRowCnt;nRows ++)
				if (pDescrLists [nRows])
				{
					long   nIndex= nCols + nRows * nColCnt;
					if ((pDescription [nIndex].eDescr == CHDESCR_PERCENT) ||
						(pDescription [nIndex].eDescr == CHDESCR_TEXTANDPERCENT))
					{
						double fTemp = pDescription [nIndex].fValue;
	
						if (fTemp != DBL_MIN)
						{
							fTotal += fTemp;
							if (fMax < fTemp)
							{
								fMax   = fTemp;
								nDirty = nIndex;
							}
						}
					}
				}

			BOOL bIsDirty = FALSE;

			for (nRows = nStart;nRows < nRowCnt;nRows ++)
				if (pDescrLists[nRows])
				{
					long nIndex = nCols + nRows * nColCnt;//                    long nIndex = nRows + nCols * nRowCnt;

					if (!bIsDirty)
						if ((pDescription [nIndex].eDescr == CHDESCR_PERCENT) ||
							(pDescription [nIndex].eDescr == CHDESCR_TEXTANDPERCENT))
							if (fTotal > 100.0000001)
							{
								DBG_ERROR2( "Dirty2D: ROW value is being changed total=%lf, Vman=%lf",
											fTotal, pDescription[nDirty].fValue );
								pDescription [nDirty].fValue -= fTotal - 100.0;
								bIsDirty                      = TRUE;
								delete pDescription [nIndex].pLabelObj;
								CreateDataDescr(pDescription[nIndex],nCols,nRows,NULL,bRowDescr,TRUE);
							}

					if (pDescription [nIndex].fValue != DBL_MIN)
						if( pDescription[nIndex].pLabelObj )
							pDescrLists[nRows]->NbcInsertObject( pDescription[nIndex].pLabelObj );
				}
		}
	}
	else
	{
		for (long nRows = nStart;nRows < nRowCnt; nRows ++)
		{
			if ( ! pDescrLists[nRows])
            	continue;
                
			double fTotal = 0.0;
			double fMax   = 0.0;
			long   nDirty = 0;

            //	Calculate the total of all segements with a percentage value and
			//	remember the largest segment's index in nDirty and its value in fMax.
			for (long nCols = 0;nCols < nColCnt;nCols ++)
			{
				long   nIndex = nCols + nRows * nColCnt;
				if ((pDescription [nIndex].eDescr == CHDESCR_PERCENT) ||
					(pDescription [nIndex].eDescr == CHDESCR_TEXTANDPERCENT))
				{
					double fTemp = pDescription [nIndex].fValue;

					if (fTemp != DBL_MIN)
					{
						fTotal += fTemp;
						if (fMax < fTemp)
						{
							fMax   = fTemp;
							nDirty = nIndex;
						}
					}
				}
			}

			BOOL bIsDirty = FALSE;

			for (nCols = 0;nCols < nColCnt;nCols ++)
			{
				long nIndex = nCols + nRows * nColCnt;

				if (!bIsDirty)
					if ((pDescription [nIndex].eDescr == CHDESCR_PERCENT) ||
						(pDescription [nIndex].eDescr == CHDESCR_TEXTANDPERCENT))
						if (fTotal > 100.0000001)
						{
							DBG_ERROR2( "Dirty2D: COL value is being changed total=%lf, Vman=%lf",
										fTotal, pDescription[nDirty].fValue );
							pDescription [nDirty].fValue -= fTotal - 100.0;
							bIsDirty                      = TRUE;
							delete pDescription[nIndex].pLabelObj;
							CreateDataDescr(pDescription[nIndex],nCols,nRows,NULL,bRowDescr,TRUE);
						}
                        
				if (pDescription[ nIndex ].fValue != DBL_MIN)
					if( pDescription[ nIndex ].pLabelObj )
						pDescrLists[nRows]->NbcInsertObject( pDescription[ nIndex ].pLabelObj );
			}
		}
	}
}

/*************************************************************************
|*
|* Trage ggf. Mittelwert und Fehlerbalken ein
|*
\************************************************************************/
void ChartModel::AverageErrorY(long       nRow,
							   double     fData,
							   const Point& rPos,
							   BOOL       bVertical,
							   SfxItemSet &rAttr,
							   SdrObjList *pList,
							   ChartAxis  *pAxis)
{
	Rectangle rRect(pAxis->GetArea());//sollte mal nach aRect umbenannt werden...oder besser raus!
	SfxItemSet &pBlackSet =(SfxItemSet &)GetErrorAttr (nRow);

	long nLow,nLen;

	if(bVertical)
	{
		nLow=rRect.Left();
		nLen= - rRect.GetWidth();
	}
	else
	{
		nLow=rRect.Bottom();
		nLen=rRect.GetHeight();
	}
	switch ((SvxChartKindError) ((const SfxInt32Item &) rAttr.Get (SCHATTR_STAT_KIND_ERROR)).GetValue ())
	{
		case CHERROR_VARIANT :
		{
			double fVariant     = GetVariantY (nRow);
			double fVariantUp   = nLow - pAxis->CalcFact(fData + fVariant) * nLen;
			double fVariantDown = nLow - pAxis->CalcFact(fData - fVariant) * nLen;

			ShowErrorLineY (bVertical, fVariantUp, fVariantDown, pBlackSet,rPos,
							(SvxChartIndicate) ((const SfxInt32Item &) rAttr.Get (SCHATTR_STAT_INDICATE)).GetValue (),
							pList);
			break;
		}

		case CHERROR_SIGMA :
		{
			double fSigma     = GetSigmaY (nRow);
			double fSigmaUp   = nLow - pAxis->CalcFact(fData + fSigma) * nLen;
			double fSigmaDown = nLow - pAxis->CalcFact(fData - fSigma) * nLen;

			ShowErrorLineY (bVertical, fSigmaUp, fSigmaDown, pBlackSet,rPos,
							(SvxChartIndicate) ((const SfxInt32Item &) rAttr.Get (SCHATTR_STAT_INDICATE)).GetValue (),
							pList);
			break;
		}

		case CHERROR_PERCENT :
		{
			double fPercent     = fData * ((const SvxDoubleItem &) rAttr.Get (SCHATTR_STAT_PERCENT)).GetValue () / 100.0;
			double fPercentUp   = nLow - pAxis->CalcFact(fData + fPercent) * nLen;
			double fPercentDown = nLow - pAxis->CalcFact(fData - fPercent) * nLen;

			ShowErrorLineY (bVertical, fPercentUp, fPercentDown, pBlackSet,rPos,
							(SvxChartIndicate) ((const SfxInt32Item &) rAttr.Get (SCHATTR_STAT_INDICATE)).GetValue (),
							pList);
			break;
		}

		case CHERROR_BIGERROR :
		{
			double fError     = GetBigErrorY (nRow, ((const SvxDoubleItem &) rAttr.Get (SCHATTR_STAT_BIGERROR)).
											  GetValue ());
			double fErrorUp   = nLow - pAxis->CalcFact(fData + fError) * nLen;
			double fErrorDown = nLow - pAxis->CalcFact(fData - fError) * nLen;

			ShowErrorLineY (bVertical, fErrorUp, fErrorDown, pBlackSet,rPos,
							(SvxChartIndicate) ((const SfxInt32Item &) rAttr.Get (SCHATTR_STAT_INDICATE)).GetValue (),
							pList);
			break;
		}

		case CHERROR_CONST :
		{
			double fErrorUp   = nLow - pAxis->CalcFact(fData +
														 ((const SvxDoubleItem &) rAttr.Get (SCHATTR_STAT_CONSTPLUS)).
														  GetValue ()) * nLen;
			double fErrorDown = nLow - pAxis->CalcFact(fData -
														  ((const SvxDoubleItem &) rAttr.Get (SCHATTR_STAT_CONSTMINUS)).
														  GetValue ()) * nLen;

			ShowErrorLineY (bVertical, fErrorUp, fErrorDown, pBlackSet,rPos,
							(SvxChartIndicate) ((const SfxInt32Item &) rAttr.Get (SCHATTR_STAT_INDICATE)).GetValue (),
							pList);
		}

		case CHERROR_NONE :
		default :
			;
	}
}

/*************************************************************************
|*
|* Erstelle Kreissegment
|*
\************************************************************************/
SdrObject *ChartModel::CreatePieSegment(SfxItemSet &rAttr,
							 Rectangle  &rRect,
							 long       nCol,
							 long       nRow,
							 long       nStartAngle,
							 long       nEndAngle,
							 long       nCnt)
{
	SdrObject  *pObj;

	// BM: Attention: Small angles are treated as equal, if they are equal
	//     after divided by 10. That is because that is also done in the
	//	   drawing layer. Giving angles which differ by 1 causes the creation
	//	   of a full circle.

	if( nCnt == 1 )	 // only one datarow => whole circle
	{
		pObj = new SdrCircObj( OBJ_CIRC, rRect );
		pObj->SetModel( this );
		SetObjectAttr( pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &rAttr);
	}
	else if( (nStartAngle/10) - (nEndAngle/10) )		// create pie segment
	{
		pObj = new SdrCircObj( OBJ_SECT, rRect, nStartAngle, nEndAngle );
		pObj->SetModel( this );
		SetObjectAttr( pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &rAttr );
	}
	else // the segment is treated as line
	{
		pObj = new SdrCircObj( OBJ_SECT, rRect, nStartAngle, nStartAngle );
		pObj->SetModel( this );
		SetObjectAttr( pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &rAttr );
	}
	pObj->InsertUserData(new SchDataPoint((short)nCol, (short)nRow));
	return pObj;
}

/*************************************************************
|*
|* create donut segment - same as circle segment for now
|*
\*************************************************************/
SdrObject* ChartModel::CreateDonutSegment( SfxItemSet& aAttr,
										   Rectangle&  aRect, ULONG nWidth,
										   long nCol,		  long nRow,
										   long nStartAngle,  long nEndAngle,
										   long nCount)
{
	SdrObject* pObj;
	if( nStartAngle > nEndAngle )
		nStartAngle += 36000;

	if( nCount==1 || nStartAngle==nEndAngle )	// we have to paint complete ring
	{
		pObj = new SdrCircObj( OBJ_CIRC, aRect );
		pObj->SetModel( this );
		SetObjectAttr( pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &aAttr );
	}
	else
	{
		pObj = new SdrCircObj( OBJ_SECT, aRect, nStartAngle, nEndAngle );
		pObj->SetModel( this );
		SetObjectAttr( pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &aAttr );
	}
	pObj->InsertUserData( new SchDataPoint( (short)nCol, (short)nRow ));
	return pObj;
}

/*************************************************************************
|*
|* Objektgruppe erzeugen
|*
\************************************************************************/
SdrRectObj *ChartModel::CreateRect (Rectangle  &rRect,long nCol,long nRow,SfxItemSet &rAttr)
{
	SdrRectObj* pRectObj = new SdrRectObj( rRect );
	pRectObj->SetModel( this );
	SetObjectAttr( pRectObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &rAttr );
	pRectObj->InsertUserData(new SchDataPoint((short) nCol, (short) nRow));
	return pRectObj;
}
