/*************************************************************************
 *
 *  $RCSfile: chtmode4.cxx,v $
 *
 *  $Revision: 1.34.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:39:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pairs.hxx"

#include <svx/eeitem.hxx>
#include <sfx2/sfxsids.hrc>
#pragma hdrstop
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SFX_PRINTER_HXX
#include <sfx2/printer.hxx>
#endif

#include <svx/editdata.hxx>
#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#define ITEMID_CHARTSTYLE       CHATTR_DIAGRAM_STYLE
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>
#endif

#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH
#include <svx/fhgtitem.hxx>
#include <svx/fwdtitem.hxx>
#ifndef _CHTMODEL_HXX
#include <globfunc.hxx>
#include <chtmodel.hxx>
#endif
#include <svx/svdoutl.hxx>	// wg. SdrOutliner
#ifndef __SVDPAGE_HXX
#include <svx/svdpage.hxx>
#endif
#ifndef _SCH_OBJADJ_HXX
#include  "objadj.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SVX_DLGUTIL_HXX
#include  <svx/dlgutil.hxx>
#endif

#include "chtscene.hxx"
#include "glob.hrc"
#include <math.h>
#include <float.h>

#include "chmod3d.hxx"
#include "docshell.hxx"

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

#ifndef	_RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif

#include "chaxis.hxx"
#include "ChXChartDocument.hxx"

/************************************************************************/

/*************************************************************************
|*
|* Achsen & Gitter aendern;
|* Liefert bei Aenderung TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeAxis( BOOL bXAxis, BOOL bXDescr,
							 BOOL bYAxis, BOOL bYDescr,
							 BOOL bZAxis, BOOL bZDescr,
							 BOOL b2YAxis, BOOL b2YDescr,
							 BOOL b2XAxis, BOOL b2XDescr,
							 BOOL bAllowBuildChart )
{
	if( bXDescr  == pChartXAxis->HasDescription() &&
		bYDescr  == pChartYAxis->HasDescription() &&
		bZDescr  == pChartZAxis->HasDescription() &&
		b2YDescr == pChartBAxis->HasDescription() &&
		b2XDescr == pChartAAxis->HasDescription() &&

		bXAxis  == pChartXAxis->IsVisible()	&&
		bYAxis  == pChartYAxis->IsVisible()	&&
		bZAxis  == pChartZAxis->IsVisible() &&
		b2YAxis == pChartBAxis->IsVisible() &&
		b2XAxis == pChartAAxis->IsVisible() )
	{
		return FALSE;
	}
	else
	{
		// special treatment for secondary y-axis:
		// if it has been disabled connect all series
		// to primary axis (#71989#)
		if( ! b2YAxis && pChartBAxis->IsVisible())
		{
			SfxItemSet rItemSet( *pItemPool, SCHATTR_AXIS, SCHATTR_AXIS );
			rItemSet.Put( SfxInt32Item( SCHATTR_AXIS, CHAXIS_AXIS_Y ));
			PutDataRowAttrAll( rItemSet );
		}

		pChartXAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWAXIS, bXAxis ));
		pChartYAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWAXIS, bYAxis ));
		pChartZAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWAXIS, bZAxis ));
		pChartBAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWAXIS, b2YAxis ));
		pChartAAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWAXIS, b2XAxis ));

		pChartXAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, bXDescr ));
		pChartYAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, bYDescr ));
		pChartZAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, bZDescr ));
		pChartBAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, b2YDescr ));
		pChartAAxis->GetItemSet()->Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, b2XDescr ));

		if( bAllowBuildChart )
		{
			CheckForNewAxisNumFormat();			// #71678#
			BuildChart( FALSE );
		}

		return TRUE;
	}
}


BOOL ChartModel::ChangeGrid( BOOL bXMain, BOOL bXHelp,
							 BOOL bYMain, BOOL bYHelp,
							 BOOL bZMain, BOOL bZHelp,
							 BOOL bAllowBuildChart )
{
	if( bXHelp == bShowXGridHelp &&
		bXMain == bShowXGridMain &&
		bYMain == bShowYGridMain &&
		bYHelp == bShowYGridHelp &&
		bZMain == bShowZGridMain &&
		bZHelp == bShowZGridHelp )
	{
		return FALSE;
	}
	else
	{
		bShowXGridMain  = bXMain;
		bShowXGridHelp  = bXHelp;
		bShowYGridMain  = bYMain;
		bShowYGridHelp  = bYHelp;
		bShowZGridMain  = bZMain;
		bShowZGridHelp  = bZHelp;

		if( bAllowBuildChart )
			BuildChart( FALSE );

		return TRUE;
	}
}


/*************************************************************************
|*
|* Datenbeschriftung aendern;
|* FG: 24.4.97 nRow ist ein Parameter der ermoeglicht die Datenbeschriftung
|*     einer einzigen Reihe zu aendern, falls er -1 ist werden alle
|*     Datenreihen mit dem uebergebenen Attributen belegt. (default ist alle)
|*
\************************************************************************/

void ChartModel::ChangeDataDescr(SvxChartDataDescr eDescr, BOOL bSym,
								 long nRowToChange, BOOL bBuildChart)
{
    if( nRowToChange == -1 ||
        IsPieChart())
    {
        // change setting globally
        eDataDescr = eDescr;
        bShowSym = bSym;

        // clear individual settings
        long nEndRow = GetRowCount();
        for( long nRow = 0; nRow < nEndRow; nRow++ )
        {
            SfxItemSet &rAttr = SAL_CONST_CAST( SfxItemSet&, GetDataRowAttr( (short)nRow ));

            rAttr.Put( SvxChartDataDescrItem( eDescr ));
            rAttr.Put( SfxBoolItem( SCHATTR_DATADESCR_SHOW_SYM, bSym ));

            // the following is the preferred method, but the items are not evaluated appropriately
//              rAttr.ClearItem( ITEMID_CHARTDATADESCR );
//              rAttr.ClearItem( SCHATTR_DATADESCR_SHOW_SYM );
        }
    }
    else
    {
        SfxItemSet &rAttr = SAL_CONST_CAST( SfxItemSet&, GetDataRowAttr( (short)nRowToChange ));

 		rAttr.Put( SvxChartDataDescrItem( eDescr ));
 		rAttr.Put( SfxBoolItem( SCHATTR_DATADESCR_SHOW_SYM, bSym ));
    }

	if( bBuildChart )
		BuildChart( FALSE );
}

/*************************************************************************
|*
|* Seitengroesse aendern;
|* Liefert bei Aenderung TRUE.
|*
\************************************************************************/

BOOL ChartModel::ResizePage(const Size& rNewSize)
{
	SdrPage* pPage = GetPage(0);

	if (!pPage || pPage->GetSize() == rNewSize) return FALSE;
	else
	{
		BOOL bWasChanged = IsChanged();

		pPage->SetSize(rNewSize);
		eOldChartStyle = eChartStyle;
		if (rNewSize.Width () != 0 && rNewSize.Height () != 0) BuildChart(FALSE);

		if (!bWasChanged) SetChanged(FALSE);

		return TRUE;
	}
}


/************************************************************************
|*
|* skaliere Texte neu um
|*
\************************************************************************/

void ChartModel::ResizeText (SfxItemSet *pTextAttr, Size aPageSize, BOOL bResizePage )
{
	double fRatio;
	if( bResizePage )
		fRatio = (double)aPageSize.Height() / (double)aInitialSize.Height();
	else
		fRatio = (double)aDiagramRectangle.GetHeight() / (double)aLastDiagramRectangle.GetHeight();

	// resize all three fonts
	static const USHORT nWhichIds[ 3 ] = {
		EE_CHAR_FONTHEIGHT,
		EE_CHAR_FONTHEIGHT_CJK,
		EE_CHAR_FONTHEIGHT_CTL
	};

	for( int i=0; i < 3; i++ )
	{
		long nHeight = ((SvxFontHeightItem &)pTextAttr->Get( nWhichIds[ i ] )).GetHeight();

        //	Scale and round height.
		nHeight = (long)( fRatio * (double)nHeight + 0.5 );

		float fPoints = (float)CalcToPoint( nHeight, SFX_MAPUNIT_100TH_MM, 10 );
		if( fPoints < 2.0 ) fPoints = 2.0;

		pTextAttr->Put( SvxFontHeightItem( CalcToUnit( fPoints / (float)10.0, SFX_MAPUNIT_100TH_MM ),
										   100, nWhichIds[ i ] ));
	}
}

/*************************************************************************
|*
|* Textobjekt fuer Editieren vorbereiten
|*
\************************************************************************/

void ChartModel::PrepareEdit(SdrTextObj& rTextObj)
{
	SchObjectAdjust* pObjAdjust = GetObjectAdjust(rTextObj);
	DBG_ASSERT(pObjAdjust, "ChartModel::PrepareEdit:Textobjekt hat keine Ausrichtungs-Information!");

	SvxChartTextOrient eOrient=pObjAdjust->GetOrient();
	if (eOrient==CHTXTORIENT_STACKED)
	{
			pOutliner->SetText(*rTextObj.GetOutlinerParaObject());
			String aString =
				pOutliner->GetText(pOutliner->GetParagraph( 0 ),
								   pOutliner->GetParagraphCount());
			pOutliner->Clear();

			SetTextString(rTextObj, UnstackString(aString),
						  CHTXTORIENT_STANDARD);
	}
}

/*************************************************************************
|*
|* Editieren abschlieen
|*
\************************************************************************/

void ChartModel::CommitEdit(SdrTextObj& rTextObj)
{


	SchObjectAdjust* pObjAdjust = GetObjectAdjust(rTextObj);
	DBG_ASSERT(pObjAdjust, "ChartModel::CommitEdit:Textobjekt hat keine Ausrichtungs-Information!");

	SvxChartTextOrient eOrient=pObjAdjust->GetOrient();
	if(eOrient==CHTXTORIENT_STACKED)
	{
		pOutliner->SetText(*rTextObj.GetOutlinerParaObject());
		String aString =
			pOutliner->GetText(pOutliner->GetParagraph( 0 ),
							   pOutliner->GetParagraphCount());
		pOutliner->Clear();

		SetTextString(rTextObj, aString);
	}
}

/*************************************************************************
|*
|* Attribute lesen
|*
\************************************************************************/

//SfxItemSet ChartModel::GetAttr() const
void ChartModel::GetAttr(SfxItemSet& rAttr)
{
	CHART_TRACE( "ChartModel::GetAttr(SfxItemSet& rAttr)" );

	rAttr.Put(SvxChartStyleItem(ChartStyle()));
	rAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_MAIN, ShowMainTitle()));
	rAttr.Put(SfxStringItem(CHATTR_TITLE_MAIN, MainTitle()));
	rAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_SUB, ShowSubTitle()));
	rAttr.Put(SfxStringItem(CHATTR_TITLE_SUB, SubTitle()));
	rAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_X_AXIS, ShowXAxisTitle()));
	rAttr.Put(SfxStringItem(CHATTR_TITLE_X_AXIS, XAxisTitle()));
	rAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_Y_AXIS, ShowYAxisTitle()));
	rAttr.Put(SfxStringItem(CHATTR_TITLE_Y_AXIS, YAxisTitle()));
	rAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_Z_AXIS, ShowZAxisTitle()));
	rAttr.Put(SfxStringItem(CHATTR_TITLE_Z_AXIS, ZAxisTitle()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_X_AXIS, ShowXAxis()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_X_MAIN, ShowXGridMain()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_X_HELP, ShowXGridHelp()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_X_DESCR, ShowXDescr()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Y_AXIS, ShowYAxis()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Y_MAIN, ShowYGridMain()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Y_HELP, ShowYGridHelp()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Y_DESCR, ShowYDescr()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Z_AXIS, ShowZAxis()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Z_MAIN, ShowZGridMain()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Z_HELP, ShowZGridHelp()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_Z_DESCR, ShowZDescr()));

	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_2Y_AXIS, GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_2Y_DESCR, GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription()));

	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_2X_AXIS, GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible()));
	rAttr.Put(SfxBoolItem(CHATTR_AXISGRID_SHOW_2X_DESCR, GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription()));

	const SfxPoolItem *pPoolItem = NULL;
	if (pLegendAttr->GetItemState(SCHATTR_LEGEND_POS, TRUE, &pPoolItem)
							== SFX_ITEM_SET)
		rAttr.Put(SvxChartLegendPosItem
					(((const SvxChartLegendPosItem*)pPoolItem)->GetValue(),
					pItemPool->GetSlotId(SCHATTR_LEGEND_POS)));

	rAttr.Put(SfxBoolItem(CHATTR_DATA_SWITCH, IsSwitchData()));


	rAttr.Put (SfxBoolItem (SCHATTR_STAT_AVERAGE,bShowAverage));
	rAttr.Put (SfxInt32Item (SCHATTR_STAT_KIND_ERROR, (INT32) eErrorKind));
	rAttr.Put (SfxInt32Item (SCHATTR_STAT_INDICATE, (INT32) eIndicate));
	rAttr.Put (SvxDoubleItem (fIndicatePercent, SCHATTR_STAT_PERCENT));
	rAttr.Put (SvxDoubleItem (fIndicateBigError, SCHATTR_STAT_BIGERROR));
	rAttr.Put (SvxDoubleItem (fIndicatePlus, SCHATTR_STAT_CONSTPLUS));
	rAttr.Put (SvxDoubleItem (fIndicateMinus, SCHATTR_STAT_CONSTMINUS));
	rAttr.Put (SfxInt32Item (SCHATTR_STAT_REGRESSTYPE, (INT32) eRegression));

	//Datenbeschriftung
	rAttr.Put(SfxBoolItem(SCHATTR_DATADESCR_SHOW_SYM,bShowSym));
	rAttr.Put(SvxChartDataDescrItem(eDataDescr));

	rAttr.Put(SfxInt32Item(CHATTR_BARWIDTH,GetBarPercentWidth()));
	rAttr.Put(SfxBoolItem(CHATTR_BARCONNECT, (BOOL)(m_nDefaultColorSet&CHSPECIAL_TRACELINES)));

	if (pChartAttr->GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem)== SFX_ITEM_SET)
	{
		long nTmp= (long)((const SfxInt32Item*)pPoolItem)->GetValue();
		rAttr.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nTmp));
	}

	ChartScene *pScene=GetScene();
	if(pScene)
//-/		pScene->TakeAttributes(rAttr,TRUE,FALSE);
		rAttr.Put(pScene->GetItemSet());

    if( pChartAttr->GetItemState( SCHATTR_USER_DEFINED_ATTR, TRUE, &pPoolItem ) == SFX_ITEM_SET )
    {
        rAttr.Put( *pPoolItem );
    }
}

/*************************************************************************
|*
|* Attribute setzen
|*
\************************************************************************/

void ChartModel::PutAttr(const SfxItemSet& rAttr)
{
	const SfxPoolItem *pPoolItem = NULL;

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_MAIN, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowMainTitle () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_MAIN, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		MainTitle () = ((const SfxStringItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_SUB, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowSubTitle () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_SUB, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		SubTitle () = ((const SfxStringItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_X_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowXAxisTitle () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_X_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		XAxisTitle () = ((const SfxStringItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_Y_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowYAxisTitle () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_Y_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		YAxisTitle () = ((const SfxStringItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_Z_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowZAxisTitle () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_TITLE_Z_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ZAxisTitle () = ((const SfxStringItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowXAxis (((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_MAIN, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowXGridMain () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_HELP, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowXGridHelp () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_DESCR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowXDescr (((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowYAxis (((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_MAIN, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowYGridMain () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_HELP, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowYGridHelp () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_DESCR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowYDescr (((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowZAxis (((const SfxBoolItem*)pPoolItem)->GetValue());

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_MAIN, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowZGridMain () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_HELP, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowZGridHelp () = ((const SfxBoolItem*)pPoolItem)->GetValue();

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_DESCR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ShowZDescr (((const SfxBoolItem*)pPoolItem)->GetValue());



	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2Y_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
	{
		BOOL b = ((const SfxBoolItem*)pPoolItem)->GetValue();
		pChartBAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWAXIS,b));
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2Y_DESCR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
	{
		BOOL b = ((const SfxBoolItem*)pPoolItem)->GetValue();
		pChartBAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWDESCR,b));
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2X_AXIS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
	{
		BOOL b = ((const SfxBoolItem*)pPoolItem)->GetValue();
		pChartAAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWAXIS,b));
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2X_DESCR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
	{
		BOOL b = ((const SfxBoolItem*)pPoolItem)->GetValue();
		pChartAAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWDESCR,b));
	}




	if (rAttr.GetItemState(CHATTR_LEGEND_POS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		pLegendAttr->Put(SvxChartLegendPosItem
			(((const SvxChartLegendPosItem*)pPoolItem)->GetValue(),
			 pItemPool->GetWhich(CHATTR_LEGEND_POS)));

	if (rAttr.GetItemState(CHATTR_DATA_SWITCH, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		ChangeSwitchData(((const SfxBoolItem*)pPoolItem)->GetValue());



//Statistik
   if (rAttr.GetItemState(SCHATTR_STAT_CONSTPLUS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		fIndicatePlus=((const SvxDoubleItem*)pPoolItem)->GetValue();

   if (rAttr.GetItemState(SCHATTR_STAT_BIGERROR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		fIndicateBigError=((const SvxDoubleItem*)pPoolItem)->GetValue();

   if (rAttr.GetItemState(SCHATTR_STAT_PERCENT, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		fIndicatePercent=((const SvxDoubleItem*)pPoolItem)->GetValue();

   if (rAttr.GetItemState(SCHATTR_STAT_INDICATE, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		eIndicate=(SvxChartIndicate)((const SfxInt32Item*)pPoolItem)->GetValue();

   if (rAttr.GetItemState(SCHATTR_STAT_KIND_ERROR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		eErrorKind=(SvxChartKindError)((const SfxInt32Item*)pPoolItem)->GetValue();

   if (rAttr.GetItemState(SCHATTR_STAT_AVERAGE, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		bShowAverage=((const SfxBoolItem*)pPoolItem)->GetValue();

   if (rAttr.GetItemState(SCHATTR_STAT_CONSTMINUS, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		fIndicateMinus=((const SvxDoubleItem*)pPoolItem)->GetValue();
   if (rAttr.GetItemState(SCHATTR_STAT_REGRESSTYPE, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		eRegression=(SvxChartRegress)((const SfxInt32Item*)pPoolItem)->GetValue();


	   //Datenbeschriftung
	   SvxChartDataDescr eNewDataDescr,eOldDataDescr;
	   BOOL bNewShowSym, bOldShowSym;

	   eNewDataDescr = eOldDataDescr = eDataDescr;
	   bNewShowSym = bOldShowSym = bShowSym;

	  if (rAttr.GetItemState(SCHATTR_DATADESCR_DESCR, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		eNewDataDescr=(SvxChartDataDescr)((const SvxChartDataDescrItem*)pPoolItem)->GetValue();

	  if (rAttr.GetItemState(SCHATTR_DATADESCR_SHOW_SYM, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
		bNewShowSym=((const SfxBoolItem*)pPoolItem)->GetValue();

	  if( bOldShowSym != bNewShowSym || eOldDataDescr != eNewDataDescr )
	  {
		  ChangeDataDescr(eNewDataDescr,bNewShowSym);
	  }

	if (rAttr.GetItemState(CHATTR_BARWIDTH, TRUE, &pPoolItem)
				== SFX_ITEM_SET)
		SetBarPercentWidth((long)((const SfxInt32Item*)pPoolItem)->GetValue());


   if (rAttr.GetItemState(CHATTR_BARCONNECT, TRUE, &pPoolItem)
					== SFX_ITEM_SET)
   {
	   BOOL bTmp=((const SfxBoolItem*)pPoolItem)->GetValue();
	   m_nDefaultColorSet=(bTmp)
		   ?(m_nDefaultColorSet|CHSPECIAL_TRACELINES)
		   :(m_nDefaultColorSet|CHSPECIAL_TRACELINES)-CHSPECIAL_TRACELINES;
   }

	if (rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem)== SFX_ITEM_SET)
	{
		long nTmp= (long)((const SfxInt32Item*)pPoolItem)->GetValue();
		SfxItemSet aS(*pItemPool,SCHATTR_STYLE_SHAPE,SCHATTR_STYLE_SHAPE,0);
		aS.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nTmp));
		PutDataRowAttrAll(aS);
	}

	// Autopilot mit CHATTR_
	if (rAttr.GetItemState(CHATTR_STYLE_SHAPE, TRUE, &pPoolItem)== SFX_ITEM_SET)
	{
		long nTmp= (long)((const SfxInt32Item*)pPoolItem)->GetValue();
		SfxItemSet aS(*pItemPool,SCHATTR_STYLE_SHAPE,SCHATTR_STYLE_SHAPE,0);
		aS.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nTmp));
		PutDataRowAttrAll(aS);
	}
	if( rAttr.GetItemState(CHATTR_AXIS_AUTO_ORIGIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		BOOL bTmp= (BOOL)((const SfxBoolItem*)pPoolItem)->GetValue();
		SfxItemSet aS( *pItemPool, SCHATTR_AXIS_AUTO_ORIGIN, SCHATTR_AXIS_AUTO_ORIGIN);
		aS.Put( SfxBoolItem( SCHATTR_AXIS_AUTO_ORIGIN, bTmp ));
		if( pChartYAxis )
		{
			pChartYAxis->SetAttributes( aS );
		}
		if( pChartBAxis )
		{
			pChartBAxis->SetAttributes( aS );
		}
	}

	ChartScene *pScene=GetScene();
	if(pScene) //ToDo: Ist das hier ntig??? warum nicht direkt rAttr? #63904#
	{
		SfxItemSet aSceneSet(*pItemPool,nRowWhichPairs);
		aSceneSet.Put(rAttr);

//-/		pScene->NbcSetAttributes(aSceneSet,FALSE);
		pScene->SetItemSet(aSceneSet);

	}

    if( rAttr.GetItemState( SCHATTR_USER_DEFINED_ATTR, TRUE, &pPoolItem ) == SFX_ITEM_SET )
    {
        pChartAttr->Put( *pPoolItem );
    }


	if (rAttr.GetItemState(CHATTR_DIAGRAM_STYLE, TRUE, &pPoolItem)
				== SFX_ITEM_SET)
		ChangeChart( ((const SvxChartStyleItem*)pPoolItem)->GetValue());
}

void ChartModel::SetOverlap(long nPercent,long nRow)
{
	if(GetAxisUID(nRow) == CHART_AXIS_SECONDARY_Y)
		aBarY2.SetOverlap(nPercent);
	else
		aBarY1.SetOverlap(nPercent);
}
void ChartModel::SetGap(long nPercent,long nRow)
{
	if(GetAxisUID(nRow) == CHART_AXIS_SECONDARY_Y)
		aBarY2.SetGap(nPercent);
	else
		aBarY1.SetGap(nPercent);
}
long ChartModel::GetOverlap(long nRow)
{
	if(GetAxisUID(nRow) == CHART_AXIS_SECONDARY_Y)
		return aBarY2.GetOverlap();
	else
		return aBarY1.GetOverlap();
}
long ChartModel::GetGap(long nRow)
{
	if(GetAxisUID(nRow) == CHART_AXIS_SECONDARY_Y)
		return aBarY2.GetGap();
	else
		return aBarY1.GetGap();
}
long ChartModel::GetAxisUID(long nRow)
{
	return ((const SfxInt32Item &)GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue();
};




/*************************************************************************
|*
|* Attribute setzen
|*
\************************************************************************/

BOOL ChartModel::ChangeAttr(const SfxItemSet& rAttr)
{
	const SfxPoolItem *pPoolItem = NULL;
//    long nLong;
	BOOL bBool;
	String aString;
	BOOL bChanged;
	BOOL bNewAttr = FALSE;

	if (rAttr.GetItemState(CHATTR_DIAGRAM_STYLE, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		SvxChartStyle eStyle = ((const SvxChartStyleItem*)pPoolItem)->GetValue();
		bChanged = (eStyle != ChartStyle());
		if (bChanged)
		{
			ChartStyle () = eStyle;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

/*    if (rAttr.GetItemState(CHATTR_DIAGRAM_GAPWIDTH, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		nLong = (long)((const SfxInt32Item*)pPoolItem)->GetValue();
		bChanged = (nLong != GapWidth());
		if (bChanged)
		{
			GapWidth () = nLong;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_DIAGRAM_OVERLAP, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		nLong = (long)((const SfxInt32Item*)pPoolItem)->GetValue();
		bChanged = (nLong != Overlap());
		if (bChanged)
		{
			Overlap () = nLong;
			bNewAttr = (bNewAttr || bChanged);
		}
	}
*/
	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowMainTitle());
		if (bChanged)
		{
			ShowMainTitle () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		aString = ((const SfxStringItem*)pPoolItem)->GetValue();
		bChanged = (aString != MainTitle());
		if (bChanged)
		{
			MainTitle () = aString;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_SUB, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowSubTitle());
		if (bChanged)
		{
			ShowSubTitle () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_SUB, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		aString = ((const SfxStringItem*)pPoolItem)->GetValue();
		bChanged = (aString != SubTitle());
		if (bChanged)
		{
			SubTitle () = aString;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowXAxisTitle());
		if (bChanged)
		{
			ShowXAxisTitle () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		aString = ((const SfxStringItem*)pPoolItem)->GetValue();
		bChanged = (aString != XAxisTitle());
		if (bChanged)
		{
			XAxisTitle () = aString;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowYAxisTitle());
		if (bChanged)
		{
			ShowYAxisTitle () = ((const SfxBoolItem*)pPoolItem)->GetValue();
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		aString = ((const SfxStringItem*)pPoolItem)->GetValue();
		bChanged = (aString != YAxisTitle());
		if (bChanged)
		{
			YAxisTitle () = aString;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_SHOW_Z_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowZAxisTitle());
		if (bChanged)
		{
			ShowZAxisTitle () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_TITLE_Z_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		aString = ((const SfxStringItem*)pPoolItem)->GetValue();
		bChanged = (aString != ZAxisTitle());
		if (bChanged)
		{
			ZAxisTitle () = aString;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowXAxis());
		if (bChanged)
		{
			ShowXAxis (bBool);
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowXGridMain());
		if (bChanged)
		{
			ShowXGridMain () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_HELP, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowXGridHelp());
		if (bChanged)
		{
			ShowXGridHelp () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_X_DESCR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowXDescr());
		if (bChanged)
		{
			ShowXDescr (((const SfxBoolItem*)pPoolItem)->GetValue()) ;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowYAxis());
		if (bChanged)
		{
			ShowYAxis (bBool) ;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowYGridMain());
		if (bChanged)
		{
			ShowYGridMain () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_HELP, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowYGridHelp());
		if (bChanged)
		{
			ShowYGridHelp () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Y_DESCR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowYDescr());
		if (bChanged)
		{
			ShowYDescr (bBool) ;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowZAxis());
		if (bChanged)
		{
			ShowZAxis (bBool) ;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_MAIN, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowZGridMain());
		if (bChanged)
		{
			ShowZGridMain () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_HELP, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowZGridHelp());
		if (bChanged)
		{
			ShowZGridHelp () = bBool;
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_Z_DESCR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != ShowZDescr());
		if (bChanged)
		{
			ShowZDescr (bBool);
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2Y_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != pChartBAxis->IsVisible());
		if (bChanged)
		{
		   pChartBAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWAXIS,bBool));
		   bNewAttr = (bNewAttr || bChanged);
		}
	}
	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2Y_DESCR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != pChartBAxis->HasDescription());
		if (bChanged)
		{
			pChartBAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWDESCR,bBool));
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2X_AXIS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != pChartAAxis->IsVisible());
		if (bChanged)
		{
		   pChartAAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWAXIS,bBool));
		   bNewAttr = (bNewAttr || bChanged);
		}
	}
	if (rAttr.GetItemState(CHATTR_AXISGRID_SHOW_2X_DESCR, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != pChartAAxis->HasDescription());
		if (bChanged)
		{
			pChartAAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_SHOWDESCR,bBool));
			bNewAttr = (bNewAttr || bChanged);
		}
	}


	if (rAttr.GetItemState(CHATTR_LEGEND_POS, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		USHORT nWhich = pItemPool->GetWhich(CHATTR_LEGEND_POS);

		SvxChartLegendPos ePos = ((const SvxChartLegendPosItem*)pPoolItem)->GetValue();
		SvxChartLegendPos eOldPos = (pLegendAttr->GetItemState(nWhich, TRUE, &pPoolItem) == SFX_ITEM_SET)
										? ((const SvxChartLegendPosItem*)pPoolItem)->GetValue()
										: CHLEGEND_NONE;

		bChanged = (ePos != eOldPos);
		bLegendVisible = (ePos != CHLEGEND_NONE);
		if (bChanged)
		{
			pLegendAttr->Put(SvxChartLegendPosItem(ePos, nWhich));
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if (rAttr.GetItemState(CHATTR_DATA_SWITCH, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		bBool = ((const SfxBoolItem*)pPoolItem)->GetValue();
		bChanged = (bBool != IsSwitchData());
		if (bChanged)
		{
			SetSwitchData (bBool);
			bNewAttr = (bNewAttr || bChanged);
		}
	}

	if(bNewAttr)
	{
		if(IsAttrChangeNeedsBuildChart(rAttr))
			BuildChart(FALSE);
	}
	return bNewAttr;
}

/*************************************************************************
|*
|* gesamte Grafik initialisieren
|*
\************************************************************************/

void ChartModel::Initialize()
{
	mbIsInitialized = TRUE;

	if (!(aInitialSize.Height () && aInitialSize.Width ()))
	{
		SdrPage* pPage = GetPage(0);
		if (pPage) aInitialSize = pPage->GetSize();

		if (!(aInitialSize.Height () && aInitialSize.Width ())) aInitialSize = Size (7000, 8000);
//        13000, 8666
	}

	ScaleText( 0, aInitialSize );

	if( bShouldBuildChart )
	{
		//	Force build chart.  If it has been loaded from an XML file, than that is
		//	done by unlocking it.
		bNoBuildChart = FALSE;

		if( pDocShell &&
			pDocShell->IsEnableSetModified())
		{
			pDocShell->EnableSetModified( FALSE );
			if (IsLockedBuild())
				UnlockBuild();
			else
				BuildChart( FALSE );
			pDocShell->EnableSetModified( TRUE );
		}
		else
			if (IsLockedBuild())
				UnlockBuild();
			else
				BuildChart( FALSE );
	}

	SetDiagramRectangle( GetChartRect() );
}


/*************************************************************************
|*
|* Sub-Methode von BuildChart()
|*
\************************************************************************/
void ChartModel::ScaleText( long nTitle, const Size& rPageSize )
{
	// #67459#
	// if the page size is unchanged ...
	if( aInitialSize == rPageSize )
	{
		// ... and the diagram (possibly) has been resized
		if( GetDiagramHasBeenMovedOrResized() && (aLastDiagramRectangle != aDiagramRectangle) )
		{
			if( nTitle != CHOBJID_DIAGRAM_X_AXIS )
				ResizeText( &GetAttr(CHOBJID_DIAGRAM_X_AXIS), rPageSize, FALSE );
			if( nTitle != CHOBJID_DIAGRAM_Y_AXIS )
				ResizeText( &GetAttr(CHOBJID_DIAGRAM_Y_AXIS), rPageSize, FALSE );
			if( nTitle != CHOBJID_DIAGRAM_A_AXIS )
				ResizeText( &GetAttr(CHOBJID_DIAGRAM_A_AXIS), rPageSize, FALSE );
			if( nTitle != CHOBJID_DIAGRAM_B_AXIS )
				ResizeText( &GetAttr(CHOBJID_DIAGRAM_B_AXIS), rPageSize, FALSE );
			if( nTitle != CHOBJID_DIAGRAM_Z_AXIS )
				ResizeText( &GetAttr(CHOBJID_DIAGRAM_Z_AXIS), rPageSize, FALSE );

			for( ULONG i=0; i<aDataRowAttrList.Count(); i++ )
				ResizeText( aDataRowAttrList.GetObject(i), rPageSize, FALSE );
			ResizeText(pDummyAttr,rPageSize);	// also resize crash test dummy to normal for next test ?
		}
	}
	else	// page size has changed
	{
		if(nTitle != CHOBJID_TITLE_MAIN)
			ResizeText (pMainTitleAttr ,rPageSize);
		if(nTitle != CHOBJID_TITLE_SUB)
			ResizeText (pSubTitleAttr  ,rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_TITLE_X_AXIS)
			ResizeText (pXAxisTitleAttr,rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_TITLE_Y_AXIS)
			ResizeText (pYAxisTitleAttr,rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_TITLE_Z_AXIS)
			ResizeText (pZAxisTitleAttr,rPageSize);

		if(nTitle != CHOBJID_DIAGRAM_X_AXIS)
			ResizeText(&GetAttr(CHOBJID_DIAGRAM_X_AXIS),rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_Y_AXIS)
			ResizeText(&GetAttr(CHOBJID_DIAGRAM_Y_AXIS),rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_A_AXIS)
			ResizeText(&GetAttr(CHOBJID_DIAGRAM_A_AXIS),rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_B_AXIS)
			ResizeText(&GetAttr(CHOBJID_DIAGRAM_B_AXIS),rPageSize);
		if(nTitle != CHOBJID_DIAGRAM_Z_AXIS)
			ResizeText(&GetAttr(CHOBJID_DIAGRAM_Z_AXIS),rPageSize);
		if(nTitle != CHOBJID_LEGEND)
			ResizeText(pLegendAttr, rPageSize);
		for( ULONG i=0; i<aDataRowAttrList.Count(); i++ )
			ResizeText(aDataRowAttrList.GetObject(i),rPageSize);
		ResizeText(pDummyAttr,rPageSize);	// also resize crash test dummy to normal for next test ?
	}
}

/*************************************************************************
|*
|* Sub-Methode von BuildChart(), Anzeige des Haupttitels
|*
\************************************************************************/
void ChartModel::DoShowMainTitle(USHORT& rIndex,const long nYOfs)
{
	SdrPage* pPage=GetPage(0);
	const Size& rPageSize=pPage->GetSize();

	Point aTitlePosition;
	if (bUseRelativePositionsForChartGroups && (aTitleTopCenter.X() > 0) &&
	   (aTitleTopCenter.Y() > 0) && GetMainTitleHasBeenMoved())
	{
		double fRelativXPosition = ((double) aTitleTopCenter.X()) / aInitialSize.Width();
		double fRelativYPosition = ((double) aTitleTopCenter.Y()) / aInitialSize.Height();
		aTitlePosition.X() = (long)((double)rPageSize.Width()  * fRelativXPosition );
		aTitlePosition.Y() = (long)((double)rPageSize.Height() * fRelativYPosition );
	}
	else
	{
		aTitlePosition.X() = aChartRect.Left() + aChartRect.GetWidth() / 2;
		aTitlePosition.Y() = aChartRect.Top();
	}

	SdrTextObj *pObj = CreateTextObj(CHOBJID_TITLE_MAIN, aTitlePosition,
									 aMainTitle,
									 *pMainTitleAttr, TRUE, CHADJUST_TOP_CENTER);

	aChartRect.Top() += GetOutputSize(*pObj).Height() + nYOfs;
	pObj->SetResizeProtect(TRUE);
	pPage->NbcInsertObject(pObj, rIndex++);
}

/*************************************************************************
|*
|* Sub-Methode von BuildChart(), man koennte vermutlich DoShowMainTitle und
|* DoShowSubTitle zu DoShowTitle zusammenfassen
|*
\************************************************************************/
void ChartModel::DoShowSubTitle(USHORT& rIndex,const long nYOfs)
{
	SdrPage* pPage=GetPage(0);
	const Size& rPageSize=pPage->GetSize();

	Point aSubTitlePosition;
	if (bUseRelativePositionsForChartGroups && (aSubTitleTopCenter.X() > 0) &&
	  (aSubTitleTopCenter.Y() > 0) && GetSubTitleHasBeenMoved())
	{
	   double fRelativeXPosition = ((double) aSubTitleTopCenter.X()) / aInitialSize.Width();
	   double fRelativeYPosition = ((double) aSubTitleTopCenter.Y()) / aInitialSize.Height();
	   aSubTitlePosition.X() = (long)((double)rPageSize.Width() *  fRelativeXPosition );
	   aSubTitlePosition.Y() = (long)((double)rPageSize.Height() * fRelativeYPosition );
	}
	else
	{
	   aSubTitlePosition.X() = aChartRect.Left() + aChartRect.GetWidth() / 2;
	   aSubTitlePosition.Y() = aChartRect.Top();
	}
	SdrTextObj *pObj = CreateTextObj(CHOBJID_TITLE_SUB, aSubTitlePosition,
									aSubTitle,
									*pSubTitleAttr, TRUE, CHADJUST_TOP_CENTER);

	aChartRect.Top() += GetOutputSize(*pObj).Height() + nYOfs;
	pObj->SetResizeProtect(TRUE);
	pPage->NbcInsertObject(pObj, rIndex++);
}

/*************************************************************************
|*
|* Sub-Methode von BuildChart(), Anzeige der Legende
|*
\************************************************************************/
void ChartModel::DoShowLegend(const Rectangle& rWholeRect,
							  const long nXOfs,const long nYOfs,USHORT& rIndex)
{
	SdrPage* pPage=GetPage(0);
	const Size& rPageSize=pPage->GetSize();

	SvxChartLegendPos eLegendPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).
							   GetValue();

	if (eLegendPos != CHLEGEND_NONE)
	{
		SdrObject   *pObj = CreateLegend(rWholeRect);

		if (pObj)
		{
			Rectangle   aRect = pObj->GetLogicRect();
			ChartAdjust eAdjust;

			Point aLegendPosition;
			if (bUseRelativePositionsForChartGroups && (aLegendTopLeft.X() > 0) &&
			   (aLegendTopLeft.Y() > 0) && GetLegendHasBeenMoved())
			{
				double fRelativeXPosition = ((double) aLegendTopLeft.X()) / aInitialSize.Width();
				double fRelativeYPosition = ((double) aLegendTopLeft.Y()) / aInitialSize.Height();
				aLegendPosition.X() = (long)((double)rPageSize.Width() *  fRelativeXPosition );
				aLegendPosition.Y() = (long)((double)rPageSize.Height() * fRelativeYPosition );
				if (bAdjustMarginsForLegend)
				{
					switch (eLegendPos)
					{
						case CHLEGEND_LEFT:
							eAdjust = CHADJUST_TOP_LEFT;
							aChartRect.Left() += aRect.GetWidth() + nXOfs;
							break;

						case CHLEGEND_TOP:
							eAdjust = CHADJUST_TOP_LEFT;
							aChartRect.Top() += aRect.GetHeight() + nYOfs;
							break;

						case CHLEGEND_RIGHT:
							eAdjust = CHADJUST_TOP_LEFT;
							aChartRect.Right() -= aRect.GetWidth() + nXOfs;
							break;

						case CHLEGEND_BOTTOM:
							eAdjust = CHADJUST_TOP_LEFT;
							aChartRect.Bottom() -= aRect.GetHeight() + nYOfs;
							break;
					}
				}
                // #96418# why shifting the legend nXOfs/nYOfs away from the
                // edge, if it moved manually; it may well reach the edge in
                // that case.  So just check if it laps out of the edge.  Apart
                // from that the default position did not satisfy this condition
                // and was therefore always shifted inside
				if (aLegendPosition.X() + aRect.GetWidth() > rPageSize.Width())
				{
					aLegendPosition.X() =  rPageSize.Width() - aRect.GetWidth();
				}
				if (aLegendPosition.Y() + aRect.GetHeight() > rPageSize.Height())
				{
					aLegendPosition.Y() =  rPageSize.Height() - aRect.GetHeight();
				}
			}
			else
			{
				switch (eLegendPos)
				{
					case CHLEGEND_LEFT:
						aLegendPosition.X() = rWholeRect.Left();
						aLegendPosition.Y() = rWholeRect.Top() + rWholeRect.GetHeight() / 2;
						eAdjust = CHADJUST_CENTER_LEFT;
						aChartRect.Left() += aRect.GetWidth() + nXOfs;
						break;

					case CHLEGEND_TOP:
						aLegendPosition.X() = rWholeRect.Left() + rWholeRect.GetWidth() / 2;
						aLegendPosition.Y() = aChartRect.Top();
						eAdjust = CHADJUST_TOP_CENTER;
						aChartRect.Top() += aRect.GetHeight() + nYOfs;
						break;

					case CHLEGEND_RIGHT:
						aLegendPosition.X() = rWholeRect.Right();
						aLegendPosition.Y() = rWholeRect.Top() + rWholeRect.GetHeight() / 2;
						eAdjust = CHADJUST_CENTER_RIGHT;
						aChartRect.Right() -= aRect.GetWidth() + nXOfs;
						break;

					case CHLEGEND_BOTTOM:
						aLegendPosition.X() = rWholeRect.Left() + rWholeRect.GetWidth() / 2;
						aLegendPosition.Y() = rWholeRect.Bottom();
						eAdjust = CHADJUST_BOTTOM_CENTER;
						aChartRect.Bottom() -= aRect.GetHeight() + nYOfs;
						break;
				}
			}
	
			//	For 3D pie charts that whose position and size have not been altered
			//	manually, the calculated size in aChartRect is 
			//	set to aDiagramRectangle after a possible adaption to half
			//	it's height.  This adaption mimics the behaviour from BuildChart
			//	and takes place only if the diagram is not more than twice as wide
			//	as it is high.
			if (IsPieChart() && IsReal3D() && ! GetDiagramHasBeenMovedOrResized())
			{
				long nWidth=aChartRect.GetWidth();
				long nHeight=aChartRect.GetHeight();
				if( ((double)nHeight/(double)nWidth) > 0.5 )
				{
					aChartRect.Top()+=nHeight/4;
					aChartRect.Bottom()-=nHeight/4;
				}
				SetDiagramRectangle (aChartRect);
			}

			aRect.SetPos(aLegendPosition);
			AdjustRect(aRect, eAdjust);
			pObj->NbcSetLogicRect(aRect);
			pObj->SetResizeProtect(TRUE);
			if (pObj->ISA(SchObjGroup))
			{
				((SchObjGroup *)pObj)->SetGroupType(SchObjGroup::LEGEND);
				((SchObjGroup *)pObj)->SetModel(this);
			}
			pPage->InsertObject(pObj, rIndex);
		}
	}
}

//bertragung der Page-Objekt-Attribute in die Modeleigenen AttrSets
void ChartModel::Rescue3DObjAttr(SdrObjList* pList)//#52277#
{
	CHART_TRACE( "ChartModel::Rescue3DObjAttr" );
	if(pList)
	{
		SdrObject* pObj;
		long nRow, nCol;
//-/		SfxItemSet aSet( *pItemPool, SID_ATTR_3D_START, SID_ATTR_3D_END );
		SfxItemSet aSet( *pItemPool, SDRATTR_3D_FIRST, SDRATTR_3D_LAST);
		aSet.ClearItem();

		SdrObjListIter aIterator( *pList, IM_DEEPWITHGROUPS );

		while( aIterator.IsMore() )
		{
			pObj = aIterator.Next();
			SchDataRow*     pDataRow   = GetDataRow( *pObj );
			SchDataPoint*   pDataPoint = GetDataPoint( *pObj );
			if( pDataRow )
			{
				nRow = pDataRow->GetRow();
//-/				pObj->TakeAttributes( aSet, FALSE, TRUE );
				aSet.Put(pObj->GetItemSet());

				aSet.ClearInvalidItems();
				aDataRowAttrList.GetObject( nRow )->Put( aSet );
				aSet.ClearItem();
			}
			else if( pDataPoint )
			{
				nCol = pDataPoint->GetCol();
				nRow = pDataPoint->GetRow();
//-/				pObj->TakeAttributes( aSet, FALSE, TRUE );
				aSet.Put(pObj->GetItemSet());

				aSet.ClearInvalidItems();
				PutDataPointAttr( nCol, nRow, aSet );
				aSet.ClearItem();
			}
			else
			{
				SchObjectId *pId = GetObjectId( *pObj );
				if( pId )
				{
					long nId = pId->GetObjId();
//-/					pObj->TakeAttributes( aSet, FALSE, TRUE );
					aSet.Put(pObj->GetItemSet());
					if( aSet.Count() )
					{
						aSet.ClearInvalidItems();
						GetAttr( nId ).Put( aSet, TRUE );
						aSet.ClearItem();
					}
				}
			}
		}
	}
}
/*************************************************************************
|*
|* Sub-Methode von BuildChart(), Loeschen aller Chartobjecte
|*
\************************************************************************/
void ChartModel::DeleteChartObjects()
{
	SdrPage* pPage=GetPage(0);
    BOOL bResize = (aInitialSize != pPage->GetSize());

	// FG: Bevor die Objekte geloescht und neu aufgebaut werden, merkt man sich deren
	//     Position. Da in InitalSize die urspruengliche Seitengroesse steht, kann
	//     man nun die relative Position auf der Seite bestimmen.
	//     Diese relative Position bleibt bei einem Resize erhalten,
	//     falls der  Schalter "bUseRelativePositionsForChartGroups" auf TRUE steht.

	SdrObject* pGroupObject = GetObjWithId( CHOBJID_DIAGRAM_AREA, *pPage );
	if( pGroupObject != NULL )
		DeleteObject( pGroupObject );

	pGroupObject = GetObjWithId( CHOBJID_TITLE_MAIN, *pPage );
	if (pGroupObject != NULL)
	{
		aTitleTopCenter = pGroupObject->GetBoundRect().TopCenter();
		DeleteObject(pGroupObject);
	}

	pGroupObject = GetObjWithId(CHOBJID_TITLE_SUB, *pPage);
	if (pGroupObject != NULL)
	{
		aSubTitleTopCenter = pGroupObject->GetBoundRect().TopCenter();
		DeleteObject(pGroupObject);
	}

	pGroupObject = GetObjWithId(CHOBJID_DIAGRAM, *pPage);
	if (pGroupObject != NULL)
	{
		// FG: 11.3.97 Wenn die Grenzen des Objekts woanders gesetzt worden sind, duerfen sie hier
		//             nicht mehr gesetzt werden.
		if (pGroupObject->ISA(SchObjGroup))
		{
			if (GetDiagramHasBeenMovedOrResized() &&
			   ((SchObjGroup *) pGroupObject)->GetAskForLogicRect())
			{
				// FG: So leider nicht das Chart-Rect ist fehlerhafterweise nicht das Bounding-Rectangle
				// aDiagramRectangle = pGroupObject->GetLogicRect();
				SetDiagramRectangle( GetChartRect() );
			}
		}
		else if (pGroupObject->ISA(ChartScene))
		{
			if (GetDiagramHasBeenMovedOrResized() &&
			   ((ChartScene *) pGroupObject)->GetAskForLogicRect())
			{
				// FG: So leider nicht das Chart-Rect ist fehlerhafterweise nicht das Bounding-Rectangle
				// aDiagramRectangle = pGroupObject->GetLogicRect();
				SetDiagramRectangle( GetChartRect() );
			}


			if(	pGroupObject == pScene )
				pScene = NULL;
		}
		DeleteObject(pGroupObject);
	}

	pGroupObject = GetObjWithId(CHOBJID_LEGEND, *pPage);
	if (pGroupObject != NULL)
	{
		// FG: 11.3.97 Wenn die Grenzen des Objekts woanders gesetzt worden sind, duerfen sie hier
		//             nicht mehr gesetzt werden.
		if (GetLegendHasBeenMoved()&&
		   ((SchObjGroup *) pGroupObject)->GetAskForLogicRect() &&
            ! bResize )
		{
  			aLegendTopLeft = pGroupObject->GetLogicRect().TopLeft();
		}
		DeleteObject(pGroupObject);
	}



	pGroupObject = GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS, *pPage);
	if (pGroupObject != NULL)
	{
		aTitleXAxisPosition = SetPointOfRectangle(pGroupObject->GetBoundRect(), eAdjustXAxesTitle);
		DeleteObject(pGroupObject);
	}

	pGroupObject = GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS, *pPage);
	if (pGroupObject != NULL)
	{
		Rectangle Test1 = pGroupObject->GetBoundRect();
		Rectangle Test2 = pGroupObject->GetSnapRect();
		aTitleYAxisPosition = SetPointOfRectangle(pGroupObject->GetBoundRect(), eAdjustYAxesTitle);
		DeleteObject(pGroupObject);
	}

	pGroupObject = GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS, *pPage);
	if (pGroupObject != NULL)
	{
		aTitleZAxisPosition = SetPointOfRectangle(pGroupObject->GetBoundRect(), eAdjustXAxesTitle);
		DeleteObject(pGroupObject);
	}
}
/*************************************************************************
|*
|* Sub-Methode von BuildChart(), Wertebereichueberpruefung mit MsgBox
|*
\************************************************************************/
BOOL ChartModel::CheckRanges(BOOL bCheckAlways)
{
	//ToDo:CHOBJID_DIAGRAM_B_AXIS
	BOOL bOK=TRUE;
	if ((eChartStyle != eOldChartStyle) || (bCheckAlways))
	{
		if ((pChartYAxis->GetMin() < 0.0) && (pChartYAxis->GetMax() > 0.0) && (!IsSignedChart()))
		{
			// FG: Falls ein Pointer auf ein Fenster uebergeben wird ist die Dialogbox nicht-modal
			//     Nutzt man dies fuer Veraenderungen am Chart aus, stuertzt das Programm ab.
			// InfoBox aInfoBox(SFX_APP()->GetAppWindow(), String(SchResId(STR_ONLY_ABS_VALUES)));
			InfoBox aInfoBox(NULL, String(SchResId(STR_ONLY_ABS_VALUES)));
			aInfoBox.Execute();
			eOldChartStyle = eChartStyle;
			bOK=FALSE;
		}
		else if ((pChartYAxis->GetMin() < 0.0) && (!IsNegativeChart ()))
			{
				// FG: Falls ein Pointer auf ein Fenster uebergeben wird ist die Dialogbox nicht-modal
				//     Nutzt man dies fuer Veraenderungen am Chart aus, stuertzt das Programm ab.
				// InfoBox aInfoBox(SFX_APP()->GetAppWindow(), String(SchResId(STR_NO_MIN_VALUES)));
				InfoBox aInfoBox(NULL, String(SchResId(STR_NO_MIN_VALUES)));
				aInfoBox.Execute();
				eOldChartStyle = eChartStyle;
				bOK=FALSE;
			}
	}
	/*
	if (bCheckAlways)
		if ((pChartYAxis->GetMin() <= 0.0)
			&& ((const SfxBoolItem&)GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Get(SCHATTR_AXIS_LOGARITHM)).GetValue())
		{
			// FG: Falls ein Pointer auf ein Fenster uebergeben wird ist die Dialogbox nicht-modal
			//     Nutzt man dies fuer Veraenderungen am Chart aus, stuertzt das Programm ab.
			// InfoBox aInfoBox(SFX_APP()->GetAppWindow(), String(SchResId(STR_NO_LOGARITHMIC_MIN_VALUES)));
			InfoBox aInfoBox(NULL, String(SchResId(STR_NO_LOGARITHMIC_MIN_VALUES)));
			aInfoBox.Execute();
			eOldChartStyle = eChartStyle;
			bOK=FALSE;
		}
*/
	return bOK;
}
/*************************************************************************
|*
|* Sub-Methode von BuildChart(), Chart-ReSizing
|*
\************************************************************************/
void ChartModel::ResizeChart(const Size& rPageSize)
{
	if (GetUseRelativePositions() && GetDiagramHasBeenMovedOrResized())
	{
		if ((rPageSize.Width() == aInitialSize.Width()) && (rPageSize.Height() == aInitialSize.Height()))
		{  // FG: Es war also ein Resize nur des Diagramms (also nur der Grafik und nicht der Seite)
			aChartRect= aDiagramRectangle;
		}
		else  // FG: 11.3.97 Dann war es ein Resize des gesamten Charts
		{
			//	The whole chart has been resized.
			//	The old size aDiagramRectangle of the diagram has to fullfill the constraint
			//	the it has to have a positive extent both in the horizontal and the vertical
			//	direction.
			//
			//	Previously (before 24.07.2001) the constraints to fullfill have been tighter:
			//	All four border lines had to lie inside the chart rectangle.
			//	If the new solution, that solves error #88404# proves to work, then remove this
			//	paragraph and the commented code below.
			if (	(aDiagramRectangle.nLeft < aDiagramRectangle.nRight)
				&&	(aDiagramRectangle.nTop < aDiagramRectangle.nBottom) )
//              if ((aDiagramRectangle.nLeft >= 0) && (aDiagramRectangle.nTop >= 0) &&
//                  (aDiagramRectangle.nRight >= 0) && (aDiagramRectangle.nBottom >= 0))
			{
				double fRelativeXPosition = ((double) aDiagramRectangle.Left()) / aInitialSize.Width();
				double fRelativeYPosition = ((double) aDiagramRectangle.Top()) / aInitialSize.Height();
//				if ((fRelativeXPosition <= 1.0) && (fRelativeYPosition <= 1.0))
//				{
					aChartRect.nLeft = (long)((double)rPageSize.Width() *  fRelativeXPosition );
					aChartRect.nTop =  (long)((double)rPageSize.Height() * fRelativeYPosition );
//				}
				fRelativeXPosition = ((double) aDiagramRectangle.Right()) / aInitialSize.Width();
				fRelativeYPosition = ((double) aDiagramRectangle.Bottom()) / aInitialSize.Height();
//				if ((fRelativeXPosition <= 1.0) && (fRelativeYPosition <= 1.0))
//				{
					aChartRect.nRight =  (long)((double)rPageSize.Width() *  fRelativeXPosition );
					aChartRect.nBottom = (long)((double)rPageSize.Height() * fRelativeYPosition );
//				}
			}
		}
	}

}
/*************************************************************************
|*
|* Sub-Methode von BuildChart(),
|*
|* FG: Hier wird der Platz berechnet, den man als oberen Rand freilassen
|*     soll,falls keine Titel dargestellt werden.
|*
\************************************************************************/
void ChartModel::CalculateUpperBorder()
{
	if ((!bShowMainTitle && !bShowSubTitle))
	{
		BOOL bSwitchColRow = eChartStyle == CHSTYLE_2D_BAR ||
							 eChartStyle == CHSTYLE_2D_STACKEDBAR ||
							 eChartStyle == CHSTYLE_2D_PERCENTBAR ||
							 eChartStyle == CHSTYLE_3D_BAR ||
							 eChartStyle == CHSTYLE_3D_FLATBAR ||
							 eChartStyle == CHSTYLE_3D_STACKEDFLATBAR ||
							 eChartStyle == CHSTYLE_3D_PERCENTFLATBAR;

		SfxItemSet aTextAttr((const SfxItemSet &)GetAttr(
					bSwitchColRow ?
						CHOBJID_DIAGRAM_X_AXIS
					  : CHOBJID_DIAGRAM_Y_AXIS));

		Size aTextSize (((SvxFontWidthItem &) aTextAttr.Get (EE_CHAR_FONTWIDTH)).GetWidth (),
						((SvxFontHeightItem &) aTextAttr.Get (EE_CHAR_FONTHEIGHT)).GetHeight ());

		aChartRect.Top () += aTextSize.Height () / 2;
	}
}
/*************************************************************************
|*
|* Sub-Methode von BuildChart(), Chart-ReSizing
|*
\************************************************************************/
void ChartModel::CreateRectsAndTitles(long whatTitle)
{
		// FG: Abhaengig von der Groesse der Page, also der Ausgabe
		// werden die Raender erst mal auf 2% der jeweiligen Richtungsausdehnung gesetzt
		// abgespeichert wird das im ChartModel. Sollte ein Text uber den  den linken
		// Rand zu weit hinausragen, also linker Rand OuterRect(SdrTextObj) < 0,
		// So wird entweder der Offset neu berechnet oder der Text veraendert.
		// Im Moment ist es nur moeglich den linken Rand nachzuregeln.
		SdrPage* pPage=GetPage(0);
		const Size& rPageSize=pPage->GetSize();

		long nYOfs = (rPageSize.Height() / 100) * 2;
		long nXOfs = (rPageSize.Width() /100) * 2;
		USHORT nIndex = 0;

		aChartRect.Left()   = aChartRect.Top()    = 0;
		aChartRect.Right()  = rPageSize.Width();
		aChartRect.Bottom() = rPageSize.Height();

		SchRectObj* pRect = new SchRectObj(aChartRect);
		pRect->SetModel( this );
		pPage->NbcInsertObject(SetObjectAttr( pRect, CHOBJID_DIAGRAM_AREA,
											  FALSE, TRUE, pDiagramAreaAttr), nIndex++);

		aChartRect.Left()   += nXOfs;  // FG: Dies ist das Rechteck in das das Chart (also die Balken ...)
		aChartRect.Top()    += nYOfs;  //     rein muss. Erst ist es maximal gross und dann wird immer
		aChartRect.Right()  -= nXOfs;  //     mehr abgezwackt.
		aChartRect.Bottom() -= nYOfs;

		Rectangle aWholeRect (aChartRect);

			// Falls aInitialSize Null ist dann wird es auf die Seitengroesse gesetzt
		if( !aInitialSize.Width ()) aInitialSize.Width () = rPageSize.Width ();
		if( !aInitialSize.Height ()) aInitialSize.Height () = rPageSize.Height ();

			// FG: Dieser Offset wird bei der Legende und den Diagrammtiteln gebraucht.
			// Er wird aus aesthetischen Gruenden verdoppelt.
			// Also ab jetzt oberer Rand nYOfs + Titel + 2*nYOfs + Unteritel + 2*nYOfs + Diagramm
			// Fuer die Legende gilt das fuer den X-Abstand.
		nXOfs *= 2; nYOfs *=2;

	   if (bTextScalable)
		  ScaleText(whatTitle,rPageSize);

	   if (bShowMainTitle)
		   DoShowMainTitle(nIndex,nYOfs);

	   if (bShowSubTitle)
		   DoShowSubTitle(nIndex,nYOfs);

		CalculateUpperBorder();
		DoShowLegend(aWholeRect,nXOfs,nYOfs,nIndex);
		ResizeChart(rPageSize);
}
/*************************************************************************
|*
|* gesamte Grafik erzeugen
|*
\************************************************************************/

void ChartModel::BuildChart(BOOL bCheckRanges,long whatTitle)
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::ChartModel::BuildChart");
	
#ifdef DBG_UTIL
	ByteString aBStr( aMainTitle, RTL_TEXTENCODING_ASCII_US );
	CHART_TRACE1( "ChartModel::BuildChart (%s)", aBStr.GetBuffer());
#endif

	//kein setzen der p*Attr durch die Objekte
	SetAttrAutoStorage(FALSE);

	if (bNoBuildChart)
	{
		bShouldBuildChart = TRUE;
	}
	else
	{
		RTL_LOGFILE_CONTEXT_AUTHOR (context2,
			"sch", "af119097", "::ChartModel::BuildChart not locked");
		//nicht ganz so schn, aber vorteilhaft. Hiermit wird ein Itemset mit
		//Attributen gefllt, die beim Einfgen etc. als default benutzt werden
		//(SetDefAttrRow). Da an dieser Stelle ein Defaultset erstellt wird, sind
		//auch Chart-globale Items gleich gesetzt (Shape3D, Fehlerbalken,Datenbeschriftung)
		//lediglich die Linien oder Flchenfarbe muss generiert werden!
		//Alternative: nur in ChangeChart defaults erstellen
		if( pChartData )
		{
			// in scatter charts the first series is for x values
			// so use first 'y-series' to copy attributes to new series
			if( IsXYChart())
			{
				if( GetRowCount() > 1 )
					pDummyAttr->Put( GetDataRowAttr( 1 ));
			}
			else
				if( GetRowCount() > 0 )
					pDummyAttr->Put( GetDataRowAttr( 0 ));
		}

		//Hotfix fr OLE-Charts #54884# Die Wurzel des bels liegt mglicherweise irgendwo anders!
		if(!pRefOutDev)
		{
			if(pChartRefOutDev)
			{
				DBG_ERROR("ChartModel::BuildChart: restoring lost pRefOutDev... something strange happend!");
				SetRefDevice(pChartRefOutDev);
			}
			else
			{
				CHART_TRACE( "ChartModel::BuildChart no pRefOutDev!" );
				if(pDocShell)
				{
					SetRefDevice(((SchChartDocShell*)pDocShell)->GetPrinter());
				}
				else
				{
					OutputDevice* pOut = Application::GetDefaultDevice();
					// this is no error: if a ChartModel is copied via clipboard there is no docshell
					// DBG_ERROR("ChartModel::BuildChart : no Docshell! (OutputDevice)");
					pChartRefOutDev = new VirtualDevice( *pOut );
					MapMode aMapMode = pChartRefOutDev->GetMapMode();
					aMapMode.SetMapUnit(MAP_100TH_MM);
					pChartRefOutDev->SetMapMode(aMapMode);
					SetRefDevice(pChartRefOutDev);
					GetOutliner()->SetRefDevice(pChartRefOutDev);
				}
			}
		}

		CheckRanges(bCheckRanges);

		if( !pChartData )		// create default chart if no chart exists so far
			InitChartData();

		if (GetColCount() && GetRowCount())
		{
			SdrPage* pPage = GetPage(0);
			if (pPage)
			{
				// MapMode des Printers auf Seite einstellen
				SfxPrinter* pPrinter = NULL;
				if(pDocShell)
					pPrinter = ((SchChartDocShell*)pDocShell)->GetPrinter();

				MapMode aOldMap;
				if(pPrinter)
					aOldMap=pPrinter->GetMapMode(); //#61431# MapMode speichern, am Ende BuildCharts restaurieren


				AdjustPrinter();
				// FG : DAs hier braucht es weil bei 3D-Charts der Bildchsimraufbau von der ChartScene
				//      erst beim ersten Paint initiiert wird. Erst dann werden die Achsentitel ausgegeben
				//      da ist aber BuildChart, aInitialSize=aPageSize setzt schon gelaufen. Deshalb diese
				//      "Chart-Globale" Variable;
				aInitialSizefor3d = aInitialSize;

				// ItemSet mit entspr. Bereich anlegen
//-/				SfxItemSet aSet( GetItemPool(), SID_ATTR_3D_RANGE_SCENE, 0);
				SfxItemSet aSet( GetItemPool(), 
					SDRATTR_3DSCENE_FIRST, SDRATTR_3DSCENE_LAST);
				BOOL bItemSetUsed = FALSE;

				if( pScene )
				{
//-/					pScene->TakeAttributes(aSet, TRUE, TRUE);
					aSet.Put(pScene->GetItemSet());
					bItemSetUsed = TRUE;
					aSceneMatrix = pScene->GetTransform();
				}
				else
				{
					SdrObject* pLoadedScene = GetObjWithId(CHOBJID_DIAGRAM, *pPage);
					if (pLoadedScene && pLoadedScene->ISA(E3dPolyScene))
					{
//-/						((E3dObject*)pLoadedScene)->SetAttrUseSubObjects(FALSE);
//-/						pLoadedScene->TakeAttributes(aSet, TRUE, TRUE);
						aSet.Put(pLoadedScene->GetItemSet());
						bItemSetUsed = TRUE;
						aSceneMatrix = ((E3dPolyScene*) pLoadedScene)->GetTransform();
						Rescue3DObjAttr(pLoadedScene->GetSubList()); //#52277#
					}
				}

				DeleteChartObjects();
				Size aPageSize = pPage->GetSize();

				SdrObjGroup *pObj = NULL;
				BOOL bNeedSetDiagram=FALSE;

				// if type addin is set the core CreateChart shoudln't be called
				// if an addin is used together with a base diagram type the base
				// type should be set as chart type here (!= CHSTYLE_ADDIN)
				if( eChartStyle != CHSTYLE_ADDIN )
				{
					// core CreateChart
					CreateRectsAndTitles(whatTitle);

					if(bResizePie && IsPieChart() && IsReal3D())
					{
						long nWidth=aChartRect.GetWidth();
						long nHeight=aChartRect.GetHeight();
						if( ((double)nHeight/(double)nWidth) > 0.5 )
						{
							bNeedSetDiagram=TRUE;
							aChartRect.Top()+=nHeight/4;
							aChartRect.Bottom()-=nHeight/4;
  							SetDiagramHasBeenMovedOrResized(TRUE);
							SetUseRelativePositions(TRUE);
							bResizePie=FALSE;
						}
					}

					pObj = CreateChart(aChartRect);

					if (pObj->ISA(SchObjGroup))
					{
						((SchObjGroup *)pObj)->SetModel(this);
						((SchObjGroup *)pObj)->SetGroupIsChart();
					}

					pPage->NbcInsertObject(pObj, 1);

				}

				// ====================
				// call AddIn if required
				// ====================
				if( mbIsInitialized &&
                    mxChartAddIn.is())
				{
					// avoid recursion
					if( ! GetChartStatusFlag( CHS_NO_ADDIN_REFRESH ))
					{
						SetChartStatusFlag( CHS_NO_ADDIN_REFRESH );
						try
						{
							mxChartAddIn->refresh();
						}
						catch( ::com::sun::star::uno::Exception aEx )
						{
#ifdef DBG_UTIL
							// convert rtl::OUString => tools String => ByteString
							String aStr( aEx.Message );
							ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
							DBG_ERROR1( "AddIn threw exception during refresh(): %s", aBStr.GetBuffer());
#endif
						}
						ResetChartStatusFlag( CHS_NO_ADDIN_REFRESH );
					}
				}

				aInitialSize = aPageSize;

				if(pScene && IsReal3D() )
				{

#ifndef NO_56798_FIX //#56798# QuickFix 5.0-Final

					if(bClearDepth)
					{
//-/						aSet.ClearItem(SID_ATTR_3D_DEPTH);
						aSet.ClearItem(SDRATTR_3DOBJ_DEPTH);
						bClearDepth=FALSE;
					}
#endif

//-/					aSet.ClearItem(SID_ATTR_3D_DOUBLE_SIDED);	//#56941#
//-/					aSet.ClearItem(SID_ATTR_3D_HORZ_SEGS);
					aSet.ClearItem(SDRATTR_3DOBJ_DOUBLE_SIDED);	//#56941#
					aSet.ClearItem(SDRATTR_3DOBJ_HORZ_SEGS);

					if(bItemSetUsed)
					{
						//funktioniert nur, wenn nicht durch vorherigen Aufruf (CheckRanges) eine MsgBox entstand
						if(eChartStyle != eOldChartStyle)
						{
							// Falls sich der ChartStyle aendert, die Extrude-Tiefe
							// auf unfueltig setzen
							const SfxPoolItem* pPoolItem = NULL;
//-/							SfxItemState eState = aSet.GetItemState(SID_ATTR_3D_DEPTH, FALSE, &pPoolItem);
							SfxItemState eState = aSet.GetItemState(SDRATTR_3DOBJ_DEPTH, FALSE, &pPoolItem);
							if(eState == SFX_ITEM_SET)
							{
								// Ist gesetzt, invalidiere
//-/								aSet.InvalidateItem(SID_ATTR_3D_DEPTH);
								aSet.InvalidateItem(SDRATTR_3DOBJ_DEPTH);
								CHART_TRACE( "Chart: Invalidating saveable item ..." );
							}
						}

						// Attribute an neuer Szene setzen

//-/						pScene->NbcSetAttributes(aSet, TRUE);
						pScene->SetItemSet(aSet);

					}

					pScene->NbcSetTransform(aSceneMatrix);

					const SfxPoolItem *pPoolItem = NULL;
					if(!IsPieChart())
					{
						if(pChartXAxis->HasDescription())
						{
							if(GetAttr(CHOBJID_DIAGRAM_X_AXIS).GetItemState( SCHATTR_TEXT_OVERLAP, FALSE, &pPoolItem ) >= SFX_ITEM_AVAILABLE )
							{
								if(!( (const SfxBoolItem*) pPoolItem)->GetValue())
									pScene->ReduceDescrList(aXDescrList);
							}
						}

						if(pChartYAxis->HasDescription())
						{
							if(GetAttr(CHOBJID_DIAGRAM_Y_AXIS).GetItemState( SCHATTR_TEXT_OVERLAP, FALSE, &pPoolItem ) >= SFX_ITEM_AVAILABLE )
							{
								if(!( (const SfxBoolItem*) pPoolItem)->GetValue())
									pScene->ReduceDescrList(aYDescrList);
							}
						}

						if(pChartZAxis->HasDescription())
						{
							if(GetAttr(CHOBJID_DIAGRAM_Z_AXIS).GetItemState( SCHATTR_TEXT_OVERLAP, FALSE, &pPoolItem ) >= SFX_ITEM_AVAILABLE )
							{
								if(!( (const SfxBoolItem*) pPoolItem)->GetValue())
									pScene->ReduceDescrList(aZDescrList);
							}
						}
					}
				}


				if(bNeedSetDiagram && pScene)
				{
					Rectangle aRectangle;
					aRectangle = pScene->GetSnapRect();
					((ChartScene *)pObj)->SetAskForLogicRect(FALSE);
					SetDiagramRectangle(aRectangle);
					SetDiagramHasBeenMovedOrResized(TRUE);
				}

				if(pPrinter)//#61431# MapMode speichern, am Ende BuildCharts restaurieren
					pPrinter->SetMapMode(aOldMap);

			}
		}
	}
	//Jetzt sollen sich die Objekte wieder drum kmmern, da das Model die Attribute erhlt
	SetAttrAutoStorage(TRUE);
	SetDiagramRectangle( aChartRect );
	eOldChartStyle = eChartStyle;
}



void ChartModel::SetUseRelativePositions (BOOL value)
{
	if (value == FALSE)
	{
		SetDiagramHasBeenMovedOrResized(FALSE);
		SetMainTitleHasBeenMoved(FALSE);
		SetSubTitleHasBeenMoved(FALSE);
		SetLegendHasBeenMoved(FALSE);
		SetXAxisTitleHasBeenMoved(FALSE);
		SetYAxisTitleHasBeenMoved(FALSE);
		SetZAxisTitleHasBeenMoved(FALSE);
		if((IsReal3D() && IsPieChart()))
		{
			Matrix4D aMatrix; //Reset der Matrix.... knnte man auch grundstzlich machen?
			aMatrix.RotateX(-F_PI/3);
			aSceneMatrix=aMatrix;
			if(pScene)
				pScene->NbcSetTransform(aSceneMatrix);
			bResizePie=TRUE;
		}
	}
	bUseRelativePositionsForChartGroups = value;
}

/*************************************************************************
|*
|* bestimme Mittelwert
|*
\************************************************************************/


double ChartModel::GetAverageValueY (long nRow)
{
	long nColCnt = GetColCount();

	if (nColCnt)
	{
		double fAverageValue = 0.0;
		long nValidCols = nColCnt;

		for (long nCol = 0;
				  nCol < nColCnt;
				  nCol ++)
		{
			double fTemp = GetData ((short) nCol, (short) nRow, FALSE);

			if( fTemp == DBL_MIN )	 // invalid value
				nValidCols--;
			else
				fAverageValue += fTemp;
		}

		return nValidCols? fAverageValue / nValidCols: DBL_MIN;
	}
	else return 0;
}

/*************************************************************************
|*
|* erzeuge mittelwertlinie
|*
\************************************************************************/


SdrObject *ChartModel::AverageValueY (long      nRow,
									  BOOL      bIsVertical,
									  Rectangle &rRect,
									  double    fAverageValue)
{
	SfxItemSet aLineAttr (GetAverageAttr(nRow));

	XPolygon aPolygon (2);

	if (bIsVertical) //#58879# x und y waren vertauscht
	{
		aPolygon [0].Y () = rRect.Top ();
		aPolygon [1].Y () = rRect.Bottom ();
		aPolygon [0].X () =
		aPolygon [1].X () = rRect.Left () + (long)( fAverageValue * (double)rRect.GetWidth());
	}
	else
	{
		aPolygon [0].X () = rRect.Left ();
		aPolygon [1].X () = rRect.Right ();
		aPolygon [0].Y () =
		aPolygon [1].Y () = rRect.Bottom() - (long)( fAverageValue * (double)rRect.GetHeight());
	}

	SdrObject *pObj = new SdrPathObj (OBJ_PLIN, aPolygon);

	if (pObj)
	{
		pObj->InsertUserData (new SchObjectId (CHOBJID_DIAGRAM_AVERAGEVALUE));
		pObj->InsertUserData (new SchDataRow( (short)nRow ));

//-/		pObj->NbcSetAttributes (aLineAttr, FALSE);
		pObj->SetItemSet(aLineAttr);
	}

	return pObj;
}
SdrObject *ChartModel::AverageValueY (long      nRow,
									  BOOL      bIsVertical,
									  ChartAxis* pAxis,
									  double    fAverageValue)
{
	SfxItemSet aLineAttr (GetAverageAttr(nRow));

	XPolygon aPolygon (2);

	//kurz und schmerzlos missbrauchen wir die Gridline-Fkt. als Mittelwertzeichner
	pAxis->GridLine(aPolygon,pAxis->GetPos(fAverageValue));

	SdrObject *pObj = new SdrPathObj (OBJ_PLIN, aPolygon);

	if (pObj)
	{
		pObj->InsertUserData (new SchObjectId (CHOBJID_DIAGRAM_AVERAGEVALUE));
		pObj->InsertUserData (new SchDataRow( (short)nRow ));

//-/		pObj->NbcSetAttributes (aLineAttr, FALSE);
		pObj->SetItemSet(aLineAttr);
	}
	return pObj;
}

/*************************************************************************
|*
|* bestimme Varianz
|*
\************************************************************************/


double ChartModel::GetVariantY (long nRow)
{
	long nColCnt = GetColCount();

	if (nColCnt)
	{
		double fSum     = 0.0;
		double fQuadSum = 0.0;
		long nValidCols = nColCnt;

		for (long nCol = 0;
				  nCol < nColCnt;
				  nCol ++)
		{
			double fData = GetData ((short) nCol, (short) nRow, FALSE);

			if( fData == DBL_MIN )
			{
				nValidCols--;
			}
			else
			{
				fSum     += fData;
				fQuadSum += fData * fData;
			}
		}

		return nValidCols? (fQuadSum - fSum*fSum / (double)nValidCols) / (double)nValidCols: DBL_MIN;
	}
	else return 0;
}

/*************************************************************************
|*
|* bestimme Varianz
|*
\************************************************************************/


double ChartModel::GetSigmaY (long nRow)
{
	return sqrt (GetVariantY (nRow));
}

/*************************************************************************
|*
|* bestimme Fehler des groessten Wertes
|*
\************************************************************************/


double ChartModel::GetBigErrorY (long   nRow,
								 double fError)
{
	double     fMax    = 0.0;
	long       nColCnt = GetColCount();

	for (long nCol = 0;
			  nCol < nColCnt;
			  nCol ++)
	{
		double fData = GetData ((short) nCol, (short) nRow, FALSE);

		if (fData != DBL_MIN)
			if (fData > fMax) fMax = fData;
	}

	return fMax * fError / 100.0;
}

/*************************************************************************
|*
|* bestimme lineare regression
|*
\************************************************************************/


void ChartModel::RegressionYX (long            nRow,
							   double          &fConst,
							   double          &fReg,
							   double          &fCorr,
							   SvxChartRegress eMyRegress)
{
	long nColCnt = GetColCount ();

	if (nColCnt)
	{
		double fAverageXY    = 0.0;
		double fAverageY     = 0.0;
		double fAverageX     = 0.0;
		double fQuadX        = 0.0;
		double fQuadY        = 0.0;

		double fCnt=0.0;

		for (long nCol = 0;nCol < nColCnt;nCol ++)
		{
			double fTempX = GetData((short)nCol,0,FALSE);
			double fTempY = GetData((short)nCol,(short)nRow,FALSE);

			if (fTempX!=DBL_MIN && fTempY!=DBL_MIN)
			{
				if ((eMyRegress == CHREGRESS_LOG) ||
					(eMyRegress == CHREGRESS_POWER)) fTempX = log (fTempX);
				if ((eMyRegress == CHREGRESS_EXP) ||
					(eMyRegress == CHREGRESS_POWER)) fTempY = log (fTempY);

				fAverageXY    += fTempX * fTempY;
				fAverageX     += fTempX;
				fAverageY     += fTempY;
				fQuadX        += fTempX * fTempX;
				fQuadY        += fTempY * fTempY;
				fCnt		  += 1.0;
			}
		}

		fCorr  = (fCnt * fAverageXY - fAverageX * fAverageY) / sqrt ((fCnt * fQuadX - fAverageX * fAverageX) *
																	 (fCnt * fQuadY - fAverageY * fAverageY));
		fReg   = (fCnt * fAverageXY - fAverageX * fAverageY) / (fCnt * fQuadX - fAverageX * fAverageX);

		fConst = (fAverageY - fReg * fAverageX) / fCnt;
		if ((eMyRegress == CHREGRESS_EXP) || (eMyRegress == CHREGRESS_POWER))
			fConst = exp (fConst);
	}
	else
		fConst = fReg = fCorr  = 0.0;
}

void ChartModel::CopyPointAttrToPage( long nRow )
{
	SdrObject* pObj;

	long nColCnt=GetColCount();

	for( long nCol = 0; nCol < nColCnt; nCol++ )
	{
		pObj = GetDataPointObj(nCol,nRow);
		DBG_ASSERT(pObj,"ChartModel::CopyPointAttrToPage:CopyPointAttrToPage: missing Object");
		if(pObj)
//-/			pObj->SetAttributes(GetFullDataPointAttr(nCol,nRow),FALSE);
			pObj->SetItemSetAndBroadcast(GetFullDataPointAttr(nCol,nRow));
	}
}
