/*************************************************************************
 *
 *  $RCSfile: chtmode9.cxx,v $
 *
 *  $Revision: 1.24.4.4 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:39:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma optimize("",off)

#pragma hdrstop
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif


#if SUPD > 364
#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif
#else
#ifndef _XTABLE_HXX //autogen
#include <svx/xtable.hxx>
#endif
#endif // SUPD

#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif

#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif

#include <list>

#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#include <svx/chrtitem.hxx>
#endif

#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH
#if SUPD > 364
#include <svx/fhgtitem.hxx>
#include <svx/fwdtitem.hxx>
#else
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#include "globfunc.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_SCHGROUP_HXX
#include "schgroup.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif

#include "ChXChartDocument.hxx"

#include <float.h>
#include "glob.hrc"

#include "pairs.hxx"
#include "chaxis.hxx"
#include "chdescr.hxx"
#include "chartbar.hxx"
#include "calculat.hxx"

/*************************************************************************
|*
|* Koordinatenachsen und Rueckwand mit Unterteilung und Beschriftung
|* erzeugen; Liefert die Einfuege-Position fuer die Chart-Datenobjekte.
|*
\************************************************************************/
void ChartModel::Create2DXYTitles(Rectangle& rRect,BOOL bSwitchColRow)
{
	SdrPage* pPage=GetPage(0);

	SdrTextObj         *pXAxisTitleObj = NULL;
	SdrTextObj         *pYAxisTitleObj = NULL;

	if (bShowXAxisTitle)
	{
		pXAxisTitleObj = CreateTitle (pXAxisTitleAttr, CHOBJID_DIAGRAM_TITLE_X_AXIS,
									  bSwitchColRow,aXAxisTitle, FALSE, &eAdjustXAxesTitle);

		if (GetAdjustMarginsForXAxisTitle())
		{
			if (bSwitchColRow)
				rRect.Left() += GetOutputSize(*pXAxisTitleObj).Width() + 200;
			else
				rRect.Bottom() -= GetOutputSize(*pXAxisTitleObj).Height() + 200;
		}
	}
	if (bShowYAxisTitle)
	{
		pYAxisTitleObj = CreateTitle (pYAxisTitleAttr, CHOBJID_DIAGRAM_TITLE_Y_AXIS,
			bSwitchColRow,aYAxisTitle, TRUE, &eAdjustYAxesTitle);
		if (GetAdjustMarginsForYAxisTitle())
		{
			if (bSwitchColRow)
				rRect.Bottom() -= GetOutputSize(*pYAxisTitleObj).Height() + 200;
			else
				rRect.Left() += GetOutputSize(*pYAxisTitleObj).Width() + 200;
		}
	}
	if (pXAxisTitleObj)
		pPage->NbcInsertObject(pXAxisTitleObj);
	if (pYAxisTitleObj)
		pPage->NbcInsertObject(pYAxisTitleObj);
}


BOOL ChartModel::CanAxis(long nAxisId) const
{
	switch(nAxisId)
	{
	   case CHART_AXIS_PRIMARY_X:
		   return TRUE;
	   case CHART_AXIS_PRIMARY_Y:
		   return TRUE;
	   case CHART_AXIS_SECONDARY_X:
	   case CHART_AXIS_SECONDARY_Y:
		   switch(eChartStyle)
		   {
				case CHSTYLE_2D_LINE:
				case CHSTYLE_2D_STACKEDLINE:
				case CHSTYLE_2D_PERCENTLINE:
				case CHSTYLE_2D_COLUMN:
				case CHSTYLE_2D_STACKEDCOLUMN:
				case CHSTYLE_2D_PERCENTCOLUMN:
				case CHSTYLE_2D_BAR:
				case CHSTYLE_2D_STACKEDBAR:
				case CHSTYLE_2D_PERCENTBAR:
				case CHSTYLE_2D_AREA:
				case CHSTYLE_2D_STACKEDAREA:
				case CHSTYLE_2D_PERCENTAREA:
/*				case CHSTYLE_2D_PIE:
				case CHSTYLE_3D_STRIPE:
				case CHSTYLE_3D_COLUMN:
				case CHSTYLE_3D_FLATCOLUMN:
				case CHSTYLE_3D_STACKEDFLATCOLUMN:
				case CHSTYLE_3D_PERCENTFLATCOLUMN:
				case CHSTYLE_3D_AREA:
				case CHSTYLE_3D_STACKEDAREA:
				case CHSTYLE_3D_PERCENTAREA:
				case CHSTYLE_3D_SURFACE:
				case CHSTYLE_3D_PIE:
*/				case CHSTYLE_2D_XY:
//				case CHSTYLE_3D_XYZ:
				case CHSTYLE_2D_LINESYMBOLS:
				case CHSTYLE_2D_STACKEDLINESYM:
				case CHSTYLE_2D_PERCENTLINESYM:
				case CHSTYLE_2D_XYSYMBOLS:
				case CHSTYLE_3D_XYZSYMBOLS:
//				case CHSTYLE_2D_DONUT1:
//				case CHSTYLE_2D_DONUT2:
				case CHSTYLE_3D_BAR:
				case CHSTYLE_3D_FLATBAR:
				case CHSTYLE_3D_STACKEDFLATBAR:
				case CHSTYLE_3D_PERCENTFLATBAR:
/*				case CHSTYLE_2D_PIE_SEGOF1:
				case CHSTYLE_2D_PIE_SEGOFALL:
				case CHSTYLE_2D_NET:
				case CHSTYLE_2D_NET_SYMBOLS:
				case CHSTYLE_2D_NET_STACK:
				case CHSTYLE_2D_NET_SYMBOLS_STACK:
				case CHSTYLE_2D_NET_PERCENT:
				case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
*/				case CHSTYLE_2D_CUBIC_SPLINE:
				case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL:
				case CHSTYLE_2D_LINE_STACKEDCOLUMN:
				case CHSTYLE_2D_LINE_COLUMN:
				case CHSTYLE_2D_B_SPLINE:
				case CHSTYLE_2D_B_SPLINE_SYMBOL:
				case CHSTYLE_2D_CUBIC_SPLINE_XY:
				case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY:
				case CHSTYLE_2D_B_SPLINE_XY:
				case CHSTYLE_2D_B_SPLINE_SYMBOL_XY:
				case CHSTYLE_2D_XY_LINE:
				case CHSTYLE_2D_STOCK_1:
				case CHSTYLE_2D_STOCK_2:
				case CHSTYLE_2D_STOCK_3:
				case CHSTYLE_2D_STOCK_4:
			    case CHSTYLE_ADDIN:
				   return TRUE;
			   default:
				   return FALSE;
		   }
		   break;


	   default:
			return FALSE;
	}
	return FALSE;
}
BOOL ChartModel::HasSecondYAxis() const
{
	switch(eChartStyle)
	{
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			return TRUE;
	}
	if(!CanAxis(CHART_AXIS_SECONDARY_Y))
		return FALSE;

	if(pChartBAxis->IsVisible())
		return TRUE;


	const SfxPoolItem *pPoolItem = NULL;

	for(long n=0;n<GetRowCount();n++)
		if(GetDataRowAttr(n).GetItemState(SCHATTR_AXIS,TRUE, &pPoolItem) == SFX_ITEM_SET)
			if(((const SfxInt32Item*)pPoolItem)->GetValue()==CHART_AXIS_SECONDARY_Y)
				return TRUE;

	return FALSE;
}
void ChartModel::Create2DBackplane(Rectangle &rRect,SdrObjList &rObjList,BOOL bPartDescr,USHORT eStackMode)
{
	BOOL bPercent=IsPercent();
	BOOL bSwitchColRow=IsXVertikal();//IsBar()

	//Initialisieren:
	pChartXAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);
	pChartYAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);
	pChartBAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);
	pChartAAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);

	//Position setzen (kann man eigentlich auch im ctor des Model machen?)
	pChartAAxis->SetPosition(CHAXIS_POS_B); //A,B sind sekundre Achsen => oben und rechts
	pChartBAxis->SetPosition(CHAXIS_POS_B);
	pChartXAxis->SetPosition(CHAXIS_POS_A); //primre Positionen=links, unten
	pChartYAxis->SetPosition(CHAXIS_POS_A);

	pChartXAxis->CalcValueSteps();
	pChartYAxis->CalcValueSteps();//#63904# 12%
	pChartAAxis->CalcValueSteps();
	pChartBAxis->CalcValueSteps();//#63904# 11%

	pChartBAxis->AttachIfNoOwnData(pChartYAxis); //skalierung transferieren, falls Y keine automatische Skalierung benutzt und B keine Daten besitzt!
	pChartYAxis->AttachIfNoOwnData(pChartBAxis); // und umgekehrt

	//Falls  einer der beiden Y-Daten keine Reihen zugeordnet sind, soll diese die andere kopieren

	long nTitleBottom	= rRect.Bottom();
	long nTitleLeft 	= rRect.Left();

// ******* RECT_CHANGES **** Ab hier wird am rRect rumgeschraubt ******************

	Create2DXYTitles(rRect,bSwitchColRow);	//abziehen der Achsen-Titel-Flche

	// FG: Ich merke mir vor jeglicher Aenderung des linken oder rechten Randes wo der Seitenrand
	//     gewesen ist. Das braucht man um nun zu entscheiden ob der linke Rand wegen eines
	//     berstehenden Textes nachgeregelt werden soll.
	const Rectangle aOldRect(rRect);

	//Zusammenfassen ???
	pChartYAxis->CalcMaxTextSize();//#63904# 14%, aber Aufruf nur wenn ntig
	pChartYAxis->InitDescr();
	pChartYAxis->SubtractDescrSize(rRect);//Gre der Beschriftung vom Rechteck abziehen
	pChartBAxis->CalcMaxTextSize();//#63904# s.o. 0% wenn nicht benutzt!
	pChartBAxis->InitDescr();
	pChartBAxis->SubtractDescrSize(rRect);

	pChartXAxis->SetArea(rRect); //Die X-Achsenlnge ist bereits bekannt! wichtig fr nDescrWidth
	pChartAAxis->SetArea(rRect); //Die Y-Lngen werden nachfolgend korrigiert

	pChartAAxis->SetColTextMode(!IsXYChart(),!bPartDescr);
	pChartXAxis->SetColTextMode(!IsXYChart(),!bPartDescr);

	//fr die X-Achse gibt es ein paar sonderregel, insbesondere wird
	//das Rect auch in der X-Breite gendert, wenn die Spaltenunterschriften sehr lang sind
	//hinzu kommt noch Umbruch (an Y-Achse nicht vorgesehen), daher mu hier eine
	//Sonderbehandlung erfolgen, auch das InitDescr erfolgt hier nachtrglich!
	pChartXAxis->SubtractDescrSize_X(rRect,aOldRect);

	pChartAAxis->SetArea(rRect);

	pChartAAxis->SubtractDescrSize_X(rRect,aOldRect); //noch falsch!

	pChartXAxis->SetArea(rRect); //jetzt sind x und y lnge bekannt
	pChartYAxis->SetArea(rRect);
	pChartAAxis->SetArea(rRect);
	pChartBAxis->SetArea(rRect);

// ******* END RECT_CHANGES ********************************************************************

	rRect.Justify();

	pChartXAxis->SetArea(rRect); //jetzt sind x und y lnge bekannt
	pChartYAxis->SetArea(rRect);
	pChartAAxis->SetArea(rRect);
	pChartBAxis->SetArea(rRect);

	long  nStepPartWidth=pChartXAxis->GetDescrWidth(); //Warum nochmal? sollte noch immer identisch nDescrWidth sein!

	Position2DAxisTitles(rRect,bSwitchColRow,nTitleLeft,nTitleBottom);

	// Diagrammwand
	SdrRectObj* pWallObj = new SdrRectObj( rRect );
	pWallObj->SetModel( this );
	rObjList.NbcInsertObject( SetObjectAttr( pWallObj, CHOBJID_DIAGRAM_WALL,
											 TRUE, TRUE, pDiagramWallAttr));

	//********* Erzeugung der Achsen und Gitter *****************************

	SdrObjList* pXGridMainList = NULL;
	SdrObjList* pYGridMainList = NULL;
	SdrObjList* pXGridHelpList = NULL;
	SdrObjList* pYGridHelpList = NULL;
	SdrObjList* pBAxisList	   = NULL;


	BOOL bXAxis = (pChartXAxis->IsVisible() && pChartYAxis->IsOriginInRange());
	BOOL bYAxis = (pChartYAxis->IsVisible() &&
		(!IsXYChart() || (IsXYChart() && pChartXAxis->IsOriginInRange())));

	if(bShowXGridMain)
		pXGridMainList = CreateGroup (rObjList, CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP);
	if(bShowYGridMain)
		pYGridMainList = CreateGroup (rObjList, CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP);
	if(bShowXGridHelp)
		pXGridHelpList = CreateGroup (rObjList, CHOBJID_DIAGRAM_X_GRID_HELP_GROUP);
	if(bShowYGridHelp)
		pYGridHelpList = CreateGroup (rObjList, CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP);

	pChartXAxis->CreateAxis( rObjList, CHOBJID_DIAGRAM_X_AXIS );
	pChartYAxis->CreateAxis( rObjList, CHOBJID_DIAGRAM_Y_AXIS );

	pChartXAxis->ShowAxis(bXAxis);
	pChartYAxis->ShowAxis(bYAxis);

	pChartXAxis->SetMainGrid(pYGridMainList,pYGridMainAttr);
	pChartXAxis->SetHelpGrid(pYGridHelpList,pYGridHelpAttr);

	pChartYAxis->SetHelpGrid(pXGridHelpList,pXGridHelpAttr);
	pChartYAxis->SetMainGrid(pXGridMainList,pXGridMainAttr);

	pChartAAxis->CreateAxis(rObjList,CHOBJID_DIAGRAM_A_AXIS);
	pChartBAxis->CreateAxis(rObjList,CHOBJID_DIAGRAM_B_AXIS);

	//sek. Achsen haben nie ein Gitter
	pChartAAxis->SetHelpGrid(NULL,NULL);
	pChartAAxis->SetMainGrid(NULL,NULL);
	pChartBAxis->SetHelpGrid(NULL,NULL);
	pChartBAxis->SetMainGrid(NULL,NULL);

	pChartXAxis->CreateAxis(pChartYAxis->GetPosOrigin(),pChartXAxis->HasDescription(),bXAxis);

	if (IsXYChart())
	{
		pChartYAxis->CreateAxis(pChartXAxis->GetPosOrigin(),pChartYAxis->HasDescription(),bYAxis);
	}
	else
	{
		if(bYAxis)
			pChartYAxis->CreateAxis();
	}

	pChartYAxis->DrawGrids();
	pChartBAxis->DrawGrids();//eigentlich kein Grid, nur die Ticks!

	if(IsXYChart())
	{	//Achtung! Die X-Achse untersttzt Umbruch (nColumnTextWidth)!
		pChartXAxis->InitDescr();
		pChartAAxis->InitDescr();
	}
	else //Hier wird der ColText genutzt -> Beschrnkung auf maMaxTextSize!
	{
		pChartXAxis->InitDescr_X();
		pChartAAxis->InitDescr_X();
	}
	pChartAAxis->DrawGrids();
	pChartXAxis->DrawGrids();
}
void ChartModel::Position2DAxisTitles(const Rectangle& rRect,BOOL bSwitchColRow,long nTitleLeft,long nTitleBottom)
{
	SdrPage *pPage = GetPage(0);
	Size aPageSize = pPage->GetSize();

	if(bShowXAxisTitle)
	{
		SdrObject *pXAxisTitleObj = GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*pPage);

		if (pXAxisTitleObj)
		{


			Point aXAxesTitlePosition (rRect.Left() + (int) (rRect.GetWidth() / 2),nTitleBottom);

			if (GetXAxisTitleHasBeenMoved() && GetUseRelativePositions() &&
				(aXAxesTitlePosition.X() > 0) && (aXAxesTitlePosition.Y() > 0))
			{
				// FG: Das ist eine Variable die in BuildChart gesetzt wird, kurz bevor
				//     das Objekt zerstoert wird.
				double fRelativeXPosition = ((double) aTitleXAxisPosition.X()) / aInitialSize.Width();
				double fRelativeYPosition = ((double) aTitleXAxisPosition.Y()) / aInitialSize.Height();
				aXAxesTitlePosition.X() = (int) (aPageSize.Width() * fRelativeXPosition + 0.5);
				aXAxesTitlePosition.Y() = (int) (aPageSize.Height() * fRelativeYPosition + 0.5);
			}
			else
			{
				if (bSwitchColRow)
				{
					aXAxesTitlePosition.X() = nTitleLeft;
					aXAxesTitlePosition.Y() = (long)(rRect.Top() + rRect.GetHeight() / 2);
				}
			}
			SetTextPos((SdrTextObj &) *pXAxisTitleObj, aXAxesTitlePosition,pXAxisTitleAttr);
		}
	}

	if(bShowYAxisTitle)
	{
		SdrObject *pYAxisTitleObj = GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*pPage);

		if (pYAxisTitleObj)
		{
			Point aYAxesTitlePosition (Max(0L,nTitleLeft),
				Max(0L,(long) (rRect.Top() + (int) (rRect.GetHeight() / 2))));

			if (GetYAxisTitleHasBeenMoved() && GetUseRelativePositions() &&
				(aYAxesTitlePosition.X() >= 0) && (aYAxesTitlePosition.Y() >= 0))
			{
				// FG: Das ist eine Variable die in BuildChart gesetzt wird, kurz bevor
				//     das Objekt zerstoert wird.
				double fRelativeXPosition = ((double) aTitleYAxisPosition.X()) / aInitialSize.Width();
				double fRelativeYPosition = ((double) aTitleYAxisPosition.Y()) / aInitialSize.Height();
				aYAxesTitlePosition.X() = (int) (aPageSize.Width() * fRelativeXPosition + 0.5);
				aYAxesTitlePosition.Y() = (int) (aPageSize.Height() * fRelativeYPosition + 0.5);
			}
			else
			{
				if (bSwitchColRow)
				{
					aYAxesTitlePosition.X() = rRect.Left() + (int) (rRect.GetWidth() / 2);
					aYAxesTitlePosition.Y() = nTitleBottom;
				}
			}
			SetTextPos((SdrTextObj &)*pYAxisTitleObj, aYAxesTitlePosition,pYAxisTitleAttr);
		}
	}
}
/*************************************************************************
|*
|* create 2d column charts
|*
\************************************************************************/

SdrObjGroup* ChartModel::Create2DColChart(Rectangle aRect)
{

	// Background
	SchObjGroup* pGroup;
	SdrObjList*  pList;
	CreateChartGroup (pGroup, pList);
	Create2DBackplane(aRect, *pList, TRUE,IsStacked() ? CHSTACK_MINMAX : CHSTACK_NONE);

	Rectangle aClipRect( aRect );
	aClipRect.Right() += 1;
	aClipRect.Top() -= 1;

	long nColCnt = GetColCount();
	long nRowCnt = GetRowCount();

	ULONG nInsert,nInsStat;
	ULONG nAxisBPos=CONTAINER_APPEND;
	ULONG nAxisYPos=pList->GetObjCount()-1;

	//VerbundChart, Symbol der Linie, dynamische Gre:
	Size aLegendSize (((SvxFontWidthItem &) pLegendAttr->Get (EE_CHAR_FONTWIDTH)).GetWidth (),
					  ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight ());
	if(pRefOutDev)
		aLegendSize = pRefOutDev->PixelToLogic (pRefOutDev->LogicToPixel (aLegendSize));
	else
		DBG_ERROR("ChartModel: no RefDevice");
	long nLegendHeight = aLegendSize.Height () * 9 / 10;

	SdrObject   *pObj;
	ChartAxis* pAxis=pChartYAxis;
	short nCol, nRow;
	BOOL  bPercent = IsPercent();

	long nLines = Min((long)GetNumLinesColChart(),(long)(nRowCnt));;//#50212#
	long nLineStart = nRowCnt-nLines; //#50212# Ab hier werden Linien gezeichnet

	//BarDescriptoren erzeugen
	long nR1=0,nR2=0;
	if(IsStacked())//Reihenzahl in diesem Fall egal
	{
		nR1=nR2=1;
	}
	else //sonst Datenreihen mit Balken je Achse zhlen: (Lines fallen weg)
	{
		for(nRow=0;nRow<nRowCnt;nRow++)
		{
			long nAxisUID=((const SfxInt32Item&)GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue();
			if(IsBar()||IsCol(nRow))
			{
				if(nAxisUID == CHART_AXIS_SECONDARY_Y)
					nR2++;
				else
					nR1++;
			}
		}
	}

	if(!nR1)    //Verbundcharts, Lines werden oben nicht bercksichtigt,
		nR1=1;  //aber nRn=0 macht keinen Sinn -> Korrektur
	if(!nR2)
		nR2=1;
	aBarY1.Create(aRect,nColCnt,nR1);
	aBarY2.Create(aRect,nColCnt,nR2);
	ChartBarDescriptor* pBar=&aBarY1;

	SdrObjList      **pRowLists   = new SdrObjList*[nRowCnt];
	SdrObjList      **pStatLists  = new SdrObjList*[nRowCnt];

	ChartDataDescription aDescr(nColCnt,nRowCnt,pList,this,bShowDataDescr);

	Point *pTracePoint=0;
	if(m_nDefaultColorSet&CHSPECIAL_TRACELINES)
	{
		pTracePoint = new Point[nRowCnt];//#50149#
	}


	XPolygon *pLine = new XPolygon[nLines]; //#50149#
	BOOL	bStartPointIsValid;	//	Indicates wether the first point of a line 
								//	segment is valid.

	for (nCol = 0; nCol < nColCnt; nCol++)
	{
		Point aTextPos;

		for (nRow = 0; nRow < nRowCnt; nRow++)
		{
			const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);
			SfxItemSet aDataPointAttr(rDataRowAttr);
			MergeDataPointAttr(aDataPointAttr,nCol,nRow); //#63904#

			//Achse und Bardescriptor whlen, Insertreihenfolge festlegen  ->
			long nAxisUID=((const SfxInt32Item&)rDataRowAttr.Get(SCHATTR_AXIS)).GetValue();
			pAxis=GetAxisByUID(nAxisUID);
			if(nAxisUID==CHART_AXIS_SECONDARY_Y)
			{
				pBar=&aBarY2;
				nInsert=nAxisBPos;
			}
			else
			{
				pBar=&aBarY1;
				nInsert=nAxisYPos;//Insert-Reihenfolge festlegen
			}
			BOOL bIsLine=IsLine(nRow);
			if(bIsLine)
				nInsert=CONTAINER_APPEND;

			nInsStat = (nInsert==CONTAINER_APPEND) ? nInsert : nInsert+1;//Statistik immer hinter den Reihenobjekten, sonst wird sie verdeckt
			//<- Achse und Bardescriptor whlen, Insertreihenfolge festlegen

			if(!nRow)
			{
				pChartBAxis->InitStacking();
				pChartYAxis->InitStacking();
			}

			if (!nCol)
			{
				SchObjGroup* pRowGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_ROWGROUP, TRUE, TRUE);

				pRowGroup->InsertUserData(new SchDataRow(nRow));
				pList->NbcInsertObject(pRowGroup,nInsert);
				pRowLists[nRow] = pRowGroup->GetSubList();

				SchObjGroup* pStatGroup = (SchObjGroup*) CreateSimpleGroup (CHOBJID_DIAGRAM_STATISTICS_GROUP, TRUE, TRUE);

				pStatGroup->InsertUserData(new SchDataRow(nRow));
				pList->NbcInsertObject(pStatGroup,nInsStat);
				pStatLists [nRow] = pStatGroup->GetSubList ();
			}

			long       nIndex         = nCol + nRow * nColCnt;
			double     fData          = GetData(nCol, nRow, bPercent);

			BOOL bLogarithm = pAxis->IsLogarithm();
			switch (eChartStyle)
			{
				case CHSTYLE_2D_COLUMN:
				case CHSTYLE_2D_LINE_COLUMN:
				{
					Point aTopLeft(pBar->BarLeft(),pAxis->GetUpper(fData,TRUE));
					Point aBottomRight(pBar->BarRight(),pAxis->GetLower(fData,TRUE));

					Rectangle aObjRect(aTopLeft, aBottomRight);

					BOOL bShow = (aObjRect.Bottom() >= aObjRect.Top());
					aObjRect.Justify();

					if (!nCol && ((const SfxBoolItem &) rDataRowAttr.Get (SCHATTR_STAT_AVERAGE)).GetValue ())
						pStatLists[nRow]->NbcInsertObject(AverageValueY(nRow,FALSE,aRect,
																		pAxis->CalcFact(GetAverageValueY(nRow))));

					if (bShow && ((!bLogarithm && (fData != DBL_MIN)) ||
								  (bLogarithm && (fData != DBL_MIN) && (fData > 0.0))))
					{
						if(bIsLine) //#50212#
						{
							// Verbund-Chart
							// Letzte "Datenreihe" als Linie ausgeben
							pLine[nRow-nLineStart][1] =
								Point(pBar->Middle(),pAxis->GetPos(fData));

							if (nCol == 0)
							{
								// Beim ersten Datenpunkt: Anfangspunkt = EndPunkt
								pLine[nRow-nLineStart][0] = pLine[nRow-nLineStart][1];//#50212#
								bStartPointIsValid = TRUE;
							}
							// Symbol einfuegen
                            Point& rInsert = pLine[ nRow - nLineStart ][ 1 ];

                            if( aClipRect.IsInside( rInsert ) )
                            {
                                SdrObject* pNewObj = CreateSymbol( rInsert, nRow, nCol,
                                                                   (SfxItemSet &)aDataPointAttr,
                                                                   nLegendHeight ); //#50212#
                                if(pNewObj)
                                {
                                    pNewObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));
                                    pRowLists[nRow]->NbcInsertObject(pNewObj);
                                }
                            }

							//	Insert the line segment only if its starting point has a valid
							//	value.
							if (bStartPointIsValid)
							{
								// Insert line.
                                XPolyPolygon aResult;
                                SchCalculationHelper::IntersectPolygonWithRectangle( pLine[ nRow - nLineStart ],
                                                                                     aClipRect,
                                                                                     aResult );
                                if( aResult.Count())
                                {
                                    SdrPathObj* pObj = new SdrPathObj( OBJ_PLIN, aResult );
                                    pObj->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_ROWSLINE ));
                                    pObj->InsertUserData( new SchDataRow( nRow ));
                                    pRowLists[ nRow ]->NbcInsertObject( pObj, 0 );

                                    // Set the line's attributes.
                                    pObj->SetItemSet( rDataRowAttr );
                                }
							}

							// Anfangspunkt des naechsten Datenpunkts =
							// Endpunkt des aktuellen Datenpunkts
							pLine[nRow-nLineStart][0] = pLine[nRow-nLineStart][1];//#50212#
							bStartPointIsValid = TRUE;
						}
						else
						{
							pRowLists[nRow]->NbcInsertObject(CreateRect (aObjRect, nCol, nRow, aDataPointAttr));
						}

						if ((SvxChartKindError)
							((const SfxInt32Item &) aDataPointAttr.Get (SCHATTR_STAT_KIND_ERROR)).GetValue () !=
							 CHERROR_NONE)
							AverageErrorY(nRow,fData,aObjRect.TopCenter(),FALSE,aDataPointAttr,pStatLists[nRow],pAxis);

						if(aDescr.Enabled())
						{
							Point aPos(bIsLine ? pLine[nRow-nLineStart][1] : aObjRect.TopCenter() );
							aDescr.Insert(nCol,nRow,aDataPointAttr,aPos,FALSE,CHADJUST_BOTTOM_CENTER,pAxis);
						}
					}
					else if (bIsLine)
					{
						//	Remember that the current point may not be inserted.
						bStartPointIsValid = FALSE;
					}

					pBar->NextBar();
				}
				break;

				case CHSTYLE_2D_STACKEDCOLUMN:
				case CHSTYLE_2D_PERCENTCOLUMN:
				case CHSTYLE_2D_LINE_STACKEDCOLUMN:
				{
					Pair aTopBottom(pAxis->Stack(fData,TRUE));
					Point aTopLeft(pBar->BarLeft()/*nPos*/,aTopBottom.A());
					Point aBottomRight(pBar->BarRight()/*nPos + nColWidth*/,aTopBottom.B());


					Rectangle aObjRect(aTopLeft, aBottomRight);

					BOOL bShow =   (aObjRect.Bottom() >= aObjRect.Top());

					//Stackedline-Chart benutzt dieses ObjectRect nicht => Bug #48970#
					if (bIsLine)
						   bShow=TRUE;//#50212#

					if(fData==DBL_MIN)
					{
						bShow=FALSE;
					}
					else
					{
						// bShow includes Top == Bottom and that may be ok, if there is no data in the chart
						// and > might also happen (difference 1 from rounding errors)
						// AND if bShow is TRUE the following part fixes the problem
						// so ASSERT => TRACE
						CHART_TRACE1( "Create2DColChart bShow = %s", bShow? "True" : "False" );
					}
					if(bLogarithm && (fData <= 0.0) )
						bShow=FALSE;

					if (bShow)
					{
						aObjRect.Justify();

						if (bIsLine)//#50212#
						{
							pLine[nRow-nLineStart][1] = Point(pBar->Middle()//MIDPOS//zu umstndlich: nPos + nPartWidth/2 - nGap
								,pAxis->GetPos(fData));//#50212#

							if (nCol == 0)
							{
								// Beim ersten Datenpunkt: Anfangspunkt = EndPunkt
								pLine[nRow-nLineStart][0] = pLine[nRow-nLineStart][1];//#50212#
							}
                            Point& rInsert = pLine[ nRow - nLineStart ][ 1 ];

                            if( aClipRect.IsInside( rInsert ))
                            {
                                SdrObject* pNewObj = CreateSymbol( rInsert, nRow, nCol,
                                                                   (SfxItemSet &) aDataPointAttr,
                                                                   nLegendHeight ); //#50212#
                                if(pNewObj)
                                {
                                    pNewObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));
                                    pRowLists[nRow]->NbcInsertObject(pNewObj);
                                }
                            }

							// Insert line.
                            XPolyPolygon aResult;
                            SchCalculationHelper::IntersectPolygonWithRectangle( pLine[ nRow - nLineStart ],
                                                                                 aClipRect,
                                                                                 aResult );
                            if( aResult.Count())
                            {
                                SdrPathObj* pObj = new SdrPathObj( OBJ_PLIN, aResult );
                                pObj->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_ROWSLINE ));
                                pObj->InsertUserData( new SchDataRow( nRow ));
                                pRowLists[ nRow ]->NbcInsertObject( pObj, 0 );

                                // Set the line's attributes.
                                pObj->SetItemSet( rDataRowAttr );
                            }

							// Anfangspunkt des naechsten Datenpunkts =
							// Endpunkt des aktuellen Datenpunkts
							pLine[nRow-nLineStart][0] = pLine[nRow-nLineStart][1];//#50212#
						}
						else
						{ //#50116#
							Rectangle aBarRect(aObjRect);
							if(nBarPercentWidth<100 && nBarPercentWidth>0)
							{
								double fWidth=aBarRect.GetWidth();
								fWidth=fWidth*((double)nBarPercentWidth/100.0);
								long nWidth=Round(fWidth);
								long nDiff=(aBarRect.GetWidth()-nWidth);

								Size aSize=aBarRect.GetSize();
								aSize.Width()-=nDiff;
								aBarRect.SetSize(aSize);
								aBarRect.Move(nDiff/2,0);
							}
							pRowLists[nRow]->NbcInsertObject(CreateRect (aBarRect, nCol, nRow, aDataPointAttr));

							BOOL bIsDownward=(BOOL)(fData < 0.0);//FALSE;//#51471#

							if(pTracePoint) //#50149#
							{
								if(nCol != 0)
								{
									Point aEndPoint=bIsDownward ? aBarRect.BottomLeft() : aBarRect.TopLeft();//#51471#
									SdrPathObj* pObj = new SdrPathObj(pTracePoint[nRow],aEndPoint);
									pObj->InsertUserData(new SchObjectId (0));
									pList->NbcInsertObject(pObj);//immer vorne, egal welche Achse
									// Linie attributieren

//-/									pObj->NbcSetAttributes(rDataRowAttr, FALSE);
									pObj->SetItemSet(rDataRowAttr);

							   }
								pTracePoint[nRow]=bIsDownward ? aBarRect.BottomRight() :aBarRect.TopRight();//#51471#
							}
						}
						if(aDescr.Enabled())
						{
							if(bIsLine)
								aDescr.Insert(nCol,nRow,aDataPointAttr,pLine[nRow-nLineStart][1],FALSE,CHADJUST_BOTTOM_CENTER,pAxis);
							else
								aDescr.Insert(nCol,nRow,aDataPointAttr,aObjRect.Center(),FALSE,CHADJUST_CENTER_CENTER,pAxis);
						}
					}
					break;
				}

				case CHSTYLE_2D_BAR:
				{
					Point aTopLeft( pAxis->GetLower(fData),pBar->BarTop() );
					Point aRightBottom( pAxis->GetUpper(fData),pBar->BarBottom() );
					Rectangle aObjRect(aTopLeft,aRightBottom);

					BOOL bShow = (aObjRect.Right() >= aObjRect.Left());
					aObjRect.Justify();

					if (!nCol && ((const SfxBoolItem &) rDataRowAttr.Get (SCHATTR_STAT_AVERAGE)).GetValue ())
						pStatLists[nRow]->NbcInsertObject (AverageValueY (nRow, TRUE, aRect,
																		  pAxis->CalcFact(GetAverageValueY (nRow))));

					if ((bShow) && ((!bLogarithm && (fData != DBL_MIN)) ||
									(bLogarithm && (fData != DBL_MIN) && (fData > 0.0))))
					{
						pRowLists[nRow]->NbcInsertObject(CreateRect (aObjRect, nCol, nRow, aDataPointAttr));

						if ((SvxChartKindError)
							((const SfxInt32Item &) aDataPointAttr.Get (SCHATTR_STAT_KIND_ERROR)).GetValue () !=
							 CHERROR_NONE)
							AverageErrorY(nRow,fData, aObjRect.RightCenter(),TRUE,aDataPointAttr,pStatLists[nRow],pAxis);

						if(aDescr.Enabled())
						{
							Point aPos(aObjRect.TopRight());
							aPos.Y()+=aObjRect.GetHeight() / 2;
							aPos.X()+=500;
							aDescr.Insert(nCol,nRow,aDataPointAttr,aPos,FALSE,CHADJUST_CENTER_LEFT,pAxis);
						}
					}
					pBar->NextBar();
				}
				break;

				case CHSTYLE_2D_STACKEDBAR:
				case CHSTYLE_2D_PERCENTBAR:
				{
					Pair aLeftRight(pAxis->Stack(fData,TRUE));
					Point aTopLeft(aLeftRight.A(),pBar->BarBottom());
					Point aBottomRight(aLeftRight.B(),pBar->BarTop());

					Rectangle aObjRect(aTopLeft,aBottomRight);


					if ((aObjRect.Right() >= aObjRect.Left()) &&
						((!bLogarithm && (fData != DBL_MIN)) ||
						 (bLogarithm && (fData != DBL_MIN) && (fData > 0.0))))
					{
						aObjRect.Justify();

						pObj = new SdrRectObj( aObjRect );
						pObj->SetModel( this );
						pObj = SetObjectAttr( pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &aDataPointAttr );
						pObj->InsertUserData(new SchDataPoint(nCol, nRow));
						pRowLists[nRow]->NbcInsertObject(pObj);

						if(aDescr.Enabled())
							aDescr.Insert(nCol,nRow,aDataPointAttr,aObjRect.Center(),FALSE,CHADJUST_CENTER_CENTER,pAxis);
					}
					break;
				}
			}
		} //for nRow
		aBarY1.NextCol();
		aBarY2.NextCol();
	}//for nCol

	aDescr.Build(TRUE);
	delete[] pTracePoint;//#50149#
	delete[] pLine;//#50212#
	delete[] pRowLists;
	delete[] pStatLists;
	return pGroup;
}


/*************************************************************************
|*
|* Flchendiagramm erzeugen
|*		case CHSTYLE_2D_LINE:
|*		case CHSTYLE_2D_STACKEDLINE:
|*		case CHSTYLE_2D_PERCENTLINE:
|*      case CHSTYLE_2D_LINESYMBOLS :
|*      case CHSTYLE_2D_STACKEDLINESYM :
|*	    case CHSTYLE_2D_PERCENTLINESYM :
|*      case CHSTYLE_2D_CUBIC_SPLINE :
|*      case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
|*      case CHSTYLE_2D_B_SPLINE :
|*      case CHSTYLE_2D_B_SPLINE_SYMBOL :
|*
\************************************************************************/
BOOL ChartModel::HasStockLines( SvxChartStyle* pStyle )
{
	switch( pStyle? *pStyle: eChartStyle )
	{
		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
		return TRUE;
		default:
		return FALSE;
	}
}
BOOL ChartModel::HasStockRects( SvxChartStyle* pStyle )
{
	switch( pStyle? *pStyle: eChartStyle )
	{
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_4:
		return TRUE;
		default:
		return FALSE;
	}
}
BOOL ChartModel::HasStockBars( SvxChartStyle* pStyle )
{
	switch( pStyle? *pStyle: eChartStyle )
	{
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
		return TRUE;
		default:
		return FALSE;
	}
}
ChartAxis* ChartModel::GetAxisByUID(long nUId)
{
	switch(nUId)
	{
	case CHART_AXIS_PRIMARY_X:
		return pChartXAxis;
	case CHART_AXIS_PRIMARY_Y:
		return pChartYAxis;
	case CHART_AXIS_PRIMARY_Z:
		return pChartZAxis;
	case CHART_AXIS_SECONDARY_Y:
		return pChartBAxis;
	case CHART_AXIS_SECONDARY_X:
		return pChartAAxis;
	}
	DBG_ERROR1( "ChartAxis not found: id=%ld", nUId );
	return pChartYAxis;
}
#define SchDataCol(a) SchDataRow(a)     //erst mal testen..... (wird eh ne geklonte Klasse)

void ChartModel::DrawStockLines( SdrObjList* pList, const Rectangle& rRect )
{	//und fuer Stock-Charts

	long nStart=HasStockBars() ? 1:0;
	if(HasStockLines())
	{

		long nColCnt = GetColCount();
		long nRowCnt = GetRowCount();
		long nCol, nRow;

		SdrObject   *pObj;
		SdrObjList  *pLineList,*pLossList=NULL,*pPlusList=NULL;
		SchObjGroup *pLineGroup,*pLossGroup=NULL,*pPlusGroup=NULL;


		ChartBarDescriptor* pBar;
		aBarY2.Create(rRect,nColCnt,1);
		aBarY1.Create(rRect,nColCnt,1);

		pLineGroup =(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_STOCKLINE_GROUP,TRUE, TRUE);
		pList->NbcInsertObject(pLineGroup);
		pLineList = pLineGroup->GetSubList();

		XPolygon aPolyStock(2);

		//StockRects:
		long nLow,nHi;

		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			BOOL bOK=FALSE;
			nLow=nHi=0;
			for (nRow = nStart; nRow < nRowCnt; nRow++)
			{
				if(GetAxisUID(nRow)==CHART_AXIS_SECONDARY_Y)
					pBar=&aBarY2;
				else
					pBar=&aBarY1;

				ChartAxis *pAxis=GetAxisByUID(((const SfxInt32Item &)GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue());
				double fData = GetData(nCol,nRow,FALSE);
				if(fData != DBL_MIN)
				{
					bOK=TRUE;
					long nYPos = pAxis->GetPos(fData);

					aPolyStock[0].X()=aPolyStock[1].X()=(USHORT)pBar->Middle();
					if(nRow==nStart)//geht auch schner: bInitialise (ToDo:)
					{
						aPolyStock[0].Y()=aPolyStock[1].Y()=(USHORT) nYPos;
					}
					else
					{
						if((USHORT)nYPos > aPolyStock[0].Y())
							aPolyStock[0].Y()=(USHORT)nYPos;
						if((USHORT)nYPos < aPolyStock[1].Y())
							aPolyStock[1].Y()=(USHORT)nYPos;
					}
					switch(nRow-nStart)//StockRects
					{
						case 0:
							nLow=nYPos;
							break;
						case 3:
							nHi=nYPos;
							break;
					}
				}
			}
			if(bOK)
			{
				pObj = new SdrPathObj(OBJ_PLIN, aPolyStock);
				pObj->InsertUserData(new SchObjectId (CHOBJID_DIAGRAM_STOCKLINE));
				pObj->InsertUserData(new SchDataCol((short)nCol));
				pLineList->NbcInsertObject(pObj,LIST_APPEND);

//-/				pObj->NbcSetAttributes(*pStockLineAttr, FALSE);
				pObj->SetItemSet(*pStockLineAttr);


				if(HasStockRects()&&nRowCnt>3)
				{
					BOOL bLoss=TRUE;
					if(nLow>nHi)
					{
						long nTmp=nLow;
						nLow=nHi;
						nHi=nTmp;
						bLoss=FALSE;
					}

					if(!pLossList&&bLoss)
					{
						pLossGroup =(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_STOCKLOSS_GROUP,TRUE, TRUE);
						pList->NbcInsertObject(pLossGroup);
						pLossList = pLossGroup->GetSubList();
					}
					if(!pPlusList && !bLoss)
					{
						pPlusGroup =(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_STOCKPLUS_GROUP,TRUE, TRUE);
						pList->NbcInsertObject(pPlusGroup);
						pPlusList = pPlusGroup->GetSubList();
					}
					pObj = new SdrRectObj(Rectangle(Point(pBar->BarLeft(),nLow),Size(pBar->BarWidth(),nHi-nLow)));
					pObj->InsertUserData(new SchObjectId (CHOBJID_DIAGRAM_STOCKRECT));
					pObj->InsertUserData(new SchDataCol((short)nCol));
					if(bLoss)
					{
						pLossList->NbcInsertObject(pObj,LIST_APPEND);

//-/						pObj->NbcSetAttributes(*pStockLossAttr, FALSE);
						pObj->SetItemSet(*pStockLossAttr);

					}
					else
					{
						pPlusList->NbcInsertObject(pObj,LIST_APPEND);

//-/						pObj->NbcSetAttributes(*pStockPlusAttr, FALSE);
						pObj->SetItemSet(*pStockPlusAttr);

					}
				}

			}

			aBarY1.NextCol();
			aBarY2.NextCol();
//			nPos+=nXWidth;
		}
	}
}
void ChartModel::DrawStockBars(SdrObjList* pList,const Rectangle& aRect)
{
	const long nRow = 0;

	const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);

	long nColCnt = GetColCount();

	ChartBarDescriptor* pBar;
	long nAxisUID=GetAxisUID(nRow);
	switch(nAxisUID)
	{
		case CHART_AXIS_SECONDARY_Y:
			aBarY2.Create(aRect,nColCnt,1);
			pBar=&aBarY2;
			break;
		default:
			aBarY1.Create(aRect,nColCnt,1);
			pBar=&aBarY1;
			break;
	}



	SchObjGroup *pStatGroup=NULL;


	if(GetRowCount()&&HasStockBars())
	{
		SdrObjList* pDescrList = NULL;

		ChartAxis *pAxis=GetAxisByUID(((const SfxInt32Item &)rDataRowAttr.Get(SCHATTR_AXIS)).GetValue());
		long nCol;

		SdrObjList  *pBarList;

		SdrObjList* pStatList  = NULL;

		SchObjGroup *pBarGroup;

		pBarGroup =(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_ROWGROUP,TRUE, TRUE);
		pBarGroup->InsertUserData(new SchDataRow(nRow));

		pList->NbcInsertObject(pBarGroup);
		pBarList = pBarGroup->GetSubList();

		//Statistik:
		if ( ((const SfxBoolItem &) rDataRowAttr.Get (SCHATTR_STAT_AVERAGE)).GetValue ())
		{
			if(!pStatList)
			{
				pStatGroup=(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_STATISTICS_GROUP,TRUE,TRUE);
				pStatGroup->InsertUserData(new SchDataRow(nRow));
				pList->NbcInsertObject(pStatGroup);
				pStatList = pStatGroup->GetSubList();
			}

			pStatList->NbcInsertObject(
				AverageValueY( nRow, FALSE, pAxis, GetAverageValueY(nRow)) );
		}

		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol,nRow));


			double fData = GetData(nCol,nRow,FALSE);
			long nHi = pAxis->GetPos(fData);
			long nLow= pAxis->GetPosOrigin();

			if(fData != DBL_MIN)
			{
				Rectangle aObjRect(Point(pBar->BarLeft(),nLow),Size(pBar->BarWidth(),nHi-nLow));

				pBarList->NbcInsertObject(CreateRect(aObjRect,nCol,nRow,aDataPointAttr));

				if ((SvxChartKindError)
					((const SfxInt32Item &) aDataPointAttr.Get (SCHATTR_STAT_KIND_ERROR)).GetValue () !=
					 CHERROR_NONE)
				{
					if(!pStatList)
					{
						pStatGroup=(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_STATISTICS_GROUP,TRUE,TRUE);
						pStatGroup->InsertUserData(new SchDataRow(nRow));
						pList->NbcInsertObject(pStatGroup);
						pStatList = pStatGroup->GetSubList();
					}
					AverageErrorY(nRow,fData,aObjRect.TopCenter(),FALSE,aDataPointAttr,pStatList,pAxis);
				}


				// ***************************** Description *****************************
				SvxChartDataDescr eDescr  = ((const SvxChartDataDescrItem&)aDataPointAttr.
												Get(SCHATTR_DATADESCR_DESCR)).GetValue();

				if((eDescr!=CHDESCR_NONE)&&bShowDataDescr)
				{
					DataDescription aDescr;
					ClearDataDescription(&aDescr,1);
					aDescr.eDescr = eDescr;
					aDescr.bSymbol=((const SfxBoolItem&)aDataPointAttr.Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();

					if (!pDescrList)
					{
						SchObjGroup* pDescrGroup =
							(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_DESCRGROUP,TRUE,TRUE);
						pDescrGroup->InsertUserData(new SchDataRow(nRow));
						pList->NbcInsertObject(pDescrGroup);
						pDescrList = pDescrGroup->GetSubList();
					}

					aDescr.fValue = fData;

					aDescr.aTextPos2D = aObjRect.TopCenter();
					aDescr.eAdjust = CHADJUST_BOTTOM_CENTER;
					CreateDataDescr(aDescr,nCol,nRow,pAxis,FALSE);
					pDescrList->NbcInsertObject(aDescr.pLabelObj);
				}
				// ************************* end description *******************************
			}
			pBar->NextCol();
			//		nPos+=nXWidth;
		}
	}
}


SdrObjGroup* ChartModel::Create2DRowLineChart(Rectangle aRect)
{
	BOOL bPartDescr=FALSE;
	if(HasStockLines())
		bPartDescr=TRUE;

	SchObjGroup *pGroup;
	SdrObjList  *pList;
	CreateChartGroup (pGroup, pList);
	BOOL bStacked   = IsStacked();
	USHORT eStackMode =  bStacked ? CHSTACK_OVERLAP : CHSTACK_NONE;
	Create2DBackplane(aRect, *pList, bPartDescr, eStackMode);

	Rectangle aClipRect( aRect );
	aClipRect.Right() += 1;
	aClipRect.Top() -= 1;

	SdrObject   *pObj;
	long	nColCnt = GetColCount();
	long	nRowCnt = GetRowCount();
	long	nCol, nRow;

	BOOL bPercent   = IsPercent();

	//ToDo: XAchse-Logarithmus auf FALSE erzwingen (???)

	long nBackColCnt = (bPartDescr) ? nColCnt +1: nColCnt ;

	if (nColCnt > 1)
	{
		nBackColCnt--;
	}

	long   nPartWidth = aRect.GetWidth() / nBackColCnt;
	double fPartWidth = ((double) aRect.GetWidth() / (double) nBackColCnt);

	SdrObjList** pRowLists   = new SdrObjList*[nRowCnt];
	SdrObjList** pStatLists  = new SdrObjList*[nRowCnt];

	ChartDataDescription aDescr(nColCnt,nRowCnt,pList,this,bShowDataDescr);

	//Berechnung von nLegendHeigth:
	Size aLegendSize (((SvxFontWidthItem &) pLegendAttr->Get(EE_CHAR_FONTWIDTH)).GetWidth(),
					  ((SvxFontHeightItem &) pLegendAttr->Get(EE_CHAR_FONTHEIGHT)).GetHeight());

	//#54884# Was soll das hier? Create2DRowLineChart
	if(pRefOutDev)
		aLegendSize = pRefOutDev->PixelToLogic(pRefOutDev->LogicToPixel(aLegendSize));
	else
		DBG_ERROR("ChartModel: no RefDevice");

	long nLegendHeight = aLegendSize.Height () * 9 / 10;

	Polygon   aPolygon( nColCnt + 16 );		// +4 -> +16: let some more points be possible. Is set to exact size later

	//Ab hier speziell fuer (Sp)Line-Charts:
	XPolygon   *pSpline = new XPolygon(nColCnt * nGranularity);

	long nStartX=aRect.Left();
	if(bPartDescr)
		nStartX+=nPartWidth/2;

	if(HasStockBars())
		DrawStockBars( pList, aRect );
	if(HasStockLines())
		DrawStockLines( pList, aRect );

	long nStart=HasStockBars() ? 1: 0;

	long nAllObjects = pList->GetObjCount () - 1;

	for (nRow = nStart; nRow < nRowCnt; nRow++)
	{
		BOOL bArea=IsArea(nRow);
		const SfxItemSet &rDataRowAttr = GetDataRowAttr(nRow);
		long nAxisUId = ((const SfxInt32Item &)rDataRowAttr.Get(SCHATTR_AXIS)).GetValue();
		ChartAxis *pAxis=GetAxisByUID(nAxisUId);

		long             nPos          = nStartX;
		double           fPos          = nStartX;
		USHORT           nPoints       = 0;

		SchObjGroup *pRowGroup =(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_ROWGROUP,TRUE, TRUE);
		SchObjGroup *pStatGroup=(SchObjGroup*)CreateSimpleGroup(CHOBJID_DIAGRAM_STATISTICS_GROUP,TRUE,TRUE);

		pRowGroup->InsertUserData(new SchDataRow((short)nRow));

		if(bArea)
			pList->NbcInsertObject(pRowGroup, nAllObjects);
		else
			pList->NbcInsertObject(pRowGroup);

		pRowLists[nRow]   = pRowGroup->GetSubList();

		pStatGroup->InsertUserData(new SchDataRow((short)nRow));
		pList->NbcInsertObject(pStatGroup);
		pStatLists [nRow] = pStatGroup->GetSubList();

		if( ! bStacked )
		{
			if (((const SfxBoolItem &) rDataRowAttr.Get (SCHATTR_STAT_AVERAGE)).GetValue ())
				pStatLists[nRow]->NbcInsertObject (AverageValueY (nRow, FALSE, aRect,
																  pAxis->CalcFact(GetAverageValueY (nRow))));
		}

		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			SfxItemSet aDataPointAttr(rDataRowAttr);//#63904#
			MergeDataPointAttr(aDataPointAttr,nCol,nRow);

			double fData = GetData(nCol, nRow, bPercent);

			BOOL bLogarithm = pAxis->IsLogarithm();
			BOOL bValidData=((fData!=DBL_MIN)&&(!bLogarithm||bLogarithm&&(fData>0.0)));

			if(!bValidData && bStacked)
			{
				fData      = 0.0;
				bValidData = TRUE;
			}

			// *****************************end Data Valid? ***************************

			if (bValidData)
			{
				if(eStackMode != CHSTACK_NONE)
					fData = pAxis->StackColData(fData,nCol,nColCnt);

				long nYPos = pAxis->GetPos(fData);

				aPolygon[nPoints].X() = nPos;
				aPolygon[nPoints].Y() = nYPos;

				nPoints++;

				if (HasSymbols(nRow))
				{

					Point& rInsert = aPolygon[nPoints - 1];

					if( aClipRect.IsInside( rInsert ) )
					{
						SdrObject *pNewObj = CreateSymbol( rInsert, nRow, nCol,
														   (SfxItemSet &) aDataPointAttr, nLegendHeight );
						if(pNewObj)
						{
							pNewObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));
							pRowLists[nRow]->NbcInsertObject(pNewObj);
						}
					}
				}

				if (!bStacked)
				{
					if ((SvxChartKindError)
						((const SfxInt32Item &)aDataPointAttr.Get(SCHATTR_STAT_KIND_ERROR)).GetValue () != CHERROR_NONE)
						 AverageErrorY(nRow,fData,aPolygon[nPoints -1],FALSE,aDataPointAttr,pStatLists[nRow],pAxis);
				}

				if(aDescr.Enabled())
				{
					Point aPos(aPolygon[nPoints-1]);
					if(aPos.X() == aRect.Left())
					{
						aPos.X()+=50;
						aDescr.Insert(nCol,nRow,aDataPointAttr,aPos,FALSE,CHADJUST_BOTTOM_LEFT,pAxis);
					}
					else
						aDescr.Insert(nCol,nRow,aDataPointAttr,aPos,FALSE,CHADJUST_BOTTOM_CENTER,pAxis);
				}
				// ************************* end description *******************************
			}
			else if( bArea )		// invalid data, area
			{
				if(eStackMode != CHSTACK_NONE)
					fData = pAxis->StackColData(fData,nCol,nColCnt);
				long nYPos = pAxis->GetPos(0.0);
				//fehlende Werte werden hier als 0 interpretiert - weglassen des BlockInhalts wre Interpolation!
				aPolygon[nPoints].X() = nPos;
				aPolygon[nPoints].Y() = nYPos;
				nPoints++;
			}
			else				// invalid data, no area
			{
				if( nPoints )
				{
					if( nPoints > 1 )
					{
						if( IsSplineChart() )
						{
							Polygon aNewPoly( nPoints );
							for( USHORT i = 0; i < nPoints; i++ )
								aNewPoly[ i ] = aPolygon[ i ];

							XPolygon aXPoly( aNewPoly );
							if ((eChartStyle == CHSTYLE_2D_CUBIC_SPLINE) ||
								(eChartStyle == CHSTYLE_2D_CUBIC_SPLINE_SYMBOL))
							{
								CubicSpline( aXPoly, nPoints - 1, nGranularity, *pSpline );
							}
							else
							{
								approxMesh( nGranularity, *pSpline, aXPoly, nPoints - 1, nSplineDepth );
							}

							XPolygon aSplinePoly( *pSpline );
							aSplinePoly.SetSize( (nPoints - 1) * nGranularity );

							// #67488# crop polygon
							XPolyPolygon aResult;
							SchCalculationHelper::IntersectPolygonWithRectangle( aSplinePoly, aClipRect, aResult );
							pObj = new SdrPathObj( OBJ_PLIN, aResult );
						}
						else
						{
							Polygon aNewPoly( nPoints );
							for( USHORT i = 0; i < nPoints; i++ )
								aNewPoly[ i ] = aPolygon[ i ];
						
							// #67488# crop polygon
							XPolyPolygon aResult;
							XPolygon aXPoly( aNewPoly );

							SchCalculationHelper::IntersectPolygonWithRectangle( aXPoly, aClipRect, aResult );
							pObj = new SdrPathObj( OBJ_PLIN, aResult );
						}
				
						pObj->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_ROWSLINE ));
						pObj->InsertUserData( new SchDataRow( (short)nRow ));
						pRowLists[ nRow ]->NbcInsertObject( pObj, 0 ); //#54870# put line to background, so symbol is in front

//-/						pObj->NbcSetAttributes( rDataRowAttr, FALSE );
						pObj->SetItemSet( rDataRowAttr);

					}
				}
				nPoints = 0;
			}

			fPos += fPartWidth;
			nPos = long(fPos);
		} //for nCol

		if( nPoints )
		{
			pObj = NULL;

			if( IsSplineChart() )
			{
				if( nPoints > 1 )
				{
					Polygon aNewPoly( nPoints );
					for( USHORT i = 0; i < nPoints; i++ )
						aNewPoly[ i ] = aPolygon[ i ];

					XPolygon aXPoly( aNewPoly );
					if ((eChartStyle == CHSTYLE_2D_CUBIC_SPLINE) ||
						(eChartStyle == CHSTYLE_2D_CUBIC_SPLINE_SYMBOL))
					{
						CubicSpline( aXPoly, nPoints - 1,nGranularity, *pSpline );
					}
					else
					{
						approxMesh( nGranularity, *pSpline, aXPoly, nPoints - 1, nSplineDepth );
					}

					XPolygon aSplinePoly( *pSpline );
					aSplinePoly.SetSize( (nPoints - 1) * nGranularity );

					// #67488# crop polygon
					XPolyPolygon aResult;
					SchCalculationHelper::IntersectPolygonWithRectangle( aSplinePoly, aClipRect, aResult );
					pObj = new SdrPathObj( OBJ_PLIN, aResult );
				}				
			}
			else
			{
				if( bArea )
				{
					Polygon aNewPoly( nPoints + 3 );
					for( USHORT i = 0; i < nPoints + 3; i++ )
						aNewPoly[ i ] = aPolygon[ i ];
					XPolygon aBase( 2 );

					pAxis->GridLine( aBase, pAxis->GetPosOrigin() );
					aNewPoly[ nPoints ]		= aBase[ 1 ];
					aNewPoly[ nPoints + 1 ]	= aBase[ 0 ];
					aNewPoly[ nPoints + 2 ]	= aNewPoly[ 0 ];

					// #67488# crop polygon
					aNewPoly.Clip( aClipRect );
					XPolygon aXPoly( aNewPoly );

					pObj = new SdrPathObj( OBJ_POLY, aXPoly );
					pObj->SetModel( this );
					SetObjectAttr( pObj,CHOBJID_DIAGRAM_ROWS, TRUE, TRUE, (SfxItemSet *)&rDataRowAttr );
				}
				else if( nPoints > 1 )			// line
				{
					// #67488# crop polygon
					Polygon aNewPoly( nPoints );
					for( USHORT i = 0; i < nPoints; i++ )
						aNewPoly[ i ] = aPolygon[ i ];

					XPolyPolygon aResult;
					XPolygon aXPoly( aNewPoly );

					SchCalculationHelper::IntersectPolygonWithRectangle( aXPoly, aClipRect, aResult );
					pObj = new SdrPathObj( OBJ_PLIN, aResult );
				}
			}

			if( pObj )
			{
				pObj->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_ROWSLINE ));

//-/				pObj->NbcSetAttributes( rDataRowAttr, FALSE );
				pObj->SetItemSet( rDataRowAttr);

				pObj->InsertUserData( new SchDataRow( (short)nRow ));

				if( ! bArea || (bArea && IsStacked()) )
					pRowLists[ nRow ]->NbcInsertObject( pObj, 0 );
				else
					pRowLists[ nRow ]->NbcInsertObject( pObj );
			}
		} // if( nPoints )
	} //for nRow

	delete pSpline;

	//Ab hier wieder wie in Create2DRow(Area)Chart:

	aDescr.Build(TRUE);
	delete[] pRowLists;
	delete[] pStatLists;
	return pGroup;
}

bool ChartModel::UsesSourceFormat( long nAxisUID, SfxItemSet** pItemSetPointer /* = NULL */ )
{
    const SfxPoolItem*    pPoolItem     = NULL;
          ChartAxis*      pAxis         = NULL;
          SfxItemSet*     pItemSet      = NULL;

    if( ( pAxis = GetAxisByUID( nAxisUID )) &&
        ( pItemSet = pAxis->GetItemSet()))
    {
        if( pItemSetPointer )
            *pItemSetPointer = pItemSet;

        // return true if item is not set (default) or it is set to TRUE
        return ( ( SFX_ITEM_SET !=
                   pItemSet->GetItemState( SID_ATTR_NUMBERFORMAT_SOURCE, FALSE, &pPoolItem )) ||
                 ( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem )->GetValue() == TRUE ));
    }

    return false;
}

// checks if the numberformat was set in MemChart (by Calc/Writer)
// if this is the case the axis attributes are overwritten and TRUE is returned
BOOL ChartModel::CheckForNewAxisNumFormat()
{
    //	Don't set the numberformater for a percent chart.
    //  or when formats are not set from the outside
    if ( IsPercentChart() ||
         UsesOwnNumberFormatter() )
    	return FALSE;

    // if source format is used, update
    const SfxPoolItem*    pPoolItem  = NULL;
          SfxItemSet*     pItemSet   =  NULL;
          SfxItemSet*     pItemSetA  =  NULL;
          bool            bRet       =  false;
          long            nRow       =  0;
          INT32           nFmt       = -1;
          USHORT          nSchattr   =  IsPercentChart()
              ? SCHATTR_AXIS_NUMFMTPERCENT
              : SCHATTR_AXIS_NUMFMT;

    // x axis
    if( IsXYChart())
    {
        bool bXUsesSrcFmt = UsesSourceFormat( CHAXIS_AXIS_X, &pItemSet );
        bool bAUsesSrcFmt = UsesSourceFormat( CHAXIS_AXIS_A, &pItemSetA );
        if( bXUsesSrcFmt || bAUsesSrcFmt )
        {
            // use source format for x-axis
            nFmt = IsDataSwitched()
                ? pChartData->GetTransNumFormatIdCol( nRow )
                : pChartData->GetTransNumFormatIdRow( nRow );
        }

        if( bXUsesSrcFmt && pItemSet && nFmt != -1 )
        {
            pItemSet->Put( SfxUInt32Item( nSchattr, nFmt ));
            bRet = true;
            nXLastNumFmt = nFmt;    // for binary file format only
        }
        if( bAUsesSrcFmt && pItemSetA && nFmt != -1 )
        {
            pItemSetA->Put( SfxUInt32Item( nSchattr, nFmt ));
            bRet = true;
            nXLastNumFmt = nFmt;
        }
        nRow++;
    }

	if( HasSecondYAxis() )	// check both y axes
    {
        // seek first series using second axis
        bool    bYAxisFound     = false;
        bool    bBAxisFound     = false;
        long    nMaxRow         = GetRowCount();

        for( ; nRow < nMaxRow; nRow++ )
        {
            if( ! bBAxisFound &&
                SFX_ITEM_SET ==
                GetDataRowAttr( nRow ).GetItemState( SCHATTR_AXIS, FALSE, &pPoolItem ) &&
                SAL_STATIC_CAST( const SfxInt32Item*, pPoolItem )->GetValue() == CHART_AXIS_SECONDARY_Y )
            {
                if( UsesSourceFormat( CHAXIS_AXIS_B, &pItemSet ) &&
                    pItemSet )
                {
                    // use source format for secondary y-axis
                    nFmt = IsDataSwitched()
                        ? pChartData->GetTransNumFormatIdCol( nRow )
                        : pChartData->GetTransNumFormatIdRow( nRow );

                    if( nFmt != -1 )
                    {
                        pItemSet->Put( SfxUInt32Item( nSchattr, nFmt ));
                        bRet = true;
                        nBLastNumFmt = nFmt;    // for binary file format only
                    }
                }
                bBAxisFound = true;
            }
            else
            {
                if( ! bYAxisFound &&
                    UsesSourceFormat( CHAXIS_AXIS_Y, &pItemSet ) &&
                    pItemSet )
                {
                    // use source format for primary  y-axis
                    nFmt = IsDataSwitched()
                        ? pChartData->GetTransNumFormatIdCol( nRow )
                        : pChartData->GetTransNumFormatIdRow( nRow );

                    if( nFmt != -1 )
                    {
                        pItemSet->Put( SfxUInt32Item( nSchattr, nFmt ));
                        bRet = true;
                        nYLastNumFmt = nFmt;    // for binary file format only
                    }
                }
                bYAxisFound = true;
            }

            if( bYAxisFound && bBAxisFound )
                break;
        }
    }
    else
    {
        // get first setting
        if( nRow < GetRowCount() &&
            UsesSourceFormat( CHAXIS_AXIS_Y, &pItemSet ) &&
            pItemSet )
        {
            nFmt = IsDataSwitched()
                ? pChartData->GetTransNumFormatIdCol( nRow )
                : pChartData->GetTransNumFormatIdRow( nRow );

            if( nFmt != -1 )
            {
                pItemSet->Put( SfxUInt32Item( nSchattr, nFmt ));
                bRet = true;
                nYLastNumFmt = nFmt;    // for binary file format only
            }
        }
    }

    return bRet;
}

BOOL ChartModel::HasDefaultGrayArea( SvxChartStyle* pStyle ) const
{
	SvxChartStyle eStyle = pStyle? *pStyle: eChartStyle;

	switch( eStyle )
	{
		case CHSTYLE_2D_NET:
		case CHSTYLE_2D_NET_SYMBOLS:
		case CHSTYLE_2D_NET_STACK:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_NET_PERCENT:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
			return TRUE;

		default:
			return FALSE;
	}

	return FALSE;
}

BOOL ChartModel::HasDefaultGrayWall( SvxChartStyle* pStyle ) const
{
	SvxChartStyle eStyle = pStyle? *pStyle: eChartStyle;

	switch( eStyle )
	{
		case CHSTYLE_2D_LINE:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_XY:
		case CHSTYLE_2D_LINESYMBOLS:
		case CHSTYLE_2D_STACKEDLINESYM:
		case CHSTYLE_2D_PERCENTLINESYM:
		case CHSTYLE_2D_XYSYMBOLS:
		case CHSTYLE_2D_CUBIC_SPLINE:
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL:
		case CHSTYLE_2D_B_SPLINE:
		case CHSTYLE_2D_B_SPLINE_SYMBOL:
		case CHSTYLE_2D_CUBIC_SPLINE_XY:
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY:
		case CHSTYLE_2D_B_SPLINE_XY:
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY:
		case CHSTYLE_2D_XY_LINE:
			return TRUE;

		default:
			return FALSE;
	}

	return FALSE;
}

using namespace com::sun::star;

void ChartModel::SetNumberFormatter( SvNumberFormatter* pFormatter )
{
	pNumFormatter = pFormatter;

	pChartXAxis->SetNumberFormatter( pNumFormatter );
	pChartYAxis->SetNumberFormatter( pNumFormatter );
	pChartZAxis->SetNumberFormatter( pNumFormatter );
	pChartAAxis->SetNumberFormatter( pNumFormatter );
	pChartBAxis->SetNumberFormatter( pNumFormatter );

    // update UNO Numberformatter Wrapper
    SfxObjectShell* pMyDocShell = GetObjectShell();
    DBG_ASSERT( pMyDocShell, "Invalid Docshell" );
    if( pMyDocShell != NULL )
    {
        ChXChartDocument* pUnoDoc = ChXChartDocument::getImplementation( pMyDocShell->GetModel());
        DBG_ASSERT( pUnoDoc, "Couldn't get XModel implementation" );
        if( pUnoDoc != NULL )
        {
            // invalidate old number formatter
            pUnoDoc->ClearNumberFormatter();
        }
	}
}

void ChartModel::TranslateAllNumFormatIds( SvULONGTable* pTransTable )
{
	if( pChartXAxis->TranslateMergedNumFormat( pTransTable ) &&
        nXLastNumFmt >= 0 )
        nXLastNumFmt = pChartXAxis->GetNumFormat();

    if( pChartYAxis->TranslateMergedNumFormat( pTransTable ) &&
        nYLastNumFmt >= 0 )
        nYLastNumFmt = pChartYAxis->GetNumFormat();

	pChartZAxis->TranslateMergedNumFormat( pTransTable );
	pChartAAxis->TranslateMergedNumFormat( pTransTable );

	if( pChartBAxis->TranslateMergedNumFormat( pTransTable ) &&
        nBLastNumFmt >= 0 )
        nBLastNumFmt = pChartBAxis->GetNumFormat();
}

void ChartModel::SetNumLinesColChart(const long nSet, BOOL bForceStyleChange)
{
	switch( eChartStyle  )
	{
		case CHSTYLE_2D_COLUMN:					// only types supporting mixing with lines
  		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_LINE_COLUMN:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			if( bForceStyleChange )
			{
				if( nSet <= 0 )
				{
					nNumLinesInColChart = 0;
					if( eChartStyle == CHSTYLE_2D_LINE_COLUMN )
						eChartStyle = CHSTYLE_2D_COLUMN;
					else if( eChartStyle == CHSTYLE_2D_LINE_STACKEDCOLUMN )
						eChartStyle = CHSTYLE_2D_STACKEDCOLUMN;
				}
				else
				{
					nNumLinesInColChart = nSet;

					if( eChartStyle == CHSTYLE_2D_COLUMN )
						eChartStyle = CHSTYLE_2D_LINE_COLUMN;
					else if( eChartStyle == CHSTYLE_2D_STACKEDCOLUMN )
						eChartStyle = CHSTYLE_2D_LINE_STACKEDCOLUMN;
				}
			}
			else
			{
				nNumLinesInColChart = nSet > 0 ? nSet : 0;
			}
            break;

        default:
            DBG_ASSERT( nSet == 0, "Trying to set number of lines to value >0 for wrong chart type" );
            nNumLinesInColChart = nSet > 0 ? nSet : 0;
            break;
	}
}

BOOL ChartModel::SetObjectShell( SfxObjectShell* pDocSh )
{
	if( ! pDocShell )
	{
		pDocShell = pDocSh;
		return TRUE;
	}
	return FALSE;
}

using namespace com::sun::star;

void ChartModel::SetChartAddIn( uno::Reference< util::XRefreshable >& xChartAddIn )
{
	if( xChartAddIn.is())
	{
		// acquire add-in
		mxChartAddIn = xChartAddIn;
		ChangeChart( CHSTYLE_ADDIN );
	}
	else
	{
		// release add-in
		mxChartAddIn = NULL;
		// if base type was not set, use default
		if( eChartStyle == CHSTYLE_ADDIN )
			ChangeChart( CHSTYLE_2D_BAR );
	}
}

void ChartModel::ResetLastAxisNumFmt( INT32 nFmt )
{
    nXLastNumFmt = nYLastNumFmt = nBLastNumFmt = nFmt;
}

void ChartModel::HandsOff()
{
    mxPictureStorage = SotStorageRef();
	mpDocStor = NULL;
}

SvStream* ChartModel::GetDocumentStream( SdrDocumentStreamInfo& rStreamInfo ) const
{
    static const String aStreamName( RTL_CONSTASCII_USTRINGPARAM( "StarChartDocument" ));
	SotStorage*	pStor = pDocShell ? pDocShell->GetMedium()->GetStorage() : NULL;
	SvStream*	pRet = NULL;

	if( pStor )
	{
		if( rStreamInfo.maUserData.Len() &&
			( rStreamInfo.maUserData.GetToken( 0, ':' ) ==
			  String( RTL_CONSTASCII_USTRINGPARAM( "vnd.sun.star.Package" ) ) ) )
		{
			const String aPicturePath( rStreamInfo.maUserData.GetToken( 1, ':' ) );

			// graphic from picture stream in picture storage in XML package
			if( aPicturePath.GetTokenCount( '/' ) == 2 )
			{
				const String aPictureStreamName( aPicturePath.GetToken( 1, '/' ) );

				if( !mxPictureStorage.Is() )
				{
					const String aPictureStorageName( aPicturePath.GetToken( 0, '/' ) );

					if( pStor->IsContained( aPictureStorageName ) &&
						pStor->IsStorage( aPictureStorageName )  )
					{
                        // member is mutable
                        mxPictureStorage = pStor->OpenUCBStorage( aPictureStorageName, STREAM_READ );
					}
				}

				if( mxPictureStorage.Is() &&
					mxPictureStorage->IsContained( aPictureStreamName ) &&
					mxPictureStorage->IsStream( aPictureStreamName ) )
				{
					pRet = mxPictureStorage->OpenSotStream( aPictureStreamName, STREAM_READ );

					if( pRet )
					{
						pRet->SetVersion( mxPictureStorage->GetVersion() );
						pRet->SetKey( mxPictureStorage->GetKey() );
					}
				}
			}

			rStreamInfo.mbDeleteAfterUse = ( pRet != NULL );
		}
		else
		{
			// graphic from plain binary document stream
			if( !mpDocStor )
			{
                SotStorageStreamRef docStream = pStor->OpenSotStream( aStreamName, STREAM_READ );
				docStream->SetVersion( pStor->GetVersion() );
				docStream->SetKey( pStor->GetKey() );

				// members are mutable
				mxDocStream = docStream;
				mpDocStor = pStor;
			}

			pRet = mxDocStream;
			rStreamInfo.mbDeleteAfterUse = FALSE;
		}
	}

#ifdef DEBUG
	if( pRet )
	{
		// try to get some information from stream
		const ULONG nStartPos = pRet->Tell();
		const ULONG nEndPos = pRet->Seek( STREAM_SEEK_TO_END );
		const ULONG nStmLen = nEndPos - nStartPos;
		sal_uChar	aTestByte;

		// try to read one byte
		if( nStmLen )
			*pRet >> aTestByte;

		pRet->Seek( nStartPos );
	}
#endif

	return pRet;
}

uno::Sequence< uno::Sequence< sal_Int32 > > ChartModel::GetSetDataPointList()
{
    const ItemSetList & rAttrList = IsDataSwitched()
        ? aSwitchDataPointAttrList
        : aDataPointAttrList;
    const long nSize = rAttrList.Count();
    long nRow, nCol;
	long nColCnt = GetColCount();
    long nRowCnt = GetRowCount();

    DBG_ASSERT( nSize == ( nRowCnt * nColCnt ), "Data-Point list has invalid size!" );

    // the 'outer' sequence contains one sequence for each series
    uno::Sequence< uno::Sequence< sal_Int32 > > aResult( nRowCnt );

    // here we need again a special treatment for pie charts as a single pie
    // uses merged data point and data row attributes the data points are also
    // set if data row attributes are set, which is always the case
    if( IsPieChart())
    {
        aResult[ 0 ].realloc( nColCnt );
        sal_Int32 * pArray = aResult[ 0 ].getArray();

        for( nCol = 0; nCol < nColCnt; ++nCol )
            pArray[ nCol ] = nCol;
    }
    else
    {
        // use a vector for quick dynamic resizing
        ::std::list< sal_Int32 > aList;

        for( nRow = 0; nRow < nRowCnt; ++nRow )
        {
            for( nCol = 0; nCol < nColCnt; ++nCol )
            {
                if( rAttrList.GetObject( nCol * nRowCnt + nRow ) != NULL )
                    aList.push_back( nCol );
            }

            if( aList.size() > 0 )
            {
                // copy list to 'inner' sequence
                aResult[ nRow ].realloc( aList.size());
                sal_Int32 * pArray = aResult[ nRow ].getArray();
                sal_Int32 i = 0;
                ::std::list< sal_Int32 >::iterator aIter;
                for( aIter = aList.begin(); aIter != aList.end(); ++aIter )
                {
                    pArray[ i++ ] = (*aIter);
                }
                aList.clear();
            }
        }
    }

    return aResult;
}

SvNumberFormatter * ChartModel::GetOwnNumberFormatter() const
{
    return pOwnNumFormatter;
}
