/*************************************************************************
 *
 *  $RCSfile: databrws.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2001/06/21 13:31:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif


#include "memchrt.hxx"
#include "chtmodel.hxx"
#include "schresid.hxx"
#include "schdll.hxx"
#include "float.h"
#include "databrws.hxx"
#include "glob.hrc"
#include "strings.hrc"



/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

ChartDataBrowseBox::ChartDataBrowseBox(Window* pParent, const ResId& rId) :
	BrowseBox(pParent, rId, BROWSER_COLUMNSELECTION | BROWSER_HIDESELECT),
	pModel(NULL),
	pMemChart(NULL),
	nRow(0),
	bValidKey (FALSE),
	pLogBook(NULL)
{
	InsertHandleColumn(30, TRUE);
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

ChartDataBrowseBox::~ChartDataBrowseBox()
{
	delete pMemChart;
}

/*************************************************************************
|*
|* Browser-Tabelle erneuern
|*
\************************************************************************/

void ChartDataBrowseBox::RenewTable()
{
	long nOldRow		= GetCurRow();
	USHORT nOldColId	= GetCurColumnId();

	BOOL bUpdate = GetUpdateMode();
	SetUpdateMode(FALSE);

	long nRowCnt = GetRowCount();

	if (nRowCnt > 0)
		RowRemoved(nRowCnt - 1, nRowCnt);

	RemoveColumns();

	InsertHandleColumn(30, TRUE);

	if (pMemChart)
	{
		short nColCnt = pMemChart->GetColCount() + 1;

		for (short i = 1; i <= nColCnt; i++)
			InsertDataColumn(i, GetColString(i), 60);

		short nRowCnt = pMemChart->GetRowCount() + 1;

		RowInserted(nRowCnt - 1, nRowCnt);

		GoToRow(Min(nOldRow, (long)(GetRowCount() - 1)));
		GoToColumnId(Min(nOldColId, (USHORT)(ColCount() - 1)));
	}

	SetUpdateMode(bUpdate);
	Invalidate();

	CursorMoved();
}

/*************************************************************************
|*
|* Spalten-String ermitteln
|*
\************************************************************************/

String ChartDataBrowseBox::GetColString(USHORT nColumnId) const
{
	if (nColumnId >= 1)
	{
		String aColString( (sal_Unicode)('A' + (nColumnId - 1) % 26));

		ULONG nFact = 27;

		for (;;)
		{
			ULONG nDiv = nColumnId / nFact;
			if (nDiv == 0)
				break;

			aColString.Insert( (sal_Unicode)('A' + ((nDiv - 1) % 26)), 0 );

			nFact *= 26;
		}

		return aColString;
	}

	return String();
}

/*************************************************************************
|*
|* Zeilen-String ermitteln
|*
\************************************************************************/

String ChartDataBrowseBox::GetRowString(long nRow) const
{
	return String::CreateFromInt32( nRow + 1 );
}

/*************************************************************************
|*
|* Zeilenzeiger auf Zeile mit der angegebenen Nummer setzen
|*
\************************************************************************/

BOOL ChartDataBrowseBox::SeekRow(long nR)
{
	nRow = (short)nR;
	return TRUE;
}

/*************************************************************************
|*
|* Feld ausgeben
|*
\************************************************************************/

void ChartDataBrowseBox::PaintField(OutputDevice& rDev,
									const Rectangle& rRect,
									USHORT nColumnId) const
{
	String aString;
	Rectangle aRect = rRect;

	if (nColumnId == 0)
	{
		aString = GetRowString(nRow);
		aRect.Top() -= 2;
	}
	else if (nRow == 0)
	{
		if (nColumnId > 1 && pMemChart)
			aString = pMemChart->GetColText((short)(nColumnId - 2));
	}
	else if( nRow > 0 )			// can be -1
	{
		switch (nColumnId)
		{
			case 1:
				if (pMemChart)
					aString = pMemChart->GetRowText((short)(nRow - 1));
				break;

			default:
				if (pMemChart)
				{
					DBG_ASSERT( pModel, "No Model" );

					double fData = pMemChart->GetData((short)(nColumnId - 2),
													  (short)(nRow - 1));

					if (fData == DBL_MIN)
						aString = String();
					else
					{
						SvNumberFormatter* pFormatter = pModel->GetNumFormatter();
						Color* pDummy = NULL;
											  ;
						pFormatter->GetOutputString(fData, pFormatter->GetStandardFormat(pMemChart->GetDataType(),
																						 LANGUAGE_SYSTEM),
													aString, &pDummy);
					}
				}
				break;
		}
	}

	if (aString.Len())
	{
		rDev.SetClipRegion(aRect);
		rDev.DrawText(aRect.TopLeft(), aString);
	}
}

/*************************************************************************
|*
|* Handler aufrufen
|*
\************************************************************************/

void ChartDataBrowseBox::CursorMoved()
{
	BrowseBox::CursorMoved();

	if (GetUpdateMode())
		aCursorMovedHdlLink.Call(this);
}

/*************************************************************************
|*
|* Abfangen, dass ueber Cursor-Left die Handle-Spalte selektiert wird.
|*
\************************************************************************/

void ChartDataBrowseBox::KeyInput(const KeyEvent& rEvt)
{
	KeyCode aKeyCode = rEvt.GetKeyCode();

	if (((aKeyCode.GetCode() >= KEY_A) && (aKeyCode.GetCode() <= KEY_Z)) ||
		((aKeyCode.GetCode() >= KEY_0) && (aKeyCode.GetCode() <= KEY_9)) ||
		(aKeyCode.GetCode() == KEY_POINT) ||
		(aKeyCode.GetCode() == KEY_COMMA) ||
		(aKeyCode.GetCode() == KEY_SUBTRACT))
	{
		long nCurCol = GetCurColumnId() - 1;
		long nCurRow = GetCurRow();

		if (!nCurCol || !nCurRow || !((aKeyCode.GetCode() >= KEY_A) && (aKeyCode.GetCode() <= KEY_Z)))
		{
			aKeyEvent = rEvt;
			bValidKey = TRUE;
			aEditFieldHdlLink.Call(this);
			bValidKey = FALSE;
			RowModified( nCurRow, (USHORT)nCurCol );
		}
	}
	else switch (aKeyCode.GetCode())
		 {
			 case KEY_UP :
				 KeyUp ();
				 break;

			 case KEY_DOWN :
				 KeyDown ();
				 break;

			 case KEY_LEFT:
				 KeyLeft ();
				 break;

			 case KEY_RIGHT:
				 KeyRight ();
				 break;

			 case KEY_DELETE:
				  {
					 long nCurCol = GetCurColumnId();
					 long nCurRow = GetCurRow();

					 if ((nCurCol >= 1) && (nCurRow >= 1)) pMemChart->SetData (nCurCol - 1, nCurRow - 1, DBL_MIN);
					 else if (!nCurRow) pMemChart->SetColText ((USHORT)nCurCol, String ());
						  else pMemChart->SetRowText ((short)nCurRow, String ());

					 RowModified( nCurRow, (USHORT)nCurCol );
				  }
				  break;

			 case KEY_HOME:
				 if (!aKeyCode.GetModifier())
				 {
					 USHORT nCurId = GetCurColumnId();
					 USHORT nLeftId = 1;

					 if (nCurId != nLeftId)
					 {
						 long nCurRow = GetCurRow();

						 while (!IsFieldVisible(nCurRow, nLeftId, FALSE))
							 ScrollColumns(-1);

						 GoToColumnId(nLeftId);
					 }
				 }
				 else BrowseBox::KeyInput(rEvt);
				 break;

			 case KEY_END:
				 if (!aKeyCode.GetModifier())
				 {
					 USHORT nCurId = GetCurColumnId();
					 USHORT nRightId = ColCount() - 1;

					 if (nCurId != nRightId)
					 {
						 long nCurRow = GetCurRow();

						 while (!IsFieldVisible(nCurRow, nRightId, FALSE))
							 ScrollColumns(1);

						 GoToColumnId(nRightId);
					 }
				 }
				 else BrowseBox::KeyInput(rEvt);
				 break;

			 default:
				 BrowseBox::KeyInput(rEvt);
				 break;
		 }
}

/*************************************************************************
|*
|* Mausklicks abfangen
|*
\************************************************************************/

void ChartDataBrowseBox::MouseButtonDown(const BrowserMouseEvent& rEvt)
{
	if (rEvt.IsLeft())
	{
		aClickHdlLink.Call(this);

		long nRow			= rEvt.GetRow();
		USHORT nColumnId	= rEvt.GetColumnId();

		if (nColumnId < 1)
		{
			if (nRow < GetRowCount())
			{
				GoToRow(nRow);
				GoToColumnId(GetCurColumnId());
			}
		}
		else if (nRow < 0 && nColumnId > 0 ||
				 nRow >= 0 && rEvt.GetColumn() < ColCount())
		{
			BrowseBox::MouseButtonDown(rEvt);
			GoToColumnId(nColumnId);
		}
	}
	else
		BrowseBox::MouseButtonDown(rEvt);
}

/*************************************************************************
|*
|* Daten aus Model setzen
|*
\************************************************************************/

void ChartDataBrowseBox::SetData(const ChartModel* pDoc)
{
	if (pDoc != pModel)
	{
		pModel = pDoc;

		delete pMemChart;

		if (pModel)
		{
			SchMemChart* pData = pModel->GetChartData();

			if (! pData)
			{
				((ChartModel *const) pModel)->InitChartData();
				pData = pModel->GetChartData();
			}

			DBG_ASSERT( pData, "No MemChart" );

			if (pData->GetColCount () && pData->GetRowCount ())
			{
				pMemChart = new SchMemChart(*(SchMemChart*)pData);

				RenewTable();
				GoToRow(1);
				GoToColumnId(2);
			}
			else
			{
				pMemChart = 0;
				RenewTable ();
			}

			//Logbuch fuer evtl. aenderungen an den Daten erstellen, damit
			// Attributierung spaeter korrekt ablaeuft:

			if(pMemChart)
				pLogBook = new SchDataLogBook(*pMemChart);
			((ChartModel *const)pModel)->SetDataLogBook(pLogBook); //delete nur im Model erlaubt!!!
		}
		else
		{
			pMemChart = NULL;

			RenewTable();
		}
	}
}

/*************************************************************************
|*
|* Spalte einfuegen
|*
\************************************************************************/

void ChartDataBrowseBox::InsertColumn()
{
	DBG_ASSERT( pMemChart, "No MemChart" );

	USHORT nCurId = GetCurColumnId();

	if (nCurId > 1)
	{
		pMemChart->InsertCols(nCurId - 2, 1);
		pLogBook->InsertCol(nCurId - 2);

		RenewTable();
	}
}

/*************************************************************************
|*
|* Spalte loeschen
|*
\************************************************************************/

void ChartDataBrowseBox::RemoveColumn()
{
	DBG_ASSERT( pMemChart, "No MemChart" );

	USHORT nCurId = GetCurColumnId();

	if (nCurId > 1)
	{
		if (ColCount() < 4)    //TVM: WAS SOLL DAS????
		{
			pMemChart->SetColText(0, String());

			short nRowCnt = pMemChart->GetRowCount();

			for (short i = 0; i < nRowCnt; i++)
				pMemChart->SetData(0, i, 0.0);
		}
		else
		{
			pMemChart->RemoveCols(nCurId - 2, 1);
			pLogBook->DeleteCol(nCurId - 2);
		}

		RenewTable();
	}
}

/*************************************************************************
|*
|* Zeile einfuegen
|*
\************************************************************************/

void ChartDataBrowseBox::InsertRow()
{
	DBG_ASSERT( pMemChart, "No MemChart" );

	long nCurRow = GetCurRow();

	if (nCurRow > 0)
	{
		pMemChart->InsertRows((short)(nCurRow - 1), 1);
		pLogBook->InsertRow(nCurRow - 1);

		RenewTable();
	}
}

/*************************************************************************
|*
|* Zeile loeschen
|*
\************************************************************************/

void ChartDataBrowseBox::RemoveRow()
{
	DBG_ASSERT( pMemChart, "No MemChart" );

	long nCurRow = GetCurRow();

	if (nCurRow > 0)
	{
		if (GetRowCount() < 3)
		{
			pMemChart->SetRowText(0, String());

			short nColCnt = pMemChart->GetColCount();

			for (short i = 0; i < nColCnt; i++)
				pMemChart->SetData(i, 0, 0.0);
		}
		else
		{
			pMemChart->RemoveRows((short)(nCurRow - 1), 1);
			pLogBook->DeleteRow(nCurRow -1 );
		}

		RenewTable();
	}
}

/*************************************************************************
|*
|* aktuellen Feld-String lesen
|*
\************************************************************************/

String ChartDataBrowseBox::GetActString() const
{
	String aString;

	if (pMemChart)
	{
		DBG_ASSERT( pModel, "No Model" );

		long nCurRow	= GetCurRow();
		USHORT nCurId	= GetCurColumnId();

		if (nCurRow == 0)
		{
			if (nCurId > 1)
				aString = pMemChart->GetColText(nCurId - 2);
		}
		else if( nCurRow > 0 )	// can be -1
		{
			if( nCurId == 1 )
				aString = pMemChart->GetRowText((short)(nCurRow - 1));
			else if( nCurId > 1 )
			{
				double fData = pMemChart->GetData((short)(nCurId - 2),
												  (short)(nCurRow - 1));
				SvNumberFormatter* pFormatter = pModel->GetNumFormatter();
				Color* pDummy = NULL;
				ULONG nFormat =
					pFormatter->GetStandardFormat(pMemChart->GetDataType(),
												  LANGUAGE_SYSTEM);
				pFormatter->GetOutputString(fData, nFormat, aString, &pDummy);
			}
		}
	}

	return aString;
}

/*************************************************************************
|*
|* aktuellen Feld-String schreiben;
|* liefert FALSE, wenn ein ungueltiger String angegeben wurde
|*
\************************************************************************/

BOOL ChartDataBrowseBox::SetActString(const String& aString)
{
	DBG_ASSERT( pMemChart, "No MemChart" );
	DBG_ASSERT( pModel, "No ChartModel" );

	long nCurRow	= GetCurRow();
	USHORT nCurId	= GetCurColumnId();

	if (nCurRow == 0)
	{
		if (nCurId > 1)
		{
			pMemChart->SetColText(nCurId - 2, aString);
			RowModified( nCurRow, nCurId );
		}
	}
	else if (nCurId == 1)
	{
		pMemChart->SetRowText((short)(nCurRow - 1), aString);
		RowModified( nCurRow, nCurId );
	}
	else if (nCurId > 1)
	{
		if (!aString.Len ())
		{
			pMemChart->SetData((short)(nCurId - 2), (short)(nCurRow - 1), DBL_MIN);
			RowModified( nCurRow, nCurId );
		}
		else
		{
			double fData;

			SvNumberFormatter* pFormatter = pModel->GetNumFormatter();
			ULONG nFormat =
				pFormatter->GetStandardFormat(pMemChart->GetDataType(),
											  LANGUAGE_SYSTEM);
			if (!pFormatter->IsNumberFormat(aString, nFormat, fData))
			{
				(WarningBox(this, WinBits(WB_OK),
							String(SchResId(STR_INVALID_NUMBER)))).Execute();
				return FALSE;
			}

			pMemChart->SetData((short)(nCurId - 2), (short)(nCurRow - 1), fData);
			RowModified( nCurRow, nCurId );
		}
	}

	return TRUE;
}

/*************************************************************************
|*
|* aktuellen Feld-Positions String ermitteln
|*
\************************************************************************/

String ChartDataBrowseBox::GetActPosString() const
{
	return GetColString(GetCurColumnId()) += GetRowString(GetCurRow());
}

/*************************************************************************
|*
|* Spalte loeschen
|*
\************************************************************************/

void ChartDataBrowseBox::SwapColumn()
{
	USHORT nCurId = GetCurColumnId();

	if (nCurId > 1)
	{
		pMemChart->SwapCols(nCurId - 2, nCurId - 1);
		pLogBook->SwapCols(nCurId -2,nCurId -1);

		SetUpdateMode(TRUE);

		if (nCurId < ColCount() - 1)
		{
			KeyRight ();
			CursorMoved();
		}

		Invalidate();
	}
}

/*************************************************************************
|*
|* Zeile loeschen
|*
\************************************************************************/

void ChartDataBrowseBox::SwapRow()
{
	long nCurRow = GetCurRow();

	if (nCurRow > 0)
	{
		pMemChart->SwapRows((short)(nCurRow - 1), (short) nCurRow);
		pLogBook->SwapRows(nCurRow-1,nCurRow);

		SetUpdateMode(TRUE);

		if (nCurRow < GetRowCount() - 1)
		{
			KeyDown ();
			CursorMoved();
		}

		Invalidate();
	}
}

/*************************************************************************
|*
|* Cursor nach links
|*
\************************************************************************/

void ChartDataBrowseBox::KeyLeft ()
{
	USHORT nCurId = GetCurColumnId();

	if (nCurId > 1)
	{
		long nCurRow = GetCurRow();
		USHORT nLeftId = nCurId - 1;

		while (!IsFieldVisible(nCurRow, nLeftId, FALSE))
			ScrollColumns(-1);

		GoToColumnId(nLeftId);
	}
}

/*************************************************************************
|*
|* Cursor nach rechts
|*
\************************************************************************/

void ChartDataBrowseBox::KeyRight ()
{
	USHORT nCurId = GetCurColumnId();

	if (nCurId < ColCount() - 1)
	{
		long nCurRow = GetCurRow();
		USHORT nRightId = nCurId + 1;

		while (!IsFieldVisible(nCurRow, nRightId, FALSE))
			ScrollColumns(1);

		GoToColumnId(nRightId);
	}
}

/*************************************************************************
|*
|* Cursor nach oben
|*
\************************************************************************/

void ChartDataBrowseBox::KeyUp ()
{
	long nCurId = GetCurRow();

	if (nCurId > 0)
	{
		USHORT nCurCol = GetCurColumnId();
		long nUpId = nCurId - 1;

		while (!IsFieldVisible(nUpId, nCurCol, FALSE))
			ScrollRows(-1);

		GoToRow(nUpId);
	}
}

/*************************************************************************
|*
|* Cursor nach unten
|*
\************************************************************************/

void ChartDataBrowseBox::KeyDown ()
{
	long nCurId = GetCurRow();

	if (nCurId < GetRowCount() - 1)
	{
		USHORT nCurCol = GetCurColumnId();
		long nDownId = nCurId + 1;

		while (!IsFieldVisible(nDownId, nCurCol, FALSE))
			ScrollRows(1);

		GoToRow(nDownId);
	}
}

/*************************************************************************
|*
|* Cursor nach unten
|*
\************************************************************************/

void ChartDataBrowseBox::QuickSortCols ()
{
	pMemChart->SortCols (GetCurRow () - 1);
	pLogBook->SetValid(FALSE);
	Invalidate();
}

/*************************************************************************
|*
|* Cursor nach unten
|*
\************************************************************************/

void ChartDataBrowseBox::QuickSortRows ()
{
	pMemChart->SortRows (GetCurColumnId () - 2);
	pLogBook->SetValid(FALSE);
	Invalidate();
}

/*************************************************************************
|*
|* Cursor nach unten
|*
\************************************************************************/

void ChartDataBrowseBox::QuickSortTableCols ()
{
	pMemChart->SortTableRows (GetCurColumnId () - 2);
	pLogBook->SetValid(FALSE);
	Invalidate();
}

/*************************************************************************
|*
|* Cursor nach unten
|*
\************************************************************************/

void ChartDataBrowseBox::QuickSortTableRows ()
{
	pMemChart->SortTableCols (GetCurRow () - 1);
	pLogBook->SetValid(FALSE);
	Invalidate();
}



