/*************************************************************************
 *
 *  $RCSfile: dgrdata.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2000/09/21 12:03:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#define _SI_NOSBXCONTROLS
#define _SDR_NOTRANSFORM

#pragma hdrstop

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif

// header for class QueryBox
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include "schresid.hxx"
#include "strings.hrc"
#include "memchrt.hxx"
#include "docshell.hxx"
#include "dgrdata.hxx"
#include "dgrdata.hrc"
#include "undgrdat.hxx"
#include "app.hrc"

SFX_IMPL_FLOATINGWINDOW(SchDiagramDataWrapper, SID_DIAGRAM_DATA_WIN)

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDiagramDataWrapper::SchDiagramDataWrapper(Window* pParent, USHORT nId,
											 SfxBindings* pBindings,
											 SfxChildWinInfo* pInfo) :
	SfxChildWindow(pParent, nId)
{
	pWindow = new SchDiagramDataWindow(pParent, pBindings, this);

	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDiagramDataWindow::SchDiagramDataWindow(Window* pWindow,
										   SfxBindings* pBind,
										   SfxChildWindow *pChild) :
		SfxFloatingWindow(pBind, pChild, pWindow, SchResId(FLTWIN_DIAGRAM_DATA)),
	aBrwData(this, ResId(CTL_DATA)),
	aFtPos(this, ResId(FT_POS)),
	aTbxEdit(this, ResId(TBX_EDIT)),
	aEdtData(this, ResId(EDT_FIELD)),
	aTbxData(this, ResId(TBX_DATA)),
	pBindings(pBind)
{
	FreeResource();

	bReadOnly=FALSE;
	Font aFont = aFtPos.GetFont();
	aFont.SetWeight(WEIGHT_NORMAL);
	aFont.SetTransparent(TRUE);
	aFtPos.SetFont(aFont);

	aTbxEdit.SetSizePixel(aTbxEdit.CalcWindowSizePixel());
	aTbxEdit.SetSelectHdl(LINK(this, SchDiagramDataWindow, EditHdl));

	aFont = aEdtData.GetFont();
	aFont.SetWeight(WEIGHT_NORMAL);
	aEdtData.SetFont(aFont);
	aEdtData.SetCancelHdl(LINK(this, SchDiagramDataWindow, CancelHdl));
	aEdtData.SetAcceptHdl(LINK(this, SchDiagramDataWindow, AcceptHdl));
	aOldEdtGetFocusHdl = aEdtData.GetGetFocusHdl();
	aEdtData.SetGetFocusHdl(LINK(this, SchDiagramDataWindow,
											  EdtGetFocusHdl));

	aTbxData.SetSizePixel(aTbxData.CalcWindowSizePixel());
	Point aPos = aTbxData.GetPosPixel();
	aPos.X() = aBrwData.GetPosPixel().X()
				+ aBrwData.GetSizePixel().Width()
				- aTbxData.GetSizePixel().Width();
	aTbxData.SetPosPixel(aPos);
	aTbxData.SetSelectHdl(LINK(this, SchDiagramDataWindow, DataHdl));

	Size aSize = aEdtData.GetSizePixel();
	aSize.Width() = aPos.X() - aEdtData.GetPosPixel().X() - 5;
	aEdtData.SetSizePixel(aSize);

	aFont = aBrwData.GetFont();
	aFont.SetWeight(WEIGHT_NORMAL);
	aBrwData.SetFont(aFont);
	aFont = aBrwData.GetTitleFont();
	aFont.SetWeight(WEIGHT_NORMAL);
	aBrwData.SetTitleFont(aFont);
	aBrwData.SetCursorMovedHdl(LINK(this, SchDiagramDataWindow,
										  NewFieldHdl));
	aBrwData.SetEditFieldHdl(LINK(this, SchDiagramDataWindow,
										EditFieldHdl));
	aBrwData.SetClickHdl(LINK(this, SchDiagramDataWindow, BrwClickHdl));

	UpdateData();
	StartListening(*pBindings);
	GrabFocus();

	aTbxData.EnableItem( TBI_DATA_TRANSFER, FALSE );

	SfxObjectShell *pShell = SfxObjectShell::Current();
	if (pShell->ISA (SchChartDocShell))
	{
		SchChartDocShell* pDocShell = (SchChartDocShell*) pShell;

		BOOL bReadOnlyData=FALSE;
		ChartModel* pModel=(ChartModel *)(&pDocShell->GetDoc());
		SchMemChart* pMemChart=pModel->GetChartData();
		if(pMemChart)
			bReadOnlyData=pMemChart->IsReadOnly();

		SetReadOnly(pDocShell->IsReadOnly()  || bReadOnlyData);
	}
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchDiagramDataWindow::~SchDiagramDataWindow()
{
	EndListening(*pBindings);
}

/*************************************************************************
|*
|* Handler Editier-Funktionen
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, EditHdl, void *, EMPTYARG )
{
	if (aEdtData.HasFocus())
		switch (aTbxEdit.GetCurItemId())
		{
			case TBI_EDIT_CANCEL:
				CancelHdl(&aEdtData);
				break;

			case TBI_EDIT_ACCEPT:
				AcceptHdl(&aEdtData);
				break;
		};
	return 0;
}

/*************************************************************************
|*
|* Handler Daten-Funktionen
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, DataHdl, void *, EMPTYARG )
{
	switch (aTbxData.GetCurItemId())
	{
		case TBI_DATA_TRANSFER:
			Transfer ();
			break;

		case TBI_DATA_INSERT_ROW:
			aBrwData.InsertRow();
			break;

		case TBI_DATA_INSERT_COL:
			aBrwData.InsertColumn();
			break;

		case TBI_DATA_DELETE_ROW:
			aBrwData.RemoveRow();
			break;

		case TBI_DATA_DELETE_COL:
			aBrwData.RemoveColumn();
			break;

		case TBI_DATA_SWAP_COL :
			aBrwData.SwapColumn ();
			break;

		case TBI_DATA_SWAP_ROW :
			aBrwData.SwapRow ();
			break;

		case TBI_DATA_SORT_COL :
			aBrwData.QuickSortCols ();
			//Transfer ();
			break;

		case TBI_DATA_SORT_ROW :
			aBrwData.QuickSortRows ();
			//Transfer ();
			break;

		case TBI_DATA_SORT_TABLE_COL :
			aBrwData.QuickSortTableCols ();
			//Transfer ();
			break;

		case TBI_DATA_SORT_TABLE_ROW :
			aBrwData.QuickSortTableRows ();
			//Transfer ();
			break;

	};
	if( ! bReadOnly )
		aTbxData.EnableItem( TBI_DATA_TRANSFER, aTbxData.GetCurItemId() != TBI_DATA_TRANSFER );

	//Einige Operation, z.B. SORT, aendern den Text unter der Selection #47334#
	aEdtData.SetText(aBrwData.GetActString());
	return 0;
}

/*************************************************************************
|*
|* Handler fuer neue Browser-Selektion
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, NewFieldHdl, void *, EMPTYARG )
{
	aFtPos.SetText(aBrwData.GetActPosString());
	aEdtData.SetText(aBrwData.GetActString());


	if(bReadOnly)return 0;

	BOOL bCanModifyRow		= aBrwData.CanModifyRow();
	BOOL bCanModifyColumn	= aBrwData.CanModifyColumn();

	aTbxData.EnableItem(TBI_DATA_INSERT_ROW, bCanModifyRow);
	aTbxData.EnableItem(TBI_DATA_INSERT_COL, bCanModifyColumn);
	aTbxData.EnableItem(TBI_DATA_DELETE_ROW, bCanModifyRow);
	aTbxData.EnableItem(TBI_DATA_DELETE_COL, bCanModifyColumn);
	aTbxData.EnableItem(TBI_DATA_SWAP_COL, bCanModifyColumn);
	aTbxData.EnableItem(TBI_DATA_SWAP_ROW, bCanModifyRow);
	aTbxData.EnableItem(TBI_DATA_SORT_COL, bCanModifyRow);
	aTbxData.EnableItem(TBI_DATA_SORT_ROW, bCanModifyColumn);

	return 0;
}
void SchDiagramDataWindow::SetReadOnly(const BOOL b)
{
	bReadOnly=b;
	if(bReadOnly)
	{
		aTbxData.EnableItem(TBX_EDIT, FALSE);
		aTbxData.EnableItem(TBI_EDIT_CANCEL, FALSE);
		aTbxData.EnableItem(TBI_EDIT_ACCEPT, FALSE);
		aEdtData.Enable(FALSE);

		aTbxData.EnableItem(TBI_DATA_SORT_TABLE_ROW, FALSE);
		aTbxData.EnableItem(TBI_DATA_SORT_TABLE_COL, FALSE);
		aTbxData.EnableItem(TBI_DATA_TRANSFER, FALSE);
		aTbxData.EnableItem(TBI_DATA_INSERT_ROW, FALSE);
		aTbxData.EnableItem(TBI_DATA_INSERT_COL, FALSE);
		aTbxData.EnableItem(TBI_DATA_DELETE_ROW, FALSE);
		aTbxData.EnableItem(TBI_DATA_DELETE_COL, FALSE);
		aTbxData.EnableItem(TBI_DATA_SWAP_COL, FALSE);
		aTbxData.EnableItem(TBI_DATA_SWAP_ROW, FALSE);
		aTbxData.EnableItem(TBI_DATA_SORT_COL, FALSE);
		aTbxData.EnableItem(TBI_DATA_SORT_ROW, FALSE);
	}
}
/*************************************************************************
|*
|* Handler fuer neue Feld-Editierung
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, EditFieldHdl, void *, EMPTYARG )
{
	aEdtData.GrabFocus();
	if (aBrwData.IsValidKey ())
	{
		aEdtData.SetText (aBrwData.LoadKey ().GetCharCode ());
		aEdtData.SetSelection (Selection (1, 1));
		aEdtData.SetModifyFlag();
//        aEdtData.GoEOL ();
	}
	else aEdtData.SetSelection(Selection(0, aEdtData.GetText().Len()));
	return 0;
}

/*************************************************************************
|*
|* Handler fuer Verwerfen der Feld-Editierung
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, CancelHdl, void *, EMPTYARG )
{
	if (aEdtData.IsModified())
	{
		aEdtData.SetText(aBrwData.GetActString());
		aEdtData.ClearModifyFlag();
	}

	aBrwData.GrabFocus();
	aTbxEdit.EnableItem(TBI_EDIT_CANCEL, FALSE);
	aTbxEdit.EnableItem(TBI_EDIT_ACCEPT, FALSE);
	return 0;
}

/*************************************************************************
|*
|* Handler fuer neue Uebernahme der Feld-Editierung
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, AcceptHdl, void *, EMPTYARG )
{
	if (aEdtData.IsModified() && !bReadOnly)
	{
		if (aBrwData.SetActString(aEdtData.GetText()))
		{
			aBrwData.Update();
			aBrwData.GrabFocus();
			aTbxEdit.EnableItem(TBI_EDIT_CANCEL, FALSE);
			aTbxEdit.EnableItem(TBI_EDIT_ACCEPT, FALSE);
			aEdtData.SetText(aBrwData.GetActString());
			aEdtData.ClearModifyFlag();
			aTbxData.EnableItem( TBI_DATA_TRANSFER, TRUE );
		}
	}
	else
	{
		aBrwData.GrabFocus();
		aTbxEdit.EnableItem(TBI_EDIT_CANCEL, FALSE);
		aTbxEdit.EnableItem(TBI_EDIT_ACCEPT, FALSE);
	}
	return 0;
}

/*************************************************************************
|*
|* GetFocus-Handler
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, EdtGetFocusHdl, void *, EMPTYARG )
{
	aTbxEdit.EnableItem(TBI_EDIT_CANCEL, TRUE);
	aTbxEdit.EnableItem(TBI_EDIT_ACCEPT, TRUE);
	aOldEdtGetFocusHdl.Call(&aEdtData);
	return 0;
}

/*************************************************************************
|*
|* Browser-Click-Handler
|*
\************************************************************************/

IMPL_LINK( SchDiagramDataWindow, BrwClickHdl, void *, EMPTYARG )
{
	if (aEdtData.IsModified() && aBrwData.SetActString(aEdtData.GetText()))
	{
		aBrwData.Update();
		aEdtData.SetText(aBrwData.GetActString());
		aEdtData.ClearModifyFlag();
	}

	aTbxEdit.EnableItem(TBI_EDIT_CANCEL, FALSE);
	aTbxEdit.EnableItem(TBI_EDIT_ACCEPT, FALSE);
	return 0;
}

/*************************************************************************
|*
|* Browser-Daten aktualisieren
|*
\************************************************************************/

void SchDiagramDataWindow::UpdateData()
{
	SfxObjectShell *pShell = SfxObjectShell::Current();

	if (pShell && pShell->ISA (SchChartDocShell))
	{
		SchChartDocShell* pDocShell = (SchChartDocShell*) pShell;
		ChartModel* pModel=NULL;
		BOOL bReadOnlyData=FALSE;

		if(pDocShell)
		{
			pModel=(ChartModel *)(&pDocShell->GetDoc());

			SchMemChart* pMemChart=pModel->GetChartData();
			if(pMemChart)
				bReadOnlyData=pMemChart->IsReadOnly();
		}

		aBrwData.SetData(pModel);
		SetReadOnly(pDocShell->IsReadOnly() || bReadOnlyData);
	}
}

/*************************************************************************
|*
|* Benachrichtigungs-Methode
|*
\************************************************************************/

void SchDiagramDataWindow::SFX_NOTIFY(SfxBroadcaster& rBC,
								  const TypeId& rBCType,
								  const SfxHint& rHint,
								  const TypeId& rHintType)
{
	if(rHint.Type() == TYPE(SfxSimpleHint))
		switch(((SfxSimpleHint&)rHint).GetId())
		{
			case SFX_HINT_DOCCHANGED:
				UpdateData();
				break;

			case SFX_HINT_DYING:
				break;
		}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchDiagramDataWindow::Close()
{
	BOOL bRet = TRUE;

	if( aTbxData.IsItemEnabled( TBI_DATA_TRANSFER ))
	{
		QueryBox aSafetyQuery( this, WB_YES_NO_CANCEL | WB_DEF_YES,
							   String( SchResId( STR_DIAGRAM_DATA_SAFETY_QUERY )));
		long nQueryResult = aSafetyQuery.Execute();

		bRet = ( nQueryResult != RET_CANCEL );

		if( nQueryResult == RET_YES )
		{
			// save changes
			Transfer();
		}
	}

	if( bRet )
	{
		// close child window
		SfxBoolItem aItem( SID_DIAGRAM_DATA, FALSE );
		if( pBindings )
		{
			SfxDispatcher* pDisp = pBindings->GetDispatcher();
			if( pDisp )
				pDisp->Execute( SID_DIAGRAM_DATA, SFX_CALLMODE_ASYNCHRON, &aItem, 0L);
			else
				DBG_ERROR( "Couldn't dispatch command" );
		}
	}

	return ( bRet? SfxFloatingWindow::Close(): FALSE );
}

void SchDiagramDataWindow::FillInfo( SfxChildWinInfo& rInfo ) const
{
	SfxFloatingWindow::FillInfo( rInfo );

	rInfo.bVisible = FALSE;
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchDiagramDataWindow::Transfer()
{
	SchChartDocShell* pDocShell =
		(SchChartDocShell*)SfxObjectShell::Current();
	if (pDocShell)
	{
		const SchMemChart* pData = aBrwData.GetData();
		if (pData)
		{
			ChartModel& rDoc = pDocShell->GetDoc();
								SchMemChart* pDocData = rDoc.GetChartData();
			DBG_ASSERT(pDocData, "Kein ChartData-Objekt vorhanden!");

			SchMemChart* pOldData = new SchMemChart(*(SchMemChart*)pDocData);
			rDoc.ChangeChartData(*new SchMemChart(*(SchMemChart*)pData), FALSE);
			SchUndoDiagramData* pUndo =
				new SchUndoDiagramData(rDoc, pOldData,
									   new SchMemChart(*(SchMemChart*)pData));
			pUndo->SetComment(String(SchResId(STR_UNDO_DIAGRAM_DATA)));
			pDocShell->GetUndoManager()->AddUndoAction(pUndo);
		}
	}
}



