/*************************************************************************
 *
 *  $RCSfile: tpdefcol.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: bm $ $Date: 2001/02/07 17:42:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
// header for GetAppData
#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#include "tpappopt.hxx"
#include "tpappopt.hrc"

#include "schdll.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "schmod.hxx"


// ====================
// class ChartColorLB
// ====================
void ChartColorLB::Fill( const SchColorTable* pTab )
{
	long nCount = pTab->Count();
	XColorEntry* pEntry;
	SetUpdateMode( FALSE );

	for( long i = 0; i < nCount; i++ )
	{
		pEntry = pTab->Get( i );
		if( pEntry )
		{
			Append( pEntry );
		}
	}
	SetUpdateMode( TRUE );	
}


// ====================
// class SchDefaultColorOptPage
// ====================
SchDefaultColorOptPage::SchDefaultColorOptPage( Window* pParent, const SfxItemSet& rInAttrs ) :
		SfxTabPage( pParent, SchResId( TP_DEF_COLOR ), rInAttrs ),
		aGbChartColors( this, SchResId( GB_CHART_COLOR_LIST ) ),
		aLbChartColors( this, SchResId( LB_CHART_COLOR_LIST ) ),
		aGbColorBox( this, SchResId( GB_COLOR_BOX ) ),
		aValSetColorBox( this, SchResId( CT_COLOR_BOX ) ),
		aPBDefault( this, SchResId( PB_RESET_TO_DEFAULT ) )
{
	FreeResource();

	aPBDefault.SetClickHdl( LINK( this, SchDefaultColorOptPage, ResetToDefaults ) );
	aLbChartColors.SetSelectHdl( LINK( this, SchDefaultColorOptPage, ListClickedHdl ) );
	aValSetColorBox.SetSelectHdl( LINK( this, SchDefaultColorOptPage, BoxClickedHdl ) );

	aValSetColorBox.SetStyle( aValSetColorBox.GetStyle()
									| WB_VSCROLL | WB_ITEMBORDER | WB_NAMEFIELD );
	aValSetColorBox.SetColCount( 8 );
	aValSetColorBox.SetLineCount( 12 );
	aValSetColorBox.SetExtraSpacing( 0 );
	aValSetColorBox.Show();

	pColorTab = new XColorTable( SvtPathOptions().GetPalettePath());

	const SfxPoolItem* pItem = NULL;
	if( rInAttrs.GetItemState( CHATTR_DEFCOLORS, FALSE, &pItem ) == SFX_ITEM_SET )
	{
		pColorConfig = SAL_STATIC_CAST( SchColorTableItem*, pItem->Clone() );
	}
	else
	{
		SchColorTable aTable;
		aTable.UseDefault();
		pColorConfig = new SchColorTableItem( CHATTR_DEFCOLORS, aTable );
		pColorConfig->SetOptions( SCH_MOD1()->GetSchOptions() );
	}

	Construct();
}

SchDefaultColorOptPage::~SchDefaultColorOptPage()
{
	delete pColorConfig;
	delete pColorTab;
}

void SchDefaultColorOptPage::Construct()
{
	if( pColorConfig )
		aLbChartColors.Fill( SAL_STATIC_CAST( SchColorTable*, pColorConfig ) );

	FillColorBox();

	aLbChartColors.SelectEntryPos( 0 );
	ListClickedHdl( &aLbChartColors );
}


SfxTabPage* __EXPORT SchDefaultColorOptPage::Create( Window* pParent, const SfxItemSet& rAttrs )
{
	return new SchDefaultColorOptPage( pParent, rAttrs );
}

BOOL __EXPORT SchDefaultColorOptPage::FillItemSet( SfxItemSet& rOutAttrs )
{
	if( pColorConfig )
		rOutAttrs.Put( *SAL_STATIC_CAST( SfxPoolItem*, pColorConfig ));
	
	return TRUE;
}

void __EXPORT SchDefaultColorOptPage::Reset( const SfxItemSet& rInAttrs )
{
	aLbChartColors.SelectEntryPos( 0 );
	ListClickedHdl( &aLbChartColors );
}

void SchDefaultColorOptPage::FillColorBox()
{
	if( !pColorTab ) return;
	
	long nCount = pColorTab->Count();
	XColorEntry* pColorEntry;

	for( long i = 0; i < nCount; i++ )
	{
		pColorEntry = pColorTab->Get( i );
		aValSetColorBox.InsertItem( (USHORT) i + 1, pColorEntry->GetColor(), pColorEntry->GetName() );
	}
}


long SchDefaultColorOptPage::GetColorIndex( const Color& rCol )
{
	if( pColorTab )
	{
		long nCount = pColorTab->Count();
		XColorEntry* pColorEntry;

		for( long i = nCount - 1; i >= 0; i-- )			// default chart colors are at the end of the table
		{
			pColorEntry = pColorTab->Get( i );
			if( pColorEntry && pColorEntry->GetColor() == rCol )
				return SAL_STATIC_CAST( XPropertyTable*, pColorTab )->Get( pColorEntry->GetName() );
		}
	}
	return -1L;
}



// --------------------
// event handlers
// --------------------

// ResetToDefaults
// ---------------

IMPL_LINK( SchDefaultColorOptPage, ResetToDefaults, void *, EMPTYARG )
{
  	SAL_STATIC_CAST( SchColorTable*, pColorConfig )->UseDefault();

	aLbChartColors.Clear();
	aLbChartColors.Fill( SAL_STATIC_CAST( SchColorTable*, pColorConfig ) );

	aLbChartColors.GetFocus();

	return 0L;
}

// ListClickedHdl
// --------------

IMPL_LINK( SchDefaultColorOptPage, ListClickedHdl, ChartColorLB*,  pColorList )
{
	Color aCol = pColorList->GetSelectEntryColor();

	long nIndex = GetColorIndex( aCol );

	if( nIndex == -1 )		// not found
	{
		aValSetColorBox.SetNoSelection();
	}
	else
	{
		aValSetColorBox.SelectItem( (USHORT)nIndex + 1 );		// ValueSet is 1-based
	}

	return 0L;
}

// BoxClickedHdl
// -------------

IMPL_LINK( SchDefaultColorOptPage, BoxClickedHdl, ValueSet*, pColorBox )
{
	USHORT nIdx = aLbChartColors.GetSelectEntryPos();
	if( nIdx != LISTBOX_ENTRY_NOTFOUND )
	{
		XColorEntry* pEntry = new XColorEntry( aValSetColorBox.GetItemColor( aValSetColorBox.GetSelectItemId() ),
											   aLbChartColors.GetSelectEntry() );

		aLbChartColors.Modify( pEntry, nIdx );
		pColorConfig->ReplaceAndDestroy( nIdx, pEntry );
							   
		aLbChartColors.SelectEntryPos( nIdx );	// reselect entry
	}
	
	return 0L;
}

