/*************************************************************************
 *
 *  $RCSfile: fudraw.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2000/09/21 12:03:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#ifndef _SVDOGRP_HXX //autogen
#include <svx/svdogrp.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/flstitem.hxx>

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
#include "schresid.hxx"
#include "objid.hxx"
#include "fudraw.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include <svx/svxids.hrc>


TYPEINIT1(SchFuDraw, SchFuPoor);


/*************************************************************************
|*
|* Basisklasse fuer alle Drawmodul-spezifischen Funktionen
|*
\************************************************************************/

SchFuDraw::SchFuDraw(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
			   ChartModel* pDoc, SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq),
	aNewPointer(POINTER_ARROW),
	aOldPointer(POINTER_ARROW),
	bMBDown(FALSE)
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuDraw::~SchFuDraw()
{
	pView->BrkAction();
}

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

BOOL SchFuDraw::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FALSE;

	switch (rKEvt.GetKeyCode().GetCode())
	{
		case KEY_ESCAPE:
			if (!pView->IsTextEdit())
				if (pView->IsAction())
				{
					pView->BrkAction();
					bReturn = TRUE;
				}
				else if (pView->HasMarkedObj())
				{
					pView->UnmarkAll();
					pView->SetDragMode( SDRDRAG_MOVE );		// #67766# remove rotation handle
					bReturn = TRUE;
				}
			break;


		case KEY_DELETE:
		case KEY_BACKSPACE:
			if (!pView->IsAction() && !pView->IsTextEdit())
			{
				if (!pView->DeleteMarkedObjects
								(String(SchResId(STR_UNDO_DELETE))))
					InfoBox(&pViewShell->GetViewFrame()->GetWindow(),
							String(SchResId(STR_ACTION_NOTPOSSIBLE))).Execute();
				bReturn = TRUE;
			}
			break;
	}

	if (!bReturn)
		bReturn = SchFuPoor::KeyInput(rKEvt);
	else
		pWindow->ReleaseMouse();

	return bReturn;
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

BOOL SchFuDraw::MouseButtonDown(const MouseEvent& rMEvt)
{
	aMDPos = pWindow->PixelToLogic(rMEvt.GetPosPixel());

	ForcePointer(&rMEvt);

	return FALSE;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

BOOL SchFuDraw::MouseMove(const MouseEvent& rMEvt)
{
	ForcePointer(&rMEvt);

	return FALSE;
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

BOOL SchFuDraw::MouseButtonUp(const MouseEvent& rMEvt)
{
	ForcePointer(&rMEvt);

	return SchFuPoor::MouseButtonUp (rMEvt);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuDraw::Activate()
{
	SchFuPoor::Activate();

	ForcePointer();
}

/*************************************************************************
|*
|* Maus-Pointer umschalten
|* FG: Bisher (8.3.97) gab es nur einen einzigen Mousepointer und den
|*     brauchte man daher auch nie umschalten. Ab jetzt gibt es auch
|*     Mousepointer die ein Resize andeuten.
|*
\************************************************************************/

void SchFuDraw::ForcePointer(const MouseEvent* pMEvt)
{
	if (pMEvt != NULL)
	{
		USHORT nModifier = 0;
		BOOL bLeftDown = FALSE;
		BOOL bAllowChange=TRUE;
		USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();

		Point aPnt(pWindow->PixelToLogic(pMEvt->GetPosPixel()));
		nModifier = pMEvt->GetModifier();
		bLeftDown = pMEvt->IsLeft();

		//doppelklick auf Achse => CRASH (nicht gefixt)
		Pointer aPointer = pView->GetPreferedPointer(aPnt, pWindow,
														  nModifier, bLeftDown);
		if(aPointer==Pointer(POINTER_TEXT))

		{
			SdrObject*   pObj = NULL;
			SdrPageView* pPV  = pView->GetPageViewPvNum (0);

			pView->PickObj(aMDPos,nHitLog,pObj,pPV);

			if(pObj)
			{

				SchObjectId* pId = GetObjectId(*pObj);
				if (pId)switch(pId->GetObjId())
				{

					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB :
					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
						break;
					default:
						bAllowChange=FALSE;
					break;
				}
//                if(pObj->GetObjList()->ISA(SdrObjGroup))
  //                  bAllowChange=FALSE;
			}
		}
		if(aPointer==Pointer(POINTER_MOVE))
		{
			SdrObject*   pObj = NULL;
			SdrPageView* pPV  = pView->GetPageViewPvNum (0);

			pView->PickObj(aMDPos,nHitLog,pObj,pPV);

			if(pObj)
			{
				SchObjectId* pId = GetObjectId(*pObj);
				if (pId)switch(pId->GetObjId())
				{

					case CHOBJID_LEGEND_SYMBOL_ROW:
					case CHOBJID_LEGEND_SYMBOL_COL:
						aPointer=Pointer(POINTER_ARROW);
						break;
					default:
					break;
				}
			}
		}


		switch(aPointer.GetStyle())
		{
		case POINTER_DRAW_BEZIER:
		case POINTER_HAND:
		case POINTER_MOVEBEZIERWEIGHT:
			 bAllowChange=FALSE;
		default: break;
		}

		if(bAllowChange)
			pWindow->SetPointer(aPointer);
	}
}

/*************************************************************************
|*
|* Reaktion auf Doppelklick
|*
\************************************************************************/

void SchFuDraw::DoubleClick()
{
	if (pView->HasMarkedObj())
	{
		const SdrMarkList& rMarkList = pView->GetMarkList();

		if (rMarkList.GetMarkCount() == 1)
		{
			SdrObject   *pObj   = rMarkList.GetMark(0)->GetObj();
			SchObjectId *pObjId = GetObjectId(*pObj);

			if (pObjId)
			{
				USHORT nId = 0;
				switch( pObjId->GetObjId() )
				{
					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
					case CHOBJID_TITLE_MAIN :
					case CHOBJID_TITLE_SUB :
						nId = SID_TEXTEDIT;
						break;

					case CHOBJID_DIAGRAM_FLOOR :
						nId = SID_DIAGRAM_FLOOR;
						break;

					case CHOBJID_DIAGRAM_WALL :
					case CHOBJID_DIAGRAM :
						if (pChDoc->IsAxisChart () && !pChDoc->IsNetChart ()) nId = SID_DIAGRAM_WALL;
						break;

					case CHOBJID_LEGEND :
						nId = SID_LEGEND;
						break;

					case CHOBJID_DIAGRAM_X_GRID_MAIN :
					case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
						nId = SID_DIAGRAM_GRID_X_MAIN;
						break;

					case CHOBJID_DIAGRAM_X_GRID_HELP :
					case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
						nId = SID_DIAGRAM_GRID_X_HELP;
						break;

					case CHOBJID_DIAGRAM_Y_GRID_MAIN :
					case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
						nId = SID_DIAGRAM_GRID_Y_MAIN;
						break;

					case CHOBJID_DIAGRAM_Y_GRID_HELP :
					case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
						nId = SID_DIAGRAM_GRID_Y_HELP;
						break;

					case CHOBJID_DIAGRAM_Z_GRID_MAIN :
					case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
						nId = SID_DIAGRAM_GRID_Z_MAIN;
						break;

					case CHOBJID_DIAGRAM_Z_GRID_HELP :
					case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
						nId = SID_DIAGRAM_GRID_Z_HELP;
						break;

					case CHOBJID_DIAGRAM_X_AXIS :
						nId = SID_DIAGRAM_AXIS_X;
						break;

					case CHOBJID_DIAGRAM_Y_AXIS :
						nId = SID_DIAGRAM_AXIS_Y;
						break;

					case CHOBJID_DIAGRAM_Z_AXIS :
						nId = SID_DIAGRAM_AXIS_Z;
						break;

					case CHOBJID_DIAGRAM_A_AXIS :
						nId = SID_DIAGRAM_AXIS_A;
						break;

					case CHOBJID_DIAGRAM_B_AXIS :
						nId = SID_DIAGRAM_AXIS_B;
						break;

					case CHOBJID_DIAGRAM_C_AXIS :
						nId = SID_DIAGRAM_AXIS_C;
						break;

					case CHOBJID_DIAGRAM_AREA:
					case CHOBJID_AREA :
						nId = SID_DIAGRAM_AREA;
						break;

					case CHOBJID_DIAGRAM_DATA :
					case CHOBJID_DIAGRAM_SPECIAL_GROUP :
					case CHOBJID_DIAGRAM_ROWGROUP :
					case CHOBJID_DIAGRAM_ROWSLINE :
					case CHOBJID_LEGEND_SYMBOL_ROW :
					case CHOBJID_LEGEND_SYMBOL_COL :
						nId = SID_DATA_ROW_POINT;
						break;

					case CHOBJID_DIAGRAM_STATISTICS_GROUP :
						nId = SID_DIAGRAM_ERROR;
						break;

					case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
						nId = SID_DIAGRAM_STOCK_LOSS;
						break;
					case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
						nId = SID_DIAGRAM_STOCK_PLUS;
						break;
					//case CHOBJID_DIAGRAM_STOCKLINE:
					case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
						nId = SID_DIAGRAM_STOCK_LINE;
						break;

					case CHOBJID_DIAGRAM_AVERAGEVALUE :
						nId = SID_DIAGRAM_AVERAGEVALUE;
						break;

					case CHOBJID_DIAGRAM_REGRESSION :
						nId = SID_DIAGRAM_REGRESSION;
						break;

					default :
						nId = 0;
						break;

				}

				if( nId > 0 )
					pViewShell->GetViewFrame()->GetDispatcher()->Execute(nId, SFX_CALLMODE_ASYNCHRON);
			}
		}
	}
}



