/*************************************************************************
 *
 *  $RCSfile: unmultdp.cxx,v $
 *
 *  $Revision: 1.1.1.1.26.1 $
 *
 *  last change: $Author: hr $ $Date: 2002/05/30 15:34:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "unmultdp.hxx"
#include "strings.hrc"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "schresid.hxx"

TYPEINIT1(SchUndoMultipleDataPoints, SchUndoAction);


#define RESIZECOUNT 16

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchUndoMultipleDataPoints::SchUndoMultipleDataPoints(ChartModel& rDoc) :
			SchUndoAction(rDoc)
{
	pSets = new List;
	pRowsAndCols = NULL;
	SetComment( String( SchResId( STR_UNDO_REMOVEPOINTATTRS )));
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchUndoMultipleDataPoints::~SchUndoMultipleDataPoints()
{
	while (pSets->Count())
		delete (SfxItemSet*)pSets->Remove(pSets->Count() - 1);
	delete[] pRowsAndCols;
}

/*************************************************************************
|*
|* AddPoint, einen Punkt hinzufuegen
|*
\************************************************************************/

void SchUndoMultipleDataPoints::AddPoint(short nCol, short nRow)
{
	long nCount = pSets->Count();

	// wenn es noch kein Array gibt, wird eines erzeugt
	if (!pRowsAndCols)
	{
		pRowsAndCols = new short[RESIZECOUNT * 2 * sizeof(short)];
	}

	// wenn es existiert, aber nicht gross genug ist, wird es umkopiert
	else if (nCount % RESIZECOUNT == 0)
	{
		short* pNewArray = new short[(nCount + RESIZECOUNT) * sizeof(short)];
		memcpy(pNewArray, pRowsAndCols, nCount * sizeof(short));
		delete[] pRowsAndCols;
		pRowsAndCols = pNewArray;
	}

	// Reihe und Spalte merken
	pRowsAndCols[nCount] = nRow;
	pRowsAndCols[nCount + 1] = nCol;

	// das alte ItemSet merken
	SfxItemSet* pOldAttr = new SfxItemSet(rDoc.GetDataPointAttr(nCol, nRow));
	pSets->Insert(pOldAttr, LIST_APPEND);
	pSets->Insert((void*)1, LIST_APPEND);   // Dummy fuer neues Set
}

/*************************************************************************
|*
|* CopyNewAttributes, die neuen Attribute merken
|*
\************************************************************************/

void SchUndoMultipleDataPoints::CopyNewAttributes()
{
	USHORT nPointCount = (USHORT)pSets->Count() / 2;

	for (USHORT nPoint = 0; nPoint < nPointCount; nPoint++)
	{
		short nRow = pRowsAndCols[2 * nPoint];
		short nCol = pRowsAndCols[2 * nPoint + 1];
		SfxItemSet* pNewAttr = new SfxItemSet(rDoc.GetDataPointAttr(nCol, nRow));
		pSets->Replace(pNewAttr, 2 * nPoint + 1);
	}
}

/*************************************************************************
|*
|* Undo
|*
\************************************************************************/

void SchUndoMultipleDataPoints::Undo()
{
	USHORT nPointCount = (USHORT)pSets->Count() / 2;

	DBG_ASSERT(nPointCount, "keine Punkte");

	BOOL bTest = FALSE;

	for (USHORT nPoint = 0; nPoint < nPointCount; nPoint++)
	{
		short nRow = pRowsAndCols[2 * nPoint];
		short nCol = pRowsAndCols[2 * nPoint + 1];
		SfxItemSet* pOldAttr = (SfxItemSet*)pSets->GetObject(2 * nPoint);
		SdrObject* pObj = rDoc.GetDataPointObj(nCol, nRow);

		// es gibt nicht immer ein entspr. Objekt im Drawing-Layer
		if (pObj)
		{
							// nicht mergen, nicht BuildChart() rufen
			rDoc.ChangeDataPointAttr(*pOldAttr, *pObj, FALSE, FALSE);
		}
		else
		{
			rDoc.PutDataPointAttr(nCol, nRow, *pOldAttr,FALSE);
		}
	}

	rDoc.BuildChart(FALSE);
}

/*************************************************************************
|*
|* Redo
|*
\************************************************************************/

void SchUndoMultipleDataPoints::Redo()
{
	USHORT nPointCount = (USHORT)pSets->Count() / 2;

	for (USHORT nPoint = 0; nPoint < nPointCount; nPoint++)
	{
		short nRow = pRowsAndCols[2 * nPoint];
		short nCol = pRowsAndCols[2 * nPoint + 1];
		SfxItemSet* pNewAttr = (SfxItemSet*)pSets->GetObject(2 * nPoint + 1);
		SdrObject* pObj = rDoc.GetDataPointObj(nCol, nRow);

		// es gibt nicht immer ein entspr. Objekt im Drawing-Layer
		if (pObj)
		{
							// nicht mergen, nicht BuildChart() rufen
			rDoc.ChangeDataPointAttr(*pNewAttr, *pObj, FALSE, FALSE);
		}
		else
		{
			rDoc.PutDataPointAttr(nCol, nRow, *pNewAttr,FALSE);
		}
	}

	rDoc.BuildChart(FALSE);
}

/*************************************************************************
|*
|* CanRepeat()
|*
\************************************************************************/

BOOL SchUndoMultipleDataPoints::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



