/*************************************************************************
 *
 *  $RCSfile: dgrdata.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:46:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_DGRDATA_HXX
#define _SCH_DGRDATA_HXX

#ifndef _STDCTRL_HXX //autogen
#include <svtools/stdctrl.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFX_CHILDWIN_HXX //autogen
#include <sfx2/childwin.hxx>
#endif
#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif


#include "databrws.hxx"
#include "dataedit.hxx"

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Daten-Window
|*
\************************************************************************/

class SchDiagramDataWrapper : public SfxChildWindow
{
 public:
	SchDiagramDataWrapper(Window* pParent, USHORT nId,
						  SfxBindings* pBindings, SfxChildWinInfo* pInfo);

	SFX_DECL_CHILDWINDOW(SchDiagramDataWrapper);
};

/*************************************************************************
|*
|* FloatingWindow zur Chart-Daten-Editierung
|*
\************************************************************************/

class SchDiagramDataWindow : public SfxFloatingWindow, public SfxListener
{
private:
	BOOL                bReadOnly;
	ChartDataBrowseBox	aBrwData;
	FixedInfo           aFtPos;
	ToolBox				aTbxEdit;
	ChartDataEdit       aEdtData;
	ToolBox				aTbxData;
	Link				aOldEdtGetFocusHdl;
	SfxBindings*		pBindings;

	DECL_LINK(EditHdl, void*);
	DECL_LINK(DataHdl, void*);
	DECL_LINK(NewFieldHdl, void*);
	DECL_LINK(EditFieldHdl, void*);
	DECL_LINK(CancelHdl, void*);
	DECL_LINK(AcceptHdl, void*);
	DECL_LINK(EdtGetFocusHdl, void*);
	DECL_LINK(BrwClickHdl, void*);

	void UpdateData();

	void Transfer ();

protected:
	virtual void SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
						const SfxHint& rHint, const TypeId& rHintType);
	virtual void FillInfo( SfxChildWinInfo& ) const;

public:
	void SetReadOnly(const BOOL b);
	SchDiagramDataWindow(Window* pParent, SfxBindings* pBind, SfxChildWindow *pChild);
	virtual ~SchDiagramDataWindow();

	virtual BOOL Close();
};

#endif	// _SCH_DGRDATA_HXX

