/*************************************************************************
 *
 *  $RCSfile: parser.cxx,v $
 *
 *  $Revision: 1.2.22.3 $
 *
 *  last change: $Author: khendricks $ $Date: 2003/01/07 13:44:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>
#include "parser.hxx"

#include <tools/fsys.hxx>

#ifdef UNIX
#include <sys/types.h>
#include <sys/stat.h>
#endif

#ifndef _SV_CONFIG_HXX
#include <vcl/config.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#define DOSTRING( x ) #x
#define STRING( x ) DOSTRING( x )

///////////////////////////////////////////////////////////////////////////////

ObjectList	aObjectList;
FILE*		pSrcFile = NULL;
Config*		pLngFile = NULL;


class DummApp : public Application {
public:
	void Main() {}
};
DummApp aApp; // wg. new Config; sonst GPF

///////////////////////////////////////////////////////////////////////////////

void Parameter::Dump( FILE* pFile )
{
	if( m_aLanguage.Len() )
		fprintf( pFile, "\t%s %s = %s;\n",
				 m_aKey.GetBuffer(), m_aLanguage.GetBuffer(), m_aValue.GetBuffer() );
	else
		fprintf( pFile, "\t%s = %s;\n",
				 m_aKey.GetBuffer(), m_aValue.GetBuffer() );
}

///////////////////////////////////////////////////////////////////////////////

Object::Object()
{
	m_pParameters = NULL;
}

Object::~Object()
{
	if( m_pParameters )
	{
		for( ULONG i = 0; i < m_pParameters->Count(); i++ )
			delete m_pParameters->GetObject(i);
	}
}

void Object::RemoveParam( const ByteString& rName, const ByteString& rLang )
{
	for( ULONG nPos = m_pParameters->Count(); nPos--; )
	{
		Parameter* pParam = m_pParameters->GetObject(nPos);
		if( pParam->m_aKey == rName && pParam->m_aLanguage == rLang )
		{
			m_pParameters->Remove( nPos );
			delete pParam;
		}
	}
}

ByteString Object::GetParam( const ByteString& rName, const ByteString& rLang )
{
	for( ULONG nPos = m_pParameters->Count(); nPos--; )
	{
		Parameter* pParam = m_pParameters->GetObject(nPos);
		if( pParam->m_aKey == rName && pParam->m_aLanguage == rLang )
			return pParam->m_aValue;
	}
	return ByteString();
}

void Object::Dump( FILE* pFile )
{
	fprintf( pFile, "%s %s\n", m_aType.GetBuffer(), m_aId.GetBuffer() );
	for( USHORT n = 0; n < m_pParameters->Count(); n++ )
		m_pParameters->GetObject(n)->Dump( pFile );
	fprintf( pFile, "End\n\n" );
}

///////////////////////////////////////////////////////////////////////////////

void ObjectList::Dump( FILE* pFile )
{
	for( USHORT n = 0; n < Count(); n++ )
		GetObject(n)->Dump( pFile );
}

void yyerror( const char* s )
{
	fprintf( stdout, "%s in %i\n", s, line );
}

///////////////////////////////////////////////////////////////////////////////

void PrintUsage()
{
	fprintf( stderr, "\nScript Particel Compiler (c) 1999 StarDivision\nusage:\n" );
	fprintf( stderr, "\t-o <outputfile>\n" );
	fprintf( stderr, "\t-s <sourcefile>\n" );
}

///////////////////////////////////////////////////////////////////////////////

void ReplaceResourceId(Parameter* pParam)
{
	if( !pLngFile )
		return;
	if( pParam->m_aKey.CompareIgnoreCaseToAscii("TEXT") == COMPARE_EQUAL	   	||
    	pParam->m_aKey.CompareIgnoreCaseToAscii("NAME") == COMPARE_EQUAL	   	||
	   	pParam->m_aKey.CompareIgnoreCaseToAscii("KEY") == COMPARE_EQUAL			||
	   	pParam->m_aKey.CompareIgnoreCaseToAscii("VALUE") == COMPARE_EQUAL		||
		pParam->m_aKey.CompareIgnoreCaseToAscii("ONSELECT") == COMPARE_EQUAL   	||
		pParam->m_aKey.CompareIgnoreCaseToAscii("ONDESELECT") == COMPARE_EQUAL 	||
		pParam->m_aKey.CompareIgnoreCaseToAscii("DOSNAME") == COMPARE_EQUAL		||
		pParam->m_aKey.CompareIgnoreCaseToAscii("DESCRIPTION") == COMPARE_EQUAL )
	{
		ByteString aLangCode( pParam->m_aLanguage );
		aLangCode.EraseLeadingChars( '(' );
		aLangCode.EraseTrailingChars( ')' );

		pLngFile->SetGroup( pParam->m_aValue );
		BOOL bIsResID = pLngFile->GetKeyCount() > 0;
		ByteString aString( pLngFile->ReadKey( aLangCode, "") );
		if( aString.Len() )
		{
			aString.Erase( 0,1 );
			aString.Erase( aString.Len()-1, 2 );
			aString.SearchAndReplaceAll( "\"", "\\\"" );

			aString.Insert( "\"", 0 );
			aString += "\"";

			pParam->m_aValue = aString;
		}
		else if( bIsResID )
		{
			pParam->m_aValue.Insert( "\"", 0 );
			pParam->m_aValue.Insert( "\"", pParam->m_aValue.Len() );
		}
	}
	else if( pParam->m_aKey.CompareIgnoreCaseToAscii("CODE") == COMPARE_EQUAL )
	{
		USHORT nStartPos = 0;
		while( (nStartPos = pParam->m_aValue.Search("STR_", nStartPos)) != STRING_NOTFOUND )
		{
			char c;
			USHORT nEndPos = nStartPos;
			while( (c = pParam->m_aValue.GetChar(nEndPos++)) &&
				   nEndPos < pParam->m_aValue.Len() &&
				   c != ' ' && c != '\n' && c != ',' && c != ')' );

			ByteString aStrRes = pParam->m_aValue.Copy( nStartPos, nEndPos - nStartPos - 1 );
			USHORT nHashIdx;
			if( (nHashIdx = aStrRes.Search('#')) == STRING_NOTFOUND )
			{
				nStartPos += aStrRes.Len();
				continue;
			}

			ByteString aLangCode	= aStrRes.Copy( nHashIdx + 1 );
			ByteString aResID	= aStrRes;
			aResID.Erase( nHashIdx );

			pLngFile->SetGroup( aResID );
			ByteString aString( pLngFile->ReadKey( aLangCode, "") );

			if( aString.Len() )
			{
				aString.SearchAndReplaceAll( "}", "\\}" );
				pParam->m_aValue.Erase( nStartPos, aStrRes.Len() );
				pParam->m_aValue.Insert( aString, nStartPos );
				nStartPos += aString.Len();
			}
			else
			{
				pParam->m_aValue.Insert( "\"", nStartPos );
				pParam->m_aValue.Insert( "\"", nEndPos );
				nStartPos += aStrRes.Len() + 2;
			}

		}
		int i = 0;
	}
}

///////////////////////////////////////////////////////////////////////////////

#include "yyparser.cxx"

int __LOADONCALLAPI main( int argv, char** argc )
{
	if( argv == 1 )	{
		PrintUsage();
		return -1;
	}

	ByteString aOutFilename("~scpout.prt");
	ByteString aSrcFilename;

	//////////////
	// parse param
	for( USHORT n = 1; n < argv; n++ )
	{
		if( argc[ n ][ 0 ] == '-' )
		{
			switch( argc[ n ][ 1 ] )
			{
				case 's': aSrcFilename = argc[ ++n ];
					break;
				case 'o': aOutFilename = argc[ ++n ];
					break;
			}
		}
	}
	fprintf( stdout, "Making script particel: %s\n", aOutFilename.GetBuffer() );

	pSrcFile = fopen( aSrcFilename.GetBuffer(), "r" );
	if( !pSrcFile )
	{
		fprintf( stdout, "error: source '%s' cannot be found.\n", aSrcFilename.GetBuffer() );
		return -1;
	}

	DirEntry aSrcEntry( aSrcFilename );
	DirEntry aLngEntry( "." );
	aLngEntry.ToAbs();
	aLngEntry += aSrcEntry.GetName();
	aLngEntry.SetExtension( UniString::CreateFromAscii("lng") );

	if( aLngEntry.Exists() )
		pLngFile = new Config( aLngEntry.GetFull() );

	DirEntry aOutFile( aOutFilename );
	aOutFile.GetPath().MakeDir();

        /////////////////
        // parse particel
    sal_Int32 nRet = 0;
        if( !yyparse() )
        {
                FILE* pFile = fopen( aOutFilename.GetBuffer(), "w" );
                for( ULONG nPos = 0; nPos < aObjectList.Count(); nPos++ )
                {
                        Object* pObject = aObjectList.GetObject(nPos);

                        if( pObject->m_pParameters ) // replace resources
                        for( ULONG nPara = 0; nPara < pObject->m_pParameters->Count(); ++nPara )
                        {
                                Parameter* pParam = pObject->m_pParameters->GetObject(nPara);
                                ReplaceResourceId(pParam);
                        }

                        pObject->Dump(pFile);
                }
                fclose(pFile);
        }
    else
    {
        nRet = -1;
    }

        fclose( pSrcFile );
        if( pLngFile )
                delete pLngFile;

        return nRet;
}

