/*************************************************************************
 *
 *  $RCSfile: lzip.cxx,v $
 *
 *  $Revision: 1.7.6.3 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/15 16:04:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <time.h>

#ifdef WNT
#include <tools/prewin.h>
#include <windows.h>
#include <winsock.h>
#include <tools/postwin.h>
#endif

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#include "tools/geninfo.hxx"
#include "bootstrp/inimgr.hxx"
#include "tools/iparser.hxx"
#include "bootstrp/vermap.hxx"
#include "bootstrp/appdef.hxx"
#include "setup2/sifsys.hxx"

#include "ziplst.hxx"

#define MAX_PARAM			100

IniManager*					pIniManager = NULL;
IniManager*					pZipIniManager = NULL;
ByteString 					m_aProjectName;
ByteString 					m_aSourceScript;
ByteString 					m_aDestPath;
ByteString					m_aLanguages;
ByteString 					m_aMergeFilename;
ByteString					m_aSplitSize;
ByteString					m_aPreInclude;
ByteString					m_aErrorLog;
ByteString					m_aZipLst;

BOOL 						m_bPrintCommandline = FALSE;
BOOL 						m_bTestOnly = FALSE;
BOOL 						m_bBuildWeb = FALSE;
BOOL 						m_bStripBinaries = FALSE;

ByteString					m_aWorkStamp;
ByteString					m_aEnvironment;
ByteString					m_aMinor;

USHORT						m_nCmd = 0;
char**						m_ppCmd = NULL;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

class LZip : public Application
{
public:
	virtual void Main() { Execute(); }
};

LZip aApp;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void PrintUsage()
{
	fprintf( stderr, "usage:\n" );
	fprintf( stderr, "\t-i[+] list configured projects [+ detailed]\n" );
	fprintf( stderr, "\t-n <projectname>\n" );
	fprintf( stderr, "\t-d <destination path>\n" );
	fprintf( stderr, "\t-s <sourcescript>\n" );
	fprintf( stderr, "\t-f <zip list>\n" );
	fprintf( stderr, "\t-p <preinclude path>\n" );
	fprintf( stderr, "\t-l <langcode,...> (first langcode is default language)\n" );
	fprintf( stderr, "\t-m <merge filename | MASTERCONFIG>\n" );
	fprintf( stderr, "\t-z <size | MASTERCONFIG>\n" );
	fprintf( stderr, "\t-e <filename> (write a non HTML log)\n" );
	fprintf( stderr, "\t-o test only mode\n" );
	fprintf( stderr, "\t-c print scpzip commandline\n" );
	fprintf( stderr, "\t-w generate a webinstall script\n" );
	fprintf( stderr, "\t-S strip binaries\n" );
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void ListProjects( BOOL bDetailed )
{
	ByteString sDefLst = m_aZipLst;
	CONVERT_R_TO_HOSTFSYS( sDefLst );
	ByteString sStandLst( pZipIniManager->ToLocal( sDefLst ));
	InformationParser aParser;

    UniString aTmpString( UniString::CreateFromAscii( sStandLst.GetBuffer()) );
	GenericInformationList* pGenList = aParser.Execute( aTmpString );
	if( !pGenList )
	{
		fprintf( stderr, "FATAL ERROR: no genlist found: %s\n", sDefLst.GetBuffer() );
		exit( -1 );
	}
	fprintf( stderr, "available projects:\n" );
	for( USHORT i = 0; i < pGenList->Count(); ++i )
	{
		GenericInformation* pInf = pGenList->GetObject(i);
		Project* pPrj = new Project( NULL );
		pPrj->Read( pGenList, pInf );

		fprintf( stderr, "\t%s\n", pPrj->m_aName.GetBuffer() );
		if( bDetailed )
		{
			fprintf( stderr, "\t\t%s =\t%d\n", KEY_PRIO, pPrj->m_nPrio );
			fprintf( stderr, "\t\t%s =\t%d\n", KEY_WEB, pPrj->m_bWeb? "TRUE" : "FALSE" );
			fprintf( stderr, "\t\t%s =\t%s\n", KEY_SCRIPT, pPrj->m_aScript.GetBuffer() );
			fprintf( stderr, "\t\t%s =\t%s\n", KEY_FATBINARY, pPrj->m_aFatbinary.GetBuffer() );
			fprintf( stderr, "\t\t%s =\t%d\n", KEY_SPLITSIZE, pPrj->m_nSplitSize );
			fprintf( stderr, "\t\t%s =\t%d\n", KEY_COMPRESSION, pPrj->m_aCompression );
			fprintf( stderr, "\t\t%s =\t%s\n", KEY_INCLUDE, pPrj->m_aInclude.GetBuffer() );
			fprintf( stderr, "\n" );
		}
		delete pPrj;
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void AddCmd( const ByteString& rCmd )
{
	m_ppCmd[m_nCmd] = new char [rCmd.Len() + 1];
	strcpy( m_ppCmd[m_nCmd], rCmd.GetBuffer() );
	m_nCmd++;
}

BOOL StartJob()
{
	ByteString aMsg( m_aWorkStamp );
	aMsg += ";";
	aMsg += m_aEnvironment;
	aMsg += ";";
	aMsg += m_aMinor;

	aMsg.ToLowerAscii();

	ByteString sDefLst( GetDefStandList() );
	ByteString sStandLst( pIniManager->ToLocal( sDefLst ));
	InformationParser aParser;
    UniString aTmpString( UniString::CreateFromAscii( sStandLst.GetBuffer()) ); 
	GenericInformationList* pGenList = aParser.Execute( aTmpString );

	if( !pGenList )
	{
		fprintf( stderr, "FATAL ERROR: no standlist found: %s\n", sStandLst.GetBuffer() );
		exit( -1 );
	}
	MetaReplacement aM;
	if( !::GetMetaReplacement(&aM, aMsg, pGenList) )
		return FALSE;

	ByteString sZipList = m_aZipLst;
	CONVERT_R_TO_HOSTFSYS( sZipList );
	sZipList = pZipIniManager->ToLocal( sZipList );
    UniString aTmpString2( UniString::CreateFromAscii( sZipList.GetBuffer()) );
	pGenList = aParser.Execute( aTmpString2 );
	Project* pPrj = new Project( NULL );
	BOOL bFnd = FALSE;

	if( !pGenList )
	{
		fprintf( stderr, "FATAL ERROR: no genlist found: %s\n", sZipList.GetBuffer() );
		exit( -1 );
	}
	for( USHORT i = 0; i < pGenList->Count(); ++i )
	{
		GenericInformation* pInf = pGenList->GetObject(i);
		if( m_aProjectName.CompareIgnoreCaseToAscii(*pInf) == COMPARE_EQUAL )
		{
			pPrj->Read( pGenList, pInf );
			bFnd = TRUE;
			break;
		}
	}

	if( !bFnd ) {
		fprintf( stderr, "ERROR: project '%s' not found!", m_aProjectName.GetBuffer() );
		exit( -1 );
	}

	ByteString aCmd;
	m_ppCmd = new char * [MAX_PARAM];

	// === include =====================
	#ifdef UNX
	aCmd += '\'';
	#endif
	if( m_aPreInclude.Len() ) {
		aCmd += m_aPreInclude;
		aCmd += ",";
	}
	aCmd += ::DoMetaReplacement(&aM, m_aLanguages, pPrj->m_aInclude);

	#ifdef UNX
	while( aCmd.SearchAndReplace("\\", "/") != STRING_NOTFOUND );
	#else
	while( aCmd.SearchAndReplace("/", "\\") != STRING_NOTFOUND );
	#endif

	#ifdef UNX
	aCmd += '\'';
	#endif

	AddCmd( "-i" );
	AddCmd( aCmd );

	// === script ======================
	if( !m_aSourceScript.Len() )
	{
		UniString aPathExtension( UniString::CreateFromAscii("bin") );

		if( aM.aMetaMinor.Len() )
		{
			aPathExtension += UniString::CreateFromAscii( "." );
			aPathExtension += UniString::CreateFromAscii( aM.aMetaMinor.GetBuffer() );
		}

		SiDirEntry aEntry( aM.aMetaSolarPath );
		aEntry += aPathExtension;
		aEntry += pPrj->m_aScript;
		if( aM.aMetaOSDef !=  "UNX" )
			aEntry.SetExtension(UniString::CreateFromAscii("inf") );
		else
			aEntry.SetExtension(UniString::CreateFromAscii("ins") );
		if( !aEntry.Exists() ) {
			fprintf( stderr, "sourcescript '%s' not found\n", aEntry.GetFull().GetBuffer() );
			exit( -1 );
		}
		m_aSourceScript = aEntry.GetFull();
	}
	AddCmd( "-s" );
	AddCmd( m_aSourceScript );

	// === generate web script =========
	if( pPrj->m_bWeb || m_bBuildWeb )
		AddCmd( "-w" );

	// === test only ===================
	if( m_bTestOnly )
		AddCmd( "-o" );

	// === compression =================
	AddCmd( "-5" );

	// === language ====================
	AddCmd( "-l" );
	AddCmd( m_aLanguages );

	// === buildid =====================
	AddCmd( "-b" );
	ByteString aBuildInfo( getenv("WORK_STAMP") );
	aBuildInfo += "_[";
	aBuildInfo += aM.aMetaBuildID;
	aBuildInfo += "]_";

	aBuildInfo += ByteString( getenv("OS") );
	aBuildInfo += "_";
	aBuildInfo += ByteString( getenv("CPUNAME") );
	aBuildInfo += "_";
	/*
	aBuildInfo += "by";
	aBuildInfo += "_";
	aBuildInfo += ByteString( getenv("USER") );
	aBuildInfo += "_";
	aBuildInfo += "on";
	*/
	aBuildInfo += "_";
	aBuildInfo += ByteString( getenv("HOST") );
	aBuildInfo += "_";
	aBuildInfo += "at";
	aBuildInfo += "_";
	International aIntn;
	aBuildInfo += ByteString( aIntn.GetDate( Date() ), RTL_TEXTENCODING_ASCII_US );
	aBuildInfo += "_";
	aBuildInfo += ByteString( aIntn.GetTime( Time() ), RTL_TEXTENCODING_ASCII_US);

	
	AddCmd( aBuildInfo );
	//AddCmd( aM.aMetaBuildID );

	// === destination =================
	AddCmd( "-d" );
	AddCmd( m_aDestPath );

	// === OS Def ======================
	AddCmd( "-t" );
	AddCmd( aM.aMetaOSDef );

	// === processor type ==============
	AddCmd( "-h" );
	AddCmd( GetProcessorType(m_aEnvironment) );

	// === mergefiles ==================
	if( m_aMergeFilename.Len() )
	{
		AddCmd( "-m" );
		m_aMergeFilename = ::DoMetaReplacement( &aM, m_aLanguages,
								m_aMergeFilename.CompareIgnoreCaseToAscii("MASTERCONFIG") == COMPARE_EQUAL?
							 	pPrj->m_aFatbinary : m_aMergeFilename );
		AddCmd( m_aMergeFilename );
		if( m_aSplitSize.Len() )
		{
			AddCmd( "-z" );
			AddCmd( m_aSplitSize.CompareIgnoreCaseToAscii("MASTERCONFIG") == COMPARE_EQUAL?
					ByteString::CreateFromInt32(pPrj->m_nSplitSize) : m_aSplitSize );
		}
	}

	// === strip binaries ==============
	if( m_bStripBinaries )
		AddCmd( "-S" );

	// === error log ===================
	if( m_aErrorLog.Len() ) {
		AddCmd( "-e" );
		AddCmd( m_aErrorLog );
	}

	if( m_bPrintCommandline )
	{
		ByteString aOut( "scpzip" );
		for( USHORT xx = 0; xx < m_nCmd; ++xx )
		{
			aOut += ' ';
			aOut += m_ppCmd[xx];
		}
		fprintf( stderr, "\n\nSCPZIP Commandline:\n\n%s\n\n", aOut.GetBuffer() );
	}

#ifdef WNT
	::rtl::OUString* pArgs = new ::rtl::OUString [ m_nCmd ];
	for( USHORT xx = 0; xx < m_nCmd; ++xx )
		pArgs[xx] = ::rtl::OUString( ::rtl::OUString::createFromAscii(m_ppCmd[xx]) );

	NAMESPACE_VOS(OArgumentList) aArgs( pArgs, m_nCmd );

	NAMESPACE_VOS(OProcess)* pProcess = new NAMESPACE_VOS(OProcess)( ::rtl::OUString::createFromAscii("scpzip.exe") );
	pProcess->execute( NAMESPACE_VOS(OProcess)::TOption_SearchPath, aArgs );
	pProcess->join();

	delete [] pArgs;

	delete pProcess;

	delete pPrj;
#else
    #ifdef QUARTZ
        char *pathToCmd;

        pathToCmd = new char[MAX_PARAM];
        strcpy( pathToCmd, getenv("STAR_RESOURCEPATH") );
        strcat( pathToCmd, "/scpzip" );
        ByteString aSysCmd( pathToCmd );
    #else
    ByteString aSysCmd( "scpzip" );
    #endif
    for( i = 0; i < m_nCmd; ++i )
    {
        aSysCmd += ' ';
        aSysCmd += m_ppCmd[i];
    }
    system( aSysCmd.GetBuffer() );
    #ifdef QUARTZ
        delete pathToCmd;
    #endif
#endif

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void InitApp()
{
	#ifdef WNT
	WORD wVersionRequested;
	WSADATA wsaData;
	int error;

	wVersionRequested = MAKEWORD(1, 1);

	error = WSAStartup(wVersionRequested, &wsaData);
	if (error == 0)
	{
		WORD wMajorVersionRequired = HIBYTE(wVersionRequested);
		WORD wMinorVersionRequired = LOBYTE(wVersionRequested);

		if ((LOBYTE(wsaData.wVersion) <  wMajorVersionRequired) ||
			(LOBYTE(wsaData.wVersion) == wMajorVersionRequired) &&
			((HIBYTE(wsaData.wVersion) < wMinorVersionRequired)))
		{
			WSACleanup();
		}
	}
	#endif

	pIniManager = new IniManager;
	pIniManager->Update();

	ByteString sZipRoot( ZIPROOT );
	CONVERT_R_TO_HOSTFSYS( sZipRoot );
	pZipIniManager = new IniManager( sZipRoot );
	pZipIniManager->Update();


	m_aWorkStamp   	= ByteString( getenv("WORK_STAMP")?	getenv("WORK_STAMP") : "" );
	m_aEnvironment	= ByteString( getenv("INPATH")? 	getenv("INPATH") : "" );
	m_aMinor	   	= ByteString( getenv("UPDMINOR")? 	getenv("UPDMINOR") : "" );
}

void DeinitApp()
{
	#ifdef WNT
	WSACleanup();

	if( m_ppCmd ) {
		for( USHORT i = 0; i < m_nCmd; ++i )
			delete m_ppCmd[i];
		delete m_ppCmd;
	}
	#endif
	if( pIniManager ) delete pIniManager;
	if( pZipIniManager ) delete pZipIniManager;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

int __LOADONCALLAPI main( int argc, char** argv )
{
	InitApp();

	fprintf( stderr, "\nLocal Script Particel Zip (c) 2000 Sun Microsystems\n" );
	if( argc == 1 ) {
		PrintUsage();
		exit( -1 );
	}

	if( !m_aWorkStamp.Len() || !m_aEnvironment.Len() ) {
		fprintf( stderr, "ERROR: no environment found; use setsolar\n" );
		exit( -1 );
	}

	m_aZipLst = ZIPLIST;

	BOOL bProjectInfo = FALSE;
	BOOL bProjectInfoDetailed = FALSE;
	for( USHORT n = 1; n < argc; n++ )
	{
		if( argv[ n ][ 0 ] == '-' )
		{
			switch( argv[ n ][ 1 ] )
			{
				case 'i':	bProjectInfo = TRUE;
							if( argv[ n ][ 2 ] && argv[ n ][ 2 ] == '+' )
								bProjectInfoDetailed = TRUE;
							break;

				case 'c':	m_bPrintCommandline = TRUE;
							break;

				case 'n':	m_aProjectName = argv[ ++n ];
							break;

				case 's':	m_aSourceScript = argv[ ++n ];
							break;

				case 'f':	m_aZipLst = argv[ ++n ];
							break;

				case 'd':	m_aDestPath = argv[ ++n ];
							break;

				case 'm':	m_aMergeFilename = argv[ ++n ];
							break;

				case 'z':	m_aSplitSize = argv[++n];
							break;

				case 'p':	m_aPreInclude = argv[++n];
							break;

				case 'l':	m_aLanguages = argv[++n];
							break;

				case 'e':	m_aErrorLog = argv[++n];
							break;

				case 'o':	m_bTestOnly = TRUE;
							break;

				case 'w':	m_bBuildWeb = TRUE;
							break;

				case 'S':	m_bStripBinaries = TRUE;
							break;
			}
		}
	}

	if( bProjectInfo ) {
		ListProjects( bProjectInfoDetailed );
		DeinitApp();
		exit( 0 );
	}

	BOOL bValidate = TRUE;
	if( !m_aProjectName.Len() ) {
		fprintf( stderr, "ERROR: no projectname defined\n" );
		bValidate = FALSE;
	}
	if( m_aSourceScript.Len() ) {
		DirEntry aEntry( m_aSourceScript );
		if( !aEntry.Exists() ) {
			fprintf( stderr, "sourcescript '%s' not found\n", m_aSourceScript.GetBuffer() );
			bValidate = FALSE;
		}
	}
	if( !m_bTestOnly && !m_aDestPath.Len() ) {
		fprintf( stderr, "ERROR: no destination defined\n" );
		bValidate = FALSE;
	}
	if( !bValidate ) {
		DeinitApp();
		exit( -1 );
	}

	if( !m_aLanguages.Len() ) m_aLanguages = "01";

	StartJob();

	DeinitApp();
	return 0;
}

