/*************************************************************************
 *
 *  $RCSfile: websnooper.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/24 15:13:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>

#ifdef UNX
#include <unistd.h>
#endif

#ifdef WNT
#include <tools/prewin.h>
#include <windows.h>
#include <winsock.h>
#include <tools/postwin.h>
#endif

#ifndef _SV_CONFIG_HXX
#include <vcl/config.hxx>
#endif

 #ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif

#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#define  HTML_PREFIX	"HTML_LINK_"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

class WebSnooper
{
	ByteString							aHTMLLinkFilePath;
	ByteString							aFTPPath;

	ByteString 							aStrPath;
	ByteString 							aStrVersion;
	ByteString 							aStrProject;
	ByteString 							aStrProjectKey;
	ByteString 							aStrPlattform;
	ByteString 							aStrPlattformExtension;
	ByteString 							aStrMajor;
	ByteString 							aStrMinor;
	ByteString 							aStrBuildNr;
	ByteString 							aStrLanguages;
	ByteString 							aStrFTPLocation;
	ByteString 							aStrConfigFilename;
	ByteString							aStrNativeLocation;
	
	ByteString 							GetProductKey4Project();

	USHORT 								nMaxInstallations;

	void 								MakeHTMLLinkIncludeFile();
	void								MakeFTPSymLink();
	void								MakeConfiguration();

public:
				WebSnooper() { nMaxInstallations = 0; }

	void								DeleteHTMLLinkFiles();
	void								DeleteFTPSymLinks();
	void								ClearConfigfiles();

	void								RecursiveDirScan( const UniString& rPath );

	ByteString 							GetHTMLLinkFilePath() const { return aHTMLLinkFilePath; }
	ByteString 							GetFTPPath() const { return aFTPPath; }
	USHORT	 							GetMaxInstallations() const { return nMaxInstallations; }

	void 								SetHTMLLinkFilePath( const ByteString& r ) { aHTMLLinkFilePath = r; }
	void 								SetFTPPath( const ByteString& r ) { aFTPPath = r; }
};

WebSnooper aSnooperApp;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void _touchfile( const ByteString& r )
{
	#ifdef UNX

	DirEntry aEntry( UniString(r, osl_getThreadTextEncoding()) );
	aEntry.Kill();

	ByteString aCmd( "touch " );
	aCmd += r;
	system( aCmd.GetBuffer() );

	#endif
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void WebSnooper::DeleteHTMLLinkFiles()
{
	DirEntry aSave( UniString(aHTMLLinkFilePath, osl_getThreadTextEncoding()) );
	if( !aSave.Exists() )
		return;

	Dir aDir( aHTMLLinkFilePath, FSYS_KIND_FILE );
	for( USHORT i = 0; i < aDir.Count(); ++i )
	{
		DirEntry aEntry( aDir[i] );
		ByteString aName( aEntry.GetName(), osl_getThreadTextEncoding() );
		if( aName.CompareIgnoreCaseToAscii(".") == COMPARE_EQUAL ||
			aName.CompareIgnoreCaseToAscii("..") == COMPARE_EQUAL )
			continue;

		if( aName.Search(HTML_PREFIX) != STRING_NOTFOUND )
			_touchfile( ByteString(aEntry.GetFull(), osl_getThreadTextEncoding()) );
	}
}

void WebSnooper::DeleteFTPSymLinks()
{
	DirEntry aSave( UniString(aFTPPath, osl_getThreadTextEncoding()) );
	if( !aSave.Exists() )
		return;

	Dir aDir( aFTPPath, FSYS_KIND_FILE );
	for( USHORT i = 0; i < aDir.Count(); ++i )
	{
		DirEntry aEntry( aDir[i] );
		ByteString aName( aEntry.GetName(), osl_getThreadTextEncoding() );
		if( aName.CompareIgnoreCaseToAscii(".") == COMPARE_EQUAL ||
			aName.CompareIgnoreCaseToAscii("..") == COMPARE_EQUAL )
			continue;
		aEntry.Kill();
	}
}

void WebSnooper::ClearConfigfiles()
{
	_touchfile( ByteString("setupserver_WIN.ini") );
//	_touchfile( ByteString("setupserver_OS2.ini") );
//	_touchfile( ByteString("setupserver_MAC.ini") );
	_touchfile( ByteString("setupserver_UNIX_SOLS.ini") );
	_touchfile( ByteString("setupserver_UNIX_SOLI.ini") );
	_touchfile( ByteString("setupserver_UNIX_LINUX.ini") );
//	_touchfile( ByteString("setupserver_UNIX_HP.ini") );
//	_touchfile( ByteString("setupserver_UNIX_SCO.ini") );
}

void WebSnooper::RecursiveDirScan( const UniString& rPath )
{
	Dir aDir( rPath, FSYS_KIND_DIR );
	aDir.SetSort( FSYS_SORT_CREATED, FSYS_SORT_MODIFYED );
	for( USHORT i = 0; i < aDir.Count(); ++i )
	{
		fprintf( stderr, "." );
		DirEntry	aEntry( aDir[i] );
		ByteString	aName( aEntry.GetName(), osl_getThreadTextEncoding() );

		if( aName.CompareIgnoreCaseToAscii(".") == COMPARE_EQUAL ||
			aName.CompareIgnoreCaseToAscii("..") == COMPARE_EQUAL )
			continue;

		if( aName.CompareIgnoreCaseToAscii("web") == COMPARE_EQUAL )
		{
			if( aEntry.Level() <= 1 )
				break;
			DirEntry aVersion( aEntry[1] );

			if( aVersion.Level() <= 1 )
				break;
			DirEntry aProject( aVersion[1] );

			if( aProject.Level() <= 1 )
				break;
			DirEntry aPlattform( aProject[1] );

			aStrPath		= ByteString( aVersion.GetFull(),	osl_getThreadTextEncoding() );
			aStrVersion		= ByteString( aVersion.GetName(),	osl_getThreadTextEncoding() );
			aStrProject		= ByteString( aProject.GetName(), 	osl_getThreadTextEncoding() );
			aStrPlattform	= ByteString( aPlattform.GetName(), osl_getThreadTextEncoding() );
			aStrPlattformExtension = aStrPlattform.GetToken( 1, '.' );

			if( aStrVersion.CompareIgnoreCaseToAscii("_pre", 4) == COMPARE_EQUAL )
				break;

			aStrMajor		= ByteString( aStrVersion.GetToken( 0, '_' ) );
			aStrMinor		= ByteString( aStrVersion.GetToken( 1, '_' ) );
			aStrBuildNr		= ByteString( aStrVersion.GetToken( 1, '.' ) );

			if( aStrMajor.Copy(3).ToInt32() < 595 )
				break;

			USHORT s = aStrVersion.Search( aStrMinor );
			USHORT e = aStrVersion.Search( '.' );
			if( s == STRING_NOTFOUND || e == STRING_NOTFOUND ) break;

			s = s + aStrMinor.Len() + 1;
			e = e - s;
			aStrLanguages	= ByteString( aStrVersion.Copy(s,e) );
			aStrProjectKey	= GetProductKey4Project();

			if( !aStrPath.Len() || !aStrVersion.Len() || !aStrProject.Len() || !aStrPlattform.Len() ||
				!aStrMajor.Len() || !aStrMinor.Len() || !aStrBuildNr.Len() || !aStrLanguages.Len() ||
				!aStrProjectKey.Len() )
				break;

			aStrFTPLocation   = aStrProject;
			aStrFTPLocation   += '.';
			aStrFTPLocation   += aStrPlattform;
			aStrFTPLocation   += '.';
			aStrFTPLocation   += aStrLanguages;
			aStrFTPLocation   += '.';
			aStrFTPLocation   += aStrMinor;
			aStrFTPLocation   += '.';
			aStrFTPLocation   += aStrBuildNr;

			aStrNativeLocation = "http://cipolla.stardiv.de:8080/web/native/";
			aStrConfigFilename = "setupserver_";
			if( aStrPlattform.CompareIgnoreCaseToAscii("wntmsci", 7) == COMPARE_EQUAL )
			{
				aStrNativeLocation += "win32/";
				aStrConfigFilename += "WIN.ini";
			}
			else if( aStrPlattform.CompareIgnoreCaseToAscii("unxsols", 7) == COMPARE_EQUAL )
			{
				aStrNativeLocation += "solaris/";
				aStrConfigFilename += "UNIX_SOLS.ini";
			}
			else if( aStrPlattform.CompareIgnoreCaseToAscii("unxsoli", 7) == COMPARE_EQUAL )
			{
				aStrNativeLocation += "solaris/";
				aStrConfigFilename += "UNIX_SOLI.ini";
			}
			else if( aStrPlattform.CompareIgnoreCaseToAscii("unxlngi", 7) == COMPARE_EQUAL )
			{
				aStrNativeLocation += "linux/";
				aStrConfigFilename += "UNIX_LINUX.ini";
			}

			MakeHTMLLinkIncludeFile();
			MakeFTPSymLink();
			MakeConfiguration();
			nMaxInstallations++;
		}
		RecursiveDirScan( aEntry.GetFull() );
	}
}

ByteString WebSnooper::GetProductKey4Project()
{
	// === OfficeFAT ======================================================
	if( aStrProject.CompareIgnoreCaseToAscii("OfficeFAT") == COMPARE_EQUAL ||
		aStrProject.CompareIgnoreCaseToAscii("OfficeFATMulti") == COMPARE_EQUAL )
	{
		if( aStrMajor.Copy(3).ToInt32() < 609 )
			return ByteString( "StarOffice 5.3" );
		else
			return ByteString( "StarOffice 6.0" );
	}	

	// === PortalOffice ===================================================
	if( aStrProject.CompareIgnoreCaseToAscii("PortalOffice") == COMPARE_EQUAL )
		return ByteString( "PortalOffice 1.0" );

	// === WebTop =========================================================
	if( aStrProject.CompareIgnoreCaseToAscii("WebTop") == COMPARE_EQUAL )
		return ByteString( "StarWebTop 6.0" );

	// === OfficeRVP ======================================================
	if( aStrProject.CompareIgnoreCaseToAscii("OfficeRVP") == COMPARE_EQUAL )
	{
		if( aStrMajor.Copy(3).ToInt32() < 609 )
			return ByteString( "StarOfficeRVP 5.3" );
		else
			return ByteString( "StarOfficeRVP 6.0" );
	}	

	fprintf( stderr, "\nunknown project: %s\n", aStrProject.GetBuffer() );
	return ByteString("");
}

void WebSnooper::MakeHTMLLinkIncludeFile()
{
	// === link include file ==============================================
	UniString aFilename( aHTMLLinkFilePath, osl_getThreadTextEncoding() );
	aFilename += UniString( HTML_PREFIX, osl_getThreadTextEncoding() );
	aFilename += UniString( aStrProject, osl_getThreadTextEncoding() );
	aFilename += '.';
	aFilename += UniString( aStrPlattform, osl_getThreadTextEncoding() );
	aFilename += UniString::CreateFromAscii( ".html" ) ;

	SvFileStream* strm = new SvFileStream( aFilename, STREAM_WRITE );
	strm->Seek(STREAM_SEEK_TO_END);

	ByteString aQuote( aStrProjectKey );
	aQuote.SearchAndReplaceAll( " ", "%20" );

	*strm << "<a href=\"http://cipolla.stardiv.de:8080/web/setup?productkey=";
	*strm << aQuote.GetBuffer();
	*strm << "&build=";
	*strm << aStrBuildNr.GetBuffer();
	*strm << "&instlanguage=";
	*strm << aStrLanguages.GetBuffer();
	*strm << "&minor=";
	*strm << aStrMinor.GetBuffer();
	*strm << aStrPlattformExtension.GetBuffer();
	*strm << "&host=cipolla&port=8209\">";
	*strm << aStrProject.GetBuffer();
	*strm << " (" << aStrMajor.GetBuffer() << " - " << aStrMinor.GetBuffer() << " - " << aStrLanguages.GetBuffer() << " - " << aStrBuildNr.GetBuffer() << ")</a><br>";
	*strm << "\n";

	delete strm;
}

void WebSnooper::MakeFTPSymLink()
{
	ByteString aLnkSrc( aStrPath );
	aLnkSrc += "/normal";

	ByteString aLnk( aFTPPath );
	aLnk += aStrFTPLocation;

	#ifdef UNX
	symlink( aLnkSrc.GetBuffer(), aLnk.GetBuffer() );
	#endif
}

void WebSnooper::MakeConfiguration()
{
	ByteString aGrpName( aStrProjectKey );
	aGrpName += '-';
	aGrpName += aStrBuildNr;
	aGrpName += '-';
	aGrpName += aStrMinor;
	aGrpName += aStrPlattformExtension;
	aGrpName += '-';
	aGrpName += aStrLanguages;

	ByteString aSetupInf( aStrPath );
	aSetupInf += '/';
	aSetupInf += "web/webinstdb.inf";

	ByteString aMirror( "StarOffice FTP Server;ftp://webinstall:webinstall@cipolla.stardiv.de/pub/" );
	aMirror += aStrFTPLocation;
	aMirror += '/';

	DirEntry aCfgFile(".");
	aCfgFile += UniString(aStrConfigFilename, osl_getThreadTextEncoding());
	aCfgFile.ToAbs();

	Config aCfg( aCfgFile.GetFull() );

	aCfg.SetGroup( aGrpName );
	aCfg.WriteKey( "script", aSetupInf );
	aCfg.WriteKey( "native", aStrNativeLocation );
	aCfg.WriteKey( "mirror", aMirror );
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

int __LOADONCALLAPI main( int argv, char** argc )
{
	fprintf( stderr, "\nWebInstall Snooper (c) 2000 Sun Microsystems\n\n" );

	for( USHORT n = 1; n < argv; n++ )
	{
		if( argc[ n ][ 0 ] == '-' )
		{
			switch( argc[ n ][ 1 ] )
			{
				case 'h' :
					{
					ByteString aTmp( argc[++n] );
					aSnooperApp.SetHTMLLinkFilePath( aTmp );
					}
					break;
				case 'f' :
					{
					ByteString aTmp( argc[++n] );
					aSnooperApp.SetFTPPath( aTmp );
					}
					break;
			}
		}
	}

	if( !aSnooperApp.GetHTMLLinkFilePath().Len() ||
		!aSnooperApp.GetFTPPath().Len() )
	{
		fprintf( stderr, "ERROR: wrong parameters\n" );
		exit( -1 );
	}

	#ifdef UNX
	DirEntry aPIDFile( UniString(aSnooperApp.GetHTMLLinkFilePath(), osl_getThreadTextEncoding()) );
	aPIDFile += UniString( "setupindex.pid", osl_getThreadTextEncoding() );
	aPIDFile.ToAbs();

	ByteString aPIDCmd( "touch " );
	aPIDCmd += ByteString(aPIDFile.GetFull(),osl_getThreadTextEncoding());
	system( aPIDCmd.GetBuffer() );
	#endif

	// scan installations
	aSnooperApp.DeleteHTMLLinkFiles();
	aSnooperApp.DeleteFTPSymLinks();
	aSnooperApp.ClearConfigfiles();
	aSnooperApp.RecursiveDirScan( UniString("/ship/install", osl_getThreadTextEncoding()) );

	// write scaninfo
	DateTime aDt;
	ByteString aMin( ByteString::CreateFromInt32(aDt.GetMin()) );
	ByteString aSec( ByteString::CreateFromInt32(aDt.GetSec()) );

	if( aMin.Len() == 1 ) aMin.Insert( '0', 0 );
	if( aSec.Len() == 1 ) aSec.Insert( '0', 0 );

	ByteString aStrTime( ByteString::CreateFromInt32(aDt.GetHour()) );
	aStrTime += ":";
	aStrTime += aMin;
	aStrTime += ":";
	aStrTime += aSec;

	ByteString aStrDate( ByteString::CreateFromInt32(aDt.GetDay()) );
	aStrDate += "-";
	aStrDate += ByteString::CreateFromInt32(aDt.GetMonth());
	aStrDate += "-";
	aStrDate += ByteString::CreateFromInt32(aDt.GetYear());

	UniString aScanInfoFilename( aSnooperApp.GetHTMLLinkFilePath(), osl_getThreadTextEncoding() );
	aScanInfoFilename += UniString( HTML_PREFIX, osl_getThreadTextEncoding() );
	aScanInfoFilename += UniString::CreateFromAscii( "scaninfo.html" ) ;

	SvFileStream* strm = new SvFileStream( aScanInfoFilename, STREAM_WRITE | STREAM_TRUNC );
	*strm << "<font size=1>[scaninfo]<br>Time: <b>";
	*strm << aStrTime.GetBuffer();
	*strm << "</b> Date: <b>";
	*strm << aStrDate.GetBuffer();
	*strm << "</b> Installations: <b>";
	*strm << ByteString::CreateFromInt32(aSnooperApp.GetMaxInstallations()).GetBuffer();
	*strm << "</b></font>\n";
	delete strm;

	// touch JSP
	DirEntry aTouchME( UniString(aSnooperApp.GetHTMLLinkFilePath(), osl_getThreadTextEncoding()) );
	aTouchME += UniString("setupindex.jsp",osl_getThreadTextEncoding());
	aTouchME.ToAbs();

	#ifdef UNX
	ByteString aCmd( "touch " );
	aCmd += ByteString(aTouchME.GetFull(),osl_getThreadTextEncoding());
	system( aCmd.GetBuffer() );
	aPIDFile.Kill();
	#endif

	fprintf( stderr, "\n" );

	return 0;
}

